/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.searchengine.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.searchengine.domain.SearchParamDomain;
import com.yqbsoft.laser.service.searchengine.domain.SkuSearchRespDomain;
import com.yqbsoft.laser.service.searchengine.domain.SkuSearchResultDomain;
import com.yqbsoft.laser.service.searchengine.service.IConnection;
import com.yqbsoft.laser.service.searchengine.service.SearchService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.http.Header;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.springframework.stereotype.Service;

@Service(value="searchServiceImpl")
public class SearchServiceImpl
extends BaseServiceImpl
implements SearchService {
    @Resource(name="esConnection")
    private IConnection esConnection;
    private static final String SYS_CODE = "es.SearchengineServiceImpl";
    String[] indices = new String[]{"sku"};
    String[] types = new String[]{"sku"};
    String[] include_fields = new String[]{"skuId", "goodsName"};
    String[] exclude_fields = new String[]{"rsGoodsFileDomainList", "rsSkuDomainList"};

    @Override
    public SkuSearchRespDomain search(SearchParamDomain searchParamDomain) throws ApiException {
        RestHighLevelClient esClient = this.esConnection.getConnection();
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"tenantCode", (String)searchParamDomain.getTenantCode()));
        boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"bizType", (String)searchParamDomain.getBizType()));
        SearchRequest searchRequest = new SearchRequest(this.indices);
        searchRequest.types(this.types);
        searchRequest.preference("_local");
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.fetchSource(this.include_fields, this.exclude_fields);
        searchSourceBuilder.timeout(new TimeValue(1000L));
        searchSourceBuilder.sort(SortBuilders.fieldSort((String)"skuId").order(SortOrder.DESC));
        searchRequest.source(searchSourceBuilder);
        ArrayList<SkuSearchResultDomain> res = new ArrayList<SkuSearchResultDomain>();
        try {
            SearchResponse searchResponse = esClient.search(searchRequest, new Header[0]);
            SearchHit[] searchHit = searchResponse.getHits().getHits();
            if (searchResponse.getHits().totalHits > 0L) {
                for (SearchHit searchhit : searchHit) {
                    Map sourceAsMap = searchhit.getSourceAsMap();
                    SkuSearchResultDomain skuSearchResultDomain = new SkuSearchResultDomain();
                    skuSearchResultDomain.setSkuId(sourceAsMap.get("skuId").toString());
                    skuSearchResultDomain.setSkuName(sourceAsMap.get("skuName").toString());
                    skuSearchResultDomain.setGoodsName(sourceAsMap.get("goodsName").toString());
                    res.add(skuSearchResultDomain);
                }
            }
        }
        catch (IOException e) {
            this.logger.error(SYS_CODE, (Object)e.getMessage(), (Throwable)e);
        }
        SkuSearchRespDomain skuSearchResp = new SkuSearchRespDomain();
        skuSearchResp.setSourcelist(res);
        return skuSearchResp;
    }
}

