/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.searchengine.util;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.suppercore.log.SupperLogUtil;
import com.yqbsoft.laser.service.suppercore.point.RegeditUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import com.yqbsoft.laser.service.tool.util.WebUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ResourceBundle;

public class EsUtil {
    private static final SupperLogUtil logger = new SupperLogUtil(EsUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String httpUrlPoolGet(String data, String type, String queryParamJson) throws IOException {
        String searchurl = "";
        BufferedReader br = null;
        OutputStream out = null;
        HttpURLConnection conn = null;
        if (StringUtils.isNotBlank((String)data)) {
            data = data.toLowerCase();
        }
        if (StringUtils.isNotBlank((String)type)) {
            type = type.toLowerCase();
        }
        logger.debug("esEsUtil", (Object)("httpUrlPoolGet method, data:" + data + ", type:" + type + ", queryParamJson:" + queryParamJson));
        try {
            ResourceBundle resourceBundle = RegeditUtil.getResourceBundle((String)"search", (String)"appres.path", (String)"");
            searchurl = resourceBundle.getString("url");
        }
        catch (Exception e) {
            logger.error("EsUtil.httpUrlGet.e1", (Throwable)e);
        }
        if (StringUtils.isNotBlank((String)searchurl)) {
            searchurl = searchurl + "/" + data + "-" + type + "/" + type + "/_search";
            logger.debug("esEsUtil.httpUrlPoolGet", (Object)("searchurl:" + searchurl));
        }
        if (null == queryParamJson) {
            queryParamJson = "";
        }
        try {
            String e = WebUtils.processPostJson((String)searchurl, (String)queryParamJson);
            return e;
        }
        catch (Exception e) {
            logger.error("EsUtil.httpUrlGet.e", (Object)searchurl, (Throwable)e);
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (br != null) {
                br.close();
            }
            if (conn != null) {
                conn.disconnect();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String httpUrlGet(String data, String type, String queryParamJson) throws IOException {
        String searchurl = "";
        String method = "GET";
        BufferedReader br = null;
        OutputStream out = null;
        HttpURLConnection conn = null;
        if (StringUtils.isNotBlank((String)data)) {
            data = data.toLowerCase();
        }
        if (StringUtils.isNotBlank((String)type)) {
            type = type.toLowerCase();
        }
        try {
            ResourceBundle resourceBundle = RegeditUtil.getResourceBundle((String)"search", (String)"appres.path", (String)"");
            searchurl = resourceBundle.getString("url");
        }
        catch (Exception e) {
            logger.error("EsUtil.httpUrlGet.e1", (Throwable)e);
        }
        if (StringUtils.isNotBlank((String)searchurl)) {
            searchurl = searchurl + "/" + data + "-" + type + "/" + type + "/_search";
            logger.info("EsUtil.httpUrlGet.searchurl", (Object)searchurl);
        }
        StringBuilder resultBuilder = new StringBuilder();
        if (null == queryParamJson) {
            queryParamJson = "";
        }
        try {
            String line;
            URL url = new URL(searchurl);
            conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod(method.toUpperCase());
            conn.setRequestProperty("Content-Type", "application/json");
            conn.setRequestProperty("Content-Length", Integer.toString(queryParamJson.getBytes().length));
            conn.setRequestProperty("Content-Language", "zh-cn");
            conn.setUseCaches(false);
            conn.setDoOutput(true);
            if (StringUtils.isNotBlank((String)queryParamJson)) {
                out = conn.getOutputStream();
                out.write(queryParamJson.getBytes());
            }
            br = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            while ((line = br.readLine()) != null) {
                resultBuilder.append(line);
                resultBuilder.append('\r');
            }
            String string = resultBuilder.toString();
            return string;
        }
        catch (Exception e) {
            logger.error("EsUtil.httpUrlGet.e", (Object)searchurl, (Throwable)e);
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (br != null) {
                br.close();
            }
            if (conn != null) {
                conn.disconnect();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void httpUrlInsert(String dataParamJson, String method, String data, String type, String id) throws Exception {
        block19: {
            HttpURLConnection conn = null;
            OutputStream out = null;
            BufferedReader br = null;
            StringBuilder resultBuilder = new StringBuilder();
            if (null == dataParamJson) {
                dataParamJson = "";
            }
            String searchurl = "";
            if (StringUtils.isNotBlank((String)data)) {
                data = data.toLowerCase();
            }
            if (StringUtils.isNotBlank((String)type)) {
                type = type.toLowerCase();
            }
            try {
                String line;
                ResourceBundle resourceBundle = RegeditUtil.getResourceBundle((String)"search", (String)"appres.path", (String)"");
                try {
                    searchurl = resourceBundle.getString("url");
                }
                catch (Exception e) {
                    logger.error("httpUrlInsert resourceBundle.getString() Exception:", (Object)e.getMessage(), (Throwable)e);
                }
                if (StringUtils.isNotBlank((String)searchurl)) {
                    searchurl = searchurl + "/" + data + "-" + type + "/" + type + "/" + id;
                }
                if ("UPDATE".equals(method.toUpperCase()) || "EDIT".equals(method.toUpperCase())) {
                    method = "POST";
                    searchurl = searchurl + "/_update";
                }
                URL url = new URL(searchurl);
                conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod(method.toUpperCase());
                conn.setRequestProperty("Content-Type", "application/json;charset=UTF-8");
                conn.setRequestProperty("Content-Length", Integer.toString(dataParamJson.getBytes().length));
                conn.setRequestProperty("Content-Language", "zh-CN,zh;q=0.8,zh-TW;q=0.7,zh-HK;q=0.5,en-US;q=0.3,en;q=0.2");
                conn.setUseCaches(false);
                conn.setDoOutput(true);
                if (StringUtils.isNotBlank((String)dataParamJson)) {
                    out = conn.getOutputStream();
                    out.write(dataParamJson.getBytes());
                }
                br = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                while ((line = br.readLine()) != null) {
                    resultBuilder.append(line);
                    resultBuilder.append('\r');
                }
                if (conn.getResponseCode() == 200 || conn.getResponseCode() == 201) {
                    logger.debug("es.responseCode", (Object)(searchurl + "=" + dataParamJson));
                    break block19;
                }
                logger.error("es.responseCode1", (Object)(searchurl + "=" + dataParamJson));
                throw new ApiException("es", "Failed : HTTP error code : " + conn.getResponseCode());
            }
            catch (ApiException e) {
                logger.error("es.apiException", (Object)(searchurl + "=" + method.toUpperCase() + "=" + dataParamJson), (Throwable)e);
                throw e;
            }
            catch (Exception e) {
                logger.error("es.exception", (Object)(searchurl + "=" + method.toUpperCase() + "=" + dataParamJson), (Throwable)e);
            }
            finally {
                if (out != null) {
                    out.close();
                }
                if (br != null) {
                    br.close();
                }
                if (conn != null) {
                    conn.disconnect();
                }
            }
        }
    }
}

