/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.searchengine.util;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.suppercore.log.SupperLogUtil;
import com.yqbsoft.laser.service.suppercore.point.RegeditUtil;
import com.yqbsoft.laser.service.tool.codec.Base64;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import com.yqbsoft.laser.service.tool.util.WebUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ResourceBundle;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.client.RestHighLevelClient;

public class EsUtil {
    private static final SupperLogUtil logger = new SupperLogUtil(EsUtil.class);
    private static RestHighLevelClient esClient = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String httpUrlPoolGet(String data, String type, String queryParamJson) throws IOException {
        String searchurl = "";
        BufferedReader br = null;
        OutputStream out = null;
        HttpURLConnection conn = null;
        if (StringUtils.isNotBlank((String)data)) {
            data = data.toLowerCase();
        }
        if (StringUtils.isNotBlank((String)type)) {
            type = type.toLowerCase();
        }
        try {
            ResourceBundle resourceBundle = RegeditUtil.getResourceBundle((String)"laser", (String)"search.path", (String)"");
            searchurl = resourceBundle.getString("search.url");
        }
        catch (Exception e) {
            logger.error("EsUtil.httpUrlGet.e1", (Throwable)e);
        }
        if (StringUtils.isNotBlank((String)searchurl)) {
            searchurl = searchurl + "/" + data + "-" + type + "/" + type + "/_search";
            logger.debug("esEsUtil.httpUrlPoolGet", (Object)("searchurl:" + searchurl));
        }
        if (null == queryParamJson) {
            queryParamJson = "";
        }
        try {
            logger.error("es.find", (Object)("searchurl:" + searchurl + ", queryParamJson:" + queryParamJson));
            String e = WebUtils.processPostJson((String)searchurl, (String)queryParamJson);
            return e;
        }
        catch (Exception e) {
            logger.error("EsUtil.httpUrlGet.e", (Object)searchurl, (Throwable)e);
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (br != null) {
                br.close();
            }
            if (conn != null) {
                conn.disconnect();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String httpUrlGet(String data, String type, String queryParamJson) throws IOException {
        String searchurl = "";
        String method = "GET";
        BufferedReader br = null;
        OutputStream out = null;
        HttpURLConnection conn = null;
        if (StringUtils.isNotBlank((String)data)) {
            data = data.toLowerCase();
        }
        if (StringUtils.isNotBlank((String)type)) {
            type = type.toLowerCase();
        }
        try {
            ResourceBundle resourceBundle = RegeditUtil.getResourceBundle((String)"laser", (String)"search.path", (String)"");
            searchurl = resourceBundle.getString("search.url");
        }
        catch (Exception e) {
            logger.error("EsUtil.httpUrlGet.e1", (Throwable)e);
        }
        if (StringUtils.isNotBlank((String)searchurl)) {
            searchurl = searchurl + "/" + data + "-" + type + "/" + type + "/_search";
            logger.info("EsUtil.httpUrlGet.searchurl", (Object)searchurl);
        }
        StringBuilder resultBuilder = new StringBuilder();
        if (null == queryParamJson) {
            queryParamJson = "";
        }
        try {
            String line;
            URL url = new URL(searchurl);
            conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod(method.toUpperCase());
            conn.setRequestProperty("Content-Type", "application/json");
            conn.setRequestProperty("Content-Length", Integer.toString(queryParamJson.getBytes().length));
            conn.setRequestProperty("Content-Language", "zh-cn");
            conn.setUseCaches(false);
            conn.setDoOutput(true);
            if (StringUtils.isNotBlank((String)queryParamJson)) {
                out = conn.getOutputStream();
                out.write(queryParamJson.getBytes());
            }
            br = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            while ((line = br.readLine()) != null) {
                resultBuilder.append(line);
                resultBuilder.append('\r');
            }
            String string = resultBuilder.toString();
            return string;
        }
        catch (Exception e) {
            logger.error("EsUtil.httpUrlGet.e", (Object)searchurl, (Throwable)e);
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (br != null) {
                br.close();
            }
            if (conn != null) {
                conn.disconnect();
            }
        }
        return null;
    }

    public static HttpsURLConnection getEsSSL(String method, String data, String type, String id, Integer len) {
        String searchurl = "";
        String username = "";
        String password = "";
        try {
            ResourceBundle resourceBundle = RegeditUtil.getResourceBundle((String)"laser", (String)"search.path", (String)"");
            searchurl = resourceBundle.getString("search.url");
            username = resourceBundle.getString("search.username");
            password = resourceBundle.getString("search.password");
        }
        catch (Exception e) {
            logger.error("httpUrlInsert resourceBundle.getString() Exception:", (Object)e.getMessage(), (Throwable)e);
        }
        if (StringUtils.isNotBlank((String)searchurl)) {
            searchurl = searchurl + "/" + data + "-" + type + "/" + type + "/" + id;
        }
        if ("UPDATE".equals(method.toUpperCase()) || "EDIT".equals(method.toUpperCase())) {
            method = "POST";
            searchurl = searchurl + "/_update";
        }
        String input = "";
        if (StringUtils.isNotBlank((String)searchurl)) {
            input = username + ":" + password;
        }
        HttpsURLConnection connHttps = null;
        try {
            URL url = new URL(searchurl);
            if ("https".equals(url.getProtocol())) {
                SSLContext ctx = null;
                try {
                    ctx = SSLContext.getInstance("TLS");
                    ctx.init(new KeyManager[0], new TrustManager[]{new DefaultTrustManager()}, new SecureRandom());
                }
                catch (Exception e) {
                    throw new IOException(e);
                }
                connHttps = (HttpsURLConnection)url.openConnection();
                connHttps.setSSLSocketFactory(ctx.getSocketFactory());
                connHttps.setHostnameVerifier(new HostnameVerifier(){

                    @Override
                    public boolean verify(String hostname, SSLSession session) {
                        return false;
                    }
                });
            } else {
                connHttps = (HttpsURLConnection)url.openConnection();
            }
            if (StringUtils.isNotBlank((String)input)) {
                Base64 base = new Base64();
                String encodedPassword = Base64.encodeBase64String((byte[])input.getBytes("UTF-8"));
                connHttps.setRequestProperty("Authorization", "Basic " + encodedPassword);
            }
            connHttps.setRequestMethod(method.toUpperCase());
            connHttps.setRequestProperty("Content-Type", "application/json;charset=UTF-8");
            connHttps.setRequestProperty("Content-Length", Integer.toString(len));
            connHttps.setRequestProperty("Content-Language", "zh-CN,zh;q=0.8,zh-TW;q=0.7,zh-HK;q=0.5,en-US;q=0.3,en;q=0.2");
            connHttps.setUseCaches(false);
            connHttps.setDoOutput(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return connHttps;
    }

    private static RestHighLevelClient getClient() {
        if (null == esClient) {
            String searchurl = "";
            int searchport = 9200;
            String searchsc = "http";
            String searchportStr = "";
            String user = "";
            String pw = "";
            try {
                ResourceBundle resourceBundle = RegeditUtil.getResourceBundle((String)"laser", (String)"search.path", (String)"");
                searchurl = resourceBundle.getString("search.url");
                searchportStr = resourceBundle.getString("search.port");
                if (StringUtils.isNotBlank((String)searchportStr)) {
                    searchport = Integer.valueOf(searchportStr);
                }
                searchsc = resourceBundle.getString("search.scheme");
                user = resourceBundle.getString("search.username");
                pw = resourceBundle.getString("search.password");
            }
            catch (Exception e) {
                logger.error("httpUrlInsert resourceBundle.getString() Exception:", (Object)e.getMessage(), (Throwable)e);
            }
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            if (StringUtils.isNotBlank((String)user)) {
                credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(user, pw));
            }
            esClient = new RestHighLevelClient(RestClient.builder((HttpHost[])new HttpHost[]{new HttpHost(searchurl, searchport, searchsc)}).setHttpClientConfigCallback(new RestClientBuilder.HttpClientConfigCallback((CredentialsProvider)credentialsProvider){
                final /* synthetic */ CredentialsProvider val$credentialsProvider;
                {
                    this.val$credentialsProvider = credentialsProvider;
                }

                public HttpAsyncClientBuilder customizeHttpClient(HttpAsyncClientBuilder httpClientBuilder) {
                    httpClientBuilder.disableAuthCaching();
                    return httpClientBuilder.setDefaultCredentialsProvider(this.val$credentialsProvider);
                }
            }));
        }
        return esClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void httpUrlInsert(String dataParamJson, String method, String data, String type, String id) throws Exception {
        block17: {
            HttpsURLConnection conn = null;
            OutputStream out = null;
            BufferedReader br = null;
            StringBuilder resultBuilder = new StringBuilder();
            if (null == dataParamJson) {
                dataParamJson = "";
            }
            String searchurl = "";
            if (StringUtils.isNotBlank((String)data)) {
                data = data.toLowerCase();
            }
            if (StringUtils.isNotBlank((String)type)) {
                type = type.toLowerCase();
            }
            try {
                String line;
                conn = EsUtil.getEsSSL(method, data, type, id, dataParamJson.getBytes().length);
                if ("UPDATE".equals(method.toUpperCase()) || "EDIT".equals(method.toUpperCase())) {
                    dataParamJson = "{\"doc\":" + dataParamJson + "}";
                }
                if ("DELETE".equals(method.toUpperCase())) {
                    dataParamJson = "";
                }
                if (StringUtils.isNotBlank((String)dataParamJson)) {
                    out = conn.getOutputStream();
                    out.write(dataParamJson.getBytes());
                }
                br = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                while ((line = br.readLine()) != null) {
                    resultBuilder.append(line);
                    resultBuilder.append('\r');
                }
                if (conn.getResponseCode() == 200 || conn.getResponseCode() == 201) {
                    logger.debug("es.responseCode", (Object)(searchurl + "=" + dataParamJson));
                    break block17;
                }
                logger.error("es.responseCode1", (Object)(searchurl + "=" + dataParamJson));
                throw new ApiException("es", "Failed : HTTP error code : " + conn.getResponseCode());
            }
            catch (ApiException e) {
                logger.error("es.apiException", (Object)(searchurl + "=" + method.toUpperCase() + "=" + dataParamJson), (Throwable)e);
                throw e;
            }
            catch (Exception e) {
                logger.error("es.exception", (Object)(searchurl + "=" + method.toUpperCase() + "=" + dataParamJson), (Throwable)e);
            }
            finally {
                if (out != null) {
                    out.close();
                }
                if (br != null) {
                    br.close();
                }
                if (conn != null) {
                    conn.disconnect();
                }
            }
        }
    }

    private static class DefaultTrustManager
    implements X509TrustManager {
        private DefaultTrustManager() {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }
    }
}

