/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.searchengine.service.impl;

import com.yqbsoft.laser.service.esb.annotation.ApiMethod;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.log.performance.OpenPerfLogUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.searchengine.domain.AccurateQueryDomain;
import com.yqbsoft.laser.service.searchengine.domain.DataHits;
import com.yqbsoft.laser.service.searchengine.domain.RestBean;
import com.yqbsoft.laser.service.searchengine.domain.ReturnBean;
import com.yqbsoft.laser.service.searchengine.domain.SearchDomain;
import com.yqbsoft.laser.service.searchengine.domain.StoreDomain;
import com.yqbsoft.laser.service.searchengine.index.StoreEnum;
import com.yqbsoft.laser.service.searchengine.service.SearchengineService;
import com.yqbsoft.laser.service.searchengine.util.EsUtil;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Service;

@Service
public class SearchengineServiceImpl
extends BaseServiceImpl
implements SearchengineService {
    private static final String SYS_CODE = "es.SearchengineServiceImpl";

    private static String list2string(List<String> params) {
        String result = "";
        String res = "";
        for (String s : params) {
            if (null != s) {
                s = s.toLowerCase();
            }
            res = res + "\"" + s + "\"" + ",";
        }
        result = "[" + res.substring(0, res.length() - 1) + "]";
        return result;
    }

    @Override
    @ApiMethod(code="es.searchengine.store", name="\u6570\u636e\u5b58\u50a8", paramStr="storeDomain", description="")
    public boolean store(StoreDomain storeDomain) throws ApiException {
        if (null == storeDomain || StringUtils.isBlank((String)storeDomain.getTenantCode()) || StringUtils.isBlank((String)storeDomain.getRequestType())) {
            return false;
        }
        this.logger.debug(SYS_CODE, (Object)("storeDomain info:" + storeDomain));
        String id = storeDomain.getBizId();
        if (StringUtils.isBlank((String)id)) {
            return false;
        }
        String type = storeDomain.getBizType();
        if (StringUtils.isBlank((String)type)) {
            return false;
        }
        String requestType = storeDomain.getRequestType();
        String method = "POST";
        String data = storeDomain.getTenantCode();
        this.logger.error("es.SearchengineServiceImpl.requestType", (Object)(requestType + "=" + storeDomain.getBizId()));
        if (StoreEnum.INSERT.getType().equals(requestType) || StoreEnum.SKUINSERT.getType().equals(requestType) || StoreEnum.SKUADD.getType().equals(requestType)) {
            method = "POST";
        } else if (StoreEnum.UPDATE.getType().equals(requestType) || StoreEnum.EDIT.getType().equals(requestType)) {
            method = "UPDATE";
        } else if (StoreEnum.DELETE.getType().equals(requestType) || StoreEnum.DELETEOP.getType().equals(requestType) || StoreEnum.SKUDELETE.getType().equals(requestType) || StoreEnum.SKUDELETEOP.getType().equals(requestType) || StoreEnum.SKUDOWN.getType().equals(requestType) || StoreEnum.DOWN.getType().equals(requestType)) {
            method = "DELETE";
        } else {
            return true;
        }
        String queryParamJson = "";
        if (null != storeDomain.getStoreObj()) {
            queryParamJson = storeDomain.getStoreObj().toString();
        }
        try {
            EsUtil.httpUrlInsert(queryParamJson, method, data, type, id);
            return true;
        }
        catch (Exception e) {
            this.logger.error("es.SearchengineServiceImpl.store", (Throwable)e);
            return false;
        }
    }

    @Override
    public Map<String, Object> findByCode(String opcode, String bizType, String tenantCode) throws ApiException {
        if (StringUtils.isBlank((String)opcode) || StringUtils.isBlank((String)bizType) || StringUtils.isBlank((String)tenantCode)) {
            this.logger.error("es.SearchengineServiceImpl.findByCode.null", (Object)"null");
            return null;
        }
        try {
            long times = System.currentTimeMillis();
            String str = EsUtil.httpUrlPoolGetByCode(tenantCode, bizType, opcode);
            OpenPerfLogUtil.info((String)("[find]htt:{},api:" + bizType), (long)(System.currentTimeMillis() - times));
            if (StringUtils.isBlank((String)str)) {
                this.logger.error("es.SearchengineServiceImpl.findByCode.str", (Object)opcode);
                return null;
            }
            RestBean restBean = (RestBean)JsonUtil.buildNormalBinder().getJsonToObject(str, RestBean.class);
            if (null == restBean || null == restBean.getHits() || null == restBean.getHits().getHits()) {
                this.logger.error("es.SearchengineServiceImpl.findByCode.restBean", (Object)str);
                return null;
            }
            List<DataHits> list = restBean.getHits().getHits();
            if (null == list || list.isEmpty()) {
                this.logger.error("es.SearchengineServiceImpl.findByCode.list", (Object)str);
                return null;
            }
            return list.get(0).get_source();
        }
        catch (IOException e) {
            this.logger.error("es.SearchengineServiceImpl.findByCode.e", (Throwable)e);
            return null;
        }
    }

    @Override
    @ApiMethod(code="es.searchengine.find", name="\u83b7\u53d6\u6570\u636e", paramStr="searchDomain", description="")
    public ReturnBean find(SearchDomain searchDomain) throws ApiException {
        int from;
        if (null == searchDomain || StringUtils.isBlank((String)searchDomain.getBizType())) {
            this.logger.error("es.SearchengineServiceImpl.find.null", (Object)"null");
            return null;
        }
        this.logger.debug(SYS_CODE, (Object)("searchDomain info:" + searchDomain));
        String data = searchDomain.getTenantCode();
        if (StringUtils.isBlank((String)data)) {
            this.logger.error("es.SearchengineServiceImpl.find.data", (Object)"data");
            return null;
        }
        Map<String, Object> pageMap = searchDomain.getPageMap();
        Integer rows = 10;
        Integer page = 1;
        if (null != pageMap && !pageMap.isEmpty()) {
            rows = Integer.parseInt(pageMap.get("rows").toString());
            page = Integer.parseInt(pageMap.get("page").toString());
        }
        if (null == rows || rows == 0) {
            rows = 10;
        }
        if (null == page) {
            page = 1;
        }
        if ((from = (Integer.valueOf(page) - 1) * Integer.valueOf(rows)) < 0) {
            from = 0;
        }
        String queryStr = "";
        String matchQuery = "";
        String queryJson = "";
        String sortStr = "";
        if (null != searchDomain.getSortDomain()) {
            if (StringUtils.isNotBlank((String)searchDomain.getSortDomain().getOrder())) {
                searchDomain.getSortDomain().setOrder(searchDomain.getSortDomain().getOrder().toLowerCase());
            }
            sortStr = "\"sort\": { \"" + searchDomain.getSortDomain().getSortField() + "\": { \"order\": \"" + searchDomain.getSortDomain().getOrder() + "\" }}";
        } else {
            sortStr = "\"sort\": { \"_score\": { \"order\": \"desc\" }}";
        }
        if (null != searchDomain.getBoolMap() && !searchDomain.getBoolMap().isEmpty()) {
            Object obj = null;
            for (String key : searchDomain.getBoolMap().keySet()) {
                if (StringUtils.isNotBlank((String)matchQuery)) {
                    matchQuery = matchQuery + ",";
                }
                if ((obj = searchDomain.getBoolMap().get(key)) instanceof String && null != obj) {
                    obj = ((String)obj).toLowerCase();
                }
                matchQuery = matchQuery + "{\"wildcard\": { \"" + key + ".keyword\":\"*" + obj + "*\"}},";
                matchQuery = matchQuery + "{\"match\": { \"" + key + "\":\"" + obj + "\"}}";
            }
            queryStr = "{\"bool\":{\"should\":[" + matchQuery + "]}}";
        }
        String priceRangeQuery = "2020050600004084".equals(searchDomain.getTenantCode()) && searchDomain.getMinPrice() == 0.0 ? "{\"range\": {\n      \"pricesetNprice\": {\n        \"gt\": " + searchDomain.getMinPrice() + "      }\n" + "    }}" : "{\"range\": {\n      \"pricesetNprice\": {\n        \"gte\": " + searchDomain.getMinPrice() + "      }\n" + "    }}";
        if (null != searchDomain.getMaxPrice()) {
            priceRangeQuery = "{\"range\": {\n      \"pricesetNprice\": {\n        \"gte\": " + searchDomain.getMinPrice() + ",\n" + "        \"lte\": " + searchDomain.getMaxPrice() + "\n" + "      }\n" + "    }}";
        }
        String accqueryStr = "";
        if (null != searchDomain.getAccurateQueryList() && !searchDomain.getAccurateQueryList().isEmpty()) {
            for (AccurateQueryDomain accurateQueryDomain : searchDomain.getAccurateQueryList()) {
                if (StringUtils.isNotBlank((String)accqueryStr)) {
                    accqueryStr = accqueryStr + ",";
                }
                if (ListUtil.isNotEmpty(accurateQueryDomain.getAccurateFieldValues())) {
                    accqueryStr = accqueryStr + "{\"terms\" : {\"" + accurateQueryDomain.getAccurateField() + "\":" + SearchengineServiceImpl.list2string(accurateQueryDomain.getAccurateFieldValues()) + "}}";
                    continue;
                }
                accqueryStr = accqueryStr + "{\"term\" : {\"" + accurateQueryDomain.getAccurateField() + "\":\"" + accurateQueryDomain.getAccurateFieldValue() + "\"}}";
            }
        }
        queryJson = StringUtils.isNotBlank((String)accqueryStr) ? (StringUtils.isNotBlank((String)queryStr) ? "{\"query\":{\"bool\":{\"must\":[" + accqueryStr + "," + queryStr + " ," + priceRangeQuery + "]}},\"from\":\"" + from + "\",\"size\":\"" + rows + "\"," + sortStr + "}" : "{\"query\":{\"bool\":{\"must\":[" + accqueryStr + " ," + priceRangeQuery + "]}},\"from\":\"" + from + "\",\"size\":\"" + rows + "\"," + sortStr + "}") : (StringUtils.isNotBlank((String)queryStr) ? "{\"query\":{\"bool\":{\"must\":[" + queryStr + " ," + priceRangeQuery + "]}},\"from\":\"" + from + "\",\"size\":\"" + rows + "\"," + sortStr + "}" : "{\"query\":{\"bool\":{\"must\":[" + priceRangeQuery + "]}},\"from\":\"" + from + "\",\"size\":\"" + rows + "\"," + sortStr + "}");
        try {
            long times = System.currentTimeMillis();
            String str = EsUtil.httpUrlPoolGet(data, searchDomain.getBizType(), queryJson);
            OpenPerfLogUtil.info((String)("[find]htt:{},api:" + searchDomain.getBizType()), (long)(System.currentTimeMillis() - times));
            if (StringUtils.isBlank((String)str)) {
                return null;
            }
            RestBean restBean = (RestBean)JsonUtil.buildNormalBinder().getJsonToObject(str, RestBean.class);
            if (null == restBean || null == restBean.getHits() || null == restBean.getHits().getHits()) {
                return null;
            }
            ReturnBean returnBean = new ReturnBean();
            List<DataHits> list = restBean.getHits().getHits();
            if (null == list || list.isEmpty()) {
                return null;
            }
            ArrayList<Map<String, Object>> sourcelist = new ArrayList<Map<String, Object>>();
            for (DataHits dataHits : list) {
                HashMap<String, Double> dataHit = new HashMap<String, Double>();
                try {
                    BeanUtils.copyAllPropertys(dataHit, dataHits.get_source());
                    dataHit.put("score", dataHits.get_score());
                }
                catch (Exception e) {
                    this.logger.error(SYS_CODE, (Object)"search response convert exception:", (Throwable)e);
                }
                sourcelist.add(dataHit);
            }
            this.logger.error(SYS_CODE, (Object)("sourcelist info:" + sourcelist));
            returnBean.setSourcelist(sourcelist);
            returnBean.setCount(restBean.getHits().getTotal());
            returnBean.setPage(page);
            returnBean.setRow(rows);
            return returnBean;
        }
        catch (IOException e) {
            this.logger.error("es.SearchengineServiceImpl.find.e", (Throwable)e);
            return null;
        }
    }

    @Override
    public void refresh(SearchDomain searchDomain) throws ApiException {
    }
}

