/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.security.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.auth.Apilimit;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.security.dao.SmApilimitMapper;
import com.yqbsoft.laser.service.security.domain.SmApilimitDomain;
import com.yqbsoft.laser.service.security.domain.SmApiparamAllotDomain;
import com.yqbsoft.laser.service.security.domain.SmApiparamConDomain;
import com.yqbsoft.laser.service.security.model.SmApilimit;
import com.yqbsoft.laser.service.security.service.ApilimitService;
import com.yqbsoft.laser.service.security.service.ApiparamAllotService;
import com.yqbsoft.laser.service.security.service.ApiparamConService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ApilimitServiceImpl
extends BaseServiceImpl
implements ApilimitService {
    public static final String SYS_CODE = "sm.SECURITY.ApilimitServiceImpl";
    private SmApilimitMapper smApilimitMapper;
    private ApiparamConService apiparamConService;
    private ApiparamAllotService apiparamAllotService;

    public void setApiparamConService(ApiparamConService apiparamConService) {
        this.apiparamConService = apiparamConService;
    }

    public void setApiparamAllotService(ApiparamAllotService apiparamAllotService) {
        this.apiparamAllotService = apiparamAllotService;
    }

    public void setSmApilimitMapper(SmApilimitMapper smApilimitMapper) {
        this.smApilimitMapper = smApilimitMapper;
    }

    private Date getSysDate() {
        try {
            return this.smApilimitMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("sm.SECURITY.ApilimitServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkApilimit(SmApilimitDomain smApilimitDomain) {
        if (null == smApilimitDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)smApilimitDomain.getAppapiCode())) {
            msg = msg + "AppapiCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setApilimitDefault(SmApilimit smApilimit) {
        if (null == smApilimit) {
            return;
        }
        if (null == smApilimit.getDataState()) {
            smApilimit.setDataState(0);
        }
        if (null == smApilimit.getGmtCreate()) {
            smApilimit.setGmtCreate(this.getSysDate());
        }
        smApilimit.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)smApilimit.getApilimitCode())) {
            int code = this.getMaxCode();
            smApilimit.setApilimitCode(this.makeMaxCode8(++code));
        }
    }

    private int getMaxCode() {
        int code = 0;
        try {
            return this.smApilimitMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("sm.SECURITY.ApilimitServiceImpl.getMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setApilimitUpdataDefault(SmApilimit smApilimit) {
        if (null == smApilimit) {
            return;
        }
        smApilimit.setGmtModified(this.getSysDate());
    }

    private void saveApilimitModel(SmApilimit smApilimit) throws ApiException {
        if (null == smApilimit) {
            return;
        }
        try {
            this.smApilimitMapper.insert(smApilimit);
        }
        catch (Exception e) {
            throw new ApiException("sm.SECURITY.ApilimitServiceImpl.saveFtpserverModel.ex");
        }
    }

    private SmApilimit getApilimitModelById(Integer apilimitId) {
        if (null == apilimitId) {
            return null;
        }
        try {
            return this.smApilimitMapper.selectByPrimaryKey(apilimitId);
        }
        catch (Exception e) {
            this.logger.error("sm.SECURITY.ApilimitServiceImpl.getApilimitModelById", (Throwable)e);
            return null;
        }
    }

    private void deleteApilimitModel(Integer apilimitId) throws ApiException {
        if (null == apilimitId) {
            return;
        }
        int i = 0;
        try {
            i = this.smApilimitMapper.deleteByPrimaryKey(apilimitId);
        }
        catch (Exception e) {
            throw new ApiException("sm.SECURITY.ApilimitServiceImpl.deleteApilimitModel.ex");
        }
        if (1 != i) {
            throw new ApiException("sm.SECURITY.ApilimitServiceImpl.deleteApilimitModel.num");
        }
    }

    private void updateApilimitModel(SmApilimit smApilimit) throws ApiException {
        if (null == smApilimit) {
            return;
        }
        try {
            this.smApilimitMapper.updateByPrimaryKeySelective(smApilimit);
        }
        catch (Exception e) {
            throw new ApiException("sm.SECURITY.ApilimitServiceImpl.updateApilimitModel.ex");
        }
    }

    private void updateStateApilimitModel(Integer apilimitId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == apilimitId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("apilimitId", apilimitId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.smApilimitMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("sm.SECURITY.ApilimitServiceImpl.updateStateApilimitModel.ex");
        }
        if (i <= 0) {
            throw new ApiException("sm.SECURITY.ApilimitServiceImpl.updateStateApilimitModel.null");
        }
    }

    private SmApilimit makeApilimit(SmApilimitDomain smApilimitDomain, SmApilimit smApilimit) {
        if (null == smApilimitDomain) {
            return null;
        }
        if (null == smApilimit) {
            smApilimit = new SmApilimit();
        }
        try {
            BeanUtils.copyAllPropertys((Object)smApilimit, (Object)smApilimitDomain);
        }
        catch (Exception e) {
            this.logger.error("sm.SECURITY.ApilimitServiceImpl.makeApilimit", (Throwable)e);
        }
        return smApilimit;
    }

    private List<SmApilimit> queryApilimitModelPage(Map<String, Object> parammap) {
        try {
            return this.smApilimitMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("sm.SECURITY.ApilimitServiceImpl.queryApilimitModel", (Throwable)e);
            return null;
        }
    }

    private int countApilimit(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.smApilimitMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("sm.SECURITY.ApilimitServiceImpl.countApilimit", (Throwable)e);
        }
        return i;
    }

    @Override
    public Integer saveApilimit(SmApilimitDomain smApilimitDomain) throws ApiException {
        String msg = this.checkApilimit(smApilimitDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("sm.SECURITY.ApilimitServiceImpl.saveApilimit.checkApilimit", msg);
        }
        SmApilimit smApilimit = this.makeApilimit(smApilimitDomain, null);
        this.setApilimitDefault(smApilimit);
        this.saveApilimitModel(smApilimit);
        return smApilimit.getApilimitId();
    }

    @Override
    public void updateApilimitState(Integer apilimitId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateApilimitModel(apilimitId, dataState, oldDataState);
        this.refreshCache(this.getApilimit(apilimitId), dataState);
    }

    @Override
    public void updateApilimit(SmApilimitDomain smApilimitDomain) throws ApiException {
        String msg = this.checkApilimit(smApilimitDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("sm.SECURITY.ApilimitServiceImpl.updateApilimit.checkApilimit", msg);
        }
        SmApilimit oldSmApilimit = this.getApilimitModelById(smApilimitDomain.getApilimitId());
        if (null == oldSmApilimit) {
            throw new ApiException("sm.SECURITY.ApilimitServiceImpl.updateApilimit.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        SmApilimit smApilimit = this.makeApilimit(smApilimitDomain, oldSmApilimit);
        this.setApilimitUpdataDefault(smApilimit);
        this.updateApilimitModel(smApilimit);
    }

    @Override
    public SmApilimit getApilimit(Integer apilimitId) {
        return this.getApilimitModelById(apilimitId);
    }

    @Override
    public void deleteApilimit(Integer apilimitId) throws ApiException {
        this.deleteApilimitModel(apilimitId);
    }

    @Override
    public QueryResult<SmApilimit> queryApilimitPage(Map<String, Object> map) {
        List<SmApilimit> smApilimitList = this.queryApilimitModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countApilimit(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(smApilimitList);
        return queryResult;
    }

    @Override
    public void queryApilimitCache() {
        this.info("sm.SECURITY.ApilimitServiceImpl.queryApilimitCache", "=======queryApilimitCache\u8c03\u5ea6start=======");
        List<SmApilimit> smApilimitList = this.queryApilimitModelPage(this.getQueryParamMap("dataState", new Object[]{1}));
        if (smApilimitList == null || smApilimitList.isEmpty()) {
            DisUtil.delVer((String)"SmApilimit-pro");
            this.info("sm.SECURITY.ApilimitServiceImpl.queryApilimitCache", "=======queryApilimitCache\u8c03\u5ea6end-del=======");
            return;
        }
        HashMap<String, List<Apilimit>> apilimitmap = new HashMap<String, List<Apilimit>>();
        for (SmApilimit smApilimit : smApilimitList) {
            this.saveCache(smApilimit, apilimitmap);
        }
        DisUtil.setVer((String)"SmApilimit-pro", (String)JsonUtil.buildNormalBinder().toJson(apilimitmap));
        this.info("sm.SECURITY.ApilimitServiceImpl.queryApilimitCache", "=======queryApilimitCache\u8c03\u5ea6end=======");
    }

    private Apilimit makeApilimit(SmApilimit smApilimit) {
        if (null == smApilimit) {
            return null;
        }
        Apilimit apilimit = new Apilimit();
        try {
            BeanUtils.copyAllPropertys((Object)apilimit, (Object)smApilimit);
        }
        catch (Exception e) {
            this.logger.error("sm.SECURITY.ApilimitServiceImpl.makeApilimit", (Throwable)e);
        }
        return apilimit;
    }

    private void refreshCache(SmApilimit smApilimit, Integer dataState) {
        boolean addflag = dataState == 1;
        HashMap<String, List<Apilimit>> map = DisUtil.getMapByListJson((String)"SmApilimit-pro", String.class, Apilimit.class);
        if (map == null) {
            map = new HashMap<String, List<Apilimit>>();
        }
        if (addflag) {
            this.saveCache(smApilimit, map);
        } else {
            this.deleteCache(smApilimit, map);
        }
        DisUtil.setVer((String)"SmApilimit-pro", (String)JsonUtil.buildNormalBinder().toJson(map));
    }

    private void deleteCache(SmApilimit smApilimit, Map<String, List<Apilimit>> map) {
        if (map == null) {
            return;
        }
        String key = smApilimit.getAppapiCode() + "-" + smApilimit.getApilimitUtype();
        List<Apilimit> list = map.get(key);
        if (list == null || list.isEmpty()) {
            return;
        }
        Integer index = null;
        for (int i = 0; i < list.size(); ++i) {
            if (!list.get(i).getApilimitId().equals(smApilimit.getApilimitId())) continue;
            index = i;
            break;
        }
        if (index != null) {
            list.remove(index);
        }
    }

    private void saveCache(SmApilimit smApilimit, Map<String, List<Apilimit>> map) {
        Apilimit apilimit = this.makeApilimit(smApilimit);
        String key = smApilimit.getAppapiCode() + "-" + smApilimit.getApilimitUtype();
        List<Apilimit> list = map.get(key);
        if (list == null) {
            list = new ArrayList<Apilimit>();
            map.put(key, list);
        }
        Integer index = null;
        for (int i = 0; i < list.size(); ++i) {
            if (!list.get(i).getApilimitId().equals(smApilimit.getApilimitId())) continue;
            index = i;
            break;
        }
        if (index != null) {
            list.set(index, apilimit);
        } else {
            list.add(apilimit);
        }
    }

    @Override
    public void saveApilimitByValidate(Map<String, String> map) throws ApiException {
        if (map == null || map.isEmpty()) {
            return;
        }
        String appapiCode = map.get("appapiCode");
        String appapiVersion = map.get("appapiVersion");
        String appmanageIcode = map.get("appmanageIcode");
        String appmanageAppkey = map.get("appmanageAppkey");
        String userCode = map.get("userCode");
        String paramName = map.get("paramName");
        String paramValue = map.get("paramValue");
        SmApilimitDomain smApilimitDomain = new SmApilimitDomain();
        SmApiparamConDomain smApiparamConDomain = new SmApiparamConDomain();
        SmApiparamAllotDomain smApiparamAllotDomain = new SmApiparamAllotDomain();
        smApilimitDomain.setAppapiCode(appapiCode);
        smApilimitDomain.setAppapiVersion(appapiVersion);
        smApilimitDomain.setApilimitType("validate");
        smApilimitDomain.setApilimitUtype(1);
        smApiparamConDomain.setAppapiCode(appapiCode);
        smApiparamConDomain.setAppapiVersion(appapiVersion);
        smApiparamConDomain.setAppmanageIcode(appmanageIcode);
        smApiparamConDomain.setParamName(paramName);
        smApiparamConDomain.setConUtype(smApilimitDomain.getApilimitUtype());
        smApiparamConDomain.setConType("0");
        smApiparamAllotDomain.setConType(smApiparamConDomain.getConType());
        smApiparamAllotDomain.setAppmanageAppkey(appmanageAppkey);
        smApiparamAllotDomain.setUserCode(userCode);
        smApiparamAllotDomain.setAllotUtype(smApilimitDomain.getApilimitUtype());
        smApiparamAllotDomain.setAllotValue(paramValue);
        smApiparamAllotDomain.setAllotType("0");
        Integer apilimitId = this.saveApilimit(smApilimitDomain);
        Integer apiparamConId = this.apiparamConService.saveApiparamCon(smApiparamConDomain);
        Integer apiparamAllotId = this.apiparamAllotService.saveApiparamAllot(smApiparamAllotDomain);
        this.updateApilimitState(apilimitId, 1, 0);
        this.apiparamConService.updateApiparamConState(apiparamConId, 1, 0);
        this.apiparamAllotService.updateApiparamAllotState(apiparamAllotId, 1, 0);
    }
}

