/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.security.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.auth.ApiparamAllot;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.security.dao.SmApiparamAllotMapper;
import com.yqbsoft.laser.service.security.domain.SmApiparamAllotDomain;
import com.yqbsoft.laser.service.security.model.SmApiparamAllot;
import com.yqbsoft.laser.service.security.service.ApiparamAllotService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ApiparamAllotServiceImpl
extends BaseServiceImpl
implements ApiparamAllotService {
    public static final String SYS_CODE = "sm.SECURITY.ApiparamAllotServiceImpl";
    private static final String CACHE_KEY = "SmApiparamAllot-pro";
    private SmApiparamAllotMapper smApiparamAllotMapper;

    public void setSmApiparamAllotMapper(SmApiparamAllotMapper smApiparamAllotMapper) {
        this.smApiparamAllotMapper = smApiparamAllotMapper;
    }

    private Date getSysDate() {
        try {
            return this.smApiparamAllotMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("sm.SECURITY.ApiparamAllotServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkApiparamAllot(SmApiparamAllotDomain smApiparamAllotDomain) {
        if (null == smApiparamAllotDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)smApiparamAllotDomain.getAppmanageAppkey())) {
            msg = msg + "AppmanageAppkey\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setApiparamAllotDefault(SmApiparamAllot smApiparamAllot) {
        if (null == smApiparamAllot) {
            return;
        }
        if (null == smApiparamAllot.getDataState()) {
            smApiparamAllot.setDataState(0);
        }
        if (null == smApiparamAllot.getGmtCreate()) {
            smApiparamAllot.setGmtCreate(this.getSysDate());
        }
        smApiparamAllot.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)smApiparamAllot.getAllotCode())) {
            int code = this.getMaxCode();
            smApiparamAllot.setAllotCode(this.makeMaxCode8(++code));
        }
    }

    private int getMaxCode() {
        int code = 0;
        try {
            return this.smApiparamAllotMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("sm.SECURITY.ApiparamAllotServiceImpl.getMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setApiparamAllotUpdataDefault(SmApiparamAllot smApiparamAllot) {
        if (null == smApiparamAllot) {
            return;
        }
        smApiparamAllot.setGmtModified(this.getSysDate());
    }

    private void saveApiparamAllotModel(SmApiparamAllot smApiparamAllot) throws ApiException {
        if (null == smApiparamAllot) {
            return;
        }
        try {
            this.smApiparamAllotMapper.insert(smApiparamAllot);
        }
        catch (Exception e) {
            throw new ApiException("sm.SECURITY.ApiparamAllotServiceImpl.saveFtpserverModel.ex");
        }
    }

    private SmApiparamAllot getApiparamAllotModelById(Integer apiparamAllotId) {
        if (null == apiparamAllotId) {
            return null;
        }
        try {
            return this.smApiparamAllotMapper.selectByPrimaryKey(apiparamAllotId);
        }
        catch (Exception e) {
            this.logger.error("sm.SECURITY.ApiparamAllotServiceImpl.getApiparamAllotModelById", (Throwable)e);
            return null;
        }
    }

    private void deleteApiparamAllotModel(Integer apiparamAllotId) throws ApiException {
        if (null == apiparamAllotId) {
            return;
        }
        int i = 0;
        try {
            i = this.smApiparamAllotMapper.deleteByPrimaryKey(apiparamAllotId);
        }
        catch (Exception e) {
            throw new ApiException("sm.SECURITY.ApiparamAllotServiceImpl.deleteApiparamAllotModel.ex");
        }
        if (1 != i) {
            throw new ApiException("sm.SECURITY.ApiparamAllotServiceImpl.deleteApiparamAllotModel.num");
        }
    }

    private void deleteApiparamAllotModelBatch(String appmanageAppkey, String conType) throws ApiException {
        if (null == appmanageAppkey || null == conType) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("appmanageAppkey", appmanageAppkey);
        map.put("conType", conType);
        try {
            this.smApiparamAllotMapper.deleteByAppkeyContype(map);
        }
        catch (Exception e) {
            throw new ApiException("sm.SECURITY.ApiparamAllotServiceImpl.deleteApiparamAllotModel.ex");
        }
    }

    private void updateApiparamAllotModel(SmApiparamAllot smApiparamAllot) throws ApiException {
        if (null == smApiparamAllot) {
            return;
        }
        try {
            this.smApiparamAllotMapper.updateByPrimaryKeySelective(smApiparamAllot);
        }
        catch (Exception e) {
            throw new ApiException("sm.SECURITY.ApiparamAllotServiceImpl.updateApiparamAllotModel.ex");
        }
    }

    private void updateStateApiparamAllotModel(Integer apiparamAllotId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == apiparamAllotId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("apiparamAllotId", apiparamAllotId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.smApiparamAllotMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("sm.SECURITY.ApiparamAllotServiceImpl.updateStateApiparamAllotModel.ex");
        }
        if (i <= 0) {
            throw new ApiException("sm.SECURITY.ApiparamAllotServiceImpl.updateStateApiparamAllotModel.null");
        }
    }

    private SmApiparamAllot makeApiparamAllot(SmApiparamAllotDomain smApiparamAllotDomain, SmApiparamAllot smApiparamAllot) {
        if (null == smApiparamAllotDomain) {
            return null;
        }
        if (null == smApiparamAllot) {
            smApiparamAllot = new SmApiparamAllot();
        }
        try {
            BeanUtils.copyAllPropertys((Object)smApiparamAllot, (Object)smApiparamAllotDomain);
        }
        catch (Exception e) {
            this.logger.error("sm.SECURITY.ApiparamAllotServiceImpl.makeApiparamAllot", (Throwable)e);
        }
        return smApiparamAllot;
    }

    private List<SmApiparamAllot> queryApiparamAllotModelPage(Map<String, Object> parammap) {
        try {
            return this.smApiparamAllotMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("sm.SECURITY.ApiparamAllotServiceImpl.queryApiparamAllotModel", (Throwable)e);
            return null;
        }
    }

    private int countApiparamAllot(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.smApiparamAllotMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("sm.SECURITY.ApiparamAllotServiceImpl.countApiparamAllot", (Throwable)e);
        }
        return i;
    }

    @Override
    public Integer saveApiparamAllot(SmApiparamAllotDomain smApiparamAllotDomain) throws ApiException {
        String msg = this.checkApiparamAllot(smApiparamAllotDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("sm.SECURITY.ApiparamAllotServiceImpl.saveApiparamAllot.checkApiparamAllot", msg);
        }
        SmApiparamAllot smApiparamAllot = this.makeApiparamAllot(smApiparamAllotDomain, null);
        this.setApiparamAllotDefault(smApiparamAllot);
        this.saveApiparamAllotModel(smApiparamAllot);
        this.updateApiparamAllotState(smApiparamAllot.getApiparamAllotId(), 1, null);
        return smApiparamAllot.getApiparamAllotId();
    }

    @Override
    public List<Integer> saveApiparamAllotBatch(List<SmApiparamAllotDomain> smApiparamAllotDomainList) throws ApiException {
        if (smApiparamAllotDomainList == null || smApiparamAllotDomainList.size() < 1) {
            return null;
        }
        ArrayList<Integer> allotIdList = new ArrayList<Integer>();
        for (SmApiparamAllotDomain smApiparamAllotDomain : smApiparamAllotDomainList) {
            Integer apiparamAllotId = this.saveApiparamAllot(smApiparamAllotDomain);
            allotIdList.add(apiparamAllotId);
        }
        return allotIdList;
    }

    @Override
    public void updateApiparamAllotState(Integer apiparamAllotId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateApiparamAllotModel(apiparamAllotId, dataState, oldDataState);
        this.refreshCache(this.getApiparamAllot(apiparamAllotId), dataState);
    }

    @Override
    public void updateApiparamAllotValue(Integer apiparamAllotId, String allotValue) throws ApiException {
        String msg = "";
        if (!StringUtils.isNotBlank((String)String.valueOf(apiparamAllotId))) {
            throw new ApiException("sm.SECURITY.ApiparamAllotServiceImpl.updateApiparamAllotValue.checkApiparamAllotId", msg);
        }
        if (!StringUtils.isNotBlank((String)allotValue)) {
            throw new ApiException("sm.SECURITY.ApiparamAllotServiceImpl.updateApiparamAllotValue.checkApiparamAllotValue", msg);
        }
        SmApiparamAllot smApiparamAllot = new SmApiparamAllot();
        smApiparamAllot.setApiparamAllotId(apiparamAllotId);
        smApiparamAllot.setAllotValue(allotValue);
        this.updateApiparamAllotModel(smApiparamAllot);
        this.refreshCache(this.getApiparamAllot(apiparamAllotId), 1);
    }

    @Override
    public void updateApiparamAllot(SmApiparamAllotDomain smApiparamAllotDomain) throws ApiException {
        String msg = this.checkApiparamAllot(smApiparamAllotDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("sm.SECURITY.ApiparamAllotServiceImpl.updateApiparamAllot.checkApiparamAllot", msg);
        }
        SmApiparamAllot oldSmApiparamAllot = this.getApiparamAllotModelById(smApiparamAllotDomain.getApiparamAllotId());
        if (null == oldSmApiparamAllot) {
            throw new ApiException("sm.SECURITY.ApiparamAllotServiceImpl.updateApiparamAllot.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        SmApiparamAllot smApiparamAllot = this.makeApiparamAllot(smApiparamAllotDomain, oldSmApiparamAllot);
        this.setApiparamAllotUpdataDefault(smApiparamAllot);
        this.updateApiparamAllotModel(smApiparamAllot);
    }

    @Override
    public SmApiparamAllot getApiparamAllot(Integer apiparamAllotId) {
        return this.getApiparamAllotModelById(apiparamAllotId);
    }

    @Override
    public void deleteApiparamAllot(Integer apiparamAllotId) throws ApiException {
        SmApiparamAllot smApiparamAllot = this.getApiparamAllot(apiparamAllotId);
        this.deleteApiparamAllotModel(apiparamAllotId);
        this.refreshCache(smApiparamAllot, 0);
    }

    @Override
    public void deleteApiparamAllotBatch(String appmanageAppkey, String conType) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("appmanageAppkey", appmanageAppkey);
        map.put("conType", conType);
        List<SmApiparamAllot> smApiparamAllotList = this.queryApiparamAllotList(map);
        if (smApiparamAllotList != null && smApiparamAllotList.size() > 0) {
            this.deleteApiparamAllotModelBatch(appmanageAppkey, conType);
            for (SmApiparamAllot smApiparamAllot : smApiparamAllotList) {
                this.refreshCache(smApiparamAllot, 0);
            }
        }
    }

    @Override
    public QueryResult<SmApiparamAllot> queryApiparamAllotPage(Map<String, Object> map) {
        List<SmApiparamAllot> smApiparamAllotList = this.queryApiparamAllotModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countApiparamAllot(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(smApiparamAllotList);
        return queryResult;
    }

    @Override
    public List<SmApiparamAllot> queryApiparamAllotList(Map<String, Object> map) {
        List<SmApiparamAllot> smApiparamAllotList = this.queryApiparamAllotModelPage(map);
        return smApiparamAllotList;
    }

    @Override
    public void queryApiparamAllotCache() {
        this.info("sm.SECURITY.ApiparamAllotServiceImpl.queryApiparamAllotCache", "=======queryApiparamAllotCache\u8c03\u5ea6start=======");
        List<SmApiparamAllot> smApiparamAllotList = this.queryApiparamAllotModelPage(this.getQueryParamMap("dataState", new Object[]{1}));
        if (smApiparamAllotList == null || smApiparamAllotList.isEmpty()) {
            DisUtil.delVer((String)CACHE_KEY);
            this.info("sm.SECURITY.ApiparamAllotServiceImpl.queryApiparamAllotCache", "=======queryApiparamAllotCache\u8c03\u5ea6end-del=======");
            return;
        }
        HashMap<String, ArrayList<ApiparamAllot>> apiparamAllotmap = new HashMap<String, ArrayList<ApiparamAllot>>();
        for (SmApiparamAllot smApiparamAllot : smApiparamAllotList) {
            ApiparamAllot apiparamAllot = this.makeApiparamAllot(smApiparamAllot);
            String key = apiparamAllot.getUserCode() + "-" + apiparamAllot.getAppmanageAppkey() + "-" + apiparamAllot.getConType() + "-" + apiparamAllot.getParamVerifyCode() + "-" + apiparamAllot.getAllotUtype();
            ArrayList<ApiparamAllot> list = (ArrayList<ApiparamAllot>)apiparamAllotmap.get(key);
            if (list == null) {
                list = new ArrayList<ApiparamAllot>();
                apiparamAllotmap.put(key, list);
            }
            list.add(apiparamAllot);
        }
        DisUtil.setVer((String)CACHE_KEY, (String)JsonUtil.buildNormalBinder().toJson(apiparamAllotmap));
        this.info("sm.SECURITY.ApiparamAllotServiceImpl.queryApiparamAllotCache", "=======queryApiparamAllotCache\u8c03\u5ea6end=======");
    }

    private ApiparamAllot makeApiparamAllot(SmApiparamAllot smApiparamAllot) {
        if (null == smApiparamAllot) {
            return null;
        }
        ApiparamAllot apiparamAllot = new ApiparamAllot();
        try {
            BeanUtils.copyAllPropertys((Object)apiparamAllot, (Object)smApiparamAllot);
        }
        catch (Exception e) {
            this.logger.error("sm.SECURITY.ApiparamAllotServiceImpl.makeApiparamAllot", (Throwable)e);
        }
        return apiparamAllot;
    }

    private void refreshCache(SmApiparamAllot smApiparamAllot, Integer dataState) {
        boolean addflag = dataState == 1;
        HashMap<String, List<ApiparamAllot>> map = DisUtil.getMapByListJson((String)CACHE_KEY, String.class, ApiparamAllot.class);
        if (map == null) {
            map = new HashMap<String, List<ApiparamAllot>>();
        }
        if (addflag) {
            this.saveCache(smApiparamAllot, map);
        } else {
            this.deleteCache(smApiparamAllot, map);
        }
        DisUtil.setVer((String)CACHE_KEY, (String)JsonUtil.buildNormalBinder().toJson(map));
    }

    private void deleteCache(SmApiparamAllot apiparamAllot, Map<String, List<ApiparamAllot>> map) {
        if (map == null) {
            return;
        }
        String key = apiparamAllot.getUserCode() + "-" + apiparamAllot.getAppmanageAppkey() + "-" + apiparamAllot.getConType() + "-" + apiparamAllot.getParamVerifyCode() + "-" + apiparamAllot.getAllotUtype();
        List<ApiparamAllot> list = map.get(key);
        if (list == null || list.isEmpty()) {
            return;
        }
        Integer index = null;
        for (int i = 0; i < list.size(); ++i) {
            if (!list.get(i).getApiparamAllotId().equals(apiparamAllot.getApiparamAllotId())) continue;
            index = i;
            break;
        }
        if (index != null) {
            list.remove(index);
        }
    }

    private void saveCache(SmApiparamAllot smApiparamAllot, Map<String, List<ApiparamAllot>> map) {
        ApiparamAllot apiparamAllot = this.makeApiparamAllot(smApiparamAllot);
        String key = apiparamAllot.getUserCode() + "-" + apiparamAllot.getAppmanageAppkey() + "-" + apiparamAllot.getConType() + "-" + apiparamAllot.getParamVerifyCode() + "-" + apiparamAllot.getAllotUtype();
        List<ApiparamAllot> list = map.get(key);
        if (list == null) {
            list = new ArrayList<ApiparamAllot>();
            map.put(key, list);
        }
        Integer index = null;
        for (int i = 0; i < list.size(); ++i) {
            if (!list.get(i).getApiparamAllotId().equals(smApiparamAllot.getApiparamAllotId())) continue;
            index = i;
            break;
        }
        if (index != null) {
            list.set(index, apiparamAllot);
        } else {
            list.add(apiparamAllot);
        }
    }
}

