/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.security.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.auth.Blackip;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.security.dao.SmBlackipMapper;
import com.yqbsoft.laser.service.security.domain.SmBlackipDomain;
import com.yqbsoft.laser.service.security.model.SmBlackip;
import com.yqbsoft.laser.service.security.service.BlackipService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BlackipServiceImpl
extends BaseServiceImpl
implements BlackipService {
    public static final String SYS_CODE = "sm.SECURITY.BlackIPServiceImpl";
    private static final String CACHE_KEY = "SmBlackip-pro";
    private SmBlackipMapper smBlackipMapper;

    public SmBlackipMapper getSmBlackipMapper() {
        return this.smBlackipMapper;
    }

    public void setSmBlackipMapper(SmBlackipMapper smBlackipMapper) {
        this.smBlackipMapper = smBlackipMapper;
    }

    private void insertBlackip(SmBlackip smBlackip) throws ApiException {
        try {
            this.smBlackipMapper.insert(smBlackip);
        }
        catch (Exception e) {
            throw new ApiException("sm.SECURITY.BlackIPServiceImpl.insertBlackip", "", (Throwable)e);
        }
    }

    private void updateBlackip(SmBlackip smBlackip) throws ApiException {
        try {
            this.smBlackipMapper.updateByPrimaryKey(smBlackip);
        }
        catch (Exception e) {
            throw new ApiException("sm.SECURITY.BlackIPServiceImpl.updateBlackip", "", (Throwable)e);
        }
    }

    private String check(SmBlackip smBlackip) {
        if (null == smBlackip) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)smBlackip.getBlackipIp())) {
            msg = msg + "BlackipIp\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setInsertDefaultValue(SmBlackip smBlackip) {
        if (null == smBlackip) {
            return;
        }
        if (null == smBlackip.getDataState()) {
            smBlackip.setDataState(0);
        }
        if (null == smBlackip.getGmtCreate()) {
            smBlackip.setGmtCreate(this.getSysDate());
        }
    }

    private void setUpdateDefaultValue(SmBlackip smBlackip) {
        if (null == smBlackip) {
            return;
        }
        if (null == smBlackip.getDataState()) {
            smBlackip.setDataState(0);
        }
        if (null == smBlackip.getGmtModified()) {
            smBlackip.setGmtModified(this.getSysDate());
        }
    }

    private Date getSysDate() {
        try {
            return this.smBlackipMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("sm.SECURITY.BlackIPServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private void deleteBlackip(Integer blackipId) throws ApiException {
        int i = 0;
        try {
            i = this.smBlackipMapper.deleteByPrimaryKey(blackipId);
        }
        catch (Exception e) {
            throw new ApiException("sm.SECURITY.BlackIPServiceImpl.deleteMq.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("sm.SECURITY.BlackIPServiceImpl.deleteMq.no");
        }
    }

    private void updateStateMode(Integer blackipId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == blackipId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("blackipId", blackipId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.smBlackipMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("sm.SECURITY.BlackIPServiceImpl.updateStateMode.ex");
        }
        if (i <= 0) {
            throw new ApiException("sm.SECURITY.BlackIPServiceImpl.updateStateMode.null");
        }
    }

    @Override
    public void saveSmBlackip(SmBlackipDomain smBlackipDomain) throws ApiException {
        SmBlackip smBlackip = new SmBlackip();
        String msg = this.check(smBlackip = this.makeModel(smBlackip, smBlackipDomain));
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("sm.SECURITY.BlackIPServiceImpl.saveSmBlackip.check", msg);
        }
        this.setInsertDefaultValue(smBlackip);
        this.insertBlackip(smBlackip);
    }

    @Override
    public void updateBlackip(SmBlackipDomain smBlackipDomain) throws ApiException {
        SmBlackip smBlackip = this.getBlackip(smBlackipDomain.getBlackipId());
        if (smBlackip == null) {
            throw new ApiException("sm.SECURITY.BlackIPServiceImpl.updateMpermission.exsit", "\u8bb0\u5f55\u4e0d\u5b58\u5728");
        }
        String msg = this.check(smBlackip = this.makeModel(smBlackip, smBlackipDomain));
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("sm.SECURITY.BlackIPServiceImpl.updateMqserver.check", msg);
        }
        this.setUpdateDefaultValue(smBlackip);
        this.updateBlackip(smBlackip);
    }

    private SmBlackip makeModel(SmBlackip smBlackip, SmBlackipDomain smBlackipDomain) {
        if (smBlackipDomain == null) {
            return null;
        }
        if (smBlackip == null) {
            smBlackip = new SmBlackip();
        }
        try {
            BeanUtils.copyAllPropertys((Object)smBlackip, (Object)smBlackipDomain);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return smBlackip;
    }

    @Override
    public void deleteSmBlackipById(Integer blackipId) throws ApiException {
        this.deleteBlackip(blackipId);
    }

    @Override
    public void updateBlackipState(Integer blackipId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateMode(blackipId, dataState, oldDataState);
        this.refreshCache(this.getBlackip(blackipId), dataState);
    }

    @Override
    public SmBlackip getBlackip(Integer blackipId) {
        return this.smBlackipMapper.selectByPrimaryKey(blackipId);
    }

    @Override
    public QueryResult<SmBlackip> querySmBlackipPage(Map<String, Object> map) {
        List<SmBlackip> SmBlackipList = this.querySmBlackip(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countBlackip(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(SmBlackipList);
        return queryResult;
    }

    private int countBlackip(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.smBlackipMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("sm.SECURITY.BlackIPServiceImpl.countBlackip", (Throwable)e);
        }
        return i;
    }

    private List<SmBlackip> querySmBlackip(Map<String, Object> parameters) {
        try {
            return this.smBlackipMapper.query(parameters);
        }
        catch (Exception e) {
            this.logger.error("", (Throwable)e);
            return null;
        }
    }

    @Override
    public List<SmBlackip> querySmBlackipList(Map<String, Object> map) {
        return this.querySmBlackip(map);
    }

    @Override
    public void queryBlackipCache() {
        this.info("sm.SECURITY.BlackIPServiceImpl.queryBlackipCache", "=======queryBlackipCache\u8c03\u5ea6start=======");
        List<SmBlackip> smBlackipList = this.querySmBlackip(this.getQueryParamMap("dataState", new Object[]{1}));
        if (smBlackipList == null || smBlackipList.isEmpty()) {
            DisUtil.delVer((String)CACHE_KEY);
            this.info("sm.SECURITY.BlackIPServiceImpl.queryBlackipCache", "=======queryBlackipCache\u8c03\u5ea6end-del=======");
            return;
        }
        HashMap<String, Blackip> smap = new HashMap<String, Blackip>();
        for (SmBlackip smBlackip : smBlackipList) {
            this.saveCache(smBlackip, smap);
        }
        DisUtil.setVer((String)CACHE_KEY, (String)JsonUtil.buildNormalBinder().toJson(smap));
        this.info("sm.SECURITY.BlackIPServiceImpl.queryBlackipCache", "=======queryBlackipCache\u8c03\u5ea6end=======");
    }

    private void refreshCache(SmBlackip smBlackip, Integer dataState) {
        boolean addflag = dataState == 1;
        HashMap<String, Blackip> map = DisUtil.getMapJson((String)CACHE_KEY, String.class, Blackip.class);
        if (map == null) {
            map = new HashMap<String, Blackip>();
        }
        if (addflag) {
            this.saveCache(smBlackip, map);
        } else {
            this.deleteCache(smBlackip, map);
        }
        DisUtil.setVer((String)CACHE_KEY, (String)JsonUtil.buildNormalBinder().toJson(map));
    }

    private void deleteCache(SmBlackip smBlackip, Map<String, Blackip> map) {
        if (map == null) {
            return;
        }
        String key = smBlackip.getBlackipIp();
        Blackip blackip = map.get(key);
        if (blackip == null) {
            return;
        }
        map.remove(key);
    }

    private void saveCache(SmBlackip smBlackip, Map<String, Blackip> map) {
        Blackip blackip = this.makeBlackip(smBlackip);
        String key = smBlackip.getBlackipIp();
        if (blackip != null) {
            map.put(key, blackip);
        }
    }

    private Blackip makeBlackip(SmBlackip smBlackip) {
        if (null == smBlackip) {
            return null;
        }
        Blackip blackip = new Blackip();
        try {
            BeanUtils.copyAllPropertys((Object)blackip, (Object)smBlackip);
        }
        catch (Exception e) {
            this.logger.error("sm.SECURITY.BlackIPServiceImpl.makeBlackip", (Throwable)e);
        }
        return blackip;
    }
}

