/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.security.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.auth.Seclist;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.security.dao.SmSeclistMapper;
import com.yqbsoft.laser.service.security.dao.SmSeclogMapper;
import com.yqbsoft.laser.service.security.domain.SmSeclistDomain;
import com.yqbsoft.laser.service.security.model.SmSeclist;
import com.yqbsoft.laser.service.security.model.SmSeclog;
import com.yqbsoft.laser.service.security.service.SeclistService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SeclistServiceImpl
extends BaseServiceImpl
implements SeclistService {
    public static final String SYS_CODE = "sm.SECURITY.SeclistServiceImpl";
    private SmSeclistMapper smSeclistMapper;
    private SmSeclogMapper smSeclogMapper;

    public void setSmSeclistMapper(SmSeclistMapper smSeclistMapper) {
        this.smSeclistMapper = smSeclistMapper;
    }

    public void setSmSeclogMapper(SmSeclogMapper smSeclogMapper) {
        this.smSeclogMapper = smSeclogMapper;
    }

    private Date getSysDate() {
        try {
            return this.smSeclistMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("sm.SECURITY.SeclistServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkSeclist(SmSeclistDomain smSeclistDomain) {
        if (null == smSeclistDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        return msg;
    }

    private void setSeclistDefault(SmSeclist smSeclist) {
        if (null == smSeclist) {
            return;
        }
        if (null == smSeclist.getDataState()) {
            smSeclist.setDataState(0);
        }
        if (null == smSeclist.getGmtCreate()) {
            smSeclist.setGmtCreate(this.getSysDate());
        }
        if (StringUtils.isBlank((String)smSeclist.getSeclistCode())) {
            int code = this.getMaxCode();
            smSeclist.setSeclistCode(this.makeMaxCode8(++code));
        }
    }

    private int getMaxCode() {
        int code = 0;
        try {
            return this.smSeclistMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("sm.SECURITY.SeclistServiceImpl.getMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setSeclogDefault(SmSeclog smSeclog) {
        if (null == smSeclog) {
            return;
        }
        if (null == smSeclog.getDataState()) {
            smSeclog.setDataState(0);
        }
        if (null == smSeclog.getGmtCreate()) {
            smSeclog.setGmtCreate(this.getSysDate());
        }
    }

    private void setSeclistUpdataDefault(SmSeclist smSeclist) {
        if (null == smSeclist) {
            return;
        }
        if (null == smSeclist.getGmtModified()) {
            smSeclist.setGmtModified(this.getSysDate());
        }
    }

    private int saveSeclistModel(SmSeclist smSeclist) throws ApiException {
        if (null == smSeclist) {
            return 0;
        }
        try {
            return this.smSeclistMapper.insert(smSeclist);
        }
        catch (Exception e) {
            throw new ApiException("sm.SECURITY.SeclistServiceImpl.saveSeclistModel.ex");
        }
    }

    private SmSeclist getSeclistModelById(Integer seclistId) {
        if (null == seclistId) {
            return null;
        }
        try {
            return this.smSeclistMapper.selectByPrimaryKey(seclistId);
        }
        catch (Exception e) {
            this.logger.error("sm.SECURITY.SeclistServiceImpl.getSeclistModelById", (Throwable)e);
            return null;
        }
    }

    private void deleteSeclistModel(Integer seclistId) throws ApiException {
        if (null == seclistId) {
            return;
        }
        int i = 0;
        try {
            i = this.smSeclistMapper.deleteByPrimaryKey(seclistId);
        }
        catch (Exception e) {
            throw new ApiException("sm.SECURITY.SeclistServiceImpl.deleteSeclistModel.ex");
        }
        if (1 != i) {
            throw new ApiException("sm.SECURITY.SeclistServiceImpl.deleteSeclistModel.num");
        }
    }

    private void deleteSeclistBatchModel(Integer seclistOtype, String seclistOcode, Integer seclistType, Integer seclistUtype) throws ApiException {
        if (null == seclistOtype || null == seclistOcode) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("seclistOtype", seclistOtype);
        map.put("seclistOcode", seclistOcode);
        map.put("seclistType", seclistType);
        map.put("seclistUtype", seclistUtype);
        try {
            this.smSeclistMapper.deleteBatch(map);
        }
        catch (Exception e) {
            throw new ApiException("sm.SECURITY.SeclistServiceImpl.deleteSeclistBatchModel.ex");
        }
    }

    private void updateSeclistModel(SmSeclist smSeclist) throws ApiException {
        if (null == smSeclist) {
            return;
        }
        try {
            this.smSeclistMapper.updateByPrimaryKeySelective(smSeclist);
        }
        catch (Exception e) {
            throw new ApiException("sm.SECURITY.SeclistServiceImpl.updateSeclistModel.ex", (Throwable)e);
        }
    }

    private void updateStateSeclistModel(Integer seclistId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == seclistId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("seclistId", seclistId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.smSeclistMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("sm.SECURITY.SeclistServiceImpl.updateStateSeclistModel.ex");
        }
        if (i <= 0) {
            throw new ApiException("sm.SECURITY.SeclistServiceImpl.updateStateSeclistModel.null");
        }
    }

    private void updateSeclistMesModel(Integer seclistId, String seclistOvalue1, String seclistOvalue2, String seclistValue1) throws ApiException {
        if (null == seclistId) {
            return;
        }
        if (null == seclistOvalue1 && null == seclistValue1) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("seclistId", seclistId);
        map.put("seclistOvalue1", seclistOvalue1);
        map.put("seclistOvalue2", seclistOvalue2);
        map.put("seclistValue1", seclistValue1);
        int i = 0;
        try {
            i = this.smSeclistMapper.updateMesByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("sm.SECURITY.SeclistServiceImpl.updateSeclistMesModel.ex");
        }
        if (i <= 0) {
            throw new ApiException("sm.SECURITY.SeclistServiceImpl.updateSeclistMesModel.null");
        }
    }

    private SmSeclist makeSeclist(SmSeclistDomain smSeclistDomain, SmSeclist smSeclist) {
        if (null == smSeclistDomain) {
            return null;
        }
        if (null == smSeclist) {
            smSeclist = new SmSeclist();
        }
        try {
            BeanUtils.copyAllPropertys((Object)smSeclist, (Object)smSeclistDomain);
        }
        catch (Exception e) {
            this.logger.error("sm.SECURITY.SeclistServiceImpl.makeSeclist", (Throwable)e);
        }
        return smSeclist;
    }

    private List<SmSeclist> querySeclistModelPage(Map<String, Object> parammap) {
        try {
            return this.smSeclistMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("sm.SECURITY.SeclistServiceImpl.querySeclistModel", (Throwable)e);
            return null;
        }
    }

    private int countSeclist(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.smSeclistMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("sm.SECURITY.SeclistServiceImpl.countSeclist", (Throwable)e);
        }
        return i;
    }

    @Override
    public int saveSeclist(SmSeclistDomain smSeclistDomain) throws ApiException {
        String msg = this.checkSeclist(smSeclistDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("sm.SECURITY.SeclistServiceImpl.saveSeclist.checkSeclist", msg);
        }
        SmSeclist smSeclist = this.makeSeclist(smSeclistDomain, null);
        this.setSeclistDefault(smSeclist);
        this.saveSeclistModel(smSeclist);
        int seclistId = smSeclist.getSeclistId();
        if (seclistId != 0) {
            String seclogNewcontent = this.getSmSeclistModContent(smSeclist);
            SmSeclog smSeclog = new SmSeclog();
            smSeclog.setSeclogNewcontent(seclogNewcontent);
            smSeclog.setSeclogType("0");
            smSeclog.setSeclistId(seclistId);
            this.setSeclogDefault(smSeclog);
            this.saveSeclog(smSeclog);
        }
        return seclistId;
    }

    @Override
    public List<Integer> saveSeclistLot(List<SmSeclistDomain> smSeclistDomainList, String cacheFlag) throws ApiException {
        ArrayList<Integer> seclistIdList = new ArrayList<Integer>();
        if (smSeclistDomainList == null || smSeclistDomainList.size() < 1) {
            return null;
        }
        for (SmSeclistDomain smSeclistDomain : smSeclistDomainList) {
            int seclistId = this.saveSeclist(smSeclistDomain);
            seclistIdList.add(seclistId);
            if (!StringUtils.isNotBlank((String)cacheFlag) || !"1".equals(cacheFlag)) continue;
            this.updateSeclistState(seclistId, 1, 0);
        }
        return seclistIdList;
    }

    @Override
    public int saveSeclistBatch(SmSeclistDomain smSeclistDomain) throws ApiException {
        String msg = this.checkSeclist(smSeclistDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("sm.SECURITY.SeclistServiceImpl.saveSeclist.checkSeclist", msg);
        }
        SmSeclist smSeclist = this.makeSeclist(smSeclistDomain, null);
        this.setSeclistDefault(smSeclist);
        this.saveSeclistModel(smSeclist);
        this.refreshCache(smSeclist, 1);
        int seclistId = smSeclist.getSeclistId();
        if (seclistId != 0) {
            String seclogNewcontent = this.getSmSeclistModContent(smSeclist);
            SmSeclog smSeclog = new SmSeclog();
            smSeclog.setSeclogNewcontent(seclogNewcontent);
            smSeclog.setSeclogType("0");
            smSeclog.setSeclistId(seclistId);
            this.setSeclogDefault(smSeclog);
            this.saveSeclog(smSeclog);
        }
        return seclistId;
    }

    public void saveSeclog(SmSeclog smSeclog) throws ApiException {
        if (null == smSeclog) {
            return;
        }
        try {
            this.smSeclogMapper.insert(smSeclog);
        }
        catch (Exception e) {
            throw new ApiException("sm.SECURITY.SeclistServiceImpl.saveSeclog.ex");
        }
    }

    public String getSmSeclistModContent(SmSeclist smSeclist) {
        StringBuffer sb = new StringBuffer();
        sb.append("CODE:" + smSeclist.getSeclistCode()).append(",Otype:" + smSeclist.getSeclistOtype()).append(",Ocode:" + smSeclist.getSeclistOcode()).append(",Oname:" + smSeclist.getSeclistOname()).append(",Type:" + smSeclist.getSeclistType()).append(",Rtype:" + smSeclist.getSeclistRtype()).append(",Proxy:" + smSeclist.getSeclistProxy()).append(",Dire:" + smSeclist.getSeclistDire()).append(",Dateflag:" + smSeclist.getSeclistDateflag()).append(",Sdate:" + smSeclist.getSeclistSdate()).append(",Edate:" + smSeclist.getSeclistEdate()).append(",Value1:" + smSeclist.getSeclistValue1()).append(",Value2:" + smSeclist.getSeclistValue2()).append(",Ovalue1:" + smSeclist.getSeclistOvalue1()).append(",Ovalue2:" + smSeclist.getSeclistOvalue2());
        return sb.toString();
    }

    public String getSmSeclistModContent(SmSeclistDomain smSeclistDomain) {
        StringBuffer sb = new StringBuffer();
        sb.append("CODE:" + smSeclistDomain.getSeclistCode()).append(",Otype:" + smSeclistDomain.getSeclistOtype()).append(",Ocode:" + smSeclistDomain.getSeclistOcode()).append(",Oname:" + smSeclistDomain.getSeclistOname()).append(",Type:" + smSeclistDomain.getSeclistType()).append(",Rtype:" + smSeclistDomain.getSeclistRtype()).append(",Proxy:" + smSeclistDomain.getSeclistProxy()).append(",Dire:" + smSeclistDomain.getSeclistDire()).append(",Dateflag:" + smSeclistDomain.getSeclistDateflag()).append(",Sdate:" + smSeclistDomain.getSeclistSdate()).append(",Edate:" + smSeclistDomain.getSeclistEdate()).append(",Value1:" + smSeclistDomain.getSeclistValue1()).append(",Value2:" + smSeclistDomain.getSeclistValue2()).append(",Ovalue1:" + smSeclistDomain.getSeclistOvalue1()).append(",Ovalue2:" + smSeclistDomain.getSeclistOvalue2());
        return sb.toString();
    }

    @Override
    public void updateSeclistState(Integer seclistId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateSeclistModel(seclistId, dataState, oldDataState);
        this.refreshCache(this.getSeclist(seclistId), dataState);
    }

    @Override
    public void updateSeclistMes(Integer seclistId, String seclistOvalue1, String seclistOvalue2, String seclistValue1) throws ApiException {
        this.updateSeclistMesModel(seclistId, seclistOvalue1, seclistOvalue2, seclistValue1);
        this.refreshCache(this.getSeclist(seclistId), 1);
    }

    @Override
    public void updateSeclist(SmSeclistDomain smSeclistDomain) throws ApiException {
        String msg = this.checkSeclist(smSeclistDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("sm.SECURITY.SeclistServiceImpl.updateSeclist.checkSeclist", msg);
        }
        SmSeclist oldSmSeclist = this.getSeclistModelById(smSeclistDomain.getSeclistId());
        if (null == oldSmSeclist) {
            throw new ApiException("sm.SECURITY.SeclistServiceImpl.updateSeclist.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        SmSeclist smSeclist = this.makeSeclist(smSeclistDomain, oldSmSeclist);
        this.setSeclistUpdataDefault(smSeclist);
        this.updateSeclistModel(smSeclist);
        String seclogOlecontent = this.getSmSeclistModContent(oldSmSeclist);
        String seclogNewcontent = this.getSmSeclistModContent(smSeclistDomain);
        SmSeclog smSeclog = new SmSeclog();
        smSeclog.setSeclogOlecontent(seclogOlecontent);
        smSeclog.setSeclogNewcontent(seclogNewcontent);
        smSeclog.setSeclogType("1");
        smSeclog.setSeclistId(smSeclist.getSeclistId());
        this.setSeclogDefault(smSeclog);
        this.saveSeclog(smSeclog);
    }

    @Override
    public SmSeclist getSeclist(Integer seclistId) {
        return this.getSeclistModelById(seclistId);
    }

    @Override
    public void deleteSeclist(Integer seclistId) throws ApiException {
        this.deleteSeclistModel(seclistId);
    }

    @Override
    public void deleteSeclistBatch(Integer seclistOtype, String seclistOcode, Integer seclistType, Integer seclistUtype) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("seclistOtype", seclistOtype);
        map.put("seclistOcode", seclistOcode);
        map.put("seclistType", seclistType);
        map.put("seclistUtype", seclistUtype);
        List<SmSeclist> smSeclistList = this.querySeclistModelPage(map);
        for (SmSeclist smSeclist : smSeclistList) {
            this.refreshCache(smSeclist, 0);
        }
        this.deleteSeclistBatchModel(seclistOtype, seclistOcode, seclistType, seclistUtype);
    }

    @Override
    public QueryResult<SmSeclist> querySeclistPage(Map<String, Object> map) {
        List<SmSeclist> smSeclistList = this.querySeclistModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countSeclist(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(smSeclistList);
        return queryResult;
    }

    @Override
    public void querySeclistCache() {
        this.info("sm.SECURITY.SeclistServiceImpl.querySeclistCache", "=======querySeclistCache\u8c03\u5ea6start=======");
        List<SmSeclist> smSeclistList = this.querySeclistModelPage(this.getQueryParamMap("dataState", new Object[]{1}));
        if (smSeclistList == null || smSeclistList.isEmpty()) {
            DisUtil.delVer((String)"SmSeclist-pro");
            this.info("sm.SECURITY.SeclistServiceImpl.querySeclistCache", "=======querySeclistCache\u8c03\u5ea6end-del=======");
            return;
        }
        HashMap<String, List<Seclist>> smap = new HashMap<String, List<Seclist>>();
        for (SmSeclist smSeclist : smSeclistList) {
            this.saveCache(smSeclist, smap);
        }
        DisUtil.setVer((String)"SmSeclist-pro", (String)JsonUtil.buildNormalBinder().toJson(smap));
        this.info("sm.SECURITY.SeclistServiceImpl.querySeclistCache", "=======querySeclistCache\u8c03\u5ea6end=======");
    }

    private Seclist makeSeclist(SmSeclist smSeclist) {
        if (null == smSeclist) {
            return null;
        }
        Seclist seclist = new Seclist();
        try {
            BeanUtils.copyAllPropertys((Object)seclist, (Object)smSeclist);
        }
        catch (Exception e) {
            this.logger.error("sm.SECURITY.SeclistServiceImpl.makeSeclist", (Throwable)e);
        }
        return seclist;
    }

    private void refreshCache(SmSeclist smSeclist, Integer dataState) {
        boolean addflag = dataState == 1;
        HashMap<String, List<Seclist>> map = DisUtil.getMapByListJson((String)"SmSeclist-pro", String.class, Seclist.class);
        if (map == null) {
            map = new HashMap<String, List<Seclist>>();
        }
        if (addflag) {
            this.saveCache(smSeclist, map);
        } else {
            this.deleteCache(smSeclist, map);
        }
        DisUtil.setVer((String)"SmSeclist-pro", (String)JsonUtil.buildNormalBinder().toJson(map));
    }

    private void deleteCache(SmSeclist seclist, Map<String, List<Seclist>> map) {
        if (map == null) {
            return;
        }
        String key = seclist.getSeclistProxy() + "-" + seclist.getSeclistUtype() + "-" + seclist.getSeclistOtype() + "-" + seclist.getSeclistOcode() + "-" + seclist.getSeclistDire();
        List<Seclist> list = map.get(key);
        if (list == null || list.isEmpty()) {
            return;
        }
        Integer index = null;
        for (int i = 0; i < list.size(); ++i) {
            if (!list.get(i).getSeclistId().equals(seclist.getSeclistId())) continue;
            index = i;
            break;
        }
        if (index != null) {
            list.remove(index);
        }
    }

    private void saveCache(SmSeclist smSeclist, Map<String, List<Seclist>> map) {
        Seclist seclist = this.makeSeclist(smSeclist);
        String key = seclist.getSeclistProxy() + "-" + seclist.getSeclistUtype() + "-" + seclist.getSeclistOtype() + "-" + seclist.getSeclistOcode() + "-" + seclist.getSeclistDire();
        List<Seclist> list = map.get(key);
        if (list == null) {
            list = new ArrayList<Seclist>();
            map.put(key, list);
        }
        Integer index = null;
        for (int i = 0; i < list.size(); ++i) {
            if (!list.get(i).getSeclistId().equals(smSeclist.getSeclistId())) continue;
            index = i;
            break;
        }
        if (index != null) {
            list.set(index, seclist);
        } else {
            list.add(seclist);
        }
    }
}

