/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.security.util;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.tool.codec.Base64;
import com.yqbsoft.laser.service.tool.util.StreamUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import javax.crypto.Cipher;

public class Signature {
    private static final int MAX_ENCRYPT_BLOCK = 117;
    private static final int MAX_DECRYPT_BLOCK = 128;

    public static String getSignContentV2(Map<String, String> sortedParams) {
        if (null == sortedParams || sortedParams.isEmpty()) {
            return null;
        }
        sortedParams.remove("sign");
        StringBuffer content = new StringBuffer();
        ArrayList<String> keys = new ArrayList<String>(sortedParams.keySet());
        Collections.sort(keys);
        int index = 0;
        for (int i = 0; i < keys.size(); ++i) {
            String value;
            String key = (String)keys.get(i);
            if (!StringUtils.areNotEmpty((String[])new String[]{key, value = sortedParams.get(key)})) continue;
            content.append((index == 0 ? "" : "&") + key + "=" + value);
            ++index;
        }
        return content.toString();
    }

    public static String rsaSign(String content, String privateKey, String charset) throws ApiException {
        try {
            PrivateKey priKey = Signature.getPrivateKeyFromPKCS8("RSA", new ByteArrayInputStream(privateKey.getBytes()));
            java.security.Signature signature = java.security.Signature.getInstance("SHA1WithRSA");
            signature.initSign(priKey);
            if (StringUtils.isEmpty((String)charset)) {
                signature.update(content.getBytes());
            } else {
                signature.update(content.getBytes(charset));
            }
            byte[] signed = signature.sign();
            return new String(Base64.encodeBase64((byte[])signed));
        }
        catch (Exception e) {
            throw new ApiException("RSAcontent = " + content + "; charset = " + charset, (Throwable)e);
        }
    }

    public static String rsaSign(Map<String, String> params, String privateKey, String charset) throws ApiException {
        String signContent = Signature.getSignContentV2(params);
        return Signature.rsaSign(signContent, privateKey, charset);
    }

    public static PrivateKey getPrivateKeyFromPKCS8(String algorithm, InputStream ins) throws Exception {
        if (ins == null || StringUtils.isEmpty((String)algorithm)) {
            return null;
        }
        KeyFactory keyFactory = KeyFactory.getInstance(algorithm);
        byte[] encodedKey = StreamUtil.readText((InputStream)ins).getBytes();
        encodedKey = Base64.decodeBase64((byte[])encodedKey);
        return keyFactory.generatePrivate(new PKCS8EncodedKeySpec(encodedKey));
    }

    public static String getSignCheckContentV1(Map<String, String> params) {
        if (params == null) {
            return null;
        }
        params.remove("sign");
        params.remove("sign_type");
        StringBuffer content = new StringBuffer();
        ArrayList<String> keys = new ArrayList<String>(params.keySet());
        Collections.sort(keys);
        for (int i = 0; i < keys.size(); ++i) {
            String key = (String)keys.get(i);
            String value = params.get(key);
            content.append((i == 0 ? "" : "&") + key + "=" + value);
        }
        return content.toString();
    }

    public static String getSignCheckContentV2(Map<String, String> params) {
        if (params == null) {
            return null;
        }
        params.remove("sign");
        StringBuffer content = new StringBuffer();
        ArrayList<String> keys = new ArrayList<String>(params.keySet());
        Collections.sort(keys);
        for (int i = 0; i < keys.size(); ++i) {
            String key = (String)keys.get(i);
            String value = params.get(key);
            content.append((i == 0 ? "" : "&") + key + "=" + value);
        }
        return content.toString();
    }

    public static boolean rsaCheckV1(Map<String, String> params, String publicKey, String charset) throws ApiException {
        String sign = params.get("sign");
        String content = Signature.getSignCheckContentV1(params);
        return Signature.rsaCheckContent(content, sign, publicKey, charset);
    }

    public static boolean rsaCheckV2(Map<String, String> params, String publicKey, String charset) throws ApiException {
        String sign = params.get("sign");
        String content = Signature.getSignCheckContentV2(params);
        return Signature.rsaCheckContent(content, sign, publicKey, charset);
    }

    public static boolean rsaCheckContent(String content, String sign, String publicKey, String charset) throws ApiException {
        try {
            PublicKey pubKey = Signature.getPublicKeyFromX509("RSA", new ByteArrayInputStream(publicKey.getBytes()));
            java.security.Signature signature = java.security.Signature.getInstance("SHA1WithRSA");
            signature.initVerify(pubKey);
            if (StringUtils.isEmpty((String)charset)) {
                signature.update(content.getBytes());
            } else {
                signature.update(content.getBytes(charset));
            }
            return signature.verify(Base64.decodeBase64((byte[])sign.getBytes()));
        }
        catch (Exception e) {
            throw new ApiException("RSAcontent = " + content + ",sign=" + sign + ",charset = " + charset, (Throwable)e);
        }
    }

    public static PublicKey getPublicKeyFromX509(String algorithm, InputStream ins) throws Exception {
        KeyFactory keyFactory = KeyFactory.getInstance(algorithm);
        StringWriter writer = new StringWriter();
        StreamUtil.io((Reader)new InputStreamReader(ins), (Writer)writer);
        byte[] encodedKey = writer.toString().getBytes();
        encodedKey = Base64.decodeBase64((byte[])encodedKey);
        return keyFactory.generatePublic(new X509EncodedKeySpec(encodedKey));
    }

    public static PrivateKey getPrivateKeyFromX509(String algorithm, InputStream ins) throws Exception {
        KeyFactory keyFactory = KeyFactory.getInstance(algorithm);
        StringWriter writer = new StringWriter();
        StreamUtil.io((Reader)new InputStreamReader(ins), (Writer)writer);
        byte[] encodedKey = writer.toString().getBytes();
        encodedKey = Base64.decodeBase64((byte[])encodedKey);
        return keyFactory.generatePrivate(new X509EncodedKeySpec(encodedKey));
    }

    public static String checkSignAndDecrypt(Map<String, String> params, String alipayPublicKey, String cusPrivateKey, boolean isCheckSign, boolean isDecrypt) throws ApiException {
        String charset = params.get("charset");
        String bizContent = params.get("biz_content");
        if (isCheckSign && !Signature.rsaCheckV2(params, alipayPublicKey, charset)) {
            throw new ApiException("rsaCheck failure:rsaParams=" + params);
        }
        if (isDecrypt) {
            return Signature.rsaDecrypt(bizContent, cusPrivateKey, charset);
        }
        return bizContent;
    }

    public static String encryptAndSign(String bizContent, String alipayPublicKey, String cusPrivateKey, String charset, boolean isEncrypt, boolean isSign) throws ApiException {
        StringBuilder sb = new StringBuilder();
        if (StringUtils.isEmpty((String)charset)) {
            charset = "GBK";
        }
        sb.append("<?xml version=\"1.0\" encoding=\"" + charset + "\"?>");
        if (isEncrypt) {
            sb.append("<alipay>");
            String encrypted = Signature.rsaEncrypt(bizContent, alipayPublicKey, charset);
            sb.append("<response>" + encrypted + "</response>");
            sb.append("<encryption_type>RSA</encryption_type>");
            if (isSign) {
                String sign = Signature.rsaSign(encrypted, cusPrivateKey, charset);
                sb.append("<sign>" + sign + "</sign>");
                sb.append("<sign_type>RSA</sign_type>");
            }
            sb.append("</alipay>");
        } else if (isSign) {
            sb.append("<alipay>");
            sb.append("<response>" + bizContent + "</response>");
            String sign = Signature.rsaSign(bizContent, cusPrivateKey, charset);
            sb.append("<sign>" + sign + "</sign>");
            sb.append("<sign_type>RSA</sign_type>");
            sb.append("</alipay>");
        } else {
            sb.append(bizContent);
        }
        return sb.toString();
    }

    public static String rsaEncrypt(String content, String publicKey, String charset) throws ApiException {
        try {
            PublicKey pubKey = Signature.getPublicKeyFromX509("RSA", new ByteArrayInputStream(publicKey.getBytes()));
            Cipher cipher = Cipher.getInstance("RSA");
            cipher.init(1, pubKey);
            byte[] data = StringUtils.isEmpty((String)charset) ? content.getBytes() : content.getBytes(charset);
            int inputLen = data.length;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            int offSet = 0;
            int i = 0;
            while (inputLen - offSet > 0) {
                byte[] cache = inputLen - offSet > 117 ? cipher.doFinal(data, offSet, 117) : cipher.doFinal(data, offSet, inputLen - offSet);
                out.write(cache, 0, cache.length);
                offSet = ++i * 117;
            }
            byte[] encryptedData = Base64.encodeBase64((byte[])out.toByteArray());
            out.close();
            return StringUtils.isEmpty((String)charset) ? new String(encryptedData) : new String(encryptedData, charset);
        }
        catch (Exception e) {
            throw new ApiException("EncryptContent = " + content + ",charset = " + charset, (Throwable)e);
        }
    }

    public static String rsaDecrypt(String content, String privateKey, String charset) throws ApiException {
        try {
            PrivateKey priKey = Signature.getPrivateKeyFromPKCS8("RSA", new ByteArrayInputStream(privateKey.getBytes()));
            Cipher cipher = Cipher.getInstance("RSA");
            cipher.init(2, priKey);
            byte[] encryptedData = StringUtils.isEmpty((String)charset) ? Base64.decodeBase64((byte[])content.getBytes()) : Base64.decodeBase64((byte[])content.getBytes(charset));
            int inputLen = encryptedData.length;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            int offSet = 0;
            int i = 0;
            while (inputLen - offSet > 0) {
                byte[] cache = inputLen - offSet > 128 ? cipher.doFinal(encryptedData, offSet, 128) : cipher.doFinal(encryptedData, offSet, inputLen - offSet);
                out.write(cache, 0, cache.length);
                offSet = ++i * 128;
            }
            byte[] decryptedData = out.toByteArray();
            out.close();
            return StringUtils.isEmpty((String)charset) ? new String(decryptedData) : new String(decryptedData, charset);
        }
        catch (Exception e) {
            throw new ApiException("EncodeContent = " + content + ",charset = " + charset, (Throwable)e);
        }
    }

    public static void main(String[] args) {
        try {
            String pubstr = "2013098";
            PublicKey pubKey = Signature.getPublicKeyFromX509("RSA", new ByteArrayInputStream(pubstr.getBytes()));
            System.out.println(pubKey.getAlgorithm());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

