/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.security.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.auth.Secapi;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.security.dao.SmSecapiMapper;
import com.yqbsoft.laser.service.security.domain.SmSecapiDomain;
import com.yqbsoft.laser.service.security.model.SmSecapi;
import com.yqbsoft.laser.service.security.service.SecapiService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SecapiServiceImpl
extends BaseServiceImpl
implements SecapiService {
    public static final String SYS_CODE = "sm.SECURITY.SecapiServiceImpl";
    private SmSecapiMapper smSecapiMapper;

    public void setsmSecapiMapper(SmSecapiMapper smSecapiMapper) {
        this.smSecapiMapper = smSecapiMapper;
    }

    private Date getSysDate() {
        try {
            return this.smSecapiMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("sm.SECURITY.SecapiServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkSecapi(SmSecapiDomain smSecapiDomain) {
        if (null == smSecapiDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        return msg;
    }

    private void setSecapiDefault(SmSecapi smSecapi) {
        if (null == smSecapi) {
            return;
        }
        if (null == smSecapi.getDataState()) {
            smSecapi.setDataState(0);
        }
        if (null == smSecapi.getGmtCreate()) {
            smSecapi.setGmtCreate(this.getSysDate());
        }
        if (StringUtils.isBlank((String)smSecapi.getSecapiCode())) {
            int code = this.getMaxCode();
            smSecapi.setSecapiCode(this.makeMaxCode8(++code));
        }
    }

    private int getMaxCode() {
        int code = 0;
        try {
            return this.smSecapiMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("sm.SECURITY.SecapiServiceImpl.getMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setSecapiUpdataDefault(SmSecapi smSecapi) {
        if (null == smSecapi) {
            return;
        }
    }

    private void saveSecapiModel(SmSecapi smSecapi) throws ApiException {
        if (null == smSecapi) {
            return;
        }
        try {
            this.smSecapiMapper.insert(smSecapi);
        }
        catch (Exception e) {
            throw new ApiException("sm.SECURITY.SecapiServiceImpl.saveSecapiModel.ex");
        }
    }

    private SmSecapi getSecapiModelById(Integer secapiId) {
        if (null == secapiId) {
            return null;
        }
        try {
            return this.smSecapiMapper.selectByPrimaryKey(secapiId);
        }
        catch (Exception e) {
            this.logger.error("sm.SECURITY.SecapiServiceImpl.getSecapiModelById", (Throwable)e);
            return null;
        }
    }

    private void deleteSecapiModel(Integer secapiId) throws ApiException {
        if (null == secapiId) {
            return;
        }
        int i = 0;
        try {
            i = this.smSecapiMapper.deleteByPrimaryKey(secapiId);
        }
        catch (Exception e) {
            throw new ApiException("sm.SECURITY.SecapiServiceImpl.deleteSecapiModel.ex");
        }
        if (1 != i) {
            throw new ApiException("sm.SECURITY.SecapiServiceImpl.deleteSecapiModel.num");
        }
    }

    private void updateSecapiModel(SmSecapi smSecapi) throws ApiException {
        if (null == smSecapi) {
            return;
        }
        try {
            this.smSecapiMapper.updateByPrimaryKeySelective(smSecapi);
        }
        catch (Exception e) {
            throw new ApiException("sm.SECURITY.SecapiServiceImpl.updateSecapiModel.ex");
        }
    }

    private void updateStateSecapiModel(Integer secapiId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == secapiId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("secapiId", secapiId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.smSecapiMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("sm.SECURITY.SecapiServiceImpl.updateStateSecapiModel.ex");
        }
        if (i <= 0) {
            throw new ApiException("sm.SECURITY.SecapiServiceImpl.updateStateSecapiModel.null");
        }
    }

    private SmSecapi makeSecapi(SmSecapiDomain smSecapiDomain, SmSecapi smSecapi) {
        if (null == smSecapiDomain) {
            return null;
        }
        if (null == smSecapi) {
            smSecapi = new SmSecapi();
        }
        try {
            BeanUtils.copyAllPropertys((Object)smSecapi, (Object)smSecapiDomain);
        }
        catch (Exception e) {
            this.logger.error("sm.SECURITY.SecapiServiceImpl.makeSecapi", (Throwable)e);
        }
        return smSecapi;
    }

    private List<SmSecapi> querySecapiModelPage(Map<String, Object> parammap) {
        try {
            return this.smSecapiMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("sm.SECURITY.SecapiServiceImpl.querySecapiModel", (Throwable)e);
            return null;
        }
    }

    private List<SmSecapi> querySecapiModelAppPage(Map<String, Object> parammap) {
        try {
            return this.smSecapiMapper.querySecapiApp(parammap);
        }
        catch (Exception e) {
            this.logger.error("sm.SECURITY.SecapiServiceImpl.querySecapiModel", (Throwable)e);
            return null;
        }
    }

    private int countSecapi(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.smSecapiMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("sm.SECURITY.SecapiServiceImpl.countSecapi", (Throwable)e);
        }
        return i;
    }

    private int countSecapiApp(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.smSecapiMapper.countSecapiApp(map);
        }
        catch (Exception e) {
            this.logger.error("sm.SECURITY.SecapiServiceImpl.countSecapi", (Throwable)e);
        }
        return i;
    }

    @Override
    public void saveSecapi(SmSecapiDomain smSecapiDomain) throws ApiException {
        String msg = this.checkSecapi(smSecapiDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("sm.SECURITY.SecapiServiceImpl.saveSecapi.checkSecapi", msg);
        }
        SmSecapi smSecapi = this.makeSecapi(smSecapiDomain, null);
        this.setSecapiDefault(smSecapi);
        this.saveSecapiModel(smSecapi);
    }

    @Override
    public void updateSecapiState(Integer secapiId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateSecapiModel(secapiId, dataState, oldDataState);
        this.refreshCache(this.getSecapi(secapiId), dataState);
    }

    @Override
    public void updateSecapi(SmSecapiDomain smSecapiDomain) throws ApiException {
        String msg = this.checkSecapi(smSecapiDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("sm.SECURITY.SecapiServiceImpl.updateSecapi.checkSecapi", msg);
        }
        SmSecapi oldSmSecapi = this.getSecapiModelById(smSecapiDomain.getSecapiId());
        if (null == oldSmSecapi) {
            throw new ApiException("sm.SECURITY.SecapiServiceImpl.updateSecapi.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        SmSecapi smSecapi = this.makeSecapi(smSecapiDomain, oldSmSecapi);
        this.setSecapiUpdataDefault(smSecapi);
        this.updateSecapiModel(smSecapi);
    }

    @Override
    public SmSecapi getSecapi(Integer secapiId) {
        return this.getSecapiModelById(secapiId);
    }

    @Override
    public void deleteSecapi(Integer secapiId) throws ApiException {
        this.deleteSecapiModel(secapiId);
    }

    @Override
    public QueryResult<SmSecapi> querySecapiPage(Map<String, Object> map) {
        List<SmSecapi> smSecapiList = this.querySecapiModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countSecapi(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(smSecapiList);
        return queryResult;
    }

    @Override
    public QueryResult<SmSecapi> queryAppSecapiPage(Map<String, Object> map) {
        List<SmSecapi> smSecapiList = this.querySecapiModelAppPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countSecapiApp(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(smSecapiList);
        return queryResult;
    }

    @Override
    public void queryAppSecapiCache() {
        this.info("sm.SECURITY.SecapiServiceImpl.queryAppSecapiCache", "=======queryAppSecapiCache\u8c03\u5ea6start=======");
        List<SmSecapi> smSecapiList = this.querySecapiModelPage(this.getQueryParamMap("dataState", new Object[]{1}));
        if (smSecapiList == null || smSecapiList.isEmpty()) {
            DisUtil.delVer((String)"SmSecapi-pro");
            this.info("sm.SECURITY.SecapiServiceImpl.queryAppSecapiCache", "=======queryAppSecapiCache\u8c03\u5ea6end-del=======");
            return;
        }
        HashMap<String, List<Secapi>> smap = new HashMap<String, List<Secapi>>();
        for (SmSecapi smSecapi : smSecapiList) {
            this.saveCache(smSecapi, smap);
        }
        DisUtil.setVer((String)"SmSecapi-pro", (String)JsonUtil.buildNormalBinder().toJson(smap));
        this.info("sm.SECURITY.SecapiServiceImpl.queryAppSecapiCache", "=======queryAppSecapiCache\u8c03\u5ea6end=======");
    }

    private Secapi makeSecapi(SmSecapi smSecapi) {
        if (null == smSecapi) {
            return null;
        }
        Secapi secapi = new Secapi();
        try {
            BeanUtils.copyAllPropertys((Object)secapi, (Object)smSecapi);
        }
        catch (Exception e) {
            this.logger.error("sm.SECURITY.SecapiServiceImpl.makeSecapi", (Throwable)e);
        }
        return secapi;
    }

    private void refreshCache(SmSecapi smSecapi, Integer dataState) {
        boolean addflag = dataState == 1;
        HashMap<String, List<Secapi>> map = DisUtil.getMapByListJson((String)"SmSecapi-pro", String.class, Secapi.class);
        if (map == null) {
            map = new HashMap<String, List<Secapi>>();
        }
        if (addflag) {
            this.saveCache(smSecapi, map);
        } else {
            this.deleteCache(smSecapi, map);
        }
        DisUtil.setVer((String)"SmSecapi-pro", (String)JsonUtil.buildNormalBinder().toJson(map));
    }

    private void deleteCache(SmSecapi smSecapi, Map<String, List<Secapi>> map) {
        if (map == null) {
            return;
        }
        String key = smSecapi.getSecapiUtype() + "-" + smSecapi.getSecapiOtype() + "-" + smSecapi.getSecapiOcode();
        List<Secapi> list = map.get(key);
        if (list == null || list.isEmpty()) {
            return;
        }
        Integer index = null;
        for (int i = 0; i < list.size(); ++i) {
            if (!list.get(i).getSecapiId().equals(smSecapi.getSecapiId())) continue;
            index = i;
            break;
        }
        if (index != null) {
            list.remove(index);
        }
    }

    private void saveCache(SmSecapi smSecapi, Map<String, List<Secapi>> map) {
        Secapi secapi = this.makeSecapi(smSecapi);
        String key = smSecapi.getSecapiUtype() + "-" + smSecapi.getSecapiOtype() + "-" + smSecapi.getSecapiOcode();
        List<Secapi> list = map.get(key);
        if (list == null) {
            list = new ArrayList<Secapi>();
            map.put(key, list);
        }
        Integer index = null;
        for (int i = 0; i < list.size(); ++i) {
            if (!list.get(i).getSecapiId().equals(smSecapi.getSecapiId())) continue;
            index = i;
            break;
        }
        if (index != null) {
            list.set(index, secapi);
        } else {
            list.add(secapi);
        }
    }

    @Override
    public List<SmSecapi> querySecapiByType(String appmanageIncode, String appmanageApptype, String appmanageUtype) {
        List<SmSecapi> sceapiList;
        ArrayList<SmSecapi> smSecapiList = new ArrayList<SmSecapi>();
        HashMap<String, SmSecapi> secapiMap = new HashMap<String, SmSecapi>();
        if (StringUtils.isNotBlank((String)appmanageIncode) && (sceapiList = this.querySecapiModelPage(this.getQueryParamMap("secapiOcode,secapiOtype,secapiUtype", new Object[]{appmanageIncode, "0", appmanageUtype}))) != null) {
            for (SmSecapi smSecapi : sceapiList) {
                secapiMap.put(smSecapi.getAppapiCode() + "-" + smSecapi.getAppapiVersion(), smSecapi);
            }
        }
        if (StringUtils.isNotBlank((String)appmanageApptype) && (sceapiList = this.querySecapiModelPage(this.getQueryParamMap("secapiOcode,secapiOtype,secapiUtype", new Object[]{appmanageApptype, "3", appmanageUtype}))) != null) {
            for (SmSecapi smSecapi : sceapiList) {
                secapiMap.put(smSecapi.getAppapiCode() + "-" + smSecapi.getAppapiVersion(), smSecapi);
            }
        }
        for (String key : secapiMap.keySet()) {
            smSecapiList.add((SmSecapi)secapiMap.get(key));
        }
        return smSecapiList;
    }
}

