/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.sendgoods.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.spring.SpringApplicationContextUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.sendgoods.dao.SgSendgoodsCallMapper;
import com.yqbsoft.laser.service.sendgoods.domain.SgSendgoodsCallDomain;
import com.yqbsoft.laser.service.sendgoods.domain.SgSendgoodsCallReDomain;
import com.yqbsoft.laser.service.sendgoods.domain.SgSendgoodsPackageDomain;
import com.yqbsoft.laser.service.sendgoods.model.SgSendgoodsCall;
import com.yqbsoft.laser.service.sendgoods.model.SgSendgoodsPackage;
import com.yqbsoft.laser.service.sendgoods.send.CallPollThread;
import com.yqbsoft.laser.service.sendgoods.send.CallPutThread;
import com.yqbsoft.laser.service.sendgoods.send.CallService;
import com.yqbsoft.laser.service.sendgoods.service.SgSendgoodsCallService;
import com.yqbsoft.laser.service.sendgoods.service.SgSendgoodsService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SgSendgoodsCallServiceImpl
extends BaseServiceImpl
implements SgSendgoodsCallService {
    private static final String SYS_CODE = "sg.SgSendgoodsCallServiceImpl";
    private SgSendgoodsCallMapper sgSendgoodsCallMapper;
    private SgSendgoodsService sgSendgoodsService;
    private static CallService callService;
    private static Object lock;

    public void setSgSendgoodsService(SgSendgoodsService sgSendgoodsService) {
        this.sgSendgoodsService = sgSendgoodsService;
    }

    public void setSgSendgoodsCallMapper(SgSendgoodsCallMapper sgSendgoodsCallMapper) {
        this.sgSendgoodsCallMapper = sgSendgoodsCallMapper;
    }

    private Date getSysDate() {
        try {
            return this.sgSendgoodsCallMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("sg.SgSendgoodsCallServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkSendgoodsCall(SgSendgoodsCallDomain sgSendgoodsCallDomain) {
        if (null == sgSendgoodsCallDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)sgSendgoodsCallDomain.getContractBillcode())) {
            msg = msg + "ContractBillcode\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)sgSendgoodsCallDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setSendgoodsCallDefault(SgSendgoodsCall sgSendgoodsCall) {
        if (null == sgSendgoodsCall) {
            return;
        }
        if (null == sgSendgoodsCall.getDataState()) {
            sgSendgoodsCall.setDataState(0);
        }
        if (null == sgSendgoodsCall.getGmtCreate()) {
            sgSendgoodsCall.setGmtCreate(this.getSysDate());
        }
        sgSendgoodsCall.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)sgSendgoodsCall.getSendgoodsCallCode())) {
            sgSendgoodsCall.setSendgoodsCallCode(this.createUUIDString());
        }
    }

    private int getSendgoodsCallMaxCode() {
        int code = 0;
        try {
            return this.sgSendgoodsCallMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("sg.SgSendgoodsCallServiceImpl.getSendgoodsCallMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setSendgoodsCallUpdataDefault(SgSendgoodsCall sgSendgoodsCall) {
        if (null == sgSendgoodsCall) {
            return;
        }
        sgSendgoodsCall.setGmtModified(this.getSysDate());
    }

    private void saveSendgoodsCallModel(SgSendgoodsCall sgSendgoodsCall) throws ApiException {
        if (null == sgSendgoodsCall) {
            return;
        }
        try {
            this.sgSendgoodsCallMapper.insert(sgSendgoodsCall);
        }
        catch (Exception e) {
            throw new ApiException("sg.SgSendgoodsCallServiceImpl.saveSendgoodsCallModel.ex", (Throwable)e);
        }
    }

    private void saveSendgoodsCallBatchModel(List<SgSendgoodsCall> sgSendgoodsCallList) throws ApiException {
        if (null == sgSendgoodsCallList || sgSendgoodsCallList.isEmpty()) {
            return;
        }
        try {
            this.sgSendgoodsCallMapper.insertBatch(sgSendgoodsCallList);
        }
        catch (Exception e) {
            throw new ApiException("sg.SgSendgoodsCallServiceImpl.saveSendgoodsCallBatchModel.ex", (Throwable)e);
        }
    }

    private SgSendgoodsCall getSendgoodsCallModelById(Integer sendgoodsCallId) {
        if (null == sendgoodsCallId) {
            return null;
        }
        try {
            return this.sgSendgoodsCallMapper.selectByPrimaryKey(sendgoodsCallId);
        }
        catch (Exception e) {
            this.logger.error("sg.SgSendgoodsCallServiceImpl.getSendgoodsCallModelById", (Throwable)e);
            return null;
        }
    }

    private SgSendgoodsCall getSendgoodsCallModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.sgSendgoodsCallMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("sg.SgSendgoodsCallServiceImpl.getSendgoodsCallModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delSendgoodsCallModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.sgSendgoodsCallMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("sg.SgSendgoodsCallServiceImpl.delSendgoodsCallModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("sg.SgSendgoodsCallServiceImpl.delSendgoodsCallModelByCode.num");
        }
    }

    private void deleteSendgoodsCallModel(Integer sendgoodsCallId) throws ApiException {
        if (null == sendgoodsCallId) {
            return;
        }
        int i = 0;
        try {
            i = this.sgSendgoodsCallMapper.deleteByPrimaryKey(sendgoodsCallId);
        }
        catch (Exception e) {
            throw new ApiException("sg.SgSendgoodsCallServiceImpl.deleteSendgoodsCallModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("sg.SgSendgoodsCallServiceImpl.deleteSendgoodsCallModel.num");
        }
    }

    private void updateSendgoodsCallModel(SgSendgoodsCall sgSendgoodsCall) throws ApiException {
        if (null == sgSendgoodsCall) {
            return;
        }
        int i = 0;
        try {
            i = this.sgSendgoodsCallMapper.updateByPrimaryKey(sgSendgoodsCall);
        }
        catch (Exception e) {
            throw new ApiException("sg.SgSendgoodsCallServiceImpl.updateSendgoodsCallModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("sg.SgSendgoodsCallServiceImpl.updateSendgoodsCallModel.num");
        }
    }

    private void updateStateSendgoodsCallModel(Integer sendgoodsCallId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == sendgoodsCallId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("sendgoodsCallId", sendgoodsCallId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.sgSendgoodsCallMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("sg.SgSendgoodsCallServiceImpl.updateStateSendgoodsCallModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("sg.SgSendgoodsCallServiceImpl.updateStateSendgoodsCallModel.null");
        }
    }

    private void updateStateSendgoodsCallModelByCode(String tenantCode, String sendgoodsCallCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)sendgoodsCallCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("sendgoodsCallCode", sendgoodsCallCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (!MapUtil.isEmpty(expmap)) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.sgSendgoodsCallMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("sg.SgSendgoodsCallServiceImpl.updateStateSendgoodsCallModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("sg.SgSendgoodsCallServiceImpl.updateStateSendgoodsCallModelByCode.null");
        }
    }

    private SgSendgoodsCall makeSendgoodsCall(SgSendgoodsCallDomain sgSendgoodsCallDomain, SgSendgoodsCall sgSendgoodsCall) {
        if (null == sgSendgoodsCallDomain) {
            return null;
        }
        if (null == sgSendgoodsCall) {
            sgSendgoodsCall = new SgSendgoodsCall();
        }
        try {
            BeanUtils.copyAllPropertys((Object)sgSendgoodsCall, (Object)sgSendgoodsCallDomain);
            return sgSendgoodsCall;
        }
        catch (Exception e) {
            this.logger.error("sg.SgSendgoodsCallServiceImpl.makeSendgoodsCall", (Throwable)e);
            return null;
        }
    }

    private SgSendgoodsCallReDomain makeSgSendgoodsCallReDomain(SgSendgoodsCall sgSendgoodsCall) {
        if (null == sgSendgoodsCall) {
            return null;
        }
        SgSendgoodsCallReDomain sgSendgoodsCallReDomain = new SgSendgoodsCallReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)sgSendgoodsCallReDomain, (Object)sgSendgoodsCall);
            return sgSendgoodsCallReDomain;
        }
        catch (Exception e) {
            this.logger.error("sg.SgSendgoodsCallServiceImpl.makeSgSendgoodsCallReDomain", (Throwable)e);
            return null;
        }
    }

    private List<SgSendgoodsCall> querySendgoodsCallModelPage(Map<String, Object> parammap) {
        try {
            return this.sgSendgoodsCallMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("sg.SgSendgoodsCallServiceImpl.querySendgoodsCallModel", (Throwable)e);
            return null;
        }
    }

    private int countSendgoodsCall(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.sgSendgoodsCallMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("sg.SgSendgoodsCallServiceImpl.countSendgoodsCall", (Throwable)e);
        }
        return i;
    }

    private SgSendgoodsCall createSgSendgoodsCall(SgSendgoodsCallDomain sgSendgoodsCallDomain) {
        String msg = this.checkSendgoodsCall(sgSendgoodsCallDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("sg.SgSendgoodsCallServiceImpl.saveSendgoodsCall.checkSendgoodsCall", msg);
        }
        SgSendgoodsCall sgSendgoodsCall = this.makeSendgoodsCall(sgSendgoodsCallDomain, null);
        this.setSendgoodsCallDefault(sgSendgoodsCall);
        return sgSendgoodsCall;
    }

    @Override
    public String saveSendgoodsCall(SgSendgoodsCallDomain sgSendgoodsCallDomain) throws ApiException {
        SgSendgoodsCall sgSendgoodsCall = this.createSgSendgoodsCall(sgSendgoodsCallDomain);
        this.saveSendgoodsCallModel(sgSendgoodsCall);
        return sgSendgoodsCall.getSendgoodsCallCode();
    }

    @Override
    public String saveSendgoodsCallBatch(List<SgSendgoodsCallDomain> sgSendgoodsCallDomainList) throws ApiException {
        if (null == sgSendgoodsCallDomainList || sgSendgoodsCallDomainList.isEmpty()) {
            return null;
        }
        ArrayList<SgSendgoodsCall> sgSendgoodsCallList = new ArrayList<SgSendgoodsCall>();
        String code = "";
        for (SgSendgoodsCallDomain sgSendgoodsCallDomain : sgSendgoodsCallDomainList) {
            SgSendgoodsCall sgSendgoodsCall = this.createSgSendgoodsCall(sgSendgoodsCallDomain);
            code = sgSendgoodsCall.getSendgoodsCallCode();
            sgSendgoodsCallList.add(sgSendgoodsCall);
        }
        this.saveSendgoodsCallBatchModel(sgSendgoodsCallList);
        return code;
    }

    @Override
    public void updateSendgoodsCallState(Integer sendgoodsCallId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        this.updateStateSendgoodsCallModel(sendgoodsCallId, dataState, oldDataState, map);
    }

    @Override
    public void updateSendgoodsCallStateByCode(String tenantCode, String sendgoodsCallCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        this.updateStateSendgoodsCallModelByCode(tenantCode, sendgoodsCallCode, dataState, oldDataState, map);
    }

    @Override
    public void updateSendgoodsCall(SgSendgoodsCallDomain sgSendgoodsCallDomain) throws ApiException {
        String msg = this.checkSendgoodsCall(sgSendgoodsCallDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("sg.SgSendgoodsCallServiceImpl.updateSendgoodsCall.checkSendgoodsCall", msg);
        }
        SgSendgoodsCall oldSgSendgoodsCall = this.getSendgoodsCallModelById(sgSendgoodsCallDomain.getSendgoodsCallId());
        if (null == oldSgSendgoodsCall) {
            throw new ApiException("sg.SgSendgoodsCallServiceImpl.updateSendgoodsCall.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        SgSendgoodsCall sgSendgoodsCall = this.makeSendgoodsCall(sgSendgoodsCallDomain, oldSgSendgoodsCall);
        this.setSendgoodsCallUpdataDefault(sgSendgoodsCall);
        this.updateSendgoodsCallModel(sgSendgoodsCall);
    }

    @Override
    public SgSendgoodsCall getSendgoodsCall(Integer sendgoodsCallId) {
        return this.getSendgoodsCallModelById(sendgoodsCallId);
    }

    @Override
    public void deleteSendgoodsCall(Integer sendgoodsCallId) throws ApiException {
        this.deleteSendgoodsCallModel(sendgoodsCallId);
    }

    @Override
    public QueryResult<SgSendgoodsCall> querySendgoodsCallPage(Map<String, Object> map) {
        List<SgSendgoodsCall> sgSendgoodsCallList = this.querySendgoodsCallModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countSendgoodsCall(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(sgSendgoodsCallList);
        return queryResult;
    }

    @Override
    public SgSendgoodsCall getSendgoodsCallByCode(String tenantCode, String sendgoodsCallCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("sendgoodsCallCode", sendgoodsCallCode);
        return this.getSendgoodsCallModelByCode(map);
    }

    @Override
    public void deleteSendgoodsCallByCode(String tenantCode, String sendgoodsCallCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("sendgoodsCallCode", sendgoodsCallCode);
        this.delSendgoodsCallModelByCode(map);
    }

    @Override
    public void callSendSgSendgoodsCall(List<SgSendgoodsCallDomain> sgSendgoodsCallDomainList) {
        if (ListUtil.isEmpty(sgSendgoodsCallDomainList)) {
            return;
        }
        if (null == sgSendgoodsCallDomainList || sgSendgoodsCallDomainList.isEmpty()) {
            return;
        }
        ArrayList<SgSendgoodsCall> sgSendgoodsCallList = new ArrayList<SgSendgoodsCall>();
        for (SgSendgoodsCallDomain sgSendgoodsCallDomain : sgSendgoodsCallDomainList) {
            SgSendgoodsCall sgSendgoodsCall = this.createSgSendgoodsCall(sgSendgoodsCallDomain);
            sgSendgoodsCallList.add(sgSendgoodsCall);
        }
        this.saveSendgoodsCallBatchModel(sgSendgoodsCallList);
        this.getCallService().addPutPool(new CallPutThread(this.getCallService(), sgSendgoodsCallList));
    }

    @Override
    public void autoSend() {
        this.loadDb();
    }

    @Override
    public void saveSendSgSendgoodsCall(SgSendgoodsCall sgSendgoodsCall) {
        this.updateSendgoodsCallStateByCode(sgSendgoodsCall.getTenantCode(), sgSendgoodsCall.getSendgoodsCallCode(), 1, 0, null);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("sendgoodsCode", sgSendgoodsCall.getSendgoodsCode());
        map.put("packageBillno", sgSendgoodsCall.getPackageBillno());
        map.put("tenantCode", sgSendgoodsCall.getTenantCode());
        QueryResult<SgSendgoodsPackage> qlist = this.sgSendgoodsService.querySendgoodsPackagePage(map);
        if (ListUtil.isNotEmpty((Collection)qlist.getList())) {
            return;
        }
        SgSendgoodsPackageDomain sgSendgoodsPackageDomain = new SgSendgoodsPackageDomain();
        try {
            BeanUtils.copyAllPropertys((Object)sgSendgoodsPackageDomain, (Object)sgSendgoodsCall);
        }
        catch (Exception e) {
            // empty catch block
        }
        sgSendgoodsPackageDomain.setExpressName(sgSendgoodsCall.getPackageMode());
        sgSendgoodsPackageDomain.setExpressCode(sgSendgoodsCall.getPackageName());
        this.sgSendgoodsService.sendSaveSendgoodsPackage(sgSendgoodsPackageDomain);
    }

    private void loadDb() {
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("dataState", 1);
            map.put("order", true);
            map.put("orderStr", "GMT_CREATE asc");
            QueryResult<SgSendgoodsCall> result = null;
            int startRow = 0;
            boolean flag = true;
            do {
                startRow = this.getCallService().getStartRow();
                map.put("startRow", startRow);
                map.put("rows", this.getCallService().getPage());
                result = this.querySendgoodsCallPage(map);
                if (null != result && null != result.getPageTools() && null != result.getRows() && !result.getRows().isEmpty()) {
                    startRow = result.getPageTools().getRecordCountNo();
                    this.getCallService().addPutPool(new CallPutThread(this.getCallService(), result.getRows()));
                    if (result.getRows().size() == this.getCallService().getPage()) continue;
                    flag = false;
                    continue;
                }
                flag = false;
            } while (flag);
            this.getCallService().initStartRow();
        }
        catch (Exception e) {
            throw new ApiException("sg.SgSendgoodsCallServiceImpl.loadDb.an.e", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CallService getCallService() {
        Object object = lock;
        synchronized (object) {
            if (null == callService) {
                callService = new CallService((SgSendgoodsCallService)SpringApplicationContextUtil.getBean((String)"sgSendgoodsCallService"));
                for (int i = 0; i < 20; ++i) {
                    callService.addPollPool(new CallPollThread(callService));
                }
            }
            return callService;
        }
    }

    static {
        lock = new Object();
    }
}

