/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.sendgoods.Thread;

import com.yqbsoft.laser.service.sendgoods.dao.SgSendgoodsMapper;
import com.yqbsoft.laser.service.sendgoods.domain.SgSendgoodsLogDomain;
import com.yqbsoft.laser.service.sendgoods.enumc.ExceptionSendStatus;
import com.yqbsoft.laser.service.sendgoods.enumc.LogisticsStatus;
import com.yqbsoft.laser.service.sendgoods.model.SgSendgoods;
import com.yqbsoft.laser.service.sendgoods.service.SgSendgoodsLogService;
import com.yqbsoft.laser.service.suppercore.log.SupperLogUtil;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class CheckSendgoodsExceptionThread
implements Runnable {
    private static final String SYS_CODE = "sg.CheckSendgoodsExceptionThread";
    public static final SimpleDateFormat sdf = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5");
    protected final SupperLogUtil logger = new SupperLogUtil(this.getClass());
    private SgSendgoods sgSendgoods;
    private SgSendgoodsMapper sgSendgoodsMapper;
    private SgSendgoodsLogService sgSendgoodsLogService;

    public CheckSendgoodsExceptionThread(SgSendgoods sgSendgoods, SgSendgoodsMapper sgSendgoodsMapper, SgSendgoodsLogService sgSendgoodsLogService) {
        this.sgSendgoods = sgSendgoods;
        this.sgSendgoodsMapper = sgSendgoodsMapper;
        this.sgSendgoodsLogService = sgSendgoodsLogService;
    }

    @Override
    public void run() {
        long start = System.currentTimeMillis();
        if (this.sgSendgoods.getSendgoodsInvstate() == 1) {
            this.logger.error("sg.CheckSendgoodsExceptionThread.run.\u5df2\u7ecf\u662f\u5f02\u5e38\u72b6\u6001", (Object)(this.sgSendgoods.getSendgoodsCode() + "__" + this.sgSendgoods.getSendgoodsInvstate()));
            return;
        }
        this.logger.info("sg.CheckSendgoodsExceptionThread.run", (Object)(this.sgSendgoods.getSendgoodsCode() + "__" + this.sgSendgoods.getDataOpnextbillstate()));
        LogisticsStatus logisticsStatus = LogisticsStatus.fromInt(this.sgSendgoods.getDataOpnextbillstate());
        if (logisticsStatus == null) {
            this.logger.error("sg.CheckSendgoodsExceptionThread.run.\u72b6\u6001\u5f02\u5e381", (Object)(this.sgSendgoods.getSendgoodsCode() + "__" + this.sgSendgoods.getDataOpnextbillstate()));
            return;
        }
        Date sendgoodsDate = LogisticsStatus.getSendgoodsDate(this.sgSendgoods);
        if (sendgoodsDate == null) {
            this.logger.error("sg.CheckSendgoodsExceptionThread.run.\u72b6\u6001\u5f02\u5e382", (Object)(this.sgSendgoods.getSendgoodsCode() + "__" + this.sgSendgoods.getDataOpnextbillstate()));
            return;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(sendgoodsDate);
        calendar.add(5, logisticsStatus.getSetting());
        if (calendar.before(Calendar.getInstance())) {
            if (this.sgSendgoods.getGoodsClass() != null && Integer.valueOf(this.sgSendgoods.getGoodsClass()) <= 10000) {
                this.logger.error("sg.CheckSendgoodsExceptionThread.run.\u72b6\u6001\u5f02\u5e384", (Object)(this.sgSendgoods.getSendgoodsCode() + "__" + this.sgSendgoods.getDataOpnextbillstate() + "__" + sendgoodsDate));
                return;
            }
            this.logger.error("sg.CheckSendgoodsExceptionThread.run.\u72b6\u6001\u5f02\u5e383", (Object)(this.sgSendgoods.getSendgoodsCode() + "__" + this.sgSendgoods.getDataOpnextbillstate() + "__" + sendgoodsDate));
            this.sgSendgoods.setSendgoodsInvstate(1);
            this.sgSendgoods.setSendgoodsRemark(sdf.format(sendgoodsDate) + this.errorMsg(logisticsStatus));
            this.sgSendgoods.setGmtUse(new Date());
            this.sgSendgoodsMapper.updateByPrimaryKeySelective(this.sgSendgoods);
            this.createSgErrLog();
        }
        this.logger.info("sg.CheckSendgoodsExceptionThread.run.\u8017\u65f6", (Object)(System.currentTimeMillis() - start));
    }

    private String errorMsg(LogisticsStatus logisticsStatus) {
        StringBuilder errorName = new StringBuilder("\u8ba2\u5355");
        switch (this.sgSendgoods.getDataOpnextbillstate()) {
            case -1: {
                this.sgSendgoods.setGoodsClass(ExceptionSendStatus.NOT_PICKED_UP.getStatusValue());
                errorName.append(logisticsStatus.getName()).append(",2\u5929\u5c1a\u672a\u63fd\u6536");
                break;
            }
            case 0: {
                this.sgSendgoods.setGoodsClass(ExceptionSendStatus.NOT_PICKED_UP.getStatusValue());
                errorName.append(logisticsStatus.getName()).append(",2\u5929\u5c1a\u672a\u63fd\u6536");
                break;
            }
            case 1: {
                this.sgSendgoods.setGoodsClass(ExceptionSendStatus.PICKED_UP_NOT_IN_TRANSIT.getStatusValue());
                errorName.append(logisticsStatus.getName()).append(",1\u5929\u5c1a\u672a\u5728\u9014");
                break;
            }
            case 2: {
                this.sgSendgoods.setGoodsClass(ExceptionSendStatus.IN_TRANSIT_NOT_DELIVERED.getStatusValue());
                errorName.append(logisticsStatus.getName()).append(",3\u5929\u5c1a\u672a\u914d\u9001");
                break;
            }
            case 5: {
                this.sgSendgoods.setGoodsClass(ExceptionSendStatus.DELIVERED_NOT_SIGNED.getStatusValue());
                errorName.append(logisticsStatus.getName()).append(",2\u5929\u5c1a\u672a\u7b7e\u6536");
                break;
            }
        }
        return errorName.toString();
    }

    private void createSgErrLog() {
        SgSendgoodsLogDomain sgSendgoodsLogDomain = new SgSendgoodsLogDomain();
        sgSendgoodsLogDomain.setSendgoodsCode(this.sgSendgoods.getSendgoodsCode());
        sgSendgoodsLogDomain.setSendgoodsLogType(this.sgSendgoods.getGoodsClass());
        ExceptionSendStatus statusValue = ExceptionSendStatus.getStatusValue(this.sgSendgoods.getGoodsClass());
        sgSendgoodsLogDomain.setSendgoodsLogSort(statusValue.getStatusName());
        sgSendgoodsLogDomain.setSendgoodsLogShow(this.sgSendgoods.getSendgoodsRemark());
        sgSendgoodsLogDomain.setContractBillcode(this.sgSendgoods.getContractBillcode());
        sgSendgoodsLogDomain.setContractBbillcode(this.sgSendgoods.getContractBbillcode());
        sgSendgoodsLogDomain.setPackageBillno(this.sgSendgoods.getPackageBillno());
        sgSendgoodsLogDomain.setPackageName(this.sgSendgoods.getPackageName());
        sgSendgoodsLogDomain.setPackageMode(this.sgSendgoods.getPackageMode());
        sgSendgoodsLogDomain.setTenantCode(this.sgSendgoods.getTenantCode());
        String code = this.sgSendgoodsLogService.saveSendgoodsLog(sgSendgoodsLogDomain);
    }
}

