/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.share.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.share.dao.ShShsettlListMapper;
import com.yqbsoft.laser.service.share.dao.ShShsettlUserMapper;
import com.yqbsoft.laser.service.share.domain.ShShsettlUserDomain;
import com.yqbsoft.laser.service.share.domain.ShShsettlUserReDomain;
import com.yqbsoft.laser.service.share.domain.UmUserDomain;
import com.yqbsoft.laser.service.share.domain.UmUserinfoDomain;
import com.yqbsoft.laser.service.share.model.ShShsettl;
import com.yqbsoft.laser.service.share.model.ShShsettlUser;
import com.yqbsoft.laser.service.share.model.ShShsettlUserStatistics;
import com.yqbsoft.laser.service.share.model.UmGroupList;
import com.yqbsoft.laser.service.share.service.ShShsettlService;
import com.yqbsoft.laser.service.share.service.ShShsettlUserService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ShShsettlUserServiceImpl
extends BaseServiceImpl
implements ShShsettlUserService {
    private static final String SYS_CODE = "sh.ShShsettlUserServiceImpl";
    private ShShsettlUserMapper shShsettlUserMapper;
    private ShShsettlListMapper shShsettlListMapper;
    ShShsettlService shShsettlService;

    public void setShShsettlUserMapper(ShShsettlUserMapper shShsettlUserMapper) {
        this.shShsettlUserMapper = shShsettlUserMapper;
    }

    public void setShShsettlListMapper(ShShsettlListMapper shShsettlListMapper) {
        this.shShsettlListMapper = shShsettlListMapper;
    }

    public void setShShsettlService(ShShsettlService shShsettlService) {
        this.shShsettlService = shShsettlService;
    }

    private Date getSysDate() {
        try {
            return this.shShsettlUserMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("sh.ShShsettlUserServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkShsettlUser(ShShsettlUserDomain shShsettlUserDomain) {
        if (null == shShsettlUserDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)shShsettlUserDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setShsettlUserDefault(ShShsettlUser shShsettlUser) {
        if (null == shShsettlUser) {
            return;
        }
        if (null == shShsettlUser.getDataState()) {
            shShsettlUser.setDataState(0);
        }
        if (null == shShsettlUser.getGmtCreate()) {
            shShsettlUser.setGmtCreate(this.getSysDate());
        }
        shShsettlUser.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)shShsettlUser.getShsettlUserCode())) {
            shShsettlUser.setShsettlUserCode(this.createUUIDString());
        }
        if (StringUtils.isBlank((String)shShsettlUser.getShsettlType())) {
            shShsettlUser.setShsettlType("0");
        }
    }

    private int getShsettlUserMaxCode() {
        int code = 0;
        try {
            return this.shShsettlUserMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("sh.ShShsettlUserServiceImpl.getShsettlUserMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setShsettlUserUpdataDefault(ShShsettlUser shShsettlUser) {
        if (null == shShsettlUser) {
            return;
        }
        shShsettlUser.setGmtModified(this.getSysDate());
    }

    private void saveShsettlUserModel(ShShsettlUser shShsettlUser) throws ApiException {
        if (null == shShsettlUser) {
            return;
        }
        try {
            this.shShsettlUserMapper.insert(shShsettlUser);
        }
        catch (Exception e) {
            throw new ApiException("sh.ShShsettlUserServiceImpl.saveShsettlUserModel.ex", (Throwable)e);
        }
    }

    private void saveShsettlUserBatchModel(List<ShShsettlUser> shShsettlUserList) throws ApiException {
        if (null == shShsettlUserList || shShsettlUserList.isEmpty()) {
            return;
        }
        try {
            this.shShsettlUserMapper.insertBatch(shShsettlUserList);
        }
        catch (Exception e) {
            throw new ApiException("sh.ShShsettlUserServiceImpl.saveShsettlUserBatchModel.ex", (Throwable)e);
        }
    }

    private ShShsettlUser getShsettlUserModelById(Integer shsettlUserId) {
        if (null == shsettlUserId) {
            return null;
        }
        try {
            return this.shShsettlUserMapper.selectByPrimaryKey(shsettlUserId);
        }
        catch (Exception e) {
            this.logger.error("sh.ShShsettlUserServiceImpl.getShsettlUserModelById", (Throwable)e);
            return null;
        }
    }

    private ShShsettlUser getShsettlUserModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.shShsettlUserMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("sh.ShShsettlUserServiceImpl.getShsettlUserModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delShsettlUserModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.shShsettlUserMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("sh.ShShsettlUserServiceImpl.delShsettlUserModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("sh.ShShsettlUserServiceImpl.delShsettlUserModelByCode.num");
        }
    }

    private void deleteShsettlUserModel(Integer shsettlUserId) throws ApiException {
        if (null == shsettlUserId) {
            return;
        }
        int i = 0;
        try {
            i = this.shShsettlUserMapper.deleteByPrimaryKey(shsettlUserId);
        }
        catch (Exception e) {
            throw new ApiException("sh.ShShsettlUserServiceImpl.deleteShsettlUserModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("sh.ShShsettlUserServiceImpl.deleteShsettlUserModel.num");
        }
    }

    private void updateShsettlUserModel(ShShsettlUser shShsettlUser) throws ApiException {
        if (null == shShsettlUser) {
            return;
        }
        int i = 0;
        try {
            i = this.shShsettlUserMapper.updateByPrimaryKey(shShsettlUser);
        }
        catch (Exception e) {
            throw new ApiException("sh.ShShsettlUserServiceImpl.updateShsettlUserModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("sh.ShShsettlUserServiceImpl.updateShsettlUserModel.num");
        }
    }

    private void updateStateShsettlUserModel(Integer shsettlUserId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == shsettlUserId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("shsettlUserId", shsettlUserId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.shShsettlUserMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("sh.ShShsettlUserServiceImpl.updateStateShsettlUserModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("sh.ShShsettlUserServiceImpl.updateStateShsettlUserModel.null");
        }
    }

    private void updateStateShsettlUserModelByCode(String tenantCode, String shsettlUserCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)shsettlUserCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("shsettlUserCode", shsettlUserCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.shShsettlUserMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("sh.ShShsettlUserServiceImpl.updateStateShsettlUserModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("sh.ShShsettlUserServiceImpl.updateStateShsettlUserModelByCode.null");
        }
    }

    private ShShsettlUser makeShsettlUser(ShShsettlUserDomain shShsettlUserDomain, ShShsettlUser shShsettlUser) {
        if (null == shShsettlUserDomain) {
            return null;
        }
        if (null == shShsettlUser) {
            shShsettlUser = new ShShsettlUser();
        }
        try {
            BeanUtils.copyAllPropertys((Object)shShsettlUser, (Object)shShsettlUserDomain);
            return shShsettlUser;
        }
        catch (Exception e) {
            this.logger.error("sh.ShShsettlUserServiceImpl.makeShsettlUser", (Throwable)e);
            return null;
        }
    }

    private ShShsettlUserReDomain makeShShsettlUserReDomain(ShShsettlUser shShsettlUser) {
        if (null == shShsettlUser) {
            return null;
        }
        ShShsettlUserReDomain shShsettlUserReDomain = new ShShsettlUserReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)shShsettlUserReDomain, (Object)shShsettlUser);
            return shShsettlUserReDomain;
        }
        catch (Exception e) {
            this.logger.error("sh.ShShsettlUserServiceImpl.makeShShsettlUserReDomain", (Throwable)e);
            return null;
        }
    }

    private List<ShShsettlUser> queryShsettlUserModelPage(Map<String, Object> parammap) {
        try {
            return this.shShsettlUserMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("sh.ShShsettlUserServiceImpl.queryShsettlUserModel", (Throwable)e);
            return null;
        }
    }

    private int countShsettlUser(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.shShsettlUserMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("sh.ShShsettlUserServiceImpl.countShsettlUser", (Throwable)e);
        }
        return i;
    }

    private ShShsettlUser createShShsettlUser(ShShsettlUserDomain shShsettlUserDomain) {
        String msg = this.checkShsettlUser(shShsettlUserDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("sh.ShShsettlUserServiceImpl.saveShsettlUser.checkShsettlUser", msg);
        }
        if (StringUtils.isBlank((String)shShsettlUserDomain.getShsettlType())) {
            shShsettlUserDomain.setShsettlType("0");
        }
        ShShsettlUser shShsettlUser = this.makeShsettlUser(shShsettlUserDomain, null);
        this.setShsettlUserDefault(shShsettlUser);
        return shShsettlUser;
    }

    @Override
    public String saveShsettlUser(ShShsettlUserDomain shShsettlUserDomain) throws ApiException {
        ShShsettlUser shShsettlUser = this.createShShsettlUser(shShsettlUserDomain);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("shsettlType", shShsettlUserDomain.getShsettlType());
        map.put("memberCode", shShsettlUserDomain.getMemberCode());
        map.put("memberBcode", shShsettlUserDomain.getMemberBcode());
        map.put("tenantCode", shShsettlUserDomain.getTenantCode());
        List<ShShsettlUser> liset = this.queryShsettlUserModelPage(map);
        if (ListUtil.isNotEmpty(liset)) {
            return liset.get(0).getShsettlUserCode();
        }
        this.saveShsettlUserModel(shShsettlUser);
        return shShsettlUser.getShsettlUserCode();
    }

    @Override
    public String saveShsettlUserBatch(List<ShShsettlUserDomain> shShsettlUserDomainList) throws ApiException {
        if (null == shShsettlUserDomainList || shShsettlUserDomainList.isEmpty()) {
            return null;
        }
        ArrayList<ShShsettlUser> shShsettlUserList = new ArrayList<ShShsettlUser>();
        String code = "";
        for (ShShsettlUserDomain shShsettlUserDomain : shShsettlUserDomainList) {
            ShShsettlUser shShsettlUser = this.createShShsettlUser(shShsettlUserDomain);
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("shsettlType", shShsettlUserDomain.getShsettlType());
            map.put("memberCode", shShsettlUserDomain.getMemberCode());
            map.put("memberBcode", shShsettlUserDomain.getMemberBcode());
            map.put("tenantCode", shShsettlUserDomain.getTenantCode());
            List<ShShsettlUser> liset = this.queryShsettlUserModelPage(map);
            if (ListUtil.isNotEmpty(liset)) continue;
            code = shShsettlUser.getShsettlUserCode();
            shShsettlUserList.add(shShsettlUser);
        }
        this.saveShsettlUserBatchModel(shShsettlUserList);
        return code;
    }

    @Override
    public void updateShsettlUserState(Integer shsettlUserId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        this.updateStateShsettlUserModel(shsettlUserId, dataState, oldDataState, map);
    }

    @Override
    public void updateShsettlUserStateByCode(String tenantCode, String shsettlUserCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        this.updateStateShsettlUserModelByCode(tenantCode, shsettlUserCode, dataState, oldDataState, map);
    }

    @Override
    public void updateShsettlUser(ShShsettlUserDomain shShsettlUserDomain) throws ApiException {
        String msg = this.checkShsettlUser(shShsettlUserDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("sh.ShShsettlUserServiceImpl.updateShsettlUser.checkShsettlUser", msg);
        }
        ShShsettlUser oldShShsettlUser = this.getShsettlUserModelById(shShsettlUserDomain.getShsettlUserId());
        if (null == oldShShsettlUser) {
            throw new ApiException("sh.ShShsettlUserServiceImpl.updateShsettlUser.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        ShShsettlUser shShsettlUser = this.makeShsettlUser(shShsettlUserDomain, oldShShsettlUser);
        this.setShsettlUserUpdataDefault(shShsettlUser);
        this.updateShsettlUserModel(shShsettlUser);
    }

    @Override
    public ShShsettlUser getShsettlUser(Integer shsettlUserId) {
        return this.getShsettlUserModelById(shsettlUserId);
    }

    @Override
    public void deleteShsettlUser(Integer shsettlUserId) throws ApiException {
        this.deleteShsettlUserModel(shsettlUserId);
    }

    @Override
    public QueryResult<ShShsettlUser> queryShsettlUserPage(Map<String, Object> map) {
        List<ShShsettlUser> shShsettlUserList = this.queryShsettlUserModelPage(map);
        if (MapUtil.isNotEmpty(map) && null != map.get("statistics") && "true".equals(map.get("statistics"))) {
            boolean group = false;
            if (null != map.get("group") && "true".equals(map.get("group"))) {
                group = true;
            }
            map.remove("startDate");
            map.remove("endDate");
            for (ShShsettlUser shShsettlUser : shShsettlUserList) {
                ShShsettlUserStatistics shsettlUserStatistics = this.getShsettlUserStatistics(map);
                if (group) {
                    String apiCode = "um.group.queryGroupListPage";
                    HashMap<String, String> paramMap = new HashMap<String, String>();
                    paramMap.put("map", JsonUtil.buildNormalBinder().toJson((Object)this.getQueryParamMap("userinfoCode,tenantCode", new Object[]{shShsettlUser.getMemberBcode(), shShsettlUser.getTenantCode()})));
                    String json = this.internalInvoke(apiCode, paramMap);
                    if (StringUtils.isBlank((String)json)) {
                        throw new ApiException("sh.ShShsettlUserServiceImpl.userinfo  make");
                    }
                    QueryResult queryResult = (QueryResult)JsonUtil.buildNormalBinder().getJsonToObject(json, QueryResult.class);
                    if (null != queryResult || ListUtil.isNotEmpty((Collection)queryResult.getList())) {
                        List umGroupLists = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)queryResult.getList()), UmGroupList.class);
                        if (null == umGroupLists) continue;
                        UmGroupList umGroupList = (UmGroupList)umGroupLists.get(0);
                        shsettlUserStatistics.setGroupName(umGroupList.getGroupName());
                    }
                }
                shShsettlUser.setShsettlUserStatistics(shsettlUserStatistics);
            }
        }
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countShsettlUser(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(shShsettlUserList);
        return queryResult;
    }

    @Override
    public List<ShShsettlUser> queryShsettlUserByBCode(String tenantCode, String memberBcode, String shsettlType) throws ApiException {
        if (StringUtils.isBlank((String)memberBcode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("memberBcode", memberBcode);
        map.put("shsettlType", shsettlType);
        return this.queryShsettlUserModelPage(map);
    }

    @Override
    public ShShsettlUser getShsettlUserByCode(String tenantCode, String shsettlUserCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("shsettlUserCode", shsettlUserCode);
        return this.getShsettlUserModelByCode(map);
    }

    @Override
    public void deleteShsettlUserByCode(String tenantCode, String shsettlUserCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("shsettlUserCode", shsettlUserCode);
        this.delShsettlUserModelByCode(map);
    }

    @Override
    public String saveUserInfo(UmUserinfoDomain umUserinfo, UmUserDomain umUser, String optype) {
        ShShsettl shShsettl;
        if (null == umUserinfo) {
            return "error";
        }
        if (StringUtils.isBlank((String)umUserinfo.getUserinfoInvite())) {
            return "success";
        }
        String shsettlCode = umUserinfo.getUserinfoDiscode();
        String tenantCode = umUserinfo.getTenantCode();
        List<ShShsettlUser> userlist = this.queryShsettlUserModelPage(this.getQueryParamMap("shsettlUserInvite,shsettlType,tenantCode", new Object[]{umUserinfo.getUserinfoInvite(), "2", tenantCode}));
        if (ListUtil.isEmpty(userlist)) {
            return "success";
        }
        ShShsettlUser shShsettlUser = userlist.get(0);
        if (StringUtils.isNotBlank((String)shsettlCode)) {
            shShsettl = this.shShsettlService.getShsettlByCode(tenantCode, shsettlCode);
        } else {
            QueryResult<ShShsettl> qset = this.shShsettlService.queryShsettlPage(this.getQueryParamMap("shsettlType,tenantCode", new Object[]{"2", tenantCode}));
            if (null == qset || ListUtil.isEmpty((Collection)qset.getList())) {
                return "error";
            }
            shShsettl = (ShShsettl)qset.getList().get(0);
        }
        if (null == shShsettl) {
            return "error";
        }
        ShShsettlUserDomain shShsettlUserDomain = new ShShsettlUserDomain();
        try {
            BeanUtils.copyAllPropertys((Object)shShsettlUserDomain, (Object)shShsettl);
        }
        catch (Exception exception) {
            // empty catch block
        }
        shShsettlUserDomain.setShsettlCode(shShsettl.getShsettlCode());
        shShsettlUserDomain.setShsettlName(shShsettl.getShsettlName());
        shShsettlUserDomain.setShsettlType(shShsettl.getShsettlType());
        shShsettlUserDomain.setMemberCode(shShsettl.getMemberCode());
        shShsettlUserDomain.setMemberName(shShsettl.getMemberName());
        shShsettlUserDomain.setShsettlType(shShsettl.getShsettlType());
        shShsettlUserDomain.setMemberBcode(umUserinfo.getUserinfoCode());
        shShsettlUserDomain.setMemberBname(umUserinfo.getUserinfoCompname());
        shShsettlUserDomain.setMemberDiscode(shShsettlUser.getMemberBcode());
        shShsettlUserDomain.setMemberDisname(shShsettlUser.getMemberBname());
        shShsettlUserDomain.setShsettlUserLogo(umUser.getUserImgurl());
        shShsettlUserDomain.setShsettlUserName(umUser.getUserName());
        shShsettlUserDomain.setShsettlUserPhone(umUser.getUserPhone());
        shShsettlUserDomain.setTenantCode(tenantCode);
        this.saveShsettlUser(shShsettlUserDomain);
        return "success";
    }

    @Override
    public ShShsettlUserStatistics getShsettlUserStatistics(Map<String, Object> map) throws ApiException {
        ShShsettlUserStatistics statistics = new ShShsettlUserStatistics();
        Map<String, Object> amount = this.shShsettlListMapper.getAmount(map);
        statistics.setIncomeAmount(null == amount || null == amount.get("incomeAmount") ? new BigDecimal(0) : (BigDecimal)amount.get("incomeAmount"));
        statistics.setVolumeAmount(null == amount || null == amount.get("volumeAmount") ? new BigDecimal(0) : (BigDecimal)amount.get("volumeAmount"));
        statistics.setOrderNum(null == amount || null == amount.get("orderNum") ? 0 : Integer.valueOf(amount.get("orderNum").toString()));
        statistics.setOrderUserNum(this.shShsettlListMapper.getOrderUserNum(map));
        map.put("memberDiscode", map.get("memberBcode"));
        statistics.setClientNum(this.shShsettlUserMapper.getClientNum(map));
        return statistics;
    }
}

