/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.suyang.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.suyang.dao.GeneralMapper;
import com.yqbsoft.laser.service.suyang.domain.GeneralDomain;
import com.yqbsoft.laser.service.suyang.domain.GeneralReDomain;
import com.yqbsoft.laser.service.suyang.model.General;
import com.yqbsoft.laser.service.suyang.service.GeneralService;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GeneralServiceImpl
extends BaseServiceImpl
implements GeneralService {
    private static final String SYS_CODE = "suyang.GeneralServiceImpl";
    private GeneralMapper generalMapper;

    public void setGeneralMapper(GeneralMapper generalMapper) {
        this.generalMapper = generalMapper;
    }

    private Date getSysDate() {
        try {
            return this.generalMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("suyang.GeneralServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkGeneral(GeneralDomain generalDomain) {
        if (null == generalDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        return msg;
    }

    private void setGeneralDefault(General general) {
        if (null == general) {
            return;
        }
    }

    private int getGeneralMaxCode() {
        int code = 0;
        try {
            return this.generalMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("suyang.GeneralServiceImpl.getGeneralMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setGeneralUpdataDefault(General general) {
        if (null == general) {
            return;
        }
    }

    private void saveGeneralModel(General general) throws ApiException {
        if (null == general) {
            return;
        }
        try {
            this.generalMapper.insert(general);
        }
        catch (Exception e) {
            throw new ApiException("suyang.GeneralServiceImpl.saveGeneralModel.ex", (Throwable)e);
        }
    }

    private void saveGeneralBatchModel(List<General> generalList) throws ApiException {
        if (null == generalList || generalList.isEmpty()) {
            return;
        }
        try {
            this.generalMapper.insertBatch(generalList);
        }
        catch (Exception e) {
            throw new ApiException("suyang.GeneralServiceImpl.saveGeneralBatchModel.ex", (Throwable)e);
        }
    }

    private General getGeneralModelById(Integer GeneralId) {
        if (null == GeneralId) {
            return null;
        }
        try {
            return this.generalMapper.selectByPrimaryKey(GeneralId);
        }
        catch (Exception e) {
            this.logger.error("suyang.GeneralServiceImpl.getGeneralModelById", (Throwable)e);
            return null;
        }
    }

    private General getGeneralModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.generalMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("suyang.GeneralServiceImpl.getGeneralModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delGeneralModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.generalMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("suyang.GeneralServiceImpl.delGeneralModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("suyang.GeneralServiceImpl.delGeneralModelByCode.num");
        }
    }

    private void deleteGeneralModel(Integer GeneralId) throws ApiException {
        if (null == GeneralId) {
            return;
        }
        int i = 0;
        try {
            i = this.generalMapper.deleteByPrimaryKey(GeneralId);
        }
        catch (Exception e) {
            throw new ApiException("suyang.GeneralServiceImpl.deleteGeneralModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("suyang.GeneralServiceImpl.deleteGeneralModel.num");
        }
    }

    private void updateGeneralModel(General general) throws ApiException {
        if (null == general) {
            return;
        }
        int i = 0;
        try {
            i = this.generalMapper.updateByPrimaryKey(general);
        }
        catch (Exception e) {
            throw new ApiException("suyang.GeneralServiceImpl.updateGeneralModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("suyang.GeneralServiceImpl.updateGeneralModel.num");
        }
    }

    private void updateStateGeneralModel(Integer GeneralId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == GeneralId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("GeneralId", GeneralId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.generalMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("suyang.GeneralServiceImpl.updateStateGeneralModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("suyang.GeneralServiceImpl.updateStateGeneralModel.null");
        }
    }

    private void updateStateGeneralModelByCode(String tenantCode, String GeneralCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)GeneralCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("GeneralCode", GeneralCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.generalMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("suyang.GeneralServiceImpl.updateStateGeneralModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("suyang.GeneralServiceImpl.updateStateGeneralModelByCode.null");
        }
    }

    private General makeGeneral(GeneralDomain generalDomain, General general) {
        if (null == generalDomain) {
            return null;
        }
        if (null == general) {
            general = new General();
        }
        try {
            BeanUtils.copyAllPropertys((Object)general, (Object)generalDomain);
            return general;
        }
        catch (Exception e) {
            this.logger.error("suyang.GeneralServiceImpl.makeGeneral", (Throwable)e);
            return null;
        }
    }

    private GeneralReDomain makeGeneralReDomain(General general) {
        if (null == general) {
            return null;
        }
        GeneralReDomain generalReDomain = new GeneralReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)generalReDomain, (Object)general);
            return generalReDomain;
        }
        catch (Exception e) {
            this.logger.error("suyang.GeneralServiceImpl.makeGeneralReDomain", (Throwable)e);
            return null;
        }
    }

    private List<General> queryGeneralModelPage(Map<String, Object> parammap) {
        try {
            return this.generalMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("suyang.GeneralServiceImpl.queryGeneralModel", (Throwable)e);
            return null;
        }
    }

    private int countGeneral(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.generalMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("suyang.GeneralServiceImpl.countGeneral", (Throwable)e);
        }
        return i;
    }

    private General createGeneral(GeneralDomain generalDomain) {
        String msg = this.checkGeneral(generalDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("suyang.GeneralServiceImpl.saveGeneral.checkGeneral", msg);
        }
        General general = this.makeGeneral(generalDomain, null);
        this.setGeneralDefault(general);
        return general;
    }

    @Override
    public String saveGeneral(GeneralDomain generalDomain) throws ApiException {
        General general = this.createGeneral(generalDomain);
        this.saveGeneralModel(general);
        return general.getTenantcode();
    }

    @Override
    public String saveGeneralBatch(List<GeneralDomain> generalDomainList) throws ApiException {
        if (null == generalDomainList || generalDomainList.isEmpty()) {
            return null;
        }
        ArrayList<General> generalList = new ArrayList<General>();
        String code = "";
        for (GeneralDomain generalDomain : generalDomainList) {
            General general = this.createGeneral(generalDomain);
            code = general.getDimCode();
            generalList.add(general);
        }
        this.saveGeneralBatchModel(generalList);
        return code;
    }

    @Override
    public void updateGeneralState(Integer GeneralId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        this.updateStateGeneralModel(GeneralId, dataState, oldDataState, map);
    }

    @Override
    public void updateGeneralStateByCode(String tenantCode, String GeneralCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        this.updateStateGeneralModelByCode(tenantCode, GeneralCode, dataState, oldDataState, map);
    }

    @Override
    public void updateGeneral(GeneralDomain generalDomain) throws ApiException {
        String msg = this.checkGeneral(generalDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("suyang.GeneralServiceImpl.updateGeneral.checkGeneral", msg);
        }
        General oldGeneral = this.getGeneralModelById(generalDomain.getId());
        if (null == oldGeneral) {
            throw new ApiException("suyang.GeneralServiceImpl.updateGeneral.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        General general = this.makeGeneral(generalDomain, oldGeneral);
        this.setGeneralUpdataDefault(general);
        this.updateGeneralModel(general);
    }

    @Override
    public General getGeneral(Integer GeneralId) {
        return this.getGeneralModelById(GeneralId);
    }

    @Override
    public void deleteGeneral(Integer GeneralId) throws ApiException {
        this.deleteGeneralModel(GeneralId);
    }

    @Override
    public QueryResult<General> queryGeneralPage(Map<String, Object> map) {
        List<General> generalList = this.queryGeneralModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countGeneral(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(generalList);
        return queryResult;
    }

    @Override
    public General getGeneralByCode(String tenantCode, String GeneralCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("GeneralCode", GeneralCode);
        return this.getGeneralModelByCode(map);
    }

    @Override
    public void deleteGeneralByCode(String tenantCode, String GeneralCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("GeneralCode", GeneralCode);
        this.delGeneralModelByCode(map);
    }
}

