/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.suyang.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.suyang.service.SuyanDbService;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.Tuple;

public class SuyanDbServiceImpl
extends BaseServiceImpl
implements SuyanDbService {
    private static final String SYS_CODE = "suyang.SuyanDbService";
    private static final String Ip = "101.132.193.181";
    private static final int port = 7000;
    private static final String password = "qianjiang9527@";
    private static final int index = 15;

    private static Jedis getJedis() {
        GenericObjectPoolConfig conf = new GenericObjectPoolConfig();
        conf.setMaxIdle(100);
        conf.setMaxTotal(3000);
        conf.setMaxWaitMillis(10000L);
        JedisPool pool = new JedisPool(conf, Ip, 7000, 5000, password);
        Jedis jedis = pool.getResource();
        jedis.select(15);
        return jedis;
    }

    @Override
    public List<Map<String, Object>> commodities(String platform, String Keyword, String spu) throws ApiException {
        Jedis jedis = SuyanDbServiceImpl.getJedis();
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        Set tuples = jedis.zrangeWithScores("bg:suyan_zpp:" + this.datenow() + ":goodsSucAmSp", 0L, -1L);
        String goodsSuc = "";
        String sucCount = "";
        if (null != spu && spu.equals("spu")) {
            spu = "spuInfo";
            goodsSuc = "goodsSucCoSp";
            sucCount = "sucSpCount";
        } else {
            spu = "skuInfo";
            goodsSuc = "goodsSucCoSk";
            sucCount = "sucSkCount";
        }
        for (Tuple tuple : tuples) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            System.out.println(tuple.getElement() + ":" + tuple.getScore());
            map.put("goodsSucAmSp", tuple.getScore());
            map.put("goodsku", tuple.getElement());
            List list1 = jedis.hmget("bg:suyan_zpp:" + spu + "", new String[]{tuple.getElement()});
            if (list1 != null && list1.size() != 0) {
                map.put("goodName", list1.get(0));
            }
            Set tuplesGoodsSucAmSp = jedis.zrangeWithScores("bg:suyan_zpp:" + this.datenow() + ":" + goodsSuc + "", 0L, -1L);
            for (Tuple GoodsSucAmSp : tuplesGoodsSucAmSp) {
                if (!tuple.getElement().equals(GoodsSucAmSp.getElement())) continue;
                map.put("sucCoSp", GoodsSucAmSp.getScore());
            }
            Long sucSpCount = jedis.scard("bg:suyan_zpp:" + this.datenow() + ":" + sucCount + ":" + tuple.getElement());
            map.put("sucSpCount", sucSpCount);
            String key = "bg:suyan_zpp:" + this.datenow() + ":" + tuple.getElement() + ":goodsCo";
            Long goodsCo = jedis.scard(key);
            map.put("goodsCo", goodsCo);
            String percent = (float)sucSpCount.longValue() / (float)goodsCo.longValue() * 100.0f + "%";
            map.put("percent", percent);
            list.add(map);
        }
        jedis.close();
        return list;
    }

    @Override
    public Map<String, Object> survey(String platform) throws ApiException {
        Jedis jedis = SuyanDbServiceImpl.getJedis();
        HashMap<String, Object> mapa = new HashMap<String, Object>();
        HashMap<String, Object> map = new HashMap<String, Object>();
        Long uv = jedis.scard("bg:suyan_zpp:" + this.datenow() + ":uv");
        map.put("uv", uv);
        Long bCodeCount = jedis.scard("bg:suyan_zpp:" + this.datenow() + ":bCodeCount");
        map.put("bCodeCount", bCodeCount);
        String percent = (float)bCodeCount.longValue() / (float)uv.longValue() * 100.0f + "%";
        map.put("percent", percent);
        Long focusShop = jedis.scard("bg:suyan_zpp:" + this.datenow() + ":focusShop");
        map.put("focusShop", focusShop);
        String pv = jedis.get("bg:suyan_zpp:" + this.datenow() + ":pv");
        map.put("pv", pv);
        Long addShopping = jedis.scard("bg:suyan_zpp:" + this.datenow() + ":addShopping");
        map.put("addShopping", addShopping);
        String ordCount = jedis.get("bg:suyan_zpp:" + this.datenow() + ":ordCount");
        map.put("ordCount", ordCount);
        String goodsCount = jedis.get("bg:suyan_zpp:" + this.datenow() + ":goodsCount");
        map.put("goodsCount", goodsCount);
        String ordAmount = jedis.get("bg:suyan_zpp:" + this.datenow() + ":ordAmount");
        map.put("ordAmount", ordAmount);
        float Customer = (float)(Double.valueOf(ordAmount) / (double)bCodeCount.longValue());
        map.put("Customer", Float.valueOf(Customer));
        ArrayList list = new ArrayList();
        long overTime = 0L;
        long nows = System.currentTimeMillis();
        SimpleDateFormat sdfOne = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat sdfTwo = new SimpleDateFormat("yyyyMMddHHmm");
        try {
            overTime = (nows - sdfOne.parse(sdfOne.format(nows)).getTime()) / 1000L;
            int i = 0;
            while ((long)i < overTime / 3600L) {
                HashMap<String, Object> maps = new HashMap<String, Object>();
                String day = "";
                day = i < 10 ? this.datenow() + "0" + i + "00" : this.datenow() + i + "00";
                Long uvs = jedis.scard("bg:suyan_zpp:" + day + ":uv");
                maps.put("uvs", uvs);
                String pvs = jedis.get("bg:suyan_zpp:" + day + ":pv");
                maps.put("pvs", pvs);
                Long bCodeCounts = jedis.scard("bg:suyan_zpp:" + day + ":bCodeCount");
                maps.put("bCodeCounts", bCodeCounts);
                String ordCounts = jedis.get("bg:suyan_zpp:" + day + ":ordCount");
                maps.put("ordCounts", ordCounts);
                String goodsCounts = jedis.get("bg:suyan_zpp:" + day + ":goodsCount");
                maps.put("goodsCounts", goodsCounts);
                String ordAmounts = jedis.get("bg:suyan_zpp:" + day + ":ordAmount");
                maps.put("ordAmounts", ordAmounts);
                maps.put("goodDate", day);
                list.add(maps);
                ++i;
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        mapa.put("survey", map);
        mapa.put("trendlist", list);
        jedis.close();
        return mapa;
    }

    @Override
    public Map<String, Object> trading(String platform) throws ApiException {
        Jedis jedis = SuyanDbServiceImpl.getJedis();
        ArrayList list = new ArrayList();
        HashMap<String, Object> maps = new HashMap<String, Object>();
        Set tuples = jedis.zrangeWithScores("bg:suyan_zpp:" + this.datenow() + ":goodsSucAmSp", 0L, -1L);
        double score = 0.0;
        for (Tuple tuple : tuples) {
            score += tuple.getScore();
        }
        for (Tuple tuple : tuples) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            System.out.println(tuple.getElement() + ":" + tuple.getScore());
            map.put("goodsSucAmSp", tuple.getScore());
            map.put("goodsku", tuple.getElement());
            List list1 = jedis.hmget("bg:suyan_zpp:spuInfo", new String[]{tuple.getElement()});
            if (list1 != null && list1.size() != 0) {
                map.put("goodName", list1.get(0));
            }
            Set tuplesGoodsSucAmSp = jedis.zrangeWithScores("bg:suyan_zpp:" + this.datenow() + ":goodsSucCoSp", 0L, -1L);
            Iterator iterator = tuplesGoodsSucAmSp.iterator();
            while (iterator.hasNext()) {
                Tuple GoodsSucAmSp = (Tuple)iterator.next();
                if (!tuple.getElement().equals(GoodsSucAmSp.getElement())) continue;
                map.put("sucCoSp", GoodsSucAmSp.getScore());
            }
            String percent = (double)((float)tuple.getScore()) / score * 100.0 + "%";
            map.put("percent", percent);
            list.add(map);
        }
        ArrayList lista = new ArrayList();
        Set tupleb = jedis.zrangeWithScores("bg:suyan_zpp:" + this.datenow() + ":goodsUV", 0L, -1L);
        double scores = 0.0;
        for (Tuple tuple : tupleb) {
            scores += tuple.getScore();
        }
        Set tuplea = jedis.zrangeWithScores("bg:suyan_zpp:" + this.datenow() + ":goodsUV", 0L, -1L);
        for (Tuple tuple : tuplea) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            System.out.println(tuple.getElement() + ":" + tuple.getScore());
            map.put("goodsSucAmSp", tuple.getScore());
            map.put("goodsku", tuple.getElement());
            List list1 = jedis.hmget("bg:suyan_zpp:spuInfo", new String[]{tuple.getElement()});
            if (list1 != null && list1.size() != 0) {
                map.put("goodName", list1.get(0));
            }
            String percent = (double)((float)tuple.getScore()) / scores * 100.0 + "%";
            map.put("percent", percent);
            lista.add(map);
        }
        maps.put("Goodlist", list);
        maps.put("Popularitylist", lista);
        jedis.close();
        return maps;
    }

    @Override
    public Map<String, Object> pageView(String platform) throws ApiException {
        Jedis jedis = SuyanDbServiceImpl.getJedis();
        HashMap<String, Long> map = new HashMap<String, Long>();
        HashMap<String, Object> mapa = new HashMap<String, Object>();
        Long pageHomeCo = jedis.scard("bg:suyan_zpp:" + this.datenow() + ":pageHomeCo");
        Long pageClassCo = jedis.scard("bg:suyan_zpp:" + this.datenow() + ":pageClassCo");
        Long viewGoodsCo = jedis.scard("bg:suyan_zpp:" + this.datenow() + ":viewGoodsCo");
        Long pageUserCo = jedis.scard("bg:suyan_zpp:" + this.datenow() + ":pageUserCo");
        map.put("pageHomeCo", pageHomeCo);
        map.put("pageClassCo", pageClassCo);
        map.put("viewGoodsCo", viewGoodsCo);
        map.put("pageUserCo", pageUserCo);
        ArrayList list = new ArrayList();
        Map userMap = jedis.hgetAll("bg:suyan_zpp:" + this.datenow() + ":provincePV");
        for (Map.Entry item : userMap.entrySet()) {
            HashMap<String, Object> maps = new HashMap<String, Object>();
            maps.put("city", item.getKey());
            maps.put("pv", item.getValue());
            Set tuples = jedis.zrangeWithScores("bg:suyan_zpp:" + this.datenow() + ":provinceUV", 0L, -1L);
            for (Tuple tuple : tuples) {
                if (!((String)item.getKey()).equals(tuple.getElement())) continue;
                maps.put("uv", tuple.getScore());
            }
            list.add(maps);
        }
        mapa.put("pageCo", map);
        mapa.put("list", list);
        return mapa;
    }

    private String subDay(int day) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        Date dt = new Date();
        Calendar rightNow = Calendar.getInstance();
        rightNow.setTime(dt);
        rightNow.add(5, -day);
        Date dt1 = rightNow.getTime();
        String reStr = sdf.format(dt1);
        return reStr;
    }

    private String datenow() {
        Date now = new Date();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd");
        String tablename = dateFormat.format(now);
        return tablename;
    }
}

