/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.suyang.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.suyang.dao.PathRankMapper;
import com.yqbsoft.laser.service.suyang.domain.PathRankDomain;
import com.yqbsoft.laser.service.suyang.domain.PathRankReDomain;
import com.yqbsoft.laser.service.suyang.model.PathRank;
import com.yqbsoft.laser.service.suyang.service.PathRankService;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PathRankServiceImpl
extends BaseServiceImpl
implements PathRankService {
    private static final String SYS_CODE = "suyang.PathRankServiceImpl";
    private PathRankMapper pathRankMapper;

    public void setPathRankMapper(PathRankMapper pathRankMapper) {
        this.pathRankMapper = pathRankMapper;
    }

    private Date getSysDate() {
        try {
            return this.pathRankMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("suyang.PathRankServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkPathRank(PathRankDomain pathRankDomain) {
        if (null == pathRankDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)pathRankDomain.getTenantcode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setPathRankDefault(PathRank pathRank) {
        if (null == pathRank) {
            return;
        }
    }

    private int getPathRankMaxCode() {
        int code = 0;
        try {
            return this.pathRankMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("suyang.PathRankServiceImpl.getPathRankMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setPathRankUpdataDefault(PathRank pathRank) {
        if (null == pathRank) {
            return;
        }
    }

    private void savePathRankModel(PathRank pathRank) throws ApiException {
        if (null == pathRank) {
            return;
        }
        try {
            this.pathRankMapper.insert(pathRank);
        }
        catch (Exception e) {
            throw new ApiException("suyang.PathRankServiceImpl.savePathRankModel.ex", (Throwable)e);
        }
    }

    private void savePathRankBatchModel(List<PathRank> pathRankList) throws ApiException {
        if (null == pathRankList || pathRankList.isEmpty()) {
            return;
        }
        try {
            this.pathRankMapper.insertBatch(pathRankList);
        }
        catch (Exception e) {
            throw new ApiException("suyang.PathRankServiceImpl.savePathRankBatchModel.ex", (Throwable)e);
        }
    }

    private PathRank getPathRankModelById(Integer PathRankId) {
        if (null == PathRankId) {
            return null;
        }
        try {
            return this.pathRankMapper.selectByPrimaryKey(PathRankId);
        }
        catch (Exception e) {
            this.logger.error("suyang.PathRankServiceImpl.getPathRankModelById", (Throwable)e);
            return null;
        }
    }

    private PathRank getPathRankModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.pathRankMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("suyang.PathRankServiceImpl.getPathRankModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delPathRankModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.pathRankMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("suyang.PathRankServiceImpl.delPathRankModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("suyang.PathRankServiceImpl.delPathRankModelByCode.num");
        }
    }

    private void deletePathRankModel(Integer PathRankId) throws ApiException {
        if (null == PathRankId) {
            return;
        }
        int i = 0;
        try {
            i = this.pathRankMapper.deleteByPrimaryKey(PathRankId);
        }
        catch (Exception e) {
            throw new ApiException("suyang.PathRankServiceImpl.deletePathRankModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("suyang.PathRankServiceImpl.deletePathRankModel.num");
        }
    }

    private void updatePathRankModel(PathRank pathRank) throws ApiException {
        if (null == pathRank) {
            return;
        }
        int i = 0;
        try {
            i = this.pathRankMapper.updateByPrimaryKey(pathRank);
        }
        catch (Exception e) {
            throw new ApiException("suyang.PathRankServiceImpl.updatePathRankModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("suyang.PathRankServiceImpl.updatePathRankModel.num");
        }
    }

    private void updateStatePathRankModel(Integer PathRankId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == PathRankId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("PathRankId", PathRankId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.pathRankMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("suyang.PathRankServiceImpl.updateStatePathRankModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("suyang.PathRankServiceImpl.updateStatePathRankModel.null");
        }
    }

    private void updateStatePathRankModelByCode(String tenantCode, String PathRankCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)PathRankCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("PathRankCode", PathRankCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.pathRankMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("suyang.PathRankServiceImpl.updateStatePathRankModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("suyang.PathRankServiceImpl.updateStatePathRankModelByCode.null");
        }
    }

    private PathRank makePathRank(PathRankDomain pathRankDomain, PathRank pathRank) {
        if (null == pathRankDomain) {
            return null;
        }
        if (null == pathRank) {
            pathRank = new PathRank();
        }
        try {
            BeanUtils.copyAllPropertys((Object)pathRank, (Object)pathRankDomain);
            return pathRank;
        }
        catch (Exception e) {
            this.logger.error("suyang.PathRankServiceImpl.makePathRank", (Throwable)e);
            return null;
        }
    }

    private PathRankReDomain makePathRankReDomain(PathRank pathRank) {
        if (null == pathRank) {
            return null;
        }
        PathRankReDomain pathRankReDomain = new PathRankReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)pathRankReDomain, (Object)pathRank);
            return pathRankReDomain;
        }
        catch (Exception e) {
            this.logger.error("suyang.PathRankServiceImpl.makePathRankReDomain", (Throwable)e);
            return null;
        }
    }

    private List<PathRank> queryPathRankModelPage(Map<String, Object> parammap) {
        try {
            return this.pathRankMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("suyang.PathRankServiceImpl.queryPathRankModel", (Throwable)e);
            return null;
        }
    }

    private int countPathRank(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.pathRankMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("suyang.PathRankServiceImpl.countPathRank", (Throwable)e);
        }
        return i;
    }

    private PathRank createPathRank(PathRankDomain pathRankDomain) {
        String msg = this.checkPathRank(pathRankDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("suyang.PathRankServiceImpl.savePathRank.checkPathRank", msg);
        }
        PathRank pathRank = this.makePathRank(pathRankDomain, null);
        this.setPathRankDefault(pathRank);
        return pathRank;
    }

    @Override
    public String savePathRank(PathRankDomain pathRankDomain) throws ApiException {
        PathRank pathRank = this.createPathRank(pathRankDomain);
        this.savePathRankModel(pathRank);
        return pathRank.getDimCode();
    }

    @Override
    public String savePathRankBatch(List<PathRankDomain> pathRankDomainList) throws ApiException {
        if (null == pathRankDomainList || pathRankDomainList.isEmpty()) {
            return null;
        }
        ArrayList<PathRank> pathRankList = new ArrayList<PathRank>();
        String code = "";
        for (PathRankDomain pathRankDomain : pathRankDomainList) {
            PathRank pathRank = this.createPathRank(pathRankDomain);
            pathRankList.add(pathRank);
        }
        this.savePathRankBatchModel(pathRankList);
        return code;
    }

    @Override
    public void updatePathRankState(Integer PathRankId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        this.updateStatePathRankModel(PathRankId, dataState, oldDataState, map);
    }

    @Override
    public void updatePathRankStateByCode(String tenantCode, String PathRankCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        this.updateStatePathRankModelByCode(tenantCode, PathRankCode, dataState, oldDataState, map);
    }

    @Override
    public void updatePathRank(PathRankDomain pathRankDomain) throws ApiException {
        String msg = this.checkPathRank(pathRankDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("suyang.PathRankServiceImpl.updatePathRank.checkPathRank", msg);
        }
        PathRank oldPathRank = this.getPathRankModelById(pathRankDomain.getId());
        if (null == oldPathRank) {
            throw new ApiException("suyang.PathRankServiceImpl.updatePathRank.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        PathRank pathRank = this.makePathRank(pathRankDomain, oldPathRank);
        this.setPathRankUpdataDefault(pathRank);
        this.updatePathRankModel(pathRank);
    }

    @Override
    public PathRank getPathRank(Integer PathRankId) {
        return this.getPathRankModelById(PathRankId);
    }

    @Override
    public void deletePathRank(Integer PathRankId) throws ApiException {
        this.deletePathRankModel(PathRankId);
    }

    @Override
    public QueryResult<PathRank> queryPathRankPage(Map<String, Object> map) {
        List<PathRank> pathRankList = this.queryPathRankModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countPathRank(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(pathRankList);
        return queryResult;
    }

    @Override
    public PathRank getPathRankByCode(String tenantCode, String PathRankCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("PathRankCode", PathRankCode);
        return this.getPathRankModelByCode(map);
    }

    @Override
    public void deletePathRankByCode(String tenantCode, String PathRankCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("PathRankCode", PathRankCode);
        this.delPathRankModelByCode(map);
    }
}

