/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.tenantmanag.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.flow.SoaUtil;
import com.yqbsoft.laser.service.esb.core.flow.UddiUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.core.OutMessage;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tenantmanag.dao.TmTmsceneApiMapper;
import com.yqbsoft.laser.service.tenantmanag.dao.TmTmsceneMapper;
import com.yqbsoft.laser.service.tenantmanag.domain.TmTmsceneApiDomain;
import com.yqbsoft.laser.service.tenantmanag.domain.TmTmsceneApiReDomain;
import com.yqbsoft.laser.service.tenantmanag.domain.TmTmsceneDomain;
import com.yqbsoft.laser.service.tenantmanag.domain.TmTmsceneReDomain;
import com.yqbsoft.laser.service.tenantmanag.model.TmSceneApi;
import com.yqbsoft.laser.service.tenantmanag.model.TmTmscene;
import com.yqbsoft.laser.service.tenantmanag.model.TmTmsceneApi;
import com.yqbsoft.laser.service.tenantmanag.service.TmSceneService;
import com.yqbsoft.laser.service.tenantmanag.service.TmTmsceneService;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TmTmsceneServiceImpl
extends BaseServiceImpl
implements TmTmsceneService {
    private static final String SYS_CODE = "tm.TmTmsceneServiceImpl";
    private TmSceneService tmSceneService;
    private TmTmsceneMapper tmTmsceneMapper;
    private TmTmsceneApiMapper tmTmsceneApiMapper;

    public void setTmTmsceneMapper(TmTmsceneMapper tmTmsceneMapper) {
        this.tmTmsceneMapper = tmTmsceneMapper;
    }

    public void setTmTmsceneApiMapper(TmTmsceneApiMapper tmTmsceneApiMapper) {
        this.tmTmsceneApiMapper = tmTmsceneApiMapper;
    }

    public void setTmSceneService(TmSceneService tmSceneService) {
        this.tmSceneService = tmSceneService;
    }

    private Date getSysDate() {
        try {
            return this.tmTmsceneMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("tm.TmTmsceneServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkTmscene(TmTmsceneDomain tmTmsceneDomain) {
        if (null == tmTmsceneDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)tmTmsceneDomain.getSceneCode())) {
            msg = msg + "SceneCode\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)tmTmsceneDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setTmsceneDefault(TmTmscene tmTmscene) {
        if (null == tmTmscene) {
            return;
        }
        if (null == tmTmscene.getDataState()) {
            tmTmscene.setDataState(0);
        }
        if (null == tmTmscene.getGmtCreate()) {
            tmTmscene.setGmtCreate(this.getSysDate());
        }
        tmTmscene.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)tmTmscene.getTmsceneCode())) {
            tmTmscene.setTmsceneCode(this.createUUIDString());
        }
    }

    private int getTmsceneMaxCode() {
        int code = 0;
        try {
            return this.tmTmsceneMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("tm.TmTmsceneServiceImpl.getTmsceneMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setTmsceneUpdataDefault(TmTmscene tmTmscene) {
        if (null == tmTmscene) {
            return;
        }
        tmTmscene.setGmtModified(this.getSysDate());
    }

    private void saveTmsceneModel(TmTmscene tmTmscene) throws ApiException {
        if (null == tmTmscene) {
            return;
        }
        try {
            this.tmTmsceneMapper.insert(tmTmscene);
        }
        catch (Exception e) {
            throw new ApiException("tm.TmTmsceneServiceImpl.saveTmsceneModel.ex", (Throwable)e);
        }
    }

    private void saveTmsceneBatchModel(List<TmTmscene> tmTmsceneList) throws ApiException {
        if (null == tmTmsceneList || tmTmsceneList.isEmpty()) {
            return;
        }
        try {
            this.tmTmsceneMapper.insertBatch(tmTmsceneList);
        }
        catch (Exception e) {
            throw new ApiException("tm.TmTmsceneServiceImpl.saveTmsceneBatchModel.ex", (Throwable)e);
        }
    }

    private TmTmscene getTmsceneModelById(Integer tmsceneId) {
        if (null == tmsceneId) {
            return null;
        }
        try {
            return this.tmTmsceneMapper.selectByPrimaryKey(tmsceneId);
        }
        catch (Exception e) {
            this.logger.error("tm.TmTmsceneServiceImpl.getTmsceneModelById", (Throwable)e);
            return null;
        }
    }

    private TmTmscene getTmsceneModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.tmTmsceneMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("tm.TmTmsceneServiceImpl.getTmsceneModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delTmsceneModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.tmTmsceneMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("tm.TmTmsceneServiceImpl.delTmsceneModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("tm.TmTmsceneServiceImpl.delTmsceneModelByCode.num");
        }
    }

    private void deleteTmsceneModel(Integer tmsceneId) throws ApiException {
        if (null == tmsceneId) {
            return;
        }
        int i = 0;
        try {
            i = this.tmTmsceneMapper.deleteByPrimaryKey(tmsceneId);
        }
        catch (Exception e) {
            throw new ApiException("tm.TmTmsceneServiceImpl.deleteTmsceneModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("tm.TmTmsceneServiceImpl.deleteTmsceneModel.num");
        }
    }

    private void updateTmsceneModel(TmTmscene tmTmscene) throws ApiException {
        if (null == tmTmscene) {
            return;
        }
        int i = 0;
        try {
            i = this.tmTmsceneMapper.updateByPrimaryKeySelective(tmTmscene);
        }
        catch (Exception e) {
            throw new ApiException("tm.TmTmsceneServiceImpl.updateTmsceneModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("tm.TmTmsceneServiceImpl.updateTmsceneModel.num");
        }
    }

    private void updateStateTmsceneModel(Integer tmsceneId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == tmsceneId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tmsceneId", tmsceneId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.tmTmsceneMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("tm.TmTmsceneServiceImpl.updateStateTmsceneModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("tm.TmTmsceneServiceImpl.updateStateTmsceneModel.null");
        }
    }

    private void updateStateTmsceneModelByCode(String tenantCode, String tmsceneCode, Integer dataState, Integer oldDataState) throws ApiException {
        if (StringUtils.isBlank((String)tmsceneCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("tmsceneCode", tmsceneCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.tmTmsceneMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("tm.TmTmsceneServiceImpl.updateStateTmsceneModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("tm.TmTmsceneServiceImpl.updateStateTmsceneModelByCode.null");
        }
    }

    private TmTmscene makeTmscene(TmTmsceneDomain tmTmsceneDomain, TmTmscene tmTmscene) {
        if (null == tmTmsceneDomain) {
            return null;
        }
        if (null == tmTmscene) {
            tmTmscene = new TmTmscene();
        }
        try {
            BeanUtils.copyAllPropertys((Object)tmTmscene, (Object)tmTmsceneDomain);
            return tmTmscene;
        }
        catch (Exception e) {
            this.logger.error("tm.TmTmsceneServiceImpl.makeTmscene", (Throwable)e);
            return null;
        }
    }

    private TmTmsceneReDomain makeTmTmsceneReDomain(TmTmscene tmTmscene) {
        if (null == tmTmscene) {
            return null;
        }
        TmTmsceneReDomain tmTmsceneReDomain = new TmTmsceneReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)tmTmsceneReDomain, (Object)tmTmscene);
            return tmTmsceneReDomain;
        }
        catch (Exception e) {
            this.logger.error("tm.TmTmsceneServiceImpl.makeTmTmsceneReDomain", (Throwable)e);
            return null;
        }
    }

    private List<TmTmscene> queryTmsceneModelPage(Map<String, Object> parammap) {
        try {
            return this.tmTmsceneMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("tm.TmTmsceneServiceImpl.queryTmsceneModel", (Throwable)e);
            return null;
        }
    }

    private int countTmscene(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.tmTmsceneMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("tm.TmTmsceneServiceImpl.countTmscene", (Throwable)e);
        }
        return i;
    }

    private TmTmscene createTmTmscene(TmTmsceneDomain tmTmsceneDomain) {
        String msg = this.checkTmscene(tmTmsceneDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("tm.TmTmsceneServiceImpl.saveTmscene.checkTmscene", msg);
        }
        TmTmscene tmTmscene = this.makeTmscene(tmTmsceneDomain, null);
        this.setTmsceneDefault(tmTmscene);
        return tmTmscene;
    }

    private String checkTmsceneApi(TmTmsceneApiDomain tmTmsceneApiDomain) {
        if (null == tmTmsceneApiDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)tmTmsceneApiDomain.getSceneCode())) {
            msg = msg + "SceneCode\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)tmTmsceneApiDomain.getSceneApiCode())) {
            msg = msg + "SceneApiCode\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)tmTmsceneApiDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setTmsceneApiDefault(TmTmsceneApi tmTmsceneApi) {
        if (null == tmTmsceneApi) {
            return;
        }
        if (null == tmTmsceneApi.getDataState()) {
            tmTmsceneApi.setDataState(0);
        }
        if (null == tmTmsceneApi.getGmtCreate()) {
            tmTmsceneApi.setGmtCreate(this.getSysDate());
        }
        tmTmsceneApi.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)tmTmsceneApi.getTmsceneApiCode())) {
            tmTmsceneApi.setTmsceneApiCode(this.createUUIDString());
        }
    }

    private int getTmsceneApiMaxCode() {
        int code = 0;
        try {
            return this.tmTmsceneApiMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("tm.TmTmsceneServiceImpl.getTmsceneApiMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setTmsceneApiUpdataDefault(TmTmsceneApi tmTmsceneApi) {
        if (null == tmTmsceneApi) {
            return;
        }
        tmTmsceneApi.setTmsceneState(0);
        tmTmsceneApi.setGmtModified(this.getSysDate());
    }

    private void saveTmsceneApiModel(TmTmsceneApi tmTmsceneApi) throws ApiException {
        if (null == tmTmsceneApi) {
            return;
        }
        try {
            this.tmTmsceneApiMapper.insert(tmTmsceneApi);
        }
        catch (Exception e) {
            throw new ApiException("tm.TmTmsceneServiceImpl.saveTmsceneApiModel.ex", (Throwable)e);
        }
    }

    private void saveTmsceneApiBatchModel(List<TmTmsceneApi> tmTmsceneApiList) throws ApiException {
        if (null == tmTmsceneApiList || tmTmsceneApiList.isEmpty()) {
            return;
        }
        try {
            this.tmTmsceneApiMapper.insertBatch(tmTmsceneApiList);
        }
        catch (Exception e) {
            throw new ApiException("tm.TmTmsceneServiceImpl.saveTmsceneApiBatchModel.ex", (Throwable)e);
        }
    }

    private TmTmsceneApi getTmsceneApiModelById(Integer tmsceneApiId) {
        if (null == tmsceneApiId) {
            return null;
        }
        try {
            return this.tmTmsceneApiMapper.selectByPrimaryKey(tmsceneApiId);
        }
        catch (Exception e) {
            this.logger.error("tm.TmTmsceneServiceImpl.getTmsceneApiModelById", (Throwable)e);
            return null;
        }
    }

    private TmTmsceneApi getTmsceneApiModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.tmTmsceneApiMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("tm.TmTmsceneServiceImpl.getTmsceneApiModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delTmsceneApiModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.tmTmsceneApiMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("tm.TmTmsceneServiceImpl.delTmsceneApiModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("tm.TmTmsceneServiceImpl.delTmsceneApiModelByCode.num");
        }
    }

    private void deleteTmsceneApiModel(Integer tmsceneApiId) throws ApiException {
        if (null == tmsceneApiId) {
            return;
        }
        int i = 0;
        try {
            i = this.tmTmsceneApiMapper.deleteByPrimaryKey(tmsceneApiId);
        }
        catch (Exception e) {
            throw new ApiException("tm.TmTmsceneServiceImpl.deleteTmsceneApiModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("tm.TmTmsceneServiceImpl.deleteTmsceneApiModel.num");
        }
    }

    private void updateTmsceneApiModel(TmTmsceneApi tmTmsceneApi) throws ApiException {
        if (null == tmTmsceneApi) {
            return;
        }
        int i = 0;
        try {
            i = this.tmTmsceneApiMapper.updateByPrimaryKeySelective(tmTmsceneApi);
        }
        catch (Exception e) {
            throw new ApiException("tm.TmTmsceneServiceImpl.updateTmsceneApiModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("tm.TmTmsceneServiceImpl.updateTmsceneApiModel.num");
        }
    }

    private void updateStateTmsceneApiModel(Integer tmsceneApiId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == tmsceneApiId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tmsceneApiId", tmsceneApiId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.tmTmsceneApiMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("tm.TmTmsceneServiceImpl.updateStateTmsceneApiModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("tm.TmTmsceneServiceImpl.updateStateTmsceneApiModel.null");
        }
    }

    private void updateStateTmsceneApiModelByCode(String tenantCode, String tmsceneApiCode, Integer dataState, Integer oldDataState) throws ApiException {
        if (StringUtils.isBlank((String)tmsceneApiCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("tmsceneApiCode", tmsceneApiCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.tmTmsceneApiMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("tm.TmTmsceneServiceImpl.updateStateTmsceneApiModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("tm.TmTmsceneServiceImpl.updateStateTmsceneApiModelByCode.null");
        }
    }

    private TmTmsceneApi makeTmsceneApi(TmTmsceneApiDomain tmTmsceneApiDomain, TmTmsceneApi tmTmsceneApi) {
        if (null == tmTmsceneApiDomain) {
            return null;
        }
        if (null == tmTmsceneApi) {
            tmTmsceneApi = new TmTmsceneApi();
        }
        try {
            BeanUtils.copyAllPropertys((Object)tmTmsceneApi, (Object)tmTmsceneApiDomain);
            return tmTmsceneApi;
        }
        catch (Exception e) {
            this.logger.error("tm.TmTmsceneServiceImpl.makeTmsceneApi", (Throwable)e);
            return null;
        }
    }

    private TmTmsceneApiReDomain makeTmTmsceneApiReDomain(TmTmsceneApi tmTmsceneApi) {
        if (null == tmTmsceneApi) {
            return null;
        }
        TmTmsceneApiReDomain tmTmsceneApiReDomain = new TmTmsceneApiReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)tmTmsceneApiReDomain, (Object)tmTmsceneApi);
            return tmTmsceneApiReDomain;
        }
        catch (Exception e) {
            this.logger.error("tm.TmTmsceneServiceImpl.makeTmTmsceneApiReDomain", (Throwable)e);
            return null;
        }
    }

    private List<TmTmsceneApi> queryTmsceneApiModelPage(Map<String, Object> parammap) {
        try {
            return this.tmTmsceneApiMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("tm.TmTmsceneServiceImpl.queryTmsceneApiModel", (Throwable)e);
            return null;
        }
    }

    private int countTmsceneApi(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.tmTmsceneApiMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("tm.TmTmsceneServiceImpl.countTmsceneApi", (Throwable)e);
        }
        return i;
    }

    private TmTmsceneApi createTmTmsceneApi(TmTmsceneApiDomain tmTmsceneApiDomain) {
        String msg = this.checkTmsceneApi(tmTmsceneApiDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("tm.TmTmsceneServiceImpl.saveTmsceneApi.checkTmsceneApi", msg);
        }
        TmTmsceneApi tmTmsceneApi = this.makeTmsceneApi(tmTmsceneApiDomain, null);
        this.setTmsceneApiDefault(tmTmsceneApi);
        return tmTmsceneApi;
    }

    @Override
    public String saveTmscene(TmTmsceneDomain tmTmsceneDomain) throws ApiException {
        TmTmscene tmTmscene = this.createTmTmscene(tmTmsceneDomain);
        this.saveTmsceneModel(tmTmscene);
        return tmTmscene.getTmsceneCode();
    }

    @Override
    public String saveTmsceneBatch(List<TmTmsceneDomain> tmTmsceneDomainList) throws ApiException {
        if (null == tmTmsceneDomainList || tmTmsceneDomainList.isEmpty()) {
            return null;
        }
        ArrayList<TmTmscene> tmTmsceneList = new ArrayList<TmTmscene>();
        String code = "";
        for (TmTmsceneDomain tmTmsceneDomain : tmTmsceneDomainList) {
            TmTmscene tmTmscene = this.createTmTmscene(tmTmsceneDomain);
            code = tmTmscene.getTmsceneCode();
            tmTmsceneList.add(tmTmscene);
        }
        this.saveTmsceneBatchModel(tmTmsceneList);
        return code;
    }

    @Override
    public void updateTmsceneState(Integer tmsceneId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateTmsceneModel(tmsceneId, dataState, oldDataState);
        if (2 != dataState) {
            return;
        }
        TmTmscene tmTmscene = this.getTmscene(tmsceneId);
        if (null == tmTmscene) {
            return;
        }
        this.updateTmsceneApiEx(tmTmscene);
    }

    @Override
    public void updateTmsceneStateByCode(String tenantCode, String tmsceneCode, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateTmsceneModelByCode(tenantCode, tmsceneCode, dataState, oldDataState);
        if (2 != dataState) {
            return;
        }
        TmTmscene tmTmscene = this.getTmsceneByCode(tenantCode, tmsceneCode);
        if (null == tmTmscene) {
            return;
        }
        this.updateTmsceneApiEx(tmTmscene);
    }

    @Override
    public void updateTmscene(TmTmsceneDomain tmTmsceneDomain) throws ApiException {
        String msg = this.checkTmscene(tmTmsceneDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("tm.TmTmsceneServiceImpl.updateTmscene.checkTmscene", msg);
        }
        TmTmscene oldTmTmscene = this.getTmsceneModelById(tmTmsceneDomain.getTmsceneId());
        if (null == oldTmTmscene) {
            throw new ApiException("tm.TmTmsceneServiceImpl.updateTmscene.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        TmTmscene tmTmscene = this.makeTmscene(tmTmsceneDomain, oldTmTmscene);
        this.setTmsceneUpdataDefault(tmTmscene);
        this.updateTmsceneModel(tmTmscene);
    }

    @Override
    public TmTmscene getTmscene(Integer tmsceneId) {
        return this.getTmsceneModelById(tmsceneId);
    }

    @Override
    public void deleteTmscene(Integer tmsceneId) throws ApiException {
        this.deleteTmsceneModel(tmsceneId);
    }

    @Override
    public QueryResult<TmTmscene> queryTmscenePage(Map<String, Object> map) {
        List<TmTmscene> tmTmsceneList = this.queryTmsceneModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countTmscene(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(tmTmsceneList);
        return queryResult;
    }

    @Override
    public TmTmscene getTmsceneByCode(String tenantCode, String tmsceneCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("tmsceneCode", tmsceneCode);
        return this.getTmsceneModelByCode(map);
    }

    @Override
    public void deleteTmsceneByCode(String tenantCode, String tmsceneCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("tmsceneCode", tmsceneCode);
        this.delTmsceneModelByCode(map);
    }

    @Override
    public String saveTmsceneApi(TmTmsceneApiDomain tmTmsceneApiDomain) throws ApiException {
        TmTmsceneApi tmTmsceneApi = this.createTmTmsceneApi(tmTmsceneApiDomain);
        this.saveTmsceneApiModel(tmTmsceneApi);
        return tmTmsceneApi.getTmsceneApiCode();
    }

    @Override
    public String saveTmsceneApiBatch(List<TmTmsceneApiDomain> tmTmsceneApiDomainList) throws ApiException {
        if (null == tmTmsceneApiDomainList || tmTmsceneApiDomainList.isEmpty()) {
            return null;
        }
        ArrayList<TmTmsceneApi> tmTmsceneApiList = new ArrayList<TmTmsceneApi>();
        String code = "";
        for (TmTmsceneApiDomain tmTmsceneApiDomain : tmTmsceneApiDomainList) {
            TmTmsceneApi tmTmsceneApi = this.createTmTmsceneApi(tmTmsceneApiDomain);
            code = tmTmsceneApi.getTmsceneApiCode();
            tmTmsceneApiList.add(tmTmsceneApi);
        }
        this.saveTmsceneApiBatchModel(tmTmsceneApiList);
        return code;
    }

    @Override
    public void updateTmsceneApiState(Integer tmsceneApiId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateTmsceneApiModel(tmsceneApiId, dataState, oldDataState);
    }

    @Override
    public void updateTmsceneApiStateByCode(String tenantCode, String tmsceneApiCode, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateTmsceneApiModelByCode(tenantCode, tmsceneApiCode, dataState, oldDataState);
    }

    private void updateTmsceneApiEx(TmTmscene tmTmscene) {
        if (null == tmTmscene) {
            return;
        }
        String tmsceneCode = tmTmscene.getTmsceneCode();
        String sceneCode = tmTmscene.getSceneCode();
        String tenantCode = tmTmscene.getTenantCode();
        HashMap<String, Object> parammap = new HashMap<String, Object>();
        parammap.put("tmsceneCode", tmsceneCode);
        parammap.put("sceneCode", sceneCode);
        parammap.put("tmsceneState", 0);
        parammap.put("orderStr", "sceneApiOrder asc");
        List<TmTmsceneApi> apilist = this.queryTmsceneApiModelPage(parammap);
        if (null == apilist || apilist.isEmpty()) {
            return;
        }
        Map<String, TmSceneApi> apiMap = this.getApiMap(sceneCode, tenantCode);
        if (null == apiMap || apiMap.isEmpty()) {
            return;
        }
        HashMap<String, Object> pmap = new HashMap<String, Object>();
        pmap.put("tmTmscene", tmTmscene);
        for (TmTmsceneApi tmTmsceneApi : apilist) {
            TmSceneApi tmSceneApi = apiMap.get(tmTmsceneApi.getSceneApiCode() + "-" + tmTmsceneApi.getTenantCode());
            if (null == tmSceneApi) continue;
            pmap.put("tmSceneApi", tmSceneApi);
            pmap.put("tmTmsceneApi", tmTmsceneApi);
            String json = this.call(tmSceneApi, pmap);
            tmTmsceneApi.setTmsceneResult(json);
            if (json.indexOf(tmSceneApi.getDataFlag()) >= 0) {
                tmTmsceneApi.setTmsceneState(0);
                pmap.put("json", JsonUtil.buildNormalBinder().getJsonToMap(json, String.class, Object.class));
                this.call2(tmSceneApi, pmap);
            } else {
                tmTmsceneApi.setTmsceneState(1);
            }
            this.updateTmsceneApiModel(tmTmsceneApi);
        }
    }

    private String call2(TmSceneApi tmSceneApi, Map<String, Object> pmap) {
        if (null == tmSceneApi || StringUtils.isBlank((String)tmSceneApi.getDataCallurl2())) {
            return null;
        }
        String paramStr = SoaUtil.makeParam((String)tmSceneApi.getDataParam2(), (String)tmSceneApi.getDataCom2(), pmap);
        Object obj = UddiUtil.invokeUrl((String)tmSceneApi.getDataCalltype2(), (String)tmSceneApi.getDataCallurl2(), (String)paramStr, null);
        OutMessage outMessage = null;
        String json = "";
        if (obj instanceof OutMessage) {
            outMessage = (OutMessage)obj;
            if (!outMessage.isError() && null != outMessage.getReObj()) {
                json = outMessage.getReObj().toString();
            }
        } else {
            json = (String)obj;
        }
        return json;
    }

    private String call(TmSceneApi tmSceneApi, Map<String, Object> pmap) {
        if (null == tmSceneApi) {
            return null;
        }
        String paramStr = SoaUtil.makeParam((String)tmSceneApi.getDataParam(), (String)tmSceneApi.getDataCom(), pmap);
        Object obj = UddiUtil.invokeUrl((String)tmSceneApi.getDataCalltype(), (String)tmSceneApi.getDataCallurl(), (String)paramStr, null);
        OutMessage outMessage = null;
        String json = "";
        if (obj instanceof OutMessage) {
            outMessage = (OutMessage)obj;
            if (!outMessage.isError() && null != outMessage.getReObj()) {
                json = outMessage.getReObj().toString();
            }
        } else {
            json = (String)obj;
        }
        return json;
    }

    private Map<String, TmSceneApi> getApiMap(String sceneCode, String tenantCode) {
        if (StringUtils.hasBlank((String[])new String[]{sceneCode, tenantCode})) {
            return null;
        }
        HashMap<String, Object> parammap = new HashMap<String, Object>();
        parammap.put("sceneCode", sceneCode);
        parammap.put("tenantCode", tenantCode);
        QueryResult<TmSceneApi> qlist = this.tmSceneService.querySceneApiPage(parammap);
        if (null == qlist || null == qlist.getRows() || qlist.getRows().isEmpty()) {
            return null;
        }
        HashMap<String, TmSceneApi> tmMap = new HashMap<String, TmSceneApi>();
        for (TmSceneApi tmSceneApi : qlist.getRows()) {
            tmMap.put(tmSceneApi.getSceneApiCode() + "-" + tmSceneApi.getTenantCode(), tmSceneApi);
        }
        return tmMap;
    }

    @Override
    public void updateTmsceneApi(TmTmsceneApiDomain tmTmsceneApiDomain) throws ApiException {
        String msg = this.checkTmsceneApi(tmTmsceneApiDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("tm.TmTmsceneServiceImpl.updateTmsceneApi.checkTmsceneApi", msg);
        }
        TmTmsceneApi oldTmTmsceneApi = this.getTmsceneApiModelById(tmTmsceneApiDomain.getTmsceneApiId());
        if (null == oldTmTmsceneApi) {
            throw new ApiException("tm.TmTmsceneServiceImpl.updateTmsceneApi.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        TmTmsceneApi tmTmsceneApi = this.makeTmsceneApi(tmTmsceneApiDomain, oldTmTmsceneApi);
        this.setTmsceneApiUpdataDefault(tmTmsceneApi);
        this.updateTmsceneApiModel(tmTmsceneApi);
    }

    @Override
    public TmTmsceneApi getTmsceneApi(Integer tmsceneApiId) {
        return this.getTmsceneApiModelById(tmsceneApiId);
    }

    @Override
    public void deleteTmsceneApi(Integer tmsceneApiId) throws ApiException {
        this.deleteTmsceneApiModel(tmsceneApiId);
    }

    @Override
    public QueryResult<TmTmsceneApi> queryTmsceneApiPage(Map<String, Object> map) {
        List<TmTmsceneApi> tmTmsceneApiList = this.queryTmsceneApiModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countTmsceneApi(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(tmTmsceneApiList);
        return queryResult;
    }

    @Override
    public TmTmsceneApi getTmsceneApiByCode(String tenantCode, String tmsceneApiCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("tmsceneApiCode", tmsceneApiCode);
        return this.getTmsceneApiModelByCode(map);
    }

    @Override
    public void deleteTmsceneApiByCode(String tenantCode, String tmsceneApiCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("tmsceneApiCode", tmsceneApiCode);
        this.delTmsceneApiModelByCode(map);
    }
}

