/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.tenantmanag.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tenantmanag.dao.TmProappConfigMapper;
import com.yqbsoft.laser.service.tenantmanag.dao.TmProappEnvMapper;
import com.yqbsoft.laser.service.tenantmanag.dao.TmProappMapper;
import com.yqbsoft.laser.service.tenantmanag.dao.TmProappMenuMapper;
import com.yqbsoft.laser.service.tenantmanag.domain.TmMenu;
import com.yqbsoft.laser.service.tenantmanag.domain.TmProappConfigDomain;
import com.yqbsoft.laser.service.tenantmanag.domain.TmProappDomain;
import com.yqbsoft.laser.service.tenantmanag.domain.TmProappEnvBean;
import com.yqbsoft.laser.service.tenantmanag.domain.TmProappEnvDomain;
import com.yqbsoft.laser.service.tenantmanag.domain.TmProappMenuBean;
import com.yqbsoft.laser.service.tenantmanag.domain.TmProappMenuDomain;
import com.yqbsoft.laser.service.tenantmanag.domain.TmProappMenupriBean;
import com.yqbsoft.laser.service.tenantmanag.domain.TmProappMenupriDomain;
import com.yqbsoft.laser.service.tenantmanag.model.TmProapp;
import com.yqbsoft.laser.service.tenantmanag.model.TmProappConfig;
import com.yqbsoft.laser.service.tenantmanag.model.TmProappEnv;
import com.yqbsoft.laser.service.tenantmanag.model.TmProappMenu;
import com.yqbsoft.laser.service.tenantmanag.model.TmProappMenupri;
import com.yqbsoft.laser.service.tenantmanag.service.TmProappMenupriService;
import com.yqbsoft.laser.service.tenantmanag.service.TmProappService;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class TmProappServiceImpl
extends BaseServiceImpl
implements TmProappService {
    private static final String SYS_CODE = "tm.TmProappServiceImpl";
    private TmProappMapper tmProappMapper;
    private TmProappConfigMapper tmProappConfigMapper;
    private TmProappEnvMapper tmProappEnvMapper;
    private TmProappMenuMapper tmProappMenuMapper;
    private TmProappMenupriService tmProappMenupriService;
    private String cachekey = "TmProappMenu-menucode";
    private String cacheAllkey = "TmProappMenu-all";
    private String cachekeydomain = "TmProappEnv-domain-code";
    private String cachekeytenant = "TmProappEnv-tenant-code";
    private String cachekeycomdomain = "TmProoapp-domain";
    private String cacheenvcode = "TmProappEnv-tenant-ProappCode";
    private String cacheOauthEnvCode = "TmProapp-ProappCode";
    private String cacheConfig = "TmProappConfig-type";
    private String cachekeyrouteClidmenu = "UpMenu-router-menuCode";
    private String cachekeyOne = "TmProappMenuListOne-";
    private String cachekeyChild = "TmProappMenuListChild-";

    public void setTmProappMenupriService(TmProappMenupriService tmProappMenupriService) {
        this.tmProappMenupriService = tmProappMenupriService;
    }

    public void setTmProappMapper(TmProappMapper tmProappMapper) {
        this.tmProappMapper = tmProappMapper;
    }

    public void setTmProappConfigMapper(TmProappConfigMapper tmProappConfigMapper) {
        this.tmProappConfigMapper = tmProappConfigMapper;
    }

    public void setTmProappEnvMapper(TmProappEnvMapper tmProappEnvMapper) {
        this.tmProappEnvMapper = tmProappEnvMapper;
    }

    public void setTmProappMenuMapper(TmProappMenuMapper tmProappMenuMapper) {
        this.tmProappMenuMapper = tmProappMenuMapper;
    }

    private Date getSysDate() {
        try {
            return this.tmProappMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("tm.TmProappServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkProapp(TmProappDomain tmProappDomain) {
        if (null == tmProappDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)tmProappDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)tmProappDomain.getProappName())) {
            msg = msg + "ProappName\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)tmProappDomain.getOauthEnvCode())) {
            msg = msg + "OauthEnvCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setProappDefault(TmProapp tmProapp) {
        if (null == tmProapp) {
            return;
        }
        if (null == tmProapp.getDataState()) {
            tmProapp.setDataState(0);
        }
        if (null == tmProapp.getGmtCreate()) {
            tmProapp.setGmtCreate(this.getSysDate());
        }
        tmProapp.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)tmProapp.getProappCode())) {
            tmProapp.setProappCode(this.createUUIDString());
        }
    }

    private int getProappMaxCode() {
        int code = 0;
        try {
            return this.tmProappMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("tm.TmProappServiceImpl.getProappMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setProappUpdataDefault(TmProapp tmProapp) {
        if (null == tmProapp) {
            return;
        }
        tmProapp.setGmtModified(this.getSysDate());
    }

    private void saveProappModel(TmProapp tmProapp) throws ApiException {
        if (null == tmProapp) {
            return;
        }
        try {
            this.tmProappMapper.insert(tmProapp);
        }
        catch (Exception e) {
            throw new ApiException("tm.TmProappServiceImpl.saveProappModel.ex", (Throwable)e);
        }
    }

    private TmProapp getProappModelById(Integer proappId) {
        if (null == proappId) {
            return null;
        }
        try {
            return this.tmProappMapper.selectByPrimaryKey(proappId);
        }
        catch (Exception e) {
            this.logger.error("tm.TmProappServiceImpl.getProappModelById", (Throwable)e);
            return null;
        }
    }

    public TmProapp getProappModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.tmProappMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("tm.TmProappServiceImpl.getProappModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delProappModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.tmProappMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("tm.TmProappServiceImpl.delProappModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("tm.TmProappServiceImpl.delProappModelByCode.num");
        }
    }

    private void deleteProappModel(Integer proappId) throws ApiException {
        if (null == proappId) {
            return;
        }
        int i = 0;
        try {
            i = this.tmProappMapper.deleteByPrimaryKey(proappId);
        }
        catch (Exception e) {
            throw new ApiException("tm.TmProappServiceImpl.deleteProappModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("tm.TmProappServiceImpl.deleteProappModel.num");
        }
    }

    private void updateProappModel(TmProapp tmProapp) throws ApiException {
        if (null == tmProapp) {
            return;
        }
        try {
            this.tmProappMapper.updateByPrimaryKeySelective(tmProapp);
        }
        catch (Exception e) {
            throw new ApiException("tm.TmProappServiceImpl.updateProappModel.ex", (Throwable)e);
        }
    }

    private void updateStateProappModel(Integer proappId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == proappId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("proappId", proappId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.tmProappMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("tm.TmProappServiceImpl.updateStateProappModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("tm.TmProappServiceImpl.updateStateProappModel.null");
        }
    }

    private TmProapp makeProapp(TmProappDomain tmProappDomain, TmProapp tmProapp) {
        if (null == tmProappDomain) {
            return null;
        }
        if (null == tmProapp) {
            tmProapp = new TmProapp();
        }
        try {
            BeanUtils.copyAllPropertys((Object)tmProapp, (Object)tmProappDomain);
            return tmProapp;
        }
        catch (Exception e) {
            this.logger.error("tm.TmProappServiceImpl.makeProapp", (Throwable)e);
            return null;
        }
    }

    private List<TmProapp> queryProappModelPage(Map<String, Object> parammap) {
        try {
            return this.tmProappMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("tm.TmProappServiceImpl.queryProappModel", (Throwable)e);
            return null;
        }
    }

    private int countProapp(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.tmProappMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("tm.TmProappServiceImpl.countProapp", (Throwable)e);
        }
        return i;
    }

    private String checkProappConfig(TmProappConfigDomain tmProappConfigDomain) {
        if (null == tmProappConfigDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)tmProappConfigDomain.getProappCode())) {
            msg = msg + "ProappCode\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)tmProappConfigDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setProappConfigDefault(TmProappConfig tmProappConfig) {
        if (null == tmProappConfig) {
            return;
        }
        if (null == tmProappConfig.getDataState()) {
            tmProappConfig.setDataState(0);
        }
        if (null == tmProappConfig.getGmtCreate()) {
            tmProappConfig.setGmtCreate(this.getSysDate());
        }
        tmProappConfig.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)tmProappConfig.getProappConfigCode())) {
            tmProappConfig.setProappConfigCode(this.createUUIDString());
        }
    }

    private int getProappConfigMaxCode() {
        int code = 0;
        try {
            return this.tmProappConfigMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("tm.TmProappServiceImpl.getProappConfigMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setProappConfigUpdataDefault(TmProappConfig tmProappConfig) {
        if (null == tmProappConfig) {
            return;
        }
        tmProappConfig.setGmtModified(this.getSysDate());
    }

    private void saveProappConfigModel(TmProappConfig tmProappConfig) throws ApiException {
        if (null == tmProappConfig) {
            return;
        }
        try {
            this.tmProappConfigMapper.insert(tmProappConfig);
        }
        catch (Exception e) {
            throw new ApiException("tm.TmProappServiceImpl.saveProappConfigModel.ex", (Throwable)e);
        }
    }

    private TmProappConfig getProappConfigModelById(Integer proappConfigId) {
        if (null == proappConfigId) {
            return null;
        }
        try {
            return this.tmProappConfigMapper.selectByPrimaryKey(proappConfigId);
        }
        catch (Exception e) {
            this.logger.error("tm.TmProappServiceImpl.getProappConfigModelById", (Throwable)e);
            return null;
        }
    }

    public TmProappConfig getProappConfigModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.tmProappConfigMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("tm.TmProappServiceImpl.getProappConfigModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delProappConfigModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.tmProappConfigMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("tm.TmProappServiceImpl.delProappConfigModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("tm.TmProappServiceImpl.delProappConfigModelByCode.num");
        }
    }

    private void deleteProappConfigModel(Integer proappConfigId) throws ApiException {
        if (null == proappConfigId) {
            return;
        }
        int i = 0;
        try {
            i = this.tmProappConfigMapper.deleteByPrimaryKey(proappConfigId);
        }
        catch (Exception e) {
            throw new ApiException("tm.TmProappServiceImpl.deleteProappConfigModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("tm.TmProappServiceImpl.deleteProappConfigModel.num");
        }
    }

    private void updateProappConfigModel(TmProappConfig tmProappConfig) throws ApiException {
        if (null == tmProappConfig) {
            return;
        }
        try {
            this.tmProappConfigMapper.updateByPrimaryKeySelective(tmProappConfig);
        }
        catch (Exception e) {
            throw new ApiException("tm.TmProappServiceImpl.updateProappConfigModel.ex", (Throwable)e);
        }
    }

    private void updateStateProappConfigModel(Integer proappConfigId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == proappConfigId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("proappConfigId", proappConfigId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.tmProappConfigMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("tm.TmProappServiceImpl.updateStateProappConfigModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("tm.TmProappServiceImpl.updateStateProappConfigModel.null");
        }
    }

    private TmProappConfig makeProappConfig(TmProappConfigDomain tmProappConfigDomain, TmProappConfig tmProappConfig) {
        if (null == tmProappConfigDomain) {
            return null;
        }
        if (null == tmProappConfig) {
            tmProappConfig = new TmProappConfig();
        }
        try {
            BeanUtils.copyAllPropertys((Object)tmProappConfig, (Object)tmProappConfigDomain);
            return tmProappConfig;
        }
        catch (Exception e) {
            this.logger.error("tm.TmProappServiceImpl.makeProappConfig", (Throwable)e);
            return null;
        }
    }

    private List<TmProappConfig> queryProappConfigModelPage(Map<String, Object> parammap) {
        try {
            return this.tmProappConfigMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("tm.TmProappServiceImpl.queryProappConfigModel", (Throwable)e);
            return null;
        }
    }

    private int countProappConfig(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.tmProappConfigMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("tm.TmProappServiceImpl.countProappConfig", (Throwable)e);
        }
        return i;
    }

    private String checkProappEnv(TmProappEnvDomain tmProappEnvDomain) {
        if (null == tmProappEnvDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)tmProappEnvDomain.getProappCode())) {
            msg = msg + "ProappCode\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)tmProappEnvDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setProappEnvDefault(TmProappEnv tmProappEnv) {
        if (null == tmProappEnv) {
            return;
        }
        if (null == tmProappEnv.getDataState()) {
            tmProappEnv.setDataState(4);
        }
        if (null == tmProappEnv.getGmtCreate()) {
            tmProappEnv.setGmtCreate(this.getSysDate());
        }
        tmProappEnv.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)tmProappEnv.getProappEnvCode())) {
            tmProappEnv.setProappEnvCode(this.createUUIDString());
        }
    }

    private int getProappEnvMaxCode() {
        int code = 0;
        try {
            return this.tmProappEnvMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("tm.TmProappServiceImpl.getProappEnvMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setProappEnvUpdataDefault(TmProappEnv tmProappEnv) {
        if (null == tmProappEnv) {
            return;
        }
        tmProappEnv.setGmtModified(this.getSysDate());
    }

    private void saveProappEnvModel(TmProappEnv tmProappEnv) throws ApiException {
        if (null == tmProappEnv) {
            return;
        }
        try {
            this.tmProappEnvMapper.insert(tmProappEnv);
        }
        catch (Exception e) {
            throw new ApiException("tm.TmProappServiceImpl.saveProappEnvModel.ex", (Throwable)e);
        }
    }

    private TmProappEnv getProappEnvModelById(Integer proappEnvId) {
        if (null == proappEnvId) {
            return null;
        }
        try {
            return this.tmProappEnvMapper.selectByPrimaryKey(proappEnvId);
        }
        catch (Exception e) {
            this.logger.error("tm.TmProappServiceImpl.getProappEnvModelById", (Throwable)e);
            return null;
        }
    }

    public TmProappEnv getProappEnvModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.tmProappEnvMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("tm.TmProappServiceImpl.getProappEnvModelByCode", (Throwable)e);
            return null;
        }
    }

    public TmProappEnv getProappEnvModelByEnvCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.tmProappEnvMapper.getByEnvCode(map);
        }
        catch (Exception e) {
            this.logger.error("tm.TmProappServiceImpl.getProappEnvModelByEnvCode", (Throwable)e);
            return null;
        }
    }

    public void delProappEnvModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.tmProappEnvMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("tm.TmProappServiceImpl.delProappEnvModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("tm.TmProappServiceImpl.delProappEnvModelByCode.num");
        }
    }

    private void deleteProappEnvModel(Integer proappEnvId) throws ApiException {
        if (null == proappEnvId) {
            return;
        }
        int i = 0;
        try {
            i = this.tmProappEnvMapper.deleteByPrimaryKey(proappEnvId);
        }
        catch (Exception e) {
            throw new ApiException("tm.TmProappServiceImpl.deleteProappEnvModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("tm.TmProappServiceImpl.deleteProappEnvModel.num");
        }
    }

    private void updateProappEnvModel(TmProappEnv tmProappEnv) throws ApiException {
        if (null == tmProappEnv) {
            return;
        }
        try {
            this.tmProappEnvMapper.updateByPrimaryKeySelective(tmProappEnv);
        }
        catch (Exception e) {
            throw new ApiException("tm.TmProappServiceImpl.updateProappEnvModel.ex", (Throwable)e);
        }
    }

    private void updateStateProappEnvModel(Integer proappEnvId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == proappEnvId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("proappEnvId", proappEnvId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.tmProappEnvMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("tm.TmProappServiceImpl.updateStateProappEnvModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("tm.TmProappServiceImpl.updateStateProappEnvModel.null");
        }
    }

    private TmProappEnv makeProappEnv(TmProappEnvDomain tmProappEnvDomain, TmProappEnv tmProappEnv) {
        if (null == tmProappEnvDomain) {
            return null;
        }
        if (null == tmProappEnv) {
            tmProappEnv = new TmProappEnv();
        }
        try {
            BeanUtils.copyAllPropertys((Object)tmProappEnv, (Object)tmProappEnvDomain);
            return tmProappEnv;
        }
        catch (Exception e) {
            this.logger.error("tm.TmProappServiceImpl.makeProappEnv", (Throwable)e);
            return null;
        }
    }

    private TmProappEnvDomain makeProappEnvDomain(TmProappEnvBean tmProappEnvBean, TmProappEnv tmProappEnv) {
        if (null == tmProappEnvBean || null == tmProappEnv) {
            return null;
        }
        TmProappEnvDomain tmProappEnvDomain = new TmProappEnvDomain();
        try {
            BeanUtils.copyAllPropertys((Object)tmProappEnvDomain, (Object)tmProappEnv);
            BeanUtils.copyAllPropertys((Object)tmProappEnvDomain, (Object)tmProappEnvBean);
            return tmProappEnvDomain;
        }
        catch (Exception e) {
            this.logger.error("tm.TmProappServiceImpl.makeProappEnvDomain", (Throwable)e);
            return null;
        }
    }

    private List<TmProappEnv> queryProappEnvModelPage(Map<String, Object> parammap) {
        try {
            return this.tmProappEnvMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("tm.TmProappServiceImpl.queryProappEnvModel", (Throwable)e);
            return null;
        }
    }

    private int countProappEnv(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.tmProappEnvMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("tm.TmProappServiceImpl.countProappEnv", (Throwable)e);
        }
        return i;
    }

    private String checkProappMenu(TmProappMenuDomain tmProappMenuDomain) {
        if (null == tmProappMenuDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)tmProappMenuDomain.getProappCode())) {
            msg = msg + "ProappCode\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)tmProappMenuDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setProappMenuDefault(TmProappMenu tmProappMenu) {
        if (null == tmProappMenu) {
            return;
        }
        if (null == tmProappMenu.getDataState()) {
            tmProappMenu.setDataState(0);
        }
        if (null == tmProappMenu.getGmtCreate()) {
            tmProappMenu.setGmtCreate(this.getSysDate());
        }
        tmProappMenu.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)tmProappMenu.getProappMenuCode())) {
            tmProappMenu.setProappMenuCode(this.createUUIDString());
        }
    }

    private int getProappMenuMaxCode() {
        int code = 0;
        try {
            return this.tmProappMenuMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("tm.TmProappServiceImpl.getProappMenuMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setProappMenuUpdataDefault(TmProappMenu tmProappMenu) {
        if (null == tmProappMenu) {
            return;
        }
        tmProappMenu.setGmtModified(this.getSysDate());
    }

    private void saveProappMenuModel(TmProappMenu tmProappMenu) throws ApiException {
        if (null == tmProappMenu) {
            return;
        }
        try {
            this.tmProappMenuMapper.insert(tmProappMenu);
        }
        catch (Exception e) {
            throw new ApiException("tm.TmProappServiceImpl.saveProappMenuModel.ex", (Throwable)e);
        }
    }

    private TmProappMenu getProappMenuModelById(Integer proappMenuId) {
        if (null == proappMenuId) {
            return null;
        }
        try {
            return this.tmProappMenuMapper.selectByPrimaryKey(proappMenuId);
        }
        catch (Exception e) {
            this.logger.error("tm.TmProappServiceImpl.getProappMenuModelById", (Throwable)e);
            return null;
        }
    }

    public TmProappMenu getProappMenuModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.tmProappMenuMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("tm.TmProappServiceImpl.getProappMenuModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delProappMenuModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.tmProappMenuMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("tm.TmProappServiceImpl.delProappMenuModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("tm.TmProappServiceImpl.delProappMenuModelByCode.num");
        }
    }

    private void deleteProappMenuModel(Integer proappMenuId) throws ApiException {
        if (null == proappMenuId) {
            return;
        }
        int i = 0;
        try {
            i = this.tmProappMenuMapper.deleteByPrimaryKey(proappMenuId);
        }
        catch (Exception e) {
            throw new ApiException("tm.TmProappServiceImpl.deleteProappMenuModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("tm.TmProappServiceImpl.deleteProappMenuModel.num");
        }
    }

    private void updateProappMenuModel(TmProappMenu tmProappMenu) throws ApiException {
        if (null == tmProappMenu) {
            return;
        }
        try {
            this.tmProappMenuMapper.updateByPrimaryKeySelective(tmProappMenu);
        }
        catch (Exception e) {
            throw new ApiException("tm.TmProappServiceImpl.updateProappMenuModel.ex", (Throwable)e);
        }
    }

    private void updateStateProappMenuModel(Integer proappMenuId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == proappMenuId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("proappMenuId", proappMenuId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.tmProappMenuMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("tm.TmProappServiceImpl.updateStateProappMenuModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("tm.TmProappServiceImpl.updateStateProappMenuModel.null");
        }
    }

    private TmProappMenu makeProappMenu(TmProappMenuDomain tmProappMenuDomain, TmProappMenu tmProappMenu) {
        if (null == tmProappMenuDomain) {
            return null;
        }
        if (null == tmProappMenu) {
            tmProappMenu = new TmProappMenu();
        }
        try {
            BeanUtils.copyAllPropertys((Object)tmProappMenu, (Object)tmProappMenuDomain);
            return tmProappMenu;
        }
        catch (Exception e) {
            this.logger.error("tm.TmProappServiceImpl.makeProappMenu", (Throwable)e);
            return null;
        }
    }

    private TmProappMenuDomain makeProappMenuDomain(TmProappMenu tmProappMenu) {
        if (null == tmProappMenu) {
            return null;
        }
        TmProappMenuDomain tmProappMenuDomain = new TmProappMenuDomain();
        try {
            BeanUtils.copyAllPropertys((Object)tmProappMenuDomain, (Object)tmProappMenu);
            return tmProappMenuDomain;
        }
        catch (Exception e) {
            this.logger.error("tm.TmProappServiceImpl.makeProappMenuDomain", (Throwable)e);
            return null;
        }
    }

    private List<TmProappMenu> queryProappMenuModelPage(Map<String, Object> parammap) {
        try {
            if (null == parammap) {
                parammap = new HashMap<String, Object>();
            }
            return this.tmProappMenuMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("tm.TmProappServiceImpl.queryProappMenuModel", (Throwable)e);
            return null;
        }
    }

    private int countProappMenu(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.tmProappMenuMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("tm.TmProappServiceImpl.countProappMenu", (Throwable)e);
        }
        return i;
    }

    @Override
    public String saveProapp(TmProappDomain tmProappDomain) throws ApiException {
        String msg = this.checkProapp(tmProappDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("tm.TmProappServiceImpl.saveProapp.checkProapp", msg);
        }
        TmProapp tmProapp = this.makeProapp(tmProappDomain, null);
        this.setProappDefault(tmProapp);
        this.saveProappModel(tmProapp);
        return tmProapp.getProappCode();
    }

    @Override
    public void updateProappState(Integer proappId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateProappModel(proappId, dataState, oldDataState);
    }

    @Override
    public void updateProapp(TmProappDomain tmProappDomain) throws ApiException {
        String msg = this.checkProapp(tmProappDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("tm.TmProappServiceImpl.updateProapp.checkProapp", msg);
        }
        TmProapp oldTmProapp = this.getProappModelById(tmProappDomain.getProappId());
        if (null == oldTmProapp) {
            throw new ApiException("tm.TmProappServiceImpl.updateProapp.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        TmProapp tmProapp = this.makeProapp(tmProappDomain, oldTmProapp);
        this.setProappUpdataDefault(tmProapp);
        this.updateProappModel(tmProapp);
    }

    @Override
    public TmProapp getProapp(Integer proappId) {
        return this.getProappModelById(proappId);
    }

    @Override
    public void deleteProapp(Integer proappId) throws ApiException {
        this.deleteProappModel(proappId);
    }

    @Override
    public QueryResult<TmProapp> queryProappPage(Map<String, Object> map) {
        List<TmProapp> tmProappList = this.queryProappModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countProapp(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(tmProappList);
        return queryResult;
    }

    @Override
    public TmProapp getProappByCode(Map<String, Object> map) {
        return this.getProappModelByCode(map);
    }

    @Override
    public void delProappByCode(Map<String, Object> map) throws ApiException {
        this.delProappModelByCode(map);
    }

    @Override
    public String saveProappConfig(TmProappConfigDomain tmProappConfigDomain) throws ApiException {
        String msg = this.checkProappConfig(tmProappConfigDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("tm.TmProappServiceImpl.saveProappConfig.checkProappConfig", msg);
        }
        TmProappConfig tmProappConfig = this.makeProappConfig(tmProappConfigDomain, null);
        this.setProappConfigDefault(tmProappConfig);
        this.saveProappConfigModel(tmProappConfig);
        return tmProappConfig.getProappConfigCode();
    }

    @Override
    public void updateProappConfigState(Integer proappConfigId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateProappConfigModel(proappConfigId, dataState, oldDataState);
    }

    @Override
    public void updateProappConfig(TmProappConfigDomain tmProappConfigDomain) throws ApiException {
        String msg = this.checkProappConfig(tmProappConfigDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("tm.TmProappServiceImpl.updateProappConfig.checkProappConfig", msg);
        }
        TmProappConfig oldTmProappConfig = this.getProappConfigModelById(tmProappConfigDomain.getProappConfigId());
        if (null == oldTmProappConfig) {
            throw new ApiException("tm.TmProappServiceImpl.updateProappConfig.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        TmProappConfig tmProappConfig = this.makeProappConfig(tmProappConfigDomain, oldTmProappConfig);
        this.setProappConfigUpdataDefault(tmProappConfig);
        this.updateProappConfigModel(tmProappConfig);
    }

    @Override
    public TmProappConfig getProappConfig(Integer proappConfigId) {
        return this.getProappConfigModelById(proappConfigId);
    }

    @Override
    public void deleteProappConfig(Integer proappConfigId) throws ApiException {
        this.deleteProappConfigModel(proappConfigId);
    }

    @Override
    public QueryResult<TmProappConfig> queryProappConfigPage(Map<String, Object> map) {
        List<TmProappConfig> tmProappConfigList = this.queryProappConfigModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countProappConfig(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(tmProappConfigList);
        return queryResult;
    }

    @Override
    public TmProappConfig getProappConfigByCode(Map<String, Object> map) {
        return this.getProappConfigModelByCode(map);
    }

    @Override
    public void delProappConfigByCode(Map<String, Object> map) throws ApiException {
        this.delProappConfigModelByCode(map);
    }

    @Override
    public String saveProappEnv(TmProappEnvDomain tmProappEnvDomain) throws ApiException {
        String msg = this.checkProappEnv(tmProappEnvDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("tm.TmProappServiceImpl.saveProappEnv.checkProappEnv", msg);
        }
        TmProappEnv tmProappEnv = this.makeProappEnv(tmProappEnvDomain, null);
        this.setProappEnvDefault(tmProappEnv);
        this.saveProappEnvModel(tmProappEnv);
        return tmProappEnv.getProappEnvCode();
    }

    @Override
    public void updateProappEnvState(Integer proappEnvId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateProappEnvModel(proappEnvId, dataState, oldDataState);
    }

    @Override
    public void updateProappEnv(TmProappEnvDomain tmProappEnvDomain) throws ApiException {
        String msg = this.checkProappEnv(tmProappEnvDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("tm.TmProappServiceImpl.updateProappEnv.checkProappEnv", msg);
        }
        TmProappEnv oldTmProappEnv = this.getProappEnvModelById(tmProappEnvDomain.getProappEnvId());
        if (null == oldTmProappEnv) {
            throw new ApiException("tm.TmProappServiceImpl.updateProappEnv.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        TmProappEnv tmProappEnv = this.makeProappEnv(tmProappEnvDomain, oldTmProappEnv);
        this.setProappEnvUpdataDefault(tmProappEnv);
        this.updateProappEnvModel(tmProappEnv);
    }

    @Override
    public TmProappEnv getProappEnv(Integer proappEnvId) {
        TmProappEnv tmProappEnv = this.getProappEnvModelById(proappEnvId);
        this.releapUrl(tmProappEnv);
        return tmProappEnv;
    }

    @Override
    public void deleteProappEnv(Integer proappEnvId) throws ApiException {
        this.deleteProappEnvModel(proappEnvId);
    }

    @Override
    public QueryResult<TmProappEnv> queryProappEnvPage(Map<String, Object> map) {
        List<TmProappEnv> tmProappEnvList = this.queryProappEnvModelPage(map);
        if (ListUtil.isNotEmpty(tmProappEnvList) && null == map.get("rel")) {
            for (TmProappEnv tmProappEnv : tmProappEnvList) {
                this.releapUrl(tmProappEnv);
            }
        }
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countProappEnv(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(tmProappEnvList);
        return queryResult;
    }

    private void releapUrl(TmProappEnv tmProappEnv) {
        String domain;
        if (null == tmProappEnv) {
            return;
        }
        if (StringUtils.isBlank((String)tmProappEnv.getProappEnvIndexr())) {
            return;
        }
        String oauthEnvCode = DisUtil.getMap((String)this.cacheOauthEnvCode, (String)(tmProappEnv.getProappCode() + "-" + "00000000"));
        tmProappEnv.setProappEnvIndexr(tmProappEnv.getProappEnvIndexr().replace("${tenantCode}", tmProappEnv.getTenantCode()));
        tmProappEnv.setProappEnvIndexr(tmProappEnv.getProappEnvIndexr().replace("${proappCode}", tmProappEnv.getProappCode()));
        if (StringUtils.isNotBlank((String)oauthEnvCode)) {
            tmProappEnv.setProappEnvIndexr(tmProappEnv.getProappEnvIndexr().replace("${oauthEnvCode}", oauthEnvCode));
        } else {
            this.logger.error("tm.TmProappServiceImpl.releapUrl.oauthEnvCode", (Object)(tmProappEnv.getProappCode() + "-" + tmProappEnv.getTenantCode()));
        }
        if (StringUtils.isNotBlank((String)tmProappEnv.getProappEnvDomain()) && tmProappEnv.getProappEnvDomain().indexOf("{domain}") >= 0) {
            domain = DisUtil.getRemotMap((String)"tmtenant-code_dmain", (String)(tmProappEnv.getTenantCode() + "-domain"));
            if (null == domain) {
                domain = "";
            }
            tmProappEnv.setProappEnvDomain(tmProappEnv.getProappEnvDomain().replace("{domain}", domain));
        }
        if (StringUtils.isNotBlank((String)tmProappEnv.getProappEnvDomain1()) && tmProappEnv.getProappEnvDomain1().indexOf("{domain0}") >= 0) {
            domain = DisUtil.getRemotMap((String)"tmtenant-code_dmain", (String)(tmProappEnv.getTenantCode() + "-domain0"));
            if (null == domain) {
                domain = "";
            }
            tmProappEnv.setProappEnvDomain1(tmProappEnv.getProappEnvDomain1().replace("{domain0}", domain));
        }
        if (StringUtils.isNotBlank((String)tmProappEnv.getProappEnvDomain2()) && tmProappEnv.getProappEnvDomain2().indexOf("{domain1}") >= 0) {
            domain = DisUtil.getRemotMap((String)"tmtenant-code_dmain", (String)(tmProappEnv.getTenantCode() + "-domain1"));
            if (null == domain) {
                domain = "";
            }
            tmProappEnv.setProappEnvDomain2(tmProappEnv.getProappEnvDomain2().replace("{domain1}", domain));
        }
    }

    @Override
    public TmProappEnv getProappEnvByCode(Map<String, Object> map) {
        TmProappEnv tmProappEnv = this.getProappEnvModelByCode(map);
        this.releapUrl(tmProappEnv);
        return tmProappEnv;
    }

    @Override
    public void delProappEnvByCode(Map<String, Object> map) throws ApiException {
        this.delProappEnvModelByCode(map);
    }

    @Override
    public String saveProappMenu(TmProappMenuDomain tmProappMenuDomain) throws ApiException {
        String msg = this.checkProappMenu(tmProappMenuDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("tm.TmProappServiceImpl.saveProappMenu.checkProappMenu", msg);
        }
        TmProappMenu tmProappMenu = this.makeProappMenu(tmProappMenuDomain, null);
        this.setProappMenuDefault(tmProappMenu);
        this.saveProappMenuModel(tmProappMenu);
        this.updateReleaseHtml(tmProappMenu);
        this.saveProappMenupri(tmProappMenu, tmProappMenuDomain.getTmProappMenupriDomainList());
        return tmProappMenu.getProappMenuCode();
    }

    private void saveProappMenupri(TmProappMenu tmProappMenu, List<TmProappMenupriDomain> tmProappMenupriDomainList) {
        if (null == tmProappMenu || ListUtil.isEmpty(tmProappMenupriDomainList)) {
            return;
        }
        for (TmProappMenupriDomain tmProappMenupriDomain : tmProappMenupriDomainList) {
            tmProappMenupriDomain.setProappCode(tmProappMenu.getProappCode());
            tmProappMenupriDomain.setProappMenuCode(tmProappMenu.getProappMenuCode());
            tmProappMenupriDomain.setTenantCode(tmProappMenu.getTenantCode());
        }
        this.tmProappMenupriService.deleteProappMenupriByPriCode(tmProappMenu.getTenantCode(), tmProappMenu.getProappMenuCode());
        this.tmProappMenupriService.saveProappMenupriBatch(tmProappMenupriDomainList);
    }

    @Override
    public void updateProappMenuState(Integer proappMenuId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateProappMenuModel(proappMenuId, dataState, oldDataState);
    }

    @Override
    public void updateProappMenu(TmProappMenuDomain tmProappMenuDomain) throws ApiException {
        String msg = this.checkProappMenu(tmProappMenuDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("tm.TmProappServiceImpl.updateProappMenu.checkProappMenu", msg);
        }
        TmProappMenu oldTmProappMenu = this.getProappMenuModelById(tmProappMenuDomain.getProappMenuId());
        if (null == oldTmProappMenu) {
            throw new ApiException("tm.TmProappServiceImpl.updateProappMenu.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        TmProappMenu tmProappMenu = this.makeProappMenu(tmProappMenuDomain, oldTmProappMenu);
        this.setProappMenuUpdataDefault(tmProappMenu);
        this.updateProappMenuModel(tmProappMenu);
        this.saveProappMenupri(tmProappMenu, tmProappMenuDomain.getTmProappMenupriDomainList());
    }

    @Override
    public TmProappMenu getProappMenu(Integer proappMenuId) {
        return this.getProappMenuModelById(proappMenuId);
    }

    @Override
    public void deleteProappMenu(Integer proappMenuId) throws ApiException {
        this.deleteProappMenuModel(proappMenuId);
    }

    @Override
    public QueryResult<TmProappMenu> queryProappMenuPage(Map<String, Object> map) {
        List<TmProappMenu> tmProappMenuList = this.queryProappMenuModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countProappMenu(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(tmProappMenuList);
        return queryResult;
    }

    @Override
    public TmProappMenu getProappMenuByCode(Map<String, Object> map) {
        return this.getProappMenuModelByCode(map);
    }

    @Override
    public void delProappMenuByCode(Map<String, Object> map) throws ApiException {
        this.delProappMenuModelByCode(map);
    }

    @Override
    public List<TmProappMenu> queryMenuByProapp(String proappCode, String tenantCode) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("proappCode", proappCode);
        map.put("tenantCode", tenantCode);
        return this.queryProappMenuModelPage(map);
    }

    @Override
    public List<TmProappMenu> queryMenuHtmlByProapp(String proappCode, String tenantCode) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("proappCode", proappCode);
        map.put("tenantCode", tenantCode);
        map.put("proappMenuPcode", "-1");
        map.put("dataState", 1);
        map.put("order", true);
        map.put("orderStr", "PROAPP_MENU_ORDER asc");
        List<TmProappMenu> rootTmProappMenuList = this.queryProappMenuModelPage(map);
        if (ListUtil.isEmpty(rootTmProappMenuList)) {
            return null;
        }
        ArrayList<TmProappMenu> returnTmProappMenuList = new ArrayList<TmProappMenu>();
        for (TmProappMenu tmProappMenu : rootTmProappMenuList) {
            if (!StringUtils.isNotBlank((String)tmProappMenu.getMenuOpcode()) || !StringUtils.isNotBlank((String)tmProappMenu.getMenuIndexCode()) && !StringUtils.isNotBlank((String)tmProappMenu.getMenuDetailsCode())) continue;
            returnTmProappMenuList.add(tmProappMenu);
        }
        if (ListUtil.isEmpty(returnTmProappMenuList)) {
            return null;
        }
        ArrayList<TmProappMenu> tmProappMenuList = new ArrayList<TmProappMenu>();
        tmProappMenuList.addAll(returnTmProappMenuList);
        for (TmProappMenu tmProappMenu : returnTmProappMenuList) {
            List<TmProappMenu> childList = this.queryChild(tmProappMenu);
            if (!ListUtil.isNotEmpty(childList)) continue;
            tmProappMenuList.addAll(childList);
        }
        return tmProappMenuList;
    }

    private List<TmProappMenu> queryChild(TmProappMenu tmProappMenu) {
        if (null == tmProappMenu) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("proappCode", tmProappMenu.getProappCode());
        map.put("tenantCode", tmProappMenu.getTenantCode());
        map.put("proappMenuPcode", tmProappMenu.getProappMenuCode());
        map.put("dataState", 1);
        map.put("order", true);
        map.put("orderStr", "PROAPP_MENU_ORDER asc");
        List<TmProappMenu> rootTmProappMenuList = this.queryProappMenuModelPage(map);
        if (ListUtil.isEmpty(rootTmProappMenuList)) {
            return null;
        }
        ArrayList<TmProappMenu> reTmProappMenuList = new ArrayList<TmProappMenu>();
        for (TmProappMenu tmProappMenu2 : rootTmProappMenuList) {
            if (!StringUtils.isNotBlank((String)tmProappMenu2.getMenuOpcode()) || !StringUtils.isNotBlank((String)tmProappMenu2.getMenuIndexCode()) && !StringUtils.isNotBlank((String)tmProappMenu2.getMenuDetailsCode())) continue;
            reTmProappMenuList.add(tmProappMenu2);
            List<TmProappMenu> childList = this.queryChild(tmProappMenu2);
            if (!ListUtil.isNotEmpty(childList)) continue;
            reTmProappMenuList.addAll(childList);
        }
        return reTmProappMenuList;
    }

    @Override
    public TmProappEnv getProappByMenuCode(String menuCode, String tenantCode) {
        if (StringUtils.isBlank((String)menuCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("menuCode", menuCode);
        map.put("tenantCode", tenantCode);
        List<TmProappMenu> list = this.queryProappMenuModelPage(map);
        if (null == list || list.isEmpty()) {
            return null;
        }
        map.put("proappCode", list.get(0).getProappCode());
        List<TmProappEnv> envList = this.queryProappEnvModelPage(map);
        if (null == envList || envList.isEmpty()) {
            return null;
        }
        return envList.get(0);
    }

    @Override
    public void queryProappMenuLoadCache() {
        this.logger.info("TmProappService.queryProappMenuLoadCache", (Object)"===========start==========");
        ConcurrentHashMap<String, Object> param = new ConcurrentHashMap<String, Object>();
        param.put("order", "true");
        param.put("orderStr", " PROAPP_MENU_ORDER asc ");
        List<TmProappMenu> list = this.queryProappMenuModelPage(param);
        if (null == list || list.isEmpty()) {
            DisUtil.delVer((String)this.cachekey);
            DisUtil.delVer((String)this.cacheAllkey);
            this.logger.info("TmProappService.queryProappMenuLoadCache", (Object)"===========del-end==========");
            return;
        }
        ConcurrentHashMap<String, String> menuMap = new ConcurrentHashMap<String, String>();
        ConcurrentHashMap<String, String> menuallMap = new ConcurrentHashMap<String, String>();
        for (TmProappMenu tmProappMenu : list) {
            menuallMap.put(tmProappMenu.getProappMenuCode() + "-" + tmProappMenu.getTenantCode(), JsonUtil.buildNormalBinder().toJson((Object)tmProappMenu));
            if (!StringUtils.isNotBlank((String)tmProappMenu.getMenuCode())) continue;
            menuMap.put(tmProappMenu.getProappCode() + "-" + tmProappMenu.getMenuCode() + "-" + tmProappMenu.getTenantCode(), tmProappMenu.getMenuCode());
        }
        DisUtil.setMapVer((String)this.cacheAllkey, menuallMap);
        DisUtil.setMapVer((String)this.cachekey, menuMap);
        this.logger.info("TmProappService.queryProappMenuLoadCache", (Object)"===========add-end==========");
    }

    @Override
    public void queryProappEnvTenantLoadCache(String tenantCode) {
        ConcurrentHashMap<String, String> envcodeMap;
        ConcurrentHashMap<String, String> envtenantMap;
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        List<TmProappEnv> proappEnvList = this.queryProappEnvModelPage(map);
        if (ListUtil.isEmpty(proappEnvList)) {
            return;
        }
        List<TmProapp> proappList = this.queryProappModelPage(new HashMap<String, Object>());
        if (ListUtil.isEmpty(proappList)) {
            return;
        }
        Map<String, String> proappMap = this.makeProappToEnv(proappList);
        ConcurrentHashMap<String, String> envdomainMap = DisUtil.getMapAll((String)this.cachekeydomain);
        if (null == envdomainMap) {
            envdomainMap = new ConcurrentHashMap<String, String>();
        }
        if (null == (envtenantMap = DisUtil.getMapAll((String)this.cachekeytenant))) {
            envtenantMap = new ConcurrentHashMap<String, String>();
        }
        if (null == (envcodeMap = DisUtil.getMapAll((String)this.cacheenvcode))) {
            envcodeMap = new ConcurrentHashMap<String, String>();
        }
        for (TmProappEnv tmProappEnv : proappEnvList) {
            try {
                String domain;
                String env = proappMap.get(tmProappEnv.getProappCode());
                this.make(tmProappEnv, env);
                if (StringUtils.isNotBlank((String)tmProappEnv.getProappEnvDomain()) && tmProappEnv.getProappEnvDomain().indexOf("{domain}") >= 0) {
                    domain = DisUtil.getRemotMap((String)"tmtenant-code_dmain", (String)(tmProappEnv.getTenantCode() + "-domain"));
                    if (null == domain) {
                        domain = "";
                    }
                    tmProappEnv.setProappEnvDomain(tmProappEnv.getProappEnvDomain().replace("{domain}", domain));
                }
                this.makemap(tmProappEnv.getProappEnvDomain(), envdomainMap, tmProappEnv, proappMap);
                if (StringUtils.isNotBlank((String)tmProappEnv.getProappEnvDomain1()) && tmProappEnv.getProappEnvDomain1().indexOf("{domain0}") >= 0) {
                    domain = DisUtil.getRemotMap((String)"tmtenant-code_dmain", (String)(tmProappEnv.getTenantCode() + "-domain0"));
                    if (null == domain) {
                        domain = "";
                    }
                    tmProappEnv.setProappEnvDomain1(tmProappEnv.getProappEnvDomain1().replace("{domain0}", domain));
                }
                this.makemap(tmProappEnv.getProappEnvDomain1(), envdomainMap, tmProappEnv, proappMap);
                if (StringUtils.isNotBlank((String)tmProappEnv.getProappEnvDomain2()) && tmProappEnv.getProappEnvDomain2().indexOf("{domain1}") >= 0) {
                    domain = DisUtil.getRemotMap((String)"tmtenant-code_dmain", (String)(tmProappEnv.getTenantCode() + "-domain1"));
                    if (null == domain) {
                        domain = "";
                    }
                    tmProappEnv.setProappEnvDomain2(tmProappEnv.getProappEnvDomain2().replace("{domain1}", domain));
                }
                this.makemap(tmProappEnv.getProappEnvDomain2(), envdomainMap, tmProappEnv, proappMap);
                this.makemap(tmProappEnv.getTenantCode(), envtenantMap, tmProappEnv, proappMap);
                envcodeMap.put(tmProappEnv.getTenantCode() + "-" + tmProappEnv.getProappCode(), JsonUtil.buildNormalBinder().toJson((Object)tmProappEnv));
            }
            catch (Exception e) {
                this.logger.error("TmProappService.queryProappEnvLoadCache.e", (Throwable)e);
            }
        }
        DisUtil.setMapVer((String)this.cachekeydomain, envdomainMap);
        DisUtil.setMapVer((String)this.cachekeytenant, envtenantMap);
        DisUtil.setMapVer((String)this.cacheenvcode, envcodeMap);
    }

    @Override
    public void queryProappEnvLoadCache() {
        this.logger.error("TmProappService.queryProappEnvLoadCache", (Object)"===========start==========");
        List<TmProappEnv> proappEnvList = this.queryProappEnvModelPage(new HashMap<String, Object>());
        List<TmProapp> proappList = this.queryProappModelPage(new HashMap<String, Object>());
        if (null == proappList || proappList.isEmpty() || null == proappEnvList || proappEnvList.isEmpty()) {
            DisUtil.delVer((String)this.cachekeydomain);
            DisUtil.delVer((String)this.cachekeytenant);
            DisUtil.delVer((String)this.cachekeycomdomain);
            DisUtil.delVer((String)this.cacheenvcode);
            DisUtil.delVer((String)this.cacheOauthEnvCode);
            this.logger.info("TmProappService.queryProappEnvLoadCache", (Object)"===========del-end==========");
            return;
        }
        List<TmProappConfig> configList = this.queryProappConfigModelPage(null);
        if (ListUtil.isEmpty(configList)) {
            DisUtil.delVer((String)this.cacheConfig);
        } else {
            ConcurrentHashMap<String, String> configMap = new ConcurrentHashMap<String, String>();
            for (TmProappConfig tmProappConfig : configList) {
                configMap.put(tmProappConfig.getProappCode() + "-" + tmProappConfig.getProappConfigType() + "-" + tmProappConfig.getTenantCode(), JsonUtil.buildNormalBinder().toJson((Object)tmProappConfig));
            }
            DisUtil.setMapVer((String)this.cacheConfig, configMap);
        }
        ConcurrentHashMap<String, String> proappDomainMap = new ConcurrentHashMap<String, String>();
        ConcurrentHashMap<String, String> envcode = new ConcurrentHashMap<String, String>();
        for (TmProapp tmProapp : proappList) {
            if (StringUtils.isNotBlank((String)tmProapp.getOauthEnvCode())) {
                envcode.put(tmProapp.getProappCode() + "-" + tmProapp.getTenantCode(), tmProapp.getOauthEnvCode());
            }
            if (StringUtils.isNotBlank((String)tmProapp.getProappDomain())) {
                proappDomainMap.put(tmProapp.getProappDomain() + "-" + tmProapp.getProappContext() + "-" + tmProapp.getOauthEnvCode(), tmProapp.getProappCode() + "," + tmProapp.getTenantCode());
            }
            if (StringUtils.isNotBlank((String)tmProapp.getProappDomain1())) {
                proappDomainMap.put(tmProapp.getProappDomain1() + "-" + tmProapp.getProappContext() + "-" + tmProapp.getOauthEnvCode(), tmProapp.getProappCode() + "," + tmProapp.getTenantCode());
            }
            if (!StringUtils.isNotBlank((String)tmProapp.getProappDomain2())) continue;
            proappDomainMap.put(tmProapp.getProappDomain2() + "-" + tmProapp.getProappContext() + "-" + tmProapp.getOauthEnvCode(), tmProapp.getProappCode() + "," + tmProapp.getTenantCode());
        }
        DisUtil.setMapVer((String)this.cacheOauthEnvCode, envcode);
        DisUtil.setMapVer((String)this.cachekeycomdomain, proappDomainMap);
        if (null == proappEnvList || proappEnvList.isEmpty()) {
            DisUtil.delVer((String)this.cachekeydomain);
            DisUtil.delVer((String)this.cachekeytenant);
            this.logger.info("TmProappService.queryProappEnvLoadCache", (Object)"===========del-end==========");
            return;
        }
        Map<String, String> proappMap = this.makeProappToEnv(proappList);
        ConcurrentHashMap<String, String> envdomainMap = new ConcurrentHashMap<String, String>();
        ConcurrentHashMap<String, String> envtenantMap = new ConcurrentHashMap<String, String>();
        ConcurrentHashMap<String, String> envcodeMap = new ConcurrentHashMap<String, String>();
        for (TmProappEnv tmProappEnv : proappEnvList) {
            try {
                String domain;
                String env = proappMap.get(tmProappEnv.getProappCode());
                this.make(tmProappEnv, env);
                if (StringUtils.isNotBlank((String)tmProappEnv.getProappEnvDomain()) && tmProappEnv.getProappEnvDomain().indexOf("{domain}") >= 0) {
                    domain = DisUtil.getRemotMap((String)"tmtenant-code_dmain", (String)(tmProappEnv.getTenantCode() + "-domain"));
                    if (null == domain) {
                        domain = "";
                    }
                    tmProappEnv.setProappEnvDomain(tmProappEnv.getProappEnvDomain().replace("{domain}", domain));
                }
                this.makemap(tmProappEnv.getProappEnvDomain(), envdomainMap, tmProappEnv, proappMap);
                if (StringUtils.isNotBlank((String)tmProappEnv.getProappEnvDomain1()) && tmProappEnv.getProappEnvDomain1().indexOf("{domain0}") >= 0) {
                    domain = DisUtil.getRemotMap((String)"tmtenant-code_dmain", (String)(tmProappEnv.getTenantCode() + "-domain0"));
                    if (null == domain) {
                        domain = "";
                    }
                    tmProappEnv.setProappEnvDomain1(tmProappEnv.getProappEnvDomain1().replace("{domain0}", domain));
                }
                this.makemap(tmProappEnv.getProappEnvDomain1(), envdomainMap, tmProappEnv, proappMap);
                if (StringUtils.isNotBlank((String)tmProappEnv.getProappEnvDomain2()) && tmProappEnv.getProappEnvDomain2().indexOf("{domain1}") >= 0) {
                    domain = DisUtil.getRemotMap((String)"tmtenant-code_dmain", (String)(tmProappEnv.getTenantCode() + "-domain1"));
                    if (null == domain) {
                        domain = "";
                    }
                    tmProappEnv.setProappEnvDomain2(tmProappEnv.getProappEnvDomain2().replace("{domain1}", domain));
                }
                this.makemap(tmProappEnv.getProappEnvDomain2(), envdomainMap, tmProappEnv, proappMap);
                this.makemap(tmProappEnv.getTenantCode(), envtenantMap, tmProappEnv, proappMap);
                envcodeMap.put(tmProappEnv.getTenantCode() + "-" + tmProappEnv.getProappCode(), JsonUtil.buildNormalBinder().toJson((Object)tmProappEnv));
            }
            catch (Exception e) {
                this.logger.error("TmProappService.queryProappEnvLoadCache.e", (Throwable)e);
            }
        }
        DisUtil.setMapVer((String)this.cachekeydomain, envdomainMap);
        DisUtil.setMapVer((String)this.cachekeytenant, envtenantMap);
        DisUtil.setMapVer((String)this.cacheenvcode, envcodeMap);
        this.logger.error("TmProappService.queryProappEnvLoadCache", (Object)"===========add-end==========");
    }

    private void make(TmProappEnv tmProappEnv, String env) {
        if (null == tmProappEnv || StringUtils.isBlank((String)env)) {
            return;
        }
        if (StringUtils.isNotBlank((String)tmProappEnv.getProappEnvIndex())) {
            tmProappEnv.setProappEnvIndex(tmProappEnv.getProappEnvIndex().replace("${tenantCode}", tmProappEnv.getTenantCode()));
            tmProappEnv.setProappEnvIndex(tmProappEnv.getProappEnvIndex().replace("${oauthEnvCode}", env));
            tmProappEnv.setProappEnvIndex(tmProappEnv.getProappEnvIndex().replace("${proappCode}", tmProappEnv.getProappCode()));
        }
        if (StringUtils.isNotBlank((String)tmProappEnv.getProappEnvIndexc())) {
            tmProappEnv.setProappEnvIndexc(tmProappEnv.getProappEnvIndexc().replace("${tenantCode}", tmProappEnv.getTenantCode()));
            tmProappEnv.setProappEnvIndexc(tmProappEnv.getProappEnvIndexc().replace("${oauthEnvCode}", env));
            tmProappEnv.setProappEnvIndexc(tmProappEnv.getProappEnvIndexc().replace("${proappCode}", tmProappEnv.getProappCode()));
        }
        if (StringUtils.isNotBlank((String)tmProappEnv.getProappEnvIndexr())) {
            tmProappEnv.setProappEnvIndexr(tmProappEnv.getProappEnvIndexr().replace("${tenantCode}", tmProappEnv.getTenantCode()));
            tmProappEnv.setProappEnvIndexr(tmProappEnv.getProappEnvIndexr().replace("${oauthEnvCode}", env));
            tmProappEnv.setProappEnvIndexr(tmProappEnv.getProappEnvIndexr().replace("${proappCode}", tmProappEnv.getProappCode()));
        }
    }

    private Map<String, String> makeProappToEnv(List<TmProapp> proappList) {
        if (null == proappList || proappList.isEmpty()) {
            return null;
        }
        ConcurrentHashMap<String, String> map = new ConcurrentHashMap<String, String>();
        for (TmProapp tmProapp : proappList) {
            map.put(tmProapp.getProappCode(), tmProapp.getOauthEnvCode());
        }
        return map;
    }

    private void makemap(String key, Map<String, String> envdMap, TmProappEnv tmProappEnv, Map<String, String> proappMap) {
        if (null == tmProappEnv || null == envdMap || StringUtils.isBlank((String)key) || null == proappMap || proappMap.isEmpty()) {
            return;
        }
        String vstr = tmProappEnv.getProappCode() + "," + tmProappEnv.getTenantCode();
        String env = proappMap.get(tmProappEnv.getProappCode());
        envdMap.put(key + "-" + tmProappEnv.getProappEnvContext() + "-" + env, vstr);
        String index = tmProappEnv.getProappEnvIndexr();
        if (StringUtils.isNotBlank((String)index)) {
            if (StringUtils.isBlank((String)tmProappEnv.getTenantCode())) {
                this.logger.error("===============" + tmProappEnv.getProappEnvId());
            }
            index = index.replace("${tenantCode}", tmProappEnv.getTenantCode());
            index = index.replace("${oauthEnvCode}", env);
            index = index.replace("${proappCode}", tmProappEnv.getProappCode());
            DisUtil.set((String)key, (String)index);
        }
    }

    @Override
    public List<TmMenu> queryMenuByProappByParent(String proappMenuPcode, String proappCode, String tenantCode) {
        ConcurrentHashMap<String, Object> parmMap = new ConcurrentHashMap<String, Object>();
        parmMap.put("proappMenuPcode", proappMenuPcode);
        parmMap.put("proappCode", proappCode);
        parmMap.put("tenantCode", tenantCode);
        parmMap.put("order", true);
        parmMap.put("orderStr", "PROAPP_MENU_ORDER asc");
        List<TmProappMenu> list = this.queryProappMenuModelPage(parmMap);
        if (null != list && !list.isEmpty()) {
            ArrayList<TmMenu> relist = new ArrayList<TmMenu>();
            this.makeRedomain(relist, list);
            return relist;
        }
        return null;
    }

    private void makeRedomain(List<TmMenu> relist, List<TmProappMenu> list) {
        if (null == list || list.isEmpty() || null == relist) {
            return;
        }
        for (TmProappMenu tmProappMenu : list) {
            TmMenu tmMenu = this.makeReDomain(tmProappMenu);
            if (null == tmMenu) continue;
            relist.add(tmMenu);
            ConcurrentHashMap<String, Object> parmMap = new ConcurrentHashMap<String, Object>();
            parmMap.put("proappMenuPcode", tmProappMenu.getProappMenuCode());
            parmMap.put("proappCode", tmProappMenu.getProappCode());
            parmMap.put("tenantCode", tmProappMenu.getTenantCode());
            parmMap.put("dataState", 1);
            parmMap.put("order", true);
            parmMap.put("orderStr", "PROAPP_MENU_ORDER asc");
            List<TmProappMenu> clist = this.queryProappMenuModelPage(parmMap);
            if (null == clist || clist.isEmpty()) continue;
            ArrayList<TmMenu> reclist = new ArrayList<TmMenu>();
            this.makeRedomain(reclist, clist);
            tmMenu.setChildren(reclist);
        }
    }

    private List<TmMenu> makePriListToMenu(TmMenu oldtmMenu, TmProappMenu tmProappMenu) {
        List<TmProappMenupriDomain> tmProappMenupriDomainList;
        if (null == tmProappMenu || null == oldtmMenu) {
            return null;
        }
        String json = DisUtil.getMap((String)this.cachekeyrouteClidmenu, (String)(oldtmMenu.getMenuCode() + "-" + "00000000"));
        ArrayList<TmMenu> routerList = null;
        if (StringUtils.isNotBlank((String)json)) {
            routerList = (ArrayList<TmMenu>)JsonUtil.buildNormalBinder().getJsonToList(json, TmMenu.class);
        }
        if (ListUtil.isEmpty(tmProappMenupriDomainList = this.tmProappMenupriService.queryProappMenupriByCode(tmProappMenu.getTenantCode(), tmProappMenu.getProappMenuCode()))) {
            return routerList;
        }
        HashMap routerMap = null;
        if (null == routerList) {
            routerList = new ArrayList<TmMenu>();
            for (TmProappMenupriDomain tmProappMenupriDomain : tmProappMenupriDomainList) {
                TmMenu tmMenu = this.makePriToMenu(tmProappMenupriDomain);
                routerList.add(tmMenu);
            }
        } else {
            List tList;
            routerMap = new HashMap();
            for (TmMenu tmMenu1 : routerList) {
                String key = tmMenu1.getAppmanageIcode() + "-" + tmMenu1.getMenuAction() + "-" + tmMenu1.getTenantCode();
                tList = (ArrayList<TmMenu>)routerMap.get(key);
                if (null == tList) {
                    tList = new ArrayList<TmMenu>();
                    routerMap.put(key, tList);
                }
                tList.add(tmMenu1);
            }
            for (TmProappMenupriDomain tmProappMenupriDomain : tmProappMenupriDomainList) {
                TmMenu tmMenu = this.makePriToMenu(tmProappMenupriDomain);
                tList = (List)routerMap.get(tmProappMenupriDomain.getAppmanageIcode() + "-" + tmProappMenupriDomain.getMenuAction() + "-" + tmProappMenupriDomain.getTenantCode());
                if (!ListUtil.isNotEmpty(tList)) continue;
                for (TmMenu tmMenu2 : tList) {
                    routerList.remove(tmMenu2);
                }
            }
        }
        return routerList;
    }

    private TmMenu makePriToMenu(TmProappMenupriDomain tmProappMenupriDomain) {
        TmMenu tmMenu;
        if (null == tmProappMenupriDomain) {
            return null;
        }
        if (StringUtils.isNotBlank((String)tmProappMenupriDomain.getMenuCode())) {
            tmMenu = this.getTmMenu(tmProappMenupriDomain.getMenuCode());
            if (null == tmMenu) {
                this.logger.error("tm.TmProappServiceImpl.makePriToMenu.null", (Object)tmProappMenupriDomain.getMenuCode());
                return null;
            }
            if (null == tmMenu.getMenuShow()) {
                tmMenu.setMenuShow(0);
            }
        } else {
            tmMenu = this.makePri(tmProappMenupriDomain);
        }
        if (null != tmMenu) {
            if (null == tmMenu.getMenuShow()) {
                tmMenu.setMenuShow(0);
            }
            tmMenu.setMenuCode(tmProappMenupriDomain.getMenuCode());
            tmMenu.setProappMenuPcode(tmProappMenupriDomain.getProappMenuCode());
            tmMenu.setProappMenuCode(tmProappMenupriDomain.getProappMenupriCode());
            tmMenu.setProappCode(tmProappMenupriDomain.getProappCode());
            tmMenu.setTenantCode(tmProappMenupriDomain.getTenantCode());
            tmMenu.setProappMenuQparam(tmProappMenupriDomain.getProappMenuQparam());
            if (StringUtils.isNotBlank((String)tmProappMenupriDomain.getMenuTarget())) {
                tmMenu.setMenuTarget(tmProappMenupriDomain.getMenuTarget());
            }
            if (StringUtils.isNotBlank((String)tmProappMenupriDomain.getMenuAction())) {
                tmMenu.setMenuAction(tmProappMenupriDomain.getMenuAction());
            }
            if (StringUtils.isNotBlank((String)tmProappMenupriDomain.getMenuTarget())) {
                tmMenu.setMenuTarget(tmProappMenupriDomain.getMenuTarget());
            }
            if (StringUtils.isNotBlank((String)tmProappMenupriDomain.getMenuJspath())) {
                tmMenu.setMenuJspath(tmProappMenupriDomain.getMenuJspath());
            }
        }
        return tmMenu;
    }

    private TmMenu makeReDomain(TmProappMenu tmProappMenu) {
        TmMenu tmMenu;
        if (null == tmProappMenu) {
            return null;
        }
        if (StringUtils.isNotBlank((String)tmProappMenu.getMenuCode())) {
            tmMenu = this.getTmMenu(tmProappMenu.getMenuCode());
            if (null == tmMenu) {
                this.logger.error("TmProappService.makeReDomain.null", (Object)tmProappMenu.getMenuCode());
                return null;
            }
            if (null == tmMenu.getMenuShow()) {
                tmMenu.setMenuShow(0);
            }
        } else {
            tmMenu = this.make(tmProappMenu);
        }
        if (null != tmMenu) {
            if (StringUtils.isNotBlank((String)tmProappMenu.getProappMenuName())) {
                tmMenu.setMenuName(tmProappMenu.getProappMenuName());
            }
            if (null == tmMenu.getMenuShow()) {
                tmMenu.setMenuShow(0);
            }
            tmMenu.setProappMenuIcon(tmProappMenu.getProappMenuIcon());
            tmMenu.setProappMenuFont(tmProappMenu.getProappMenuFont());
            tmMenu.setMenuCode(tmProappMenu.getMenuCode());
            tmMenu.setProappMenuPcode(tmProappMenu.getProappMenuPcode());
            tmMenu.setProappMenuCode(tmProappMenu.getProappMenuCode());
            tmMenu.setProappMenuRemark(tmProappMenu.getProappMenuRemark());
            tmMenu.setProappMenuOrder(tmProappMenu.getProappMenuOrder());
            tmMenu.setProappCode(tmProappMenu.getProappCode());
            tmMenu.setTenantCode(tmProappMenu.getTenantCode());
            tmMenu.setProappMenuQparam(tmProappMenu.getProappMenuQparam());
            tmMenu.setProappMenuConfig(tmProappMenu.getProappMenuConfig());
            if (StringUtils.isNotBlank((String)tmProappMenu.getMenuDefaultClass())) {
                tmMenu.setMenuDefaultClass(tmProappMenu.getMenuDefaultClass());
            }
            if (StringUtils.isNotBlank((String)tmProappMenu.getMenuSelectClass())) {
                tmMenu.setMenuSelectClass(tmProappMenu.getMenuSelectClass());
            }
            if (StringUtils.isNotBlank((String)tmProappMenu.getMenuTarget())) {
                tmMenu.setMenuTarget(tmProappMenu.getMenuTarget());
            }
            if (StringUtils.isNotBlank((String)tmProappMenu.getProappMenuRemark())) {
                tmMenu.setMenuRemark(tmProappMenu.getProappMenuRemark());
            }
            if (StringUtils.isNotBlank((String)tmProappMenu.getMenuAction())) {
                tmMenu.setMenuAction(tmProappMenu.getMenuAction());
            }
            if (StringUtils.isNotBlank((String)tmProappMenu.getMenuTarget())) {
                tmMenu.setMenuTarget(tmProappMenu.getMenuTarget());
            }
            if (StringUtils.isNotBlank((String)tmProappMenu.getMenuJspath())) {
                tmMenu.setMenuJspath(tmProappMenu.getMenuJspath());
            }
            if (StringUtils.isNotBlank((String)tmProappMenu.getMenuDetailsCode())) {
                tmMenu.setMenuDetailsCode(tmProappMenu.getMenuDetailsCode());
            }
            if (StringUtils.isNotBlank((String)tmProappMenu.getMenuIndexCode())) {
                tmMenu.setMenuIndexCode(tmProappMenu.getMenuIndexCode());
            }
            tmMenu.setRoutechildren(this.makePriListToMenu(tmMenu, tmProappMenu));
        }
        return tmMenu;
    }

    private TmMenu getTmMenu(String menuCode) {
        if (StringUtils.isBlank((String)menuCode)) {
            return null;
        }
        String menuStr = DisUtil.getMap((String)"UpMenu-menuCode", (String)(menuCode + "-" + "00000000"));
        if (StringUtils.isNotBlank((String)menuStr)) {
            TmMenu tmMenu = (TmMenu)JsonUtil.buildNormalBinder().getJsonToObject(menuStr, TmMenu.class);
            return tmMenu;
        }
        return null;
    }

    @Override
    public List<TmMenu> queryMenuByProappOne(String proappCode, String tenantCode) {
        ConcurrentHashMap<String, Object> parmMap = new ConcurrentHashMap<String, Object>();
        parmMap.put("proappCode", proappCode);
        parmMap.put("tenantCode", tenantCode);
        parmMap.put("proappMenuPcode", "-1");
        parmMap.put("dataState", 1);
        parmMap.put("order", true);
        parmMap.put("orderStr", "PROAPP_MENU_ORDER asc");
        List<TmProappMenu> list = this.queryProappMenuModelPage(parmMap);
        if (null == list || list.isEmpty()) {
            return null;
        }
        ArrayList<TmMenu> menuList = new ArrayList<TmMenu>();
        TmMenu tmMenu = null;
        for (TmProappMenu tmProappMenu : list) {
            tmMenu = this.makeReDomain(tmProappMenu);
            if (null == tmMenu) continue;
            tmMenu.setProappMenuCode(tmProappMenu.getProappMenuCode());
            tmMenu.setTenantCode(tmProappMenu.getTenantCode());
            tmMenu.setProappCode(tmProappMenu.getProappCode());
            menuList.add(tmMenu);
        }
        return menuList;
    }

    @Override
    public void queryProappMenuTreeLoadCache() {
        this.logger.info("TmProappService.queryProappMenuTreeLoadCache", (Object)"===========start==========");
        List<TmProappEnv> envList = this.queryProappEnvModelPage(null);
        if (null == envList || envList.isEmpty()) {
            this.logger.info("TmProappService.queryProappMenuTreeLoadCache", (Object)"===========null-end==========");
            return;
        }
        for (TmProappEnv tmProappEnv : envList) {
            this.loadEnvCache(tmProappEnv);
        }
    }

    private void loadEnvCache(TmProappEnv tmProappEnv) {
        if (null != tmProappEnv && null != tmProappEnv.getDataState() && 4 == tmProappEnv.getDataState()) {
            this.loadMenuOneCache(this.cachekeyOne, tmProappEnv);
        } else {
            DisUtil.delVer((String)(this.cachekeyOne + "-" + tmProappEnv.getProappCode() + "-" + tmProappEnv.getTenantCode()));
            DisUtil.delVer((String)(this.cachekeyChild + "-" + tmProappEnv.getProappCode() + "-" + tmProappEnv.getTenantCode()));
        }
    }

    private void loadMenuChildCache(TmMenu tmMenu) {
        if (null == tmMenu) {
            return;
        }
        List<TmMenu> menuList = this.queryMenuByProappByParent(tmMenu.getProappMenuCode(), tmMenu.getProappCode(), tmMenu.getTenantCode());
        if (null == menuList || menuList.isEmpty()) {
            DisUtil.delVer((String)(this.cachekeyChild + "-" + tmMenu.getProappMenuCode() + "-" + tmMenu.getProappCode() + "-" + tmMenu.getTenantCode()));
        } else {
            DisUtil.setJson((String)(this.cachekeyChild + "-" + tmMenu.getProappMenuCode() + "-" + tmMenu.getProappCode() + "-" + tmMenu.getTenantCode()), menuList);
        }
    }

    private void loadMenuOneCache(String cachekeyOne, TmProappEnv tmProappEnv) {
        if (null == tmProappEnv) {
            return;
        }
        List<TmMenu> menuList = this.queryMenuByProappOne(tmProappEnv.getProappCode(), tmProappEnv.getTenantCode());
        if (null == menuList || menuList.isEmpty()) {
            DisUtil.delVer((String)(cachekeyOne + "-" + tmProappEnv.getProappCode() + "-" + tmProappEnv.getTenantCode()));
        } else {
            DisUtil.setJson((String)(cachekeyOne + "-" + tmProappEnv.getProappCode() + "-" + tmProappEnv.getTenantCode()), menuList);
            for (TmMenu tmMenu : menuList) {
                this.loadMenuChildCache(tmMenu);
            }
        }
    }

    private TmMenu make(TmProappMenu tmProappMenu) {
        if (null == tmProappMenu) {
            return null;
        }
        if (null == tmProappMenu.getDataState() || 1 != tmProappMenu.getDataState()) {
            return null;
        }
        TmMenu tmMenu = new TmMenu();
        tmMenu.setMenuCode(tmProappMenu.getProappMenuCode());
        tmMenu.setMenuParentCode(tmProappMenu.getProappMenuPcode());
        tmMenu.setMenuName(tmProappMenu.getProappMenuName());
        tmMenu.setMenuOrder(tmProappMenu.getProappMenuOrder());
        tmMenu.setTenantCode(tmProappMenu.getTenantCode());
        tmMenu.setProappCode(tmProappMenu.getProappCode());
        tmMenu.setMenuAction(tmProappMenu.getMenuAction());
        tmMenu.setMenuJspath(tmProappMenu.getMenuJspath());
        tmMenu.setMenuDetailsCode(tmProappMenu.getMenuDetailsCode());
        tmMenu.setMenuIndexCode(tmProappMenu.getMenuIndexCode());
        tmMenu.setMenuRemark(tmProappMenu.getProappMenuRemark());
        tmMenu.setMenuDefaultClass(tmProappMenu.getMenuDefaultClass());
        tmMenu.setMenuSelectClass(tmProappMenu.getMenuSelectClass());
        tmMenu.setMenuTarget(tmProappMenu.getMenuTarget());
        tmMenu.setProappMenuIcon(tmProappMenu.getProappMenuIcon());
        tmMenu.setProappMenuFont(tmProappMenu.getProappMenuFont());
        tmMenu.setProappMenuQparam(tmProappMenu.getProappMenuQparam());
        tmMenu.setProappMenuConfig(tmProappMenu.getProappMenuConfig());
        return tmMenu;
    }

    private TmMenu makePri(TmProappMenupriDomain tmProappMenupriDomain) {
        if (null == tmProappMenupriDomain) {
            return null;
        }
        TmMenu tmMenu = new TmMenu();
        tmMenu.setMenuCode(tmProappMenupriDomain.getProappMenupriCode());
        tmMenu.setMenuParentCode(tmProappMenupriDomain.getProappMenuCode());
        tmMenu.setMenuName(tmProappMenupriDomain.getProappMenupriCode());
        tmMenu.setTenantCode(tmProappMenupriDomain.getTenantCode());
        tmMenu.setProappCode(tmProappMenupriDomain.getProappCode());
        tmMenu.setMenuAction(tmProappMenupriDomain.getMenuAction());
        tmMenu.setMenuJspath(tmProappMenupriDomain.getMenuJspath());
        tmMenu.setMenuTarget(tmProappMenupriDomain.getMenuTarget());
        tmMenu.setProappMenuQparam(tmProappMenupriDomain.getProappMenuQparam());
        return tmMenu;
    }

    @Override
    public void updateTmProappMenuRel(Integer proappMenuId) {
        TmProappMenu tmProappMenu = this.getProappMenu(proappMenuId);
        if (null == tmProappMenu) {
            throw new ApiException("tm.TmProappServiceImpl.updateTmProappMenuRel.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        this.updateReleaseHtml(tmProappMenu);
    }

    private void updateReleaseHtml(TmProappMenu tmProappMenu) {
        String[] atcionS;
        String[] atcionS2;
        if (null == tmProappMenu || StringUtils.isBlank((String)tmProappMenu.getMenuIndexCode()) && StringUtils.isBlank((String)tmProappMenu.getMenuDetailsCode())) {
            return;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("htmldataMenutype", "TM");
        params.put("htmldataMenu", tmProappMenu.getProappMenuCode());
        params.put("htmldataCode", "TmProappMenu");
        params.put("tenantCode", tmProappMenu.getTenantCode());
        String filename = "";
        if (StringUtils.isNotBlank((String)tmProappMenu.getMenuAction()) && StringUtils.isNotBlank((String)(filename = (atcionS2 = tmProappMenu.getMenuAction().split("/"))[atcionS2.length - 1]))) {
            filename = filename.replace("${htmldataFilename}", tmProappMenu.getMenuCode());
        }
        String filepath = "";
        if (StringUtils.isNotBlank((String)tmProappMenu.getMenuJspath()) && StringUtils.isNotBlank((String)(filepath = (atcionS = tmProappMenu.getMenuJspath().split("/"))[atcionS.length - 1]))) {
            filepath = filepath.replace("${htmldataFilepath}", tmProappMenu.getMenuCode());
        }
        params.put("htmldataFilename", filename);
        params.put("htmlcontOpparam", JsonUtil.buildNormalBinder().toJson((Object)tmProappMenu));
        params.put("htmldataFilepath", filepath);
        map.put("htmlRelease", JsonUtil.buildNormalBinder().toJson(params));
        this.internalInvoke("pfs.htmlcont.sendHtmlcontOpData", map);
    }

    @Override
    public void saveProappEnvInit(List<TmProappEnvBean> tmProappEnvBeanList) {
        if (ListUtil.isEmpty(tmProappEnvBeanList)) {
            return;
        }
        List<TmProappEnv> tmProappEnvList = this.queryProappEnvModelPage(this.getQueryMapParam("tenantCode", new Object[]{"00000000"}));
        if (ListUtil.isEmpty(tmProappEnvList)) {
            return;
        }
        Map<String, TmProappEnv> envMap = this.makeMap(tmProappEnvList);
        if (null == envMap || envMap.isEmpty()) {
            return;
        }
        HashMap<String, Object> codeMap = new HashMap<String, Object>();
        for (TmProappEnvBean tmProappEnvBean : tmProappEnvBeanList) {
            TmProappEnvDomain tmProappEnvDomain;
            TmProappEnv tmProappEnv = envMap.get(tmProappEnvBean.getProappCode());
            if (null == tmProappEnv || null == (tmProappEnvDomain = this.makeProappEnvDomain(tmProappEnvBean, tmProappEnv))) continue;
            tmProappEnvDomain.setProappEnvId(null);
            this.copyTmProappEnvBean(tmProappEnvDomain, tmProappEnv);
            codeMap.put("tenantCode", tmProappEnvDomain.getTenantCode());
            codeMap.put("proappEnvCode", tmProappEnvDomain.getProappEnvCode());
            TmProappEnv oldTmProappEnv = this.getProappEnvModelByCode(codeMap);
            if (null == oldTmProappEnv) {
                this.saveProappEnv(tmProappEnvDomain);
            }
            if (ListUtil.isEmpty(tmProappEnvBean.getTmProappMenuBeanList())) {
                this.saveMenuDefuat(tmProappEnvDomain.getProappCode(), tmProappEnvDomain.getTenantCode());
                continue;
            }
            this.saveBatchProappMenuBean(tmProappEnvBean.getTmProappMenuBeanList(), tmProappEnvDomain.getTenantCode());
        }
        this.queryProappEnvLoadCache();
        this.queryProappMenuLoadCache();
        this.queryProappMenuTreeLoadCache();
    }

    private void saveMenuDefuat(String proappCode, String tenantCode) {
        if (StringUtils.isBlank((String)proappCode)) {
            return;
        }
        List<TmProappMenu> tmProappMenuList = this.queryProappMenuModelPage(this.getQueryMapParam("tenantCode,proappCode", new Object[]{"00000000", proappCode}));
        if (ListUtil.isEmpty(tmProappMenuList)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (TmProappMenu tmProappMenu : tmProappMenuList) {
            TmProappMenuDomain tmProappMenuDomain = this.makeProappMenuDomain(tmProappMenu);
            if (null == tmProappMenuDomain) continue;
            tmProappMenuDomain.setProappMenuId(null);
            tmProappMenuDomain.setTenantCode(tenantCode);
            map.put("proappMenuCode", tmProappMenu.getProappMenuCode());
            map.put("tenantCode", tenantCode);
            TmProappMenu oldTmProappMenu = this.getProappMenuByCode(map);
            if (null != oldTmProappMenu) {
                tmProappMenuDomain.setProappMenuId(oldTmProappMenu.getProappMenuId());
                this.updateProappMenu(tmProappMenuDomain);
                continue;
            }
            List<TmProappMenupriDomain> priList = this.tmProappMenupriService.queryProappMenupriByCode("00000000", tmProappMenu.getProappMenuCode());
            tmProappMenuDomain.setTmProappMenupriDomainList(priList);
            this.saveProappMenu(tmProappMenuDomain);
        }
    }

    @Override
    public String saveBatchProappMenu(List<TmProappMenuDomain> tmProappMenuDomainList) throws ApiException {
        if (ListUtil.isEmpty(tmProappMenuDomainList)) {
            return null;
        }
        String code = "";
        for (TmProappMenuDomain tmProappMenuDomain : tmProappMenuDomainList) {
            code = this.saveProappMenu(tmProappMenuDomain);
        }
        return code;
    }

    public String saveBatchProappMenuBean(List<TmProappMenuBean> tmProappMenuBeanList, String tenantCode) throws ApiException {
        if (ListUtil.isEmpty(tmProappMenuBeanList)) {
            return null;
        }
        String code = "";
        HashMap<String, Object> map = new HashMap<String, Object>();
        TmProappMenu tmProappMenu = null;
        TmProappMenu oldTmProappMenu = null;
        for (TmProappMenuBean tmProappMenuBean : tmProappMenuBeanList) {
            map.put("proappMenuCode", tmProappMenuBean.getProappMenuCode());
            map.put("tenantCode", "00000000");
            tmProappMenu = this.getProappMenuByCode(map);
            if (null == tmProappMenu) continue;
            TmProappMenuDomain tmProappMenuDomain = new TmProappMenuDomain();
            try {
                BeanUtils.copyAllPropertys((Object)tmProappMenuDomain, (Object)tmProappMenu);
                tmProappMenuDomain.setProappMenuId(null);
                tmProappMenuDomain.setTenantCode(tenantCode);
            }
            catch (Exception e) {
                // empty catch block
            }
            map.put("tenantCode", tmProappMenuBean.getTenantCode());
            oldTmProappMenu = this.getProappMenuByCode(map);
            if (null != oldTmProappMenu) {
                tmProappMenuDomain.setProappMenuId(oldTmProappMenu.getProappMenuId());
                this.updateProappMenu(tmProappMenuDomain);
                continue;
            }
            ArrayList<TmProappMenupriDomain> priList = null;
            if (ListUtil.isEmpty(tmProappMenuBean.getTmProappMenupriBeanList())) {
                priList = this.tmProappMenupriService.queryProappMenupriByCode("00000000", tmProappMenu.getProappMenuCode());
            } else {
                priList = new ArrayList();
                for (TmProappMenupriBean tmProappMenupriBean : tmProappMenuBean.getTmProappMenupriBeanList()) {
                    TmProappMenupriDomain tmProappMenupriDomain = new TmProappMenupriDomain();
                    TmProappMenupri tmProappMenupri = this.tmProappMenupriService.getProappMenupriByCode(tenantCode, tmProappMenupriBean.getProappMenupriCode());
                    try {
                        BeanUtils.copyAllPropertys((Object)tmProappMenupriDomain, (Object)tmProappMenupriBean);
                        BeanUtils.copyAllPropertys((Object)tmProappMenupriDomain, (Object)tmProappMenupri);
                        tmProappMenupriDomain.setProappMenupriId(null);
                        tmProappMenupriDomain.setTenantCode(tenantCode);
                        priList.add(tmProappMenupriDomain);
                    }
                    catch (Exception e) {}
                }
            }
            tmProappMenuDomain.setTmProappMenupriDomainList(priList);
            code = this.saveProappMenu(tmProappMenuDomain);
        }
        return code;
    }

    private void copyTmProappEnvBean(TmProappEnvDomain tmProappEnvDomain, TmProappEnv tmProappEnv) {
        if (null == tmProappEnvDomain || null == tmProappEnv) {
            return;
        }
        if (StringUtils.isBlank((String)tmProappEnvDomain.getProappEnvOpenconf())) {
            tmProappEnvDomain.setProappEnvOpenconf(tmProappEnv.getProappEnvOpenconf());
        }
        if (StringUtils.isBlank((String)tmProappEnvDomain.getProappEnvLayout())) {
            tmProappEnvDomain.setProappEnvLayout(tmProappEnv.getProappEnvLayout());
        }
        if (StringUtils.isBlank((String)tmProappEnvDomain.getProappEnvTheme())) {
            tmProappEnvDomain.setProappEnvTheme(tmProappEnv.getProappEnvTheme());
        }
        if (StringUtils.isBlank((String)tmProappEnvDomain.getProappEnvDomain())) {
            tmProappEnvDomain.setProappEnvDomain(tmProappEnv.getProappEnvDomain());
        }
        if (StringUtils.isBlank((String)tmProappEnvDomain.getProappEnvDomain1())) {
            tmProappEnvDomain.setProappEnvDomain1(tmProappEnv.getProappEnvDomain1());
        }
        if (StringUtils.isBlank((String)tmProappEnvDomain.getProappEnvDomain2())) {
            tmProappEnvDomain.setProappEnvDomain2(tmProappEnv.getProappEnvDomain2());
        }
        if (StringUtils.isBlank((String)tmProappEnvDomain.getProappEnvIconUrl())) {
            tmProappEnvDomain.setProappEnvIconUrl(tmProappEnv.getProappEnvIconUrl());
        }
    }

    private Map<String, TmProappEnv> makeMap(List<TmProappEnv> tmProappEnvList) {
        if (ListUtil.isEmpty(tmProappEnvList)) {
            return null;
        }
        HashMap<String, TmProappEnv> envMap = new HashMap<String, TmProappEnv>();
        for (TmProappEnv tmProappEnv : tmProappEnvList) {
            envMap.put(tmProappEnv.getProappCode(), tmProappEnv);
        }
        return envMap;
    }
}

