/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.tenantmanag.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.spring.SpringApplicationContextUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.tenantmanag.domain.TmTenantDomain;
import com.yqbsoft.laser.service.tenantmanag.domain.TmTmsceneDomain;
import com.yqbsoft.laser.service.tenantmanag.domain.UmUserDomainBean;
import com.yqbsoft.laser.service.tenantmanag.domain.UmUserinfoDomainBean;
import com.yqbsoft.laser.service.tenantmanag.es.EsEnginePollThread;
import com.yqbsoft.laser.service.tenantmanag.es.EsEnginePutThread;
import com.yqbsoft.laser.service.tenantmanag.es.EsEngineService;
import com.yqbsoft.laser.service.tenantmanag.model.TmTmsceneApi;
import com.yqbsoft.laser.service.tenantmanag.service.TmTenantBaseService;
import com.yqbsoft.laser.service.tenantmanag.service.TmTenantService;
import com.yqbsoft.laser.service.tenantmanag.service.TmTmsceneBaseService;
import com.yqbsoft.laser.service.tenantmanag.service.TmTmsceneService;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import java.util.List;

public class TmTenantBaseServiceImpl
extends BaseServiceImpl
implements TmTenantBaseService {
    public static final String SYS_CODE = "tm.TmTenantBaseServiceImpl";
    private TmTmsceneService tmTmsceneService;
    private TmTenantService tmTenantService;
    private static EsEngineService esEngineService;
    private static Object lock;

    public void setTmTenantService(TmTenantService tmTenantService) {
        this.tmTenantService = tmTenantService;
    }

    public void setTmTmsceneService(TmTmsceneService tmTmsceneService) {
        this.tmTmsceneService = tmTmsceneService;
    }

    @Override
    public String sendSaveTenant(TmTenantDomain tmTenantDomain) throws ApiException {
        String code = this.tmTenantService.saveTenant(tmTenantDomain);
        this.tmTmsceneService.loadDb();
        return code;
    }

    @Override
    public String sendSaveTmscene(TmTmsceneDomain tmTmsceneDomain) throws ApiException {
        List<TmTmsceneApi> tmTmsceneApiList = this.tmTmsceneService.saveTmscene(tmTmsceneDomain);
        if (ListUtil.isEmpty(tmTmsceneApiList)) {
            return null;
        }
        this.getEsEngineService().addPutPool(new EsEnginePutThread(this.getEsEngineService(), tmTmsceneApiList));
        return tmTmsceneApiList.get(0).getSceneApiCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EsEngineService getEsEngineService() {
        Object object = lock;
        synchronized (object) {
            if (null == esEngineService) {
                esEngineService = new EsEngineService((TmTmsceneBaseService)SpringApplicationContextUtil.getBean((String)"tmTmsceneBaseService"));
                for (int i = 0; i < 5; ++i) {
                    esEngineService.addPollPool(new EsEnginePollThread(esEngineService));
                }
            }
            return esEngineService;
        }
    }

    @Override
    public String sendSaveTmsceneBatch(List<TmTmsceneDomain> tmTmsceneDomainList) throws ApiException {
        String code = this.tmTmsceneService.saveTmsceneBatch(tmTmsceneDomainList);
        this.tmTmsceneService.loadDb();
        return code;
    }

    @Override
    public String sendUserSaveTenant(UmUserinfoDomainBean umUserinfo, UmUserDomainBean umUser) throws ApiException {
        if (null == umUserinfo || null == umUser) {
            return "ERROR";
        }
        TmTenantDomain tmTenantDomain = new TmTenantDomain();
        tmTenantDomain.setTenantMember(umUserinfo.getUserinfoCode());
        tmTenantDomain.setTenantCompname(umUserinfo.getUserinfoCompname());
        tmTenantDomain.setTenantCert1No(umUserinfo.getUserinfoCert1No());
        tmTenantDomain.setTenantCert1Url(umUserinfo.getUserinfoCert1Url());
        tmTenantDomain.setTenantCert2No(umUserinfo.getUserinfoCert2No());
        tmTenantDomain.setTenantCert2Url(umUserinfo.getUserinfoCert2Url());
        tmTenantDomain.setTenantCertNo(umUserinfo.getUserinfoCertNo());
        tmTenantDomain.setTenantCertUrl(umUserinfo.getUserinfoCertUrl());
        tmTenantDomain.setTenantCoid(umUserinfo.getUserinfoCoid());
        tmTenantDomain.setTenantCon(umUserinfo.getUserinfoCon());
        tmTenantDomain.setTenantConPhone(umUserinfo.getUserinfoConPhone());
        tmTenantDomain.setTenantPhone(umUserinfo.getUserinfoPhone());
        this.sendSaveTenant(tmTenantDomain);
        return "SUCCESS";
    }

    static {
        lock = new Object();
    }
}

