/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.tenantmanag.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tenantmanag.dao.TmTenantMapper;
import com.yqbsoft.laser.service.tenantmanag.dao.TmTenantSecondaryMapper;
import com.yqbsoft.laser.service.tenantmanag.domain.TmTenantSecondaryDomain;
import com.yqbsoft.laser.service.tenantmanag.model.TmTenant;
import com.yqbsoft.laser.service.tenantmanag.model.TmTenantSecondary;
import com.yqbsoft.laser.service.tenantmanag.service.TmTenantSecondaryService;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class TmTenantSecondaryServiceImpl
extends BaseServiceImpl
implements TmTenantSecondaryService {
    private static final String SYS_CODE = "tm.TmTenantSecondaryServiceImpl";
    private TmTenantSecondaryMapper tmTenantSecondaryMapper;
    private TmTenantMapper tmTenantMapper;

    public void setTmTenantSecondaryMapper(TmTenantSecondaryMapper tmTenantSecondaryMapper) {
        this.tmTenantSecondaryMapper = tmTenantSecondaryMapper;
    }

    public void setTmTenantMapper(TmTenantMapper tmTenantMapper) {
        this.tmTenantMapper = tmTenantMapper;
    }

    private Date getSysDate() {
        try {
            return this.tmTenantSecondaryMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("tm.TmTenantSecondaryServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkTenantSecondary(TmTenantSecondaryDomain tmTenantSecondaryDomain) {
        if (null == tmTenantSecondaryDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        return msg;
    }

    private void setTenantSecondaryDefault(TmTenantSecondary tmTenantSecondary) {
        if (null == tmTenantSecondary) {
            return;
        }
        if (null == tmTenantSecondary.getDataState()) {
            tmTenantSecondary.setDataState(0);
        }
        if (null == tmTenantSecondary.getGmtCreate()) {
            tmTenantSecondary.setGmtCreate(this.getSysDate());
        }
        tmTenantSecondary.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)tmTenantSecondary.getSecondaryCode())) {
            tmTenantSecondary.setSecondaryCode(this.createUUIDString());
        }
    }

    private int getTenantSecondaryMaxCode() {
        int code = 0;
        try {
            return this.tmTenantSecondaryMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("tm.TmTenantSecondaryServiceImpl.getTenantSecondaryMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setTenantSecondaryUpdataDefault(TmTenantSecondary tmTenantSecondary) {
        if (null == tmTenantSecondary) {
            return;
        }
        tmTenantSecondary.setGmtModified(this.getSysDate());
        if (tmTenantSecondary.getGmtCreate() == null) {
            tmTenantSecondary.setGmtCreate(Calendar.getInstance().getTime());
        }
        if (StringUtils.isBlank((String)tmTenantSecondary.getSecondaryCode())) {
            tmTenantSecondary.setSecondaryCode(this.createUUIDString());
        }
        if (tmTenantSecondary.getDataState() == null) {
            tmTenantSecondary.setDataState(0);
        }
    }

    private void saveTenantSecondaryModel(TmTenantSecondary tmTenantSecondary) throws ApiException {
        if (null == tmTenantSecondary) {
            return;
        }
        try {
            this.tmTenantSecondaryMapper.insert(tmTenantSecondary);
        }
        catch (Exception e) {
            throw new ApiException("tm.TmTenantSecondaryServiceImpl.saveTenantSecondaryModel.ex", (Throwable)e);
        }
    }

    private TmTenantSecondary getTenantSecondaryModelById(Integer secondaryId) {
        if (null == secondaryId) {
            return null;
        }
        try {
            return this.tmTenantSecondaryMapper.selectByPrimaryKey(secondaryId);
        }
        catch (Exception e) {
            this.logger.error("tm.TmTenantSecondaryServiceImpl.getTenantSecondaryModelById", (Throwable)e);
            return null;
        }
    }

    public TmTenantSecondary getTenantSecondaryModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.tmTenantSecondaryMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("tm.TmTenantSecondaryServiceImpl.getTenantSecondaryModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delTenantSecondaryModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.tmTenantSecondaryMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("tm.TmTenantSecondaryServiceImpl.delTenantSecondaryModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("tm.TmTenantSecondaryServiceImpl.delTenantSecondaryModelByCode.num");
        }
    }

    private void deleteTenantSecondaryModel(Integer secondaryId) throws ApiException {
        if (null == secondaryId) {
            return;
        }
        int i = 0;
        try {
            i = this.tmTenantSecondaryMapper.deleteByPrimaryKey(secondaryId);
        }
        catch (Exception e) {
            throw new ApiException("tm.TmTenantSecondaryServiceImpl.deleteTenantSecondaryModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("tm.TmTenantSecondaryServiceImpl.deleteTenantSecondaryModel.num");
        }
    }

    private void updateTenantSecondaryModel(TmTenantSecondary tmTenantSecondary) throws ApiException {
        if (null == tmTenantSecondary) {
            return;
        }
        try {
            this.tmTenantSecondaryMapper.updateByPrimaryKeySelective(tmTenantSecondary);
        }
        catch (Exception e) {
            throw new ApiException("tm.TmTenantSecondaryServiceImpl.updateTenantSecondaryModel.ex", (Throwable)e);
        }
    }

    private void updateStateTenantSecondaryModel(Integer secondaryId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == secondaryId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("secondaryId", secondaryId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.tmTenantSecondaryMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("tm.TmTenantSecondaryServiceImpl.updateStateTenantSecondaryModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("tm.TmTenantSecondaryServiceImpl.updateStateTenantSecondaryModel.null");
        }
    }

    private TmTenantSecondary makeTenantSecondary(TmTenantSecondaryDomain tmTenantSecondaryDomain, TmTenantSecondary tmTenantSecondary) {
        if (null == tmTenantSecondaryDomain) {
            return null;
        }
        if (null == tmTenantSecondary) {
            tmTenantSecondary = new TmTenantSecondary();
        }
        try {
            BeanUtils.copyAllPropertys((Object)tmTenantSecondary, (Object)tmTenantSecondaryDomain);
            return tmTenantSecondary;
        }
        catch (Exception e) {
            this.logger.error("tm.TmTenantSecondaryServiceImpl.makeTenantSecondary", (Throwable)e);
            return null;
        }
    }

    private List<TmTenantSecondary> queryTenantSecondaryModelPage(Map<String, Object> parammap) {
        try {
            return this.tmTenantSecondaryMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("tm.TmTenantSecondaryServiceImpl.queryTenantSecondaryModel", (Throwable)e);
            return null;
        }
    }

    private int countTenantSecondary(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.tmTenantSecondaryMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("tm.TmTenantSecondaryServiceImpl.countTenantSecondary", (Throwable)e);
        }
        return i;
    }

    @Override
    public String saveTenantSecondary(TmTenantSecondaryDomain tmTenantSecondaryDomain) throws ApiException {
        String msg = this.checkTenantSecondary(tmTenantSecondaryDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("tm.TmTenantSecondaryServiceImpl.saveTenantSecondary.checkTenantSecondary", msg);
        }
        TmTenantSecondary tmTenantSecondary = this.makeTenantSecondary(tmTenantSecondaryDomain, null);
        this.setTenantSecondaryDefault(tmTenantSecondary);
        this.saveTenantSecondaryModel(tmTenantSecondary);
        return tmTenantSecondary.getSecondaryCode();
    }

    @Override
    public void updateTenantSecondaryState(Integer secondaryId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateTenantSecondaryModel(secondaryId, dataState, oldDataState);
    }

    @Override
    public void updateTenantSecondary(TmTenantSecondaryDomain tmTenantSecondaryDomain) throws ApiException {
        String msg = this.checkTenantSecondary(tmTenantSecondaryDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("tm.TmTenantSecondaryServiceImpl.updateTenantSecondary.checkTenantSecondary", msg);
        }
        TmTenantSecondary oldTmTenantSecondary = this.getTenantSecondaryModelById(tmTenantSecondaryDomain.getSecondaryId());
        if (null == oldTmTenantSecondary) {
            throw new ApiException("tm.TmTenantSecondaryServiceImpl.updateTenantSecondary.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        TmTenantSecondary tmTenantSecondary = this.makeTenantSecondary(tmTenantSecondaryDomain, oldTmTenantSecondary);
        this.setTenantSecondaryUpdataDefault(tmTenantSecondary);
        this.updateTenantSecondaryModel(tmTenantSecondary);
    }

    @Override
    public TmTenantSecondary getTenantSecondary(Integer secondaryId) {
        return this.getTenantSecondaryModelById(secondaryId);
    }

    @Override
    public void deleteTenantSecondary(Integer secondaryId) throws ApiException {
        this.deleteTenantSecondaryModel(secondaryId);
    }

    @Override
    public QueryResult<TmTenantSecondary> queryTenantSecondaryPage(Map<String, Object> map) {
        List<TmTenantSecondary> tmTenantSecondaryList = this.queryTenantSecondaryModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countTenantSecondary(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(tmTenantSecondaryList);
        return queryResult;
    }

    @Override
    public TmTenantSecondary getTenantSecondaryByCode(Map<String, Object> map) {
        return this.getTenantSecondaryModelByCode(map);
    }

    @Override
    public void delTenantSecondaryByCode(Map<String, Object> map) throws ApiException {
        this.delTenantSecondaryModelByCode(map);
    }

    @Override
    public void addTenantSecondary(String tenantCode, TmTenant tmTenantSearch) {
        if (StringUtils.isBlank((String)tenantCode) || tmTenantSearch == null) {
            this.logger.warn("IllegalArgument", (Object)"params is null");
            return;
        }
        TmTenant tmTenant = this.tmTenantMapper.getTenantByUnique(tmTenantSearch);
        if (tmTenant == null) {
            throw new ApiException("IllegalArgument", "tmTenantSearch can`t seach suitable record");
        }
        TmTenantSecondaryDomain tmTenantSecondary = new TmTenantSecondaryDomain();
        tmTenantSecondary.setTenantCode(tenantCode);
        tmTenantSecondary.setSecondaryTenantCode(tmTenant.getTenantCode());
        tmTenantSecondary.setSecondaryTenantCompname(tmTenant.getTenantCompname());
        tmTenantSecondary.setSecondaryMerchantType(tmTenant.getMerchantType());
        this.saveTenantSecondary(tmTenantSecondary);
    }

    @Override
    public TmTenantSecondary getTenantSecondaryByUnique(TmTenantSecondary tmTenantSecondarySearch) {
        if (tmTenantSecondarySearch == null) {
            throw new ApiException("ERROR", "query params can`t be null");
        }
        try {
            return this.tmTenantSecondaryMapper.selectByUnique(tmTenantSecondarySearch);
        }
        catch (Exception e) {
            this.logger.error("ERROR", (Object)"selectByUnique Fail", (Throwable)e);
            return null;
        }
    }

    @Override
    public List<String> getTenantCodeListByPage(Map<String, Object> map) {
        return this.tmTenantSecondaryMapper.getTenantCodeList(map);
    }

    @Override
    public Map<String, Object> countTmTenantSecondaryByCode(Map<String, Object> map) {
        try {
            Objects.requireNonNull(map);
            return this.tmTenantSecondaryMapper.countTmTenantSecondaryByCode(map);
        }
        catch (Exception e) {
            this.logger.error("ERROR", (Object)"count fail");
            return null;
        }
    }
}

