/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.tenantmanag.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tenantmanag.dao.TmScenerMapper;
import com.yqbsoft.laser.service.tenantmanag.domain.TmScenerDomain;
import com.yqbsoft.laser.service.tenantmanag.domain.TmScenerReDomain;
import com.yqbsoft.laser.service.tenantmanag.model.TmScener;
import com.yqbsoft.laser.service.tenantmanag.service.TmScenerService;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TmScenerServiceImpl
extends BaseServiceImpl
implements TmScenerService {
    private static final String SYS_CODE = "tm.TmScenerServiceImpl";
    private TmScenerMapper tmScenerMapper;

    public void setTmScenerMapper(TmScenerMapper tmScenerMapper) {
        this.tmScenerMapper = tmScenerMapper;
    }

    private Date getSysDate() {
        try {
            return this.tmScenerMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("tm.TmScenerServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkScener(TmScenerDomain tmScenerDomain) {
        if (null == tmScenerDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)tmScenerDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setScenerDefault(TmScener tmScener) {
        if (null == tmScener) {
            return;
        }
        if (null == tmScener.getDataState()) {
            tmScener.setDataState(0);
        }
        if (null == tmScener.getGmtCreate()) {
            tmScener.setGmtCreate(this.getSysDate());
        }
        tmScener.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)tmScener.getScenerCode())) {
            tmScener.setScenerCode(this.createUUIDString());
        }
    }

    private int getScenerMaxCode() {
        int code = 0;
        try {
            return this.tmScenerMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("tm.TmScenerServiceImpl.getScenerMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setScenerUpdataDefault(TmScener tmScener) {
        if (null == tmScener) {
            return;
        }
        tmScener.setGmtModified(this.getSysDate());
    }

    private void saveScenerModel(TmScener tmScener) throws ApiException {
        if (null == tmScener) {
            return;
        }
        try {
            this.tmScenerMapper.insert(tmScener);
        }
        catch (Exception e) {
            throw new ApiException("tm.TmScenerServiceImpl.saveScenerModel.ex", (Throwable)e);
        }
    }

    private void saveScenerBatchModel(List<TmScener> tmScenerList) throws ApiException {
        if (null == tmScenerList || tmScenerList.isEmpty()) {
            return;
        }
        try {
            this.tmScenerMapper.insertBatch(tmScenerList);
        }
        catch (Exception e) {
            throw new ApiException("tm.TmScenerServiceImpl.saveScenerBatchModel.ex", (Throwable)e);
        }
    }

    private TmScener getScenerModelById(Integer scenerId) {
        if (null == scenerId) {
            return null;
        }
        try {
            return this.tmScenerMapper.selectByPrimaryKey(scenerId);
        }
        catch (Exception e) {
            this.logger.error("tm.TmScenerServiceImpl.getScenerModelById", (Throwable)e);
            return null;
        }
    }

    private TmScener getScenerModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.tmScenerMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("tm.TmScenerServiceImpl.getScenerModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delScenerModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.tmScenerMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("tm.TmScenerServiceImpl.delScenerModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("tm.TmScenerServiceImpl.delScenerModelByCode.num");
        }
    }

    private void deleteScenerModel(Integer scenerId) throws ApiException {
        if (null == scenerId) {
            return;
        }
        int i = 0;
        try {
            i = this.tmScenerMapper.deleteByPrimaryKey(scenerId);
        }
        catch (Exception e) {
            throw new ApiException("tm.TmScenerServiceImpl.deleteScenerModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("tm.TmScenerServiceImpl.deleteScenerModel.num");
        }
    }

    private void updateScenerModel(TmScener tmScener) throws ApiException {
        if (null == tmScener) {
            return;
        }
        int i = 0;
        try {
            i = this.tmScenerMapper.updateByPrimaryKeySelective(tmScener);
        }
        catch (Exception e) {
            throw new ApiException("tm.TmScenerServiceImpl.updateScenerModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("tm.TmScenerServiceImpl.updateScenerModel.num");
        }
    }

    private void updateStateScenerModel(Integer scenerId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == scenerId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("scenerId", scenerId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.tmScenerMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("tm.TmScenerServiceImpl.updateStateScenerModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("tm.TmScenerServiceImpl.updateStateScenerModel.null");
        }
    }

    private void updateStateScenerModelByCode(String tenantCode, String scenerCode, Integer dataState, Integer oldDataState) throws ApiException {
        if (StringUtils.isBlank((String)scenerCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("scenerCode", scenerCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.tmScenerMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("tm.TmScenerServiceImpl.updateStateScenerModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("tm.TmScenerServiceImpl.updateStateScenerModelByCode.null");
        }
    }

    private TmScener makeScener(TmScenerDomain tmScenerDomain, TmScener tmScener) {
        if (null == tmScenerDomain) {
            return null;
        }
        if (null == tmScener) {
            tmScener = new TmScener();
        }
        try {
            BeanUtils.copyAllPropertys((Object)tmScener, (Object)tmScenerDomain);
            return tmScener;
        }
        catch (Exception e) {
            this.logger.error("tm.TmScenerServiceImpl.makeScener", (Throwable)e);
            return null;
        }
    }

    private TmScenerReDomain makeTmScenerReDomain(TmScener tmScener) {
        if (null == tmScener) {
            return null;
        }
        TmScenerReDomain tmScenerReDomain = new TmScenerReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)tmScenerReDomain, (Object)tmScener);
            return tmScenerReDomain;
        }
        catch (Exception e) {
            this.logger.error("tm.TmScenerServiceImpl.makeTmScenerReDomain", (Throwable)e);
            return null;
        }
    }

    private List<TmScener> queryScenerModelPage(Map<String, Object> parammap) {
        try {
            return this.tmScenerMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("tm.TmScenerServiceImpl.queryScenerModel", (Throwable)e);
            return null;
        }
    }

    private int countScener(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.tmScenerMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("tm.TmScenerServiceImpl.countScener", (Throwable)e);
        }
        return i;
    }

    private TmScener createTmScener(TmScenerDomain tmScenerDomain) {
        String msg = this.checkScener(tmScenerDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("tm.TmScenerServiceImpl.saveScener.checkScener", msg);
        }
        TmScener tmScener = this.makeScener(tmScenerDomain, null);
        this.setScenerDefault(tmScener);
        return tmScener;
    }

    @Override
    public String saveScener(TmScenerDomain tmScenerDomain) throws ApiException {
        TmScener tmScener = this.createTmScener(tmScenerDomain);
        this.saveScenerModel(tmScener);
        return tmScener.getScenerCode();
    }

    @Override
    public String saveScenerBatch(List<TmScenerDomain> tmScenerDomainList) throws ApiException {
        if (null == tmScenerDomainList || tmScenerDomainList.isEmpty()) {
            return null;
        }
        ArrayList<TmScener> tmScenerList = new ArrayList<TmScener>();
        String code = "";
        for (TmScenerDomain tmScenerDomain : tmScenerDomainList) {
            TmScener tmScener = this.createTmScener(tmScenerDomain);
            code = tmScener.getScenerCode();
            tmScenerList.add(tmScener);
        }
        this.saveScenerBatchModel(tmScenerList);
        return code;
    }

    @Override
    public void updateScenerState(Integer scenerId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateScenerModel(scenerId, dataState, oldDataState);
    }

    @Override
    public void updateScenerStateByCode(String tenantCode, String scenerCode, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateScenerModelByCode(tenantCode, scenerCode, dataState, oldDataState);
    }

    @Override
    public void updateScener(TmScenerDomain tmScenerDomain) throws ApiException {
        String msg = this.checkScener(tmScenerDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("tm.TmScenerServiceImpl.updateScener.checkScener", msg);
        }
        TmScener oldTmScener = this.getScenerModelById(tmScenerDomain.getScenerId());
        if (null == oldTmScener) {
            throw new ApiException("tm.TmScenerServiceImpl.updateScener.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        TmScener tmScener = this.makeScener(tmScenerDomain, oldTmScener);
        this.setScenerUpdataDefault(tmScener);
        this.updateScenerModel(tmScener);
    }

    @Override
    public TmScener getScener(Integer scenerId) {
        return this.getScenerModelById(scenerId);
    }

    @Override
    public void deleteScener(Integer scenerId) throws ApiException {
        this.deleteScenerModel(scenerId);
    }

    @Override
    public QueryResult<TmScener> queryScenerPage(Map<String, Object> map) {
        List<TmScener> tmScenerList = this.queryScenerModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countScener(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(tmScenerList);
        return queryResult;
    }

    @Override
    public TmScener getScenerByCode(String tenantCode, String scenerCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("scenerCode", scenerCode);
        return this.getScenerModelByCode(map);
    }

    @Override
    public void deleteScenerByCode(String tenantCode, String scenerCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("scenerCode", scenerCode);
        this.delScenerModelByCode(map);
    }
}

