/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.pos.term.handler;

import com.yqbsoft.laser.service.esb.core.log.OpenLogUtil;
import com.yqbsoft.laser.service.esb.core.spring.SpringApplicationContextUtil;
import com.yqbsoft.laser.service.pos.term.MngTxnEnum;
import com.yqbsoft.laser.service.pos.term.handler.TermMngHandler;
import com.yqbsoft.laser.service.pos.term.service.impl.PosMngTxnServiceImpl;
import com.yqbsoft.laser.service.pos.term.vo.MngMsg;
import java.util.concurrent.locks.ReentrantLock;

public class HandlerFactory {
    private static final OpenLogUtil logger = new OpenLogUtil(HandlerFactory.class);
    private TermMngHandler termMngHandle;
    private static HandlerFactory handlerFactory;
    private static ReentrantLock lock;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HandlerFactory newHandlerFactory() {
        if (handlerFactory == null) {
            try {
                lock.lock();
                if (handlerFactory == null) {
                    handlerFactory = new HandlerFactory();
                }
            }
            catch (Exception e) {
                logger.error("init handler factory error.", (Throwable)e);
            }
            finally {
                lock.unlock();
            }
        }
        return handlerFactory;
    }

    public TermMngHandler getMngHandler(MngMsg mngMsg, PosMngTxnServiceImpl mngTxnServiceImpl) {
        this.termMngHandle = (TermMngHandler)SpringApplicationContextUtil.getBean((String)MngTxnEnum.mngTxnEnumMap.get(mngMsg.getTxnNum()).getHandleName());
        if (null != this.termMngHandle) {
            this.termMngHandle.setMngMsg(mngMsg);
            this.termMngHandle.setMngTxnServiceImpl(mngTxnServiceImpl);
        }
        return this.termMngHandle;
    }

    static {
        lock = new ReentrantLock();
    }
}

