/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.pos.term.handler;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.log.OpenLogUtil;
import com.yqbsoft.laser.service.pos.term.TermConstants;
import com.yqbsoft.laser.service.pos.term.domain.PosMngTxnDomain;
import com.yqbsoft.laser.service.pos.term.model.PosTerm;
import com.yqbsoft.laser.service.pos.term.service.PosTermMngService;
import com.yqbsoft.laser.service.pos.term.service.PosTermService;
import com.yqbsoft.laser.service.pos.term.service.impl.PosMngTxnServiceImpl;
import com.yqbsoft.laser.service.pos.term.vo.MngMsg;
import com.yqbsoft.laser.service.tool.util.DateUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Map;

public abstract class TermMngHandler {
    protected final OpenLogUtil logger = new OpenLogUtil(this.getClass());
    public static final String SYS_CODE = "post.POS.TERM.PosTermAdminServiceImpl";
    private static final String COMMON_FLAG_BLANK = "20";
    protected String sysSeq;
    protected PosTerm posTerm;
    protected MngMsg mngMsg;
    protected PosTermService posTermService;
    protected PosTermMngService posTermMngService;
    protected PosMngTxnServiceImpl mngTxnServiceImpl;
    protected static String ACQ_INST_ID_CODE = "";

    public boolean termIsOk() {
        this.posTerm = this.posTermService.getPosTermByTermId(this.mngMsg.getCardAccptrTermnlId());
        return null != this.posTerm && "1".equals(this.posTerm.getTermValid());
    }

    public boolean initSysSeqNum(TermMngHandler termMngHandler) {
        String sysSeqNum = null;
        try {
            sysSeqNum = this.mngTxnServiceImpl.getNo(null, "t_pos_mng_txn", "cup_ssn", null);
        }
        catch (Exception e) {
            this.logger.info("post.POS.TERM.PosTermAdminServiceImpl.post. Generate sys seq num error.", (Object)e);
            return false;
        }
        if (StringUtils.isEmpty((String)sysSeqNum)) {
            return false;
        }
        this.sysSeq = sysSeqNum;
        return true;
    }

    protected void updateTermAndWriteMng(Map<String, Object> termParams, PosMngTxnDomain posMngTxnDomain) throws ApiException {
        termParams.put("termInfId", this.posTerm.getTermInfId());
        termParams.put("termId", this.posTerm.getTermId());
        termParams.put("termValid", this.posTerm.getTermValid());
        try {
            this.posTermMngService.updateTermMngTxn(termParams, posMngTxnDomain);
        }
        catch (Exception e) {
            this.mngMsg.setRespCode("96");
            throw new ApiException("Updating term or saving mngTxn error. txnNum:" + this.mngMsg.getTxnNum() + ",merchId:" + this.posTerm.getMchtCd() + ",termId:" + this.posTerm.getTermId());
        }
    }

    protected PosMngTxnDomain createPosMngTxnDomain() {
        PosMngTxnDomain posMngTxnDomain = new PosMngTxnDomain();
        posMngTxnDomain.setSysSeqNum(this.mngMsg.getTermSSN());
        posMngTxnDomain.setTxnNum(this.mngMsg.getTxnNum());
        posMngTxnDomain.setTransCode(TermConstants.TXN_NUM_TRANS_CODE.get(this.mngMsg.getTxnNum()));
        posMngTxnDomain.setInsertTime(DateUtil.getDateStr((String)"yyyyMMddHHmmss"));
        posMngTxnDomain.setUpdateTime(DateUtil.getDateStr((String)"yyyyMMddHHmmss"));
        posMngTxnDomain.setTimeLocalTrans(this.mngMsg.getTimeLocalTrans());
        posMngTxnDomain.setDateLocalTrans(this.mngMsg.getDateLocalTrans());
        posMngTxnDomain.setMsgSrcId(this.mngMsg.getMsgSrcId());
        posMngTxnDomain.setMsgDestId(this.mngMsg.getMsgDestId());
        posMngTxnDomain.setMsgType(this.mngMsg.getMsgType());
        posMngTxnDomain.setTransDateTime(this.mngMsg.getTransmsnDateTime());
        posMngTxnDomain.setCupSsn(this.sysSeq);
        posMngTxnDomain.setAcqInstIdCode(this.mngMsg.getAcqInstIdCode());
        posMngTxnDomain.setFwdInstIdCode(this.mngMsg.getFwdInstIdCode());
        posMngTxnDomain.setRespCode(this.mngMsg.getRespCode());
        return posMngTxnDomain;
    }

    public void rewriteMngMsg() {
        this.mngMsg.setRetrivlRefNum(this.sysSeq);
        this.mngMsg.setSysSeqNum(this.sysSeq);
        this.mngMsg.setTimeLocalTrans(DateUtil.getDateStr((String)"HHmmss"));
        this.mngMsg.setDateLocalTrans(DateUtil.getDateStr((String)"MMdd"));
        if (StringUtils.isEmpty((String)ACQ_INST_ID_CODE)) {
            ACQ_INST_ID_CODE = this.mngTxnServiceImpl.getSysParam("ACQINSTIDCODE", "1", "00");
        }
        this.mngMsg.setAcqInstIdCode(ACQ_INST_ID_CODE);
    }

    protected String getBlankStr(int length) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < length; ++i) {
            stringBuffer.append(COMMON_FLAG_BLANK);
        }
        return stringBuffer.toString();
    }

    protected String replaceStr(String orignStr, int start, int end, String value) {
        StringBuffer buffer = new StringBuffer(orignStr);
        buffer.replace(start, end, value);
        return buffer.toString();
    }

    public PosMngTxnServiceImpl getMngTxnServiceImpl() {
        return this.mngTxnServiceImpl;
    }

    public void setMngTxnServiceImpl(PosMngTxnServiceImpl mngTxnServiceImpl) {
        this.mngTxnServiceImpl = mngTxnServiceImpl;
    }

    public PosTermService getPosTermService() {
        return this.posTermService;
    }

    public void setPosTermService(PosTermService posTermService) {
        this.posTermService = posTermService;
    }

    public PosTermMngService getPosTermMngService() {
        return this.posTermMngService;
    }

    public void setPosTermMngService(PosTermMngService posTermMngService) {
        this.posTermMngService = posTermMngService;
    }

    public MngMsg getMngMsg() {
        return this.mngMsg;
    }

    public void setMngMsg(MngMsg mngMsg) {
        this.mngMsg = mngMsg;
    }

    public abstract void execute() throws Exception;
}

