/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.pos.term.handler;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.pos.term.TermConstants;
import com.yqbsoft.laser.service.pos.term.handler.TermMngHandler;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;

public class TmkUpdateApplyHandler
extends TermMngHandler {
    @Override
    public void execute() throws Exception {
        HashMap<String, Object> termParams = new HashMap<String, Object>();
        if (StringUtils.isEmpty((String)this.mngMsg.getSwitchingData())) {
            this.mngMsg.setRespCode("96");
            this.logger.error("post.POS.TERM.PosTermAdminServiceImpl.validateCheckNum. Request's random is empty.");
            throw new ApiException("post.POS.TERM.PosTermAdminServiceImpl.validateCheckNum. Request's random is empty.");
        }
        if (StringUtils.isEmpty((String)this.posTerm.getPsamId())) {
            this.logger.error("post.POS.TERM.PosTermAdminServiceImpl.validateCheckNum. The random is unapply or invalidation.");
            throw new ApiException("post.POS.TERM.PosTermAdminServiceImpl.validateCheckNum. The random is unapply or invalidation.");
        }
        String randomCode = "";
        try {
            randomCode = this.decryptRandomCode(this.posTerm.getTermId(), this.posTerm.getMchtCd(), this.posTerm.getTermIns(), this.mngMsg.getSwitchingData());
        }
        catch (Exception e) {
            this.logger.error("post.POS.TERM.PosTermAdminServiceImpl.validateCheckNum. Decrypt random code error.", (Throwable)e);
            this.mngMsg.setRespCode("96");
            throw new ApiException("post.POS.TERM.PosTermAdminServiceImpl.validateCheckNum. Decrypt random code error.");
        }
        if (StringUtils.isEmpty((String)randomCode)) {
            this.logger.error("post.POS.TERM.PosTermAdminServiceImpl.validateCheckNum. Decrypted random is null or error.");
            this.mngMsg.setRespCode("96");
            throw new ApiException("post.POS.TERM.PosTermAdminServiceImpl.validateCheckNum. Decrypted random is null");
        }
        if (!this.posTerm.getPsamId().equals(randomCode)) {
            this.mngMsg.setRespCode("96");
            throw new ApiException("post.POS.TERM.PosTermAdminServiceImpl.validateCheckNum. Random code differ.");
        }
        termParams.put("chkStaCond", this.posTerm.getChkSta());
        this.posTerm.setChkSta("S");
        termParams.put("chkSta", "S");
        this.updateTermAndWriteMng(termParams, this.createPosMngTxnDomain());
    }

    private String decryptRandomCode(String termId, String merchId, String instId, String cipherNum) throws Exception {
        ConcurrentHashMap<String, String> paramMap = new ConcurrentHashMap<String, String>();
        paramMap.put("termId", termId);
        paramMap.put("merchId", merchId);
        paramMap.put("instId", instId);
        paramMap.put("cipherNum", cipherNum);
        Object object = this.mngTxnServiceImpl.getInternalRouter().inInvoke("post.kms.checkRandNum", "1.0", "0", paramMap);
        if (object == null) {
            return null;
        }
        Object result = JsonUtil.getResultObject((String)((String)object));
        if (result == null) {
            return null;
        }
        String decrpytedCode = (String)result;
        Matcher matcher = TermConstants.REGEX_PRE_8_DIGIT.matcher(decrpytedCode);
        if (!matcher.find()) {
            return null;
        }
        decrpytedCode = decrpytedCode.substring(0, 8);
        return decrpytedCode;
    }
}

