/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.pos.term.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.pos.term.TermConstants;
import com.yqbsoft.laser.service.pos.term.domain.PosMngTxnDomain;
import com.yqbsoft.laser.service.pos.term.model.PosTerm;
import com.yqbsoft.laser.service.pos.term.service.PosTermAdminService;
import com.yqbsoft.laser.service.pos.term.service.PosTermMngService;
import com.yqbsoft.laser.service.pos.term.service.PosTermService;
import com.yqbsoft.laser.service.pos.term.vo.MngMsg;
import com.yqbsoft.laser.service.tool.util.DateUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import org.apache.commons.collections.CollectionUtils;

public class PosTermAdminServiceImpl
extends BaseServiceImpl
implements PosTermAdminService {
    public static final String SYS_CODE = "post.POS.TERM.PosTermAdminServiceImpl";
    private static String ACQ_INST_ID_CODE = "";
    private static final String COMMON_FLAG_BLANK = "20";
    private static final String PARAM_SEND_FIXED_CONTENT = "011021031041051116012991311468888888      1568888888      166880";
    private PosTermService posTermService;
    private PosTermMngService posTermMngService;

    @Override
    public MngMsg post(MngMsg mngMsg) throws ApiException {
        long start2;
        HashMap<String, Object> termParams;
        String sysSeqNum;
        PosTerm term;
        block34: {
            this.logger.info("[posAdmin]=====start=====");
            String termId = mngMsg.getCardAccptrTermnlId();
            this.logger.info("[posAdmin]termId:" + termId + ",TxnNum" + mngMsg.getTxnNum());
            term = this.posTermService.getPosTermByTermId(termId);
            if (null == term || !"1".equals(term.getTermValid())) {
                this.logger.error("post.POS.TERM.PosTermAdminServiceImpl.post. term is not valid.txnNum:" + mngMsg.getTxnNum() + ",termId:" + term.getTermId());
                mngMsg.setRespCode("97");
                return mngMsg;
            }
            try {
                sysSeqNum = this.getNo(null, "t_pos_mng_txn", "cup_ssn", null);
            }
            catch (Exception e) {
                this.logger.error("post.POS.TERM.PosTermAdminServiceImpl.post. Generate sys seq num error. txnNum:" + mngMsg.getTxnNum(), (Throwable)e);
                mngMsg.setRespCode(TermConstants.REQ_RSP_ERR.get(mngMsg.getTxnNum()));
                return mngMsg;
            }
            if (StringUtils.isEmpty((String)sysSeqNum)) {
                this.logger.error("post.POS.TERM.PosTermAdminServiceImpl.post. Sys seq num is null");
                mngMsg.setRespCode(TermConstants.REQ_RSP_ERR.get(mngMsg.getTxnNum()));
                return mngMsg;
            }
            mngMsg.setRetrivlRefNum(sysSeqNum);
            mngMsg.setSysSeqNum(sysSeqNum);
            if (StringUtils.isEmpty((String)ACQ_INST_ID_CODE)) {
                ACQ_INST_ID_CODE = this.getSysParam("ACQINSTIDCODE", "1", "00");
            }
            mngMsg.setAcqInstIdCode(ACQ_INST_ID_CODE);
            mngMsg.setTimeLocalTrans(DateUtil.getDateStr((String)"HHmmss"));
            mngMsg.setDateLocalTrans(DateUtil.getDateStr((String)"MMdd"));
            termParams = new HashMap<String, Object>();
            start2 = 0L;
            try {
                if ("8111".equals(mngMsg.getTxnNum())) {
                    this.signIn(mngMsg, term, termParams);
                    break block34;
                }
                if ("8121".equals(mngMsg.getTxnNum())) {
                    this.signOut(mngMsg, term, termParams);
                    break block34;
                }
                if ("8411".equals(mngMsg.getTxnNum())) {
                    this.downloadTmk(mngMsg, term, termParams);
                    break block34;
                }
                if ("8401".equals(mngMsg.getTxnNum())) {
                    this.checkRandomCode(mngMsg, term, termParams);
                    break block34;
                }
                if ("8031".equals(mngMsg.getTxnNum())) {
                    this.batchSettle(mngMsg, term, termParams);
                    break block34;
                }
                if ("8081".equals(mngMsg.getTxnNum())) {
                    this.batchUpload(mngMsg, term, termParams);
                } else if ("80B1".equals(mngMsg.getTxnNum())) {
                    this.icCaParaStateSend(mngMsg);
                } else if ("8061".equals(mngMsg.getTxnNum())) {
                    this.transParam(mngMsg);
                } else if ("8071".equals(mngMsg.getTxnNum())) {
                    this.icDownOver(mngMsg);
                } else if ("8041".equals(mngMsg.getTxnNum())) {
                    mngMsg.setRespCode("00");
                } else if ("80C1".equals(mngMsg.getTxnNum())) {
                    String blankStr = this.getBlankStr(161);
                    mngMsg.setAddtnlDataPrivate(blankStr);
                    mngMsg.setAddtnlDataPrivateLen("161");
                    if (StringUtils.isEmpty((String)mngMsg.getSwitchingData())) {
                        mngMsg.setSwitchingData(this.getBlankStr(512));
                        mngMsg.setSwitchingDataLen("512");
                    }
                    mngMsg.setRespCode("00");
                } else if ("80D1".equals(mngMsg.getTxnNum())) {
                    String blankStr = this.getBlankStr(161);
                    mngMsg.setAddtnlDataPrivate(blankStr);
                    mngMsg.setAddtnlDataPrivateLen("161");
                    mngMsg.setSwitchingData(this.getBlankStr(512));
                    mngMsg.setSwitchingDataLen("512");
                    mngMsg.setRespCode("00");
                } else if ("80E1".equals(mngMsg.getTxnNum())) {
                    mngMsg.setRespCode("00");
                    mngMsg.setSwitchingData(PARAM_SEND_FIXED_CONTENT);
                } else if ("80A1".equals(mngMsg.getTxnNum())) {
                    mngMsg.setRespCode("00");
                    mngMsg.setSwitchingData("0");
                } else {
                    mngMsg.setRespCode("99");
                }
                this.logger.info("[posAdmin]=====end=====");
                return mngMsg;
            }
            catch (Exception e) {
                this.logger.error("post.POS.TERM.PosTermAdminServiceImpl.post. Execute operation error. txnNum:" + mngMsg.getTxnNum() + ",merchId:" + term.getMchtCd() + ",termId:" + term.getTermId(), (Throwable)e);
                mngMsg.setRespCode(TermConstants.REQ_RSP_ERR.get(mngMsg.getTxnNum()));
                this.logger.info("[posAdmin]=====end=====");
                return mngMsg;
            }
        }
        mngMsg.setRespCode("00");
        PosMngTxnDomain mngTxnDomain = this.getPosMngTxnDomain(mngMsg, sysSeqNum, TermConstants.TXN_NUM_TRANS_CODE.get(mngMsg.getTxnNum()));
        termParams.put("termInfId", term.getTermInfId());
        termParams.put("termId", term.getTermId());
        termParams.put("termValid", term.getTermValid());
        try {
            this.posTermMngService.updateTermMngTxn(termParams, mngTxnDomain);
            long start3 = System.currentTimeMillis();
            this.logger.info("name:[PosTermAdminServiceImpl.post]===after update term===" + (start3 - start2) + "===");
        }
        catch (ApiException penApiException) {
            this.logger.error("post.POS.TERM.PosTermAdminServiceImpl.post. Updating term or saving mngTxn error. txnNum:" + mngMsg.getTxnNum() + ",merchId:" + term.getMchtCd() + ",termId:" + term.getTermId(), (Throwable)penApiException);
            mngMsg.setRespCode(TermConstants.REQ_RSP_ERR.get(mngMsg.getTxnNum()));
        }
        catch (Exception e) {
            this.logger.error("post.POS.TERM.PosTermAdminServiceImpl.post." + e.getMessage());
            mngMsg.setRespCode(TermConstants.REQ_RSP_ERR.get(mngMsg.getTxnNum()));
        }
        this.logger.info("[posAdmin]=====end=====");
        return mngMsg;
    }

    private String getBlankStr(int length) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < length; ++i) {
            stringBuffer.append(COMMON_FLAG_BLANK);
        }
        return stringBuffer.toString();
    }

    private void checkRandomCode(MngMsg mngMsg, PosTerm term, Map<String, Object> termParams) throws ApiException {
        if (StringUtils.isEmpty((String)mngMsg.getSwitchingData())) {
            mngMsg.setRespCode("96");
            this.logger.error("post.POS.TERM.PosTermAdminServiceImpl.validateCheckNum. Request's random is empty.");
            throw new ApiException("post.POS.TERM.PosTermAdminServiceImpl.validateCheckNum. Request's random is empty.");
        }
        if (StringUtils.isEmpty((String)term.getPsamId())) {
            this.logger.error("post.POS.TERM.PosTermAdminServiceImpl.validateCheckNum. The random is unapply or invalidation.");
            throw new ApiException("post.POS.TERM.PosTermAdminServiceImpl.validateCheckNum. The random is unapply or invalidation.");
        }
        String randomCode = "";
        try {
            randomCode = this.decryptRandomCode(term.getTermId(), term.getMchtCd(), term.getTermIns(), mngMsg.getSwitchingData());
        }
        catch (Exception e) {
            this.logger.error("post.POS.TERM.PosTermAdminServiceImpl.validateCheckNum. Decrypt random code error.", (Throwable)e);
            mngMsg.setRespCode("96");
            throw new ApiException("post.POS.TERM.PosTermAdminServiceImpl.validateCheckNum. Decrypt random code error.");
        }
        if (StringUtils.isEmpty((String)randomCode)) {
            this.logger.error("post.POS.TERM.PosTermAdminServiceImpl.validateCheckNum. Decrypted random is null or error.");
            mngMsg.setRespCode("96");
            throw new ApiException("post.POS.TERM.PosTermAdminServiceImpl.validateCheckNum. Decrypted random is null");
        }
        if (!term.getPsamId().equals(randomCode)) {
            mngMsg.setRespCode("96");
            throw new ApiException("post.POS.TERM.PosTermAdminServiceImpl.validateCheckNum. Random code differ.");
        }
        termParams.put("chkStaCond", term.getChkSta());
        term.setChkSta("S");
        termParams.put("chkSta", "S");
    }

    private void downloadTmk(MngMsg mngMsg, PosTerm term, Map<String, Object> termParams) throws ApiException {
        if (!term.getChkSta().equals("S")) {
            mngMsg.setRespCode("96");
            this.logger.error("\u968f\u673a\u6570\u6821\u9a8c\u72b6\u6001\u4e0d\u5bf9\u6216\u5df2\u7ecf\u4e0b\u8f7d\u8fc7TMK,\u968f\u673a\u7801\u6821\u9a8c\u72b6\u6001:" + term.getChkSta());
        }
        String tmk = null;
        try {
            tmk = this.updateTMK(term.getTermId(), term.getMchtCd(), term.getTermIns(), mngMsg.getSwitchingData());
        }
        catch (Exception e) {
            this.logger.error("post.POS.TERM.PosTermAdminServiceImpl.applyTmk. Update tmk error", (Throwable)e);
            mngMsg.setRespCode("96");
            throw new ApiException("post.POS.TERM.PosTermAdminServiceImpl.applyTmk. Update tmk error");
        }
        if (StringUtils.isEmpty((String)tmk)) {
            this.logger.error("post.POS.TERM.PosTermAdminServiceImpl.applyTmk. Tmk is null");
            mngMsg.setRespCode("96");
            throw new ApiException("post.POS.TERM.PosTermAdminServiceImpl.applyTmk. Tmk is null");
        }
        mngMsg.setSwitchingData(tmk);
        termParams.put("chkStaCond", term.getChkSta());
        term.setChkSta("D");
        termParams.put("chkSta", "D");
    }

    private void signIn(MngMsg mngMsg, PosTerm term, Map<String, Object> termParams) throws ApiException {
        String keyInf = null;
        try {
            keyInf = this.updateWmk(term.getTermId(), term.getMchtCd(), term.getTermIns());
        }
        catch (Exception e) {
            this.logger.error("post.POS.TERM.PosTermAdminServiceImpl.signIn. Update work master key error.", (Throwable)e);
            mngMsg.setRespCode("91");
            throw new ApiException("post.POS.TERM.PosTermAdminServiceImpl.signIn. Update work master key error.");
        }
        if (StringUtils.isEmpty((String)keyInf)) {
            this.logger.error("post.POS.TERM.PosTermAdminServiceImpl.signIn. work master key is null.");
            mngMsg.setRespCode("91");
            throw new ApiException("post.POS.TERM.PosTermAdminServiceImpl.signIn. Work master key is null.");
        }
        termParams.put("termSignStaCond", term.getTermSignSta());
        term.setTermSignSta("1");
        termParams.put("termSignSta", "1");
        mngMsg.setFldReserved(this.replaceStr(mngMsg.getFldReserved(), 2, 8, term.getTermBatchNm()));
        mngMsg.setSwitchingData(keyInf);
    }

    private void icDownOver(MngMsg mngMsg) throws ApiException {
        String fldReserved = mngMsg.getFldReserved().substring(8, 11);
        if ("371".equals(fldReserved)) {
            mngMsg.setRespCode("00");
        } else if ("381".equals(fldReserved)) {
            mngMsg.setRespCode("00");
        }
    }

    private void icCaParaStateSend(MngMsg mngMsg) throws ApiException {
        String fldReserved = mngMsg.getFldReserved().substring(8, 11);
        StringBuffer buffer = new StringBuffer();
        if ("372".equals(fldReserved)) {
            ConcurrentHashMap<String, String> paramMap = new ConcurrentHashMap<String, String>();
            paramMap.put("usageKey", "1");
            Object result = null;
            try {
                result = this.getInternalRouter().inInvoke("post.baseinfo.getEmvParasByKey", "1.0", "0", paramMap);
            }
            catch (Exception e) {
                this.logger.error("post.POS.TERM.PosTermAdminServiceImpl.transParam. get ic ca err. sys err.");
                mngMsg.setRespCode("96");
                throw new ApiException("post.POS.TERM.PosTermAdminServiceImpl.transParam. get ic ca err. sys err.");
            }
            if (null == result) {
                this.logger.error("post.POS.TERM.PosTermAdminServiceImpl.transParam. get ic ca err. ic ca is empty.");
                mngMsg.setRespCode("96");
                throw new ApiException("post.POS.TERM.PosTermAdminServiceImpl.transParam. get ic ca err. ic ca is empty.");
            }
            List emvs = (List)JsonUtil.buildNormalBinder().getJsonToList(String.valueOf(result), Map.class);
            if (!CollectionUtils.isEmpty((Collection)emvs)) {
                buffer.append("31");
                for (Map emvMap : emvs) {
                    if (!MapUtil.isNotEmpty((Map)emvMap) || null == emvMap.get("paraVal") || ((String)emvMap.get("paraVal")).length() < 46) continue;
                    buffer.append(((String)emvMap.get("paraVal")).substring(0, 46));
                }
            } else {
                buffer.append("30");
            }
        } else if ("382".equals(fldReserved)) {
            ConcurrentHashMap<String, String> paramMap = new ConcurrentHashMap<String, String>();
            paramMap.put("usageKey", "0");
            Object result = null;
            try {
                result = this.getInternalRouter().inInvoke("post.baseinfo.getEmvParasByKey", "1.0", "0", paramMap);
            }
            catch (Exception e) {
                this.logger.error("post.POS.TERM.PosTermAdminServiceImpl.transParam. get ic param err. sys err.");
                mngMsg.setRespCode("96");
                throw new ApiException("post.POS.TERM.PosTermAdminServiceImpl.transParam. get ic param err. sys err.");
            }
            if (null == result) {
                this.logger.error("post.POS.TERM.PosTermAdminServiceImpl.transParam. get ic param err. ic param is empty.");
                mngMsg.setRespCode("96");
                throw new ApiException("post.POS.TERM.PosTermAdminServiceImpl.transParam. get ic param err. ic param is empty.");
            }
            List emvs = (List)JsonUtil.buildNormalBinder().getJsonToList(String.valueOf(result), Map.class);
            if (!CollectionUtils.isEmpty((Collection)emvs)) {
                buffer.append("31");
                for (Map emvMap : emvs) {
                    if (!MapUtil.isNotEmpty((Map)emvMap) || null == emvMap.get("paraVal") || ((String)emvMap.get("paraVal")).length() < 22) continue;
                    buffer.append(((String)emvMap.get("paraVal")).substring(0, 22));
                }
            } else {
                buffer.append("30");
            }
        }
        mngMsg.setSwitchingData(buffer.toString());
        mngMsg.setF062Ind(true);
        mngMsg.setRespCode("00");
    }

    private void transParam(MngMsg mngMsg) throws ApiException {
        String fldReserved = mngMsg.getFldReserved().substring(8, 11);
        if ("370".equals(fldReserved)) {
            ConcurrentHashMap<String, String> paramMap = new ConcurrentHashMap<String, String>();
            paramMap.put("usageKey", "1");
            String tlvKey = mngMsg.getSwitchingData().substring(0, 24);
            paramMap.put("paraValue", tlvKey);
            Object result = null;
            try {
                result = this.getInternalRouter().inInvoke("post.baseinfo.getEmvParaByKeyAndValue", "1.0", "0", paramMap);
            }
            catch (Exception e) {
                this.logger.error("post.POS.TERM.PosTermAdminServiceImpl.transParam. get ic ca err. sys err.");
                mngMsg.setRespCode("96");
                throw new ApiException("post.POS.TERM.PosTermAdminServiceImpl.transParam. get ic ca err. sys err.");
            }
            if (null == result) {
                mngMsg.setSwitchingData(StringUtils.fillLeft((String)"", (char)'0', (int)512));
                return;
            }
            Map emvPara = (Map)JsonUtil.buildNormalBinder().getJsonToMap(String.valueOf(result), String.class, Object.class);
            mngMsg.setSwitchingData("31" + emvPara.get("paraVal"));
            mngMsg.setF062Ind(true);
            mngMsg.setFldReserved(this.replaceStr(mngMsg.getFldReserved(), 8, 11, "371"));
        } else if ("380".equals(fldReserved)) {
            ConcurrentHashMap<String, String> paramMap = new ConcurrentHashMap<String, String>();
            paramMap.put("usageKey", "0");
            String paraId = mngMsg.getSwitchingData().substring(6, 22);
            paramMap.put("paraId", paraId);
            Object result = null;
            try {
                result = this.getInternalRouter().inInvoke("post.baseinfo.getEmvParaByKeyAndParaId", "1.0", "0", paramMap);
            }
            catch (Exception e) {
                this.logger.error("post.POS.TERM.PosTermAdminServiceImpl.transParam. get ic ca err. sys err.");
                mngMsg.setRespCode("96");
                throw new ApiException("post.POS.TERM.PosTermAdminServiceImpl.transParam. get ic ca err. sys err.");
            }
            if (null == result) {
                mngMsg.setSwitchingData(StringUtils.fillLeft((String)"", (char)'0', (int)512));
                return;
            }
            Map emvPara = JsonUtil.getJsonToMap((String)String.valueOf(result));
            mngMsg.setSwitchingData("31" + (String)emvPara.get("paraVal"));
            mngMsg.setF062Ind(true);
            mngMsg.setFldReserved(this.replaceStr(mngMsg.getFldReserved(), 8, 11, "381"));
        }
        mngMsg.setRespCode("00");
    }

    private String replaceStr(String orignStr, int start, int end, String value) {
        StringBuffer buffer = new StringBuffer(orignStr);
        buffer.replace(start, end, value);
        return buffer.toString();
    }

    private void batchSettle(MngMsg mngMsg, PosTerm term, Map<String, Object> termParams) throws ApiException {
        StringBuffer stringBuffer = new StringBuffer(mngMsg.getAddtnlDataPrivate());
        if (!term.getTermSignSta().equals("1")) {
            mngMsg.setRespCode("77");
            stringBuffer.setCharAt(30, '3');
            stringBuffer.setCharAt(61, '3');
            mngMsg.setAddtnlDataPrivate(stringBuffer.toString());
            this.logger.error("post.POS.TERM.PosTermAdminServiceImpl.batchSettle. term is not signed.");
            throw new ApiException("post.POS.TERM.PosTermAdminServiceImpl.batchSettle. Term is not signed.");
        }
        stringBuffer.setCharAt(30, '1');
        stringBuffer.setCharAt(61, '1');
        mngMsg.setAddtnlDataPrivate(stringBuffer.toString());
        String posBatchNo = mngMsg.getFldReserved().substring(2, 8);
        if (!posBatchNo.equals(term.getTermBatchNm())) {
            mngMsg.setRespCode("77");
            this.logger.error("post.POS.TERM.PosTermAdminServiceImpl.batchSettle. Term's batchNo not match. db's batchNo:" + term.getTermBatchNm() + ",pos's batchNod:" + posBatchNo);
        }
        String batchNo = "";
        batchNo = "999999".equals(term.getTermBatchNm()) ? "000001" : StringUtils.fillLeft((String)String.valueOf(Long.parseLong(term.getTermBatchNm()) + 1L), (char)'0', (int)6);
        termParams.put("termBatchNmCond", term.getTermBatchNm());
        termParams.put("termParaCond", term.getTermPara());
        term.setTermBatchNm(batchNo);
        term.setTermPara(batchNo);
        termParams.put("termBatchNm", batchNo);
        termParams.put("termPara", batchNo);
        mngMsg.setDateSettlmt(DateUtil.getDateStr((String)"MMdd"));
        mngMsg.setFldReserved(this.replaceStr(mngMsg.getFldReserved(), 2, 8, term.getTermBatchNm()));
    }

    private void batchUpload(MngMsg mngMsg, PosTerm term, Map<String, Object> termParams) {
        mngMsg.setFldReserved(this.replaceStr(mngMsg.getFldReserved(), 8, 11, "207"));
        mngMsg.setTimeLocalTrans(DateUtil.getDateStr((String)"HHmmss"));
        mngMsg.setDateLocalTrans(DateUtil.getDateStr((String)"MMdd"));
        mngMsg.setRespCode("00");
    }

    private void signOut(MngMsg mngMsg, PosTerm term, Map<String, Object> termParams) throws ApiException {
        termParams.put("termSignStaCond", term.getTermSignSta());
        term.setTermSignSta("0");
        termParams.put("termSignSta", "0");
    }

    private PosMngTxnDomain getPosMngTxnDomain(MngMsg mngMsg, String sysSeqNum, String transCode) {
        PosMngTxnDomain posMngTxnDomain = new PosMngTxnDomain();
        posMngTxnDomain.setSysSeqNum(mngMsg.getTermSSN());
        posMngTxnDomain.setTxnNum(mngMsg.getTxnNum());
        posMngTxnDomain.setTransCode(transCode);
        posMngTxnDomain.setInsertTime(DateUtil.getDateStr((String)"yyyyMMddHHmmss"));
        posMngTxnDomain.setUpdateTime(DateUtil.getDateStr((String)"yyyyMMddHHmmss"));
        posMngTxnDomain.setTimeLocalTrans(mngMsg.getTimeLocalTrans());
        posMngTxnDomain.setDateLocalTrans(mngMsg.getDateLocalTrans());
        posMngTxnDomain.setMsgSrcId(mngMsg.getMsgSrcId());
        posMngTxnDomain.setMsgDestId(mngMsg.getMsgDestId());
        posMngTxnDomain.setMsgType(mngMsg.getMsgType());
        posMngTxnDomain.setTransDateTime(mngMsg.getTransmsnDateTime());
        posMngTxnDomain.setCupSsn(sysSeqNum);
        posMngTxnDomain.setAcqInstIdCode(mngMsg.getAcqInstIdCode());
        posMngTxnDomain.setFwdInstIdCode(mngMsg.getFwdInstIdCode());
        posMngTxnDomain.setRespCode(mngMsg.getRespCode());
        return posMngTxnDomain;
    }

    private String updateWmk(String termId, String merchId, String instId) throws Exception {
        ConcurrentHashMap<String, String> paramMap = new ConcurrentHashMap<String, String>();
        paramMap.put("termId", termId);
        paramMap.put("merchId", merchId);
        paramMap.put("instId", instId);
        Object object = this.getInternalRouter().inInvoke("post.kms.updateWorkKey", "1.0", "0", paramMap);
        if (object == null) {
            return null;
        }
        Object result = JsonUtil.getResultObject((String)((String)object));
        return result == null ? null : (String)result;
    }

    private String decryptRandomCode(String termId, String merchId, String instId, String cipherNum) throws Exception {
        ConcurrentHashMap<String, String> paramMap = new ConcurrentHashMap<String, String>();
        paramMap.put("termId", termId);
        paramMap.put("merchId", merchId);
        paramMap.put("instId", instId);
        paramMap.put("cipherNum", cipherNum);
        Object object = this.getInternalRouter().inInvoke("post.kms.checkRandNum", "1.0", "0", paramMap);
        if (object == null) {
            return null;
        }
        Object result = JsonUtil.getResultObject((String)((String)object));
        if (result == null) {
            return null;
        }
        String decrpytedCode = (String)result;
        Matcher matcher = TermConstants.REGEX_PRE_8_DIGIT.matcher(decrpytedCode);
        if (!matcher.find()) {
            return null;
        }
        decrpytedCode = decrpytedCode.substring(0, 8);
        return decrpytedCode;
    }

    private String updateTMK(String termId, String merchId, String instId, String klkCipherA) throws Exception {
        ConcurrentHashMap<String, String> paramMap = new ConcurrentHashMap<String, String>();
        paramMap.put("termId", termId);
        paramMap.put("merchId", merchId);
        paramMap.put("instId", instId);
        paramMap.put("klkCipherA", klkCipherA);
        Object object = this.getInternalRouter().inInvoke("post.kms.updateTMK", "1.0", "0", paramMap);
        if (object == null) {
            return null;
        }
        Object result = JsonUtil.getResultObject((String)((String)object));
        if (result == null) {
            return null;
        }
        String decrpytedTmk = (String)result;
        return decrpytedTmk;
    }

    public PosTermService getPosTermService() {
        return this.posTermService;
    }

    public void setPosTermService(PosTermService posTermService) {
        this.posTermService = posTermService;
    }

    public PosTermMngService getPosTermMngService() {
        return this.posTermMngService;
    }

    public void setPosTermMngService(PosTermMngService posTermMngService) {
        this.posTermMngService = posTermMngService;
    }
}

