/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.pos.term.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.dd.DdTransUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.pos.term.dao.PosTermInfTmpMapper;
import com.yqbsoft.laser.service.pos.term.dao.PosTermMapper;
import com.yqbsoft.laser.service.pos.term.dao.PosTermMngMapper;
import com.yqbsoft.laser.service.pos.term.domain.PosTermDomain;
import com.yqbsoft.laser.service.pos.term.model.PosTerm;
import com.yqbsoft.laser.service.pos.term.model.PosTermInfTmp;
import com.yqbsoft.laser.service.pos.term.service.PosTermService;
import com.yqbsoft.laser.service.pos.term.vo.CityCodeVo;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;

public class PosTermServiceImpl
extends BaseServiceImpl
implements PosTermService {
    public static final String SYS_CODE = "post.POS.TERM.PosTermServiceImpl";
    private PosTermMapper posTermMapper;
    private PosTermInfTmpMapper posTermInfTmpMapper;
    private PosTermMngMapper posTermMngMapper;
    public static final String PROVINCE_MAP_KEY = "0000";
    private static final String CACHECITYCODE_PROVINCE = "CACHE_PROVINCE";
    private static final String CACHECITYCODE_CITY = "CACHE_CITY";
    private static final String CACHECITYCODE_AREA = "CACHE_AREA";
    private static final String PROPTP_KEY = "PosTermInf-propTp";
    private static final String DIALTP_KEY = "PosTermInf-dialTp";
    private static final String TERMTP_KEY = "PosTermInf-termTp";
    private static final String TERMFACTORY_KEY = "PosTermInf-termFactory";

    public void setPosTermInfTmpMapper(PosTermInfTmpMapper posTermInfTmpMapper) {
        this.posTermInfTmpMapper = posTermInfTmpMapper;
    }

    public void setPosTermMngMapper(PosTermMngMapper posTermMngMapper) {
        this.posTermMngMapper = posTermMngMapper;
    }

    public void setPosTermMapper(PosTermMapper posTermMapper) {
        this.posTermMapper = posTermMapper;
    }

    private Date getSysDate() {
        try {
            return this.posTermMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("post.POS.TERM.PosTermServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkPosTerm(PosTermDomain posTermDomain) {
        if (null == posTermDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        return msg;
    }

    private void setPosTermDefault(PosTerm posTerm) {
        if (null == posTerm) {
            return;
        }
        if (null == posTerm.getDataState()) {
            posTerm.setDataState(0);
        }
        if (null == posTerm.getGmtCreate()) {
            posTerm.setGmtCreate(this.getSysDate());
        }
        posTerm.setGmtModified(this.getSysDate());
    }

    private void setPosTermUpdataDefault(PosTerm posTerm) {
        if (null == posTerm) {
            return;
        }
        posTerm.setGmtModified(this.getSysDate());
    }

    private void savePosTermModel(PosTerm posTerm) throws ApiException {
        if (null == posTerm) {
            return;
        }
        try {
            this.posTermMapper.insert(posTerm);
        }
        catch (Exception e) {
            throw new ApiException("post.POS.TERM.PosTermServiceImpl.savePosTermModel.ex");
        }
    }

    private PosTerm getPosTermModelById(Integer termInfId) {
        if (null == termInfId) {
            return null;
        }
        try {
            return this.posTermMapper.selectByPrimaryKey(termInfId);
        }
        catch (Exception e) {
            this.logger.error("post.POS.TERM.PosTermServiceImpl.getPosTermModelById", (Throwable)e);
            return null;
        }
    }

    private void deletePosTermModel(Integer termInfId) throws ApiException {
        if (null == termInfId) {
            return;
        }
        int i = 0;
        try {
            i = this.posTermMapper.deleteByPrimaryKey(termInfId);
        }
        catch (Exception e) {
            throw new ApiException("post.POS.TERM.PosTermServiceImpl.deletePosTermModel.ex");
        }
        if (1 != i) {
            throw new ApiException("post.POS.TERM.PosTermServiceImpl.deletePosTermModel.num");
        }
    }

    private void updatePosTermModel(PosTerm posTerm) throws ApiException {
        if (null == posTerm) {
            return;
        }
        try {
            this.posTermMapper.updateByPrimaryKeySelective(posTerm);
        }
        catch (Exception e) {
            throw new ApiException("post.POS.TERM.PosTermServiceImpl.updatePosTermModel.ex");
        }
    }

    private void updateStatePosTermModel(Integer termInfId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == termInfId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("termInfId", termInfId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.posTermMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("post.POS.TERM.PosTermServiceImpl.updateStatePosTermModel.ex");
        }
        if (i <= 0) {
            throw new ApiException("post.POS.TERM.PosTermServiceImpl.updateStatePosTermModel.null");
        }
    }

    private void updateAdminState(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.posTermMapper.updateAdminState(map);
        }
        catch (Exception e) {
            throw new ApiException("post.POS.TERM.PosTermServiceImpl.updatePosTermAdminState.ex");
        }
        if (i <= 0) {
            throw new ApiException("post.POS.TERM.PosTermServiceImpl.updatePosTermAdminState.null");
        }
    }

    @Override
    public void updateTermByKey(Map<String, Object> termParams) throws ApiException {
        this.updateTerm(termParams);
    }

    private void updateTerm(Map<String, Object> termParams) throws ApiException {
        int rows = 0;
        try {
            rows = this.posTermMngMapper.updateTermByKey(termParams);
        }
        catch (Exception e) {
            throw new ApiException("post.POS.TERM.PosTermServiceImpl.updateTermByKey.ex");
        }
        if (rows <= 0) {
            this.logger.error("update term error.param:" + termParams);
            throw new ApiException("post.POS.TERM.PosTermServiceImpl.updateTermByKey.null");
        }
    }

    private PosTerm makePosTerm(PosTermDomain posTermDomain, PosTerm posTerm) {
        if (null == posTermDomain) {
            return null;
        }
        if (null == posTerm) {
            posTerm = new PosTerm();
        }
        try {
            BeanUtils.copyAllPropertys((Object)posTerm, (Object)posTermDomain);
        }
        catch (Exception e) {
            this.logger.error("post.POS.TERM.PosTermServiceImpl.makePosTerm", (Throwable)e);
        }
        return posTerm;
    }

    private List<PosTerm> queryPosTermModelPage(Map<String, Object> parammap) {
        try {
            return this.posTermMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("post.POS.TERM.PosTermServiceImpl.queryPosTermModel", (Throwable)e);
            return null;
        }
    }

    private List<PosTerm> queryTermKeyIussueApply(Map<String, Object> parammap) {
        try {
            return this.posTermMapper.queryTermKeyIussueApply(parammap);
        }
        catch (Exception e) {
            this.logger.error("post.POS.TERM.PosTermServiceImpl.queryPosTermModel", (Throwable)e);
            return null;
        }
    }

    private List<PosTerm> queryTermBySta(Map<String, Object> parammap) {
        try {
            return this.posTermMapper.queryTermByState(parammap);
        }
        catch (Exception e) {
            this.logger.error("post.POS.TERM.PosTermServiceImpl.queryPosTermModel", (Throwable)e);
            return null;
        }
    }

    private int countPosTerm(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.posTermMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("post.POS.TERM.PosTermServiceImpl.countPosTerm", (Throwable)e);
        }
        return i;
    }

    private int countValidTerm(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.posTermMapper.countValidTerm(map);
        }
        catch (Exception e) {
            this.logger.error("post.POS.TERM.PosTermServiceImpl.countPosTerm", (Throwable)e);
        }
        return i;
    }

    private int coutTermKeyIussueApply(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.posTermMapper.coutTermKeyIussueApply(map);
        }
        catch (Exception e) {
            this.logger.error("post.POS.TERM.PosTermServiceImpl.countPosTerm", (Throwable)e);
        }
        return i;
    }

    private int countByStates(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.posTermMapper.countByStates(map);
        }
        catch (Exception e) {
            this.logger.error("post.POS.TERM.PosTermServiceImpl.countByStates", (Throwable)e);
        }
        return i;
    }

    @Override
    public void savePosTerm(PosTermDomain posTermDomain) throws ApiException {
        String msg = this.checkPosTerm(posTermDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("post.POS.TERM.PosTermServiceImpl.savePosTerm.checkPosTerm", msg);
        }
        PosTerm posTerm = this.makePosTerm(posTermDomain, null);
        this.setPosTermDefault(posTerm);
        this.savePosTermModel(posTerm);
    }

    @Override
    public Integer savePosTermReturnId(PosTermDomain posTermDomain) throws ApiException {
        String msg = this.checkPosTerm(posTermDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("post.POS.TERM.PosTermServiceImpl.savePosTerm.checkPosTerm", msg);
        }
        PosTerm posTerm = this.makePosTerm(posTermDomain, null);
        this.setPosTermDefault(posTerm);
        this.savePosTermModel(posTerm);
        return posTerm.getTermInfId();
    }

    @Override
    public PosTermDomain savePosTermReturnDomain(PosTermDomain posTermDomain) throws ApiException {
        String msg = this.checkPosTerm(posTermDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("post.POS.TERM.PosTermServiceImpl.savePosTerm.checkPosTerm", msg);
        }
        PosTerm posTerm = this.makePosTerm(posTermDomain, null);
        this.setPosTermDefault(posTerm);
        this.savePosTermModel(posTerm);
        posTermDomain.setTermInfId(posTerm.getTermInfId());
        return posTermDomain;
    }

    @Override
    public void updatePosTermState(Integer termInfId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStatePosTermModel(termInfId, dataState, oldDataState);
    }

    @Override
    public void updatePosTermAdminState(Integer termInfId, String targetState, String currentState, String tmpState) throws ApiException {
        if (null == termInfId || StringUtils.isEmpty((String)targetState) || StringUtils.isEmpty((String)currentState) || StringUtils.isEmpty((String)tmpState)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("termInfId", termInfId);
        map.put("targetState", targetState);
        map.put("currentState", currentState);
        map.put("tmpState", tmpState);
        this.updateAdminState(map);
    }

    @Override
    public void updatePosTermStateInWf(Integer termInfId, String targetState, String currentState) throws ApiException {
        if (null == termInfId || StringUtils.isEmpty((String)targetState) || StringUtils.isEmpty((String)currentState)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("termInfId", termInfId);
        map.put("targetState", targetState);
        map.put("currentState", currentState);
        if ("9".equals(targetState)) {
            PosTerm posTerm = this.getPosTermModelById(termInfId);
            if ("1".equals(posTerm.getTermValid()) && "2".equals(posTerm.getTermSta())) {
                PosTermInfTmp posTermInfTmp = this.posTermInfTmpMapper.selectByPrimaryKey(posTerm.getTermTmpId());
                try {
                    BeanUtils.copyAllPropertysNotNull((Object)posTerm, (Object)posTermInfTmp);
                    posTerm.setTermSta("9");
                    this.updatePosTermModel(posTerm);
                }
                catch (Exception e) {
                    this.logger.error("recovery backup term error.", (Throwable)e);
                    throw new ApiException("post.POS.TERM.PosTermServiceImpl.updatePosTermAdminState.ex");
                }
            }
        } else {
            if ("1".equals(targetState)) {
                map.put("termValid", "1");
            } else if ("4".equals(targetState)) {
                map.put("termValid", "0");
            }
            this.updateStateInWf(map);
        }
    }

    private void updateStateInWf(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.posTermMapper.updateStateInWf(map);
        }
        catch (Exception e) {
            throw new ApiException("post.POS.TERM.PosTermServiceImpl.updatePosTermAdminState.ex");
        }
        if (i <= 0) {
            throw new ApiException("post.POS.TERM.PosTermServiceImpl.updatePosTermAdminState.null");
        }
    }

    private void updateTermInWf(Integer termInfId, String targetState, String currentState) {
        if (null == termInfId || StringUtils.isEmpty((String)targetState) || StringUtils.isEmpty((String)currentState)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("termInfId", termInfId);
        map.put("targetState", targetState);
        map.put("currentState", currentState);
        this.updateStateInWf(map);
    }

    @Override
    public void applyStop(Integer termInfId, String targetState, String currentState) throws ApiException {
        this.updateTermInWf(termInfId, targetState, currentState);
    }

    @Override
    public void submitApply(Integer termInfId, String targetState, String currentState) throws ApiException {
        this.updateTermInWf(termInfId, targetState, currentState);
    }

    @Override
    public void applyRecover(Integer termInfId, String targetState, String currentState) throws ApiException {
        this.updateTermInWf(termInfId, targetState, currentState);
    }

    @Override
    public void applyUpdate(Integer termInfId, String targetState, String currentState) throws ApiException {
        if ("2".equals(targetState)) {
            this.updateTermInWf(termInfId, targetState, currentState);
        }
    }

    @Override
    public boolean checkTermValid(String merchantId, String termId) throws ApiException {
        if (StringUtils.isBlank((String)merchantId) || StringUtils.isBlank((String)termId)) {
            return false;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("merchantId", merchantId);
        map.put("termId", termId);
        int count = this.countValidTerm(map);
        return count > 0;
    }

    @Override
    public void updatePosTerm(PosTermDomain posTermDomain) throws ApiException {
        String msg = this.checkPosTerm(posTermDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("post.POS.TERM.PosTermServiceImpl.updatePosTerm.checkPosTerm", msg);
        }
        PosTerm oldPosTerm = this.getPosTermModelById(posTermDomain.getTermInfId());
        if (null == oldPosTerm) {
            throw new ApiException("post.POS.TERM.PosTermServiceImpl.updatePosTerm.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        if ("1".equals(oldPosTerm.getTermSta())) {
            PosTermInfTmp posTermInfTmp = new PosTermInfTmp();
            try {
                BeanUtils.copyAllPropertysNotNull((Object)posTermInfTmp, (Object)oldPosTerm);
            }
            catch (Exception e) {
                this.logger.error("post.POS.TERM.PosTermServiceImplupdatePosTerm. OldPosTerm copy to posTermInfTmp error.", (Throwable)e);
            }
            this.posTermInfTmpMapper.insert(posTermInfTmp);
            oldPosTerm.setTermTmpId(posTermInfTmp.getTermInfTmpId());
        }
        PosTerm posTerm = this.makePosTerm(posTermDomain, oldPosTerm);
        this.setPosTermUpdataDefault(posTerm);
        this.updatePosTermModel(posTerm);
    }

    @Override
    public PosTerm getPosTerm(Integer termInfId) {
        PosTerm posTerm = this.getPosTermModelById(termInfId);
        this.decodeBizType(posTerm);
        return posTerm;
    }

    @Override
    public PosTerm getPosTermByTermId(String termId) throws ApiException {
        return this.selectByTermId(termId);
    }

    private PosTerm selectByTermId(String termId) {
        PosTerm posTerm = null;
        try {
            posTerm = this.posTermMapper.selectByTermId(termId);
        }
        catch (Exception e) {
            this.logger.error("post.POS.TERM.PosTermServiceImpl.getPosTermByTermId", (Throwable)e);
            throw new ApiException("post.POS.TERM.PosTermServiceImpl.getPosTermByTermId", (Throwable)e);
        }
        return posTerm;
    }

    @Override
    public void deletePosTerm(Integer termInfId) throws ApiException {
        this.deletePosTermModel(termInfId);
    }

    private void decodeBizType(PosTerm posTerm) {
        if (StringUtils.isNotBlank((String)posTerm.getPropTp())) {
            posTerm.setPropTpName(posTerm.getPropTp() + "-" + DdTransUtil.getDdValue((String)("PosTermInf-propTp-" + posTerm.getPropTp())));
        }
        if (StringUtils.isNotBlank((String)posTerm.getDialTp())) {
            posTerm.setDialTpName(posTerm.getDialTp() + "-" + DdTransUtil.getDdValue((String)("PosTermInf-dialTp-" + posTerm.getDialTp())));
        }
        if (StringUtils.isNotBlank((String)posTerm.getTermTp())) {
            posTerm.setTermTpName(posTerm.getTermTp() + "-" + DdTransUtil.getDdValue((String)("PosTermInf-termTp-" + posTerm.getTermTp())));
        }
        if (StringUtils.isNotBlank((String)posTerm.getTermFactory())) {
            posTerm.setTermFactoryName(posTerm.getTermFactory() + "-" + DdTransUtil.getDdValue((String)("PosTermInf-termFactory-" + posTerm.getTermFactory())));
        }
        if (StringUtils.isNotBlank((String)posTerm.getTermSta())) {
            posTerm.setTermStaName("1".equals(posTerm.getTermSta()) ? "\u542f\u7528" : "\u672a\u542f\u7528");
        }
        Map provinceMap = DisUtil.getMapByListJson((String)CACHECITYCODE_PROVINCE, String.class, CityCodeVo.class);
        Map cityMap = DisUtil.getMapByListJson((String)CACHECITYCODE_CITY, String.class, CityCodeVo.class);
        Map areaMap = DisUtil.getMapByListJson((String)CACHECITYCODE_AREA, String.class, CityCodeVo.class);
        this.decodeCity(provinceMap, cityMap, areaMap, posTerm);
    }

    private void decodeCity(Map<String, List<CityCodeVo>> provinceMap, Map<String, List<CityCodeVo>> cityMap, Map<String, List<CityCodeVo>> areaMap, PosTerm posTerm) {
        List<CityCodeVo> areaList;
        List<CityCodeVo> cityList;
        List<CityCodeVo> provinceList;
        String provicneTmp = posTerm.getProvince();
        String cityTmp = posTerm.getCity();
        if (MapUtil.isNotEmpty(provinceMap) && StringUtils.isNotBlank((String)posTerm.getProvince()) && ListUtil.isNotEmpty(provinceList = provinceMap.get(PROVINCE_MAP_KEY))) {
            for (CityCodeVo cityCodeVo : provinceList) {
                if (!cityCodeVo.getCityCode().equals(posTerm.getProvince())) continue;
                posTerm.setProvinceName(cityCodeVo.getCityCode() + "-" + cityCodeVo.getCityDes());
                break;
            }
        }
        if (MapUtil.isNotEmpty(cityMap) && StringUtils.isNotBlank((String)provicneTmp) && StringUtils.isNotBlank((String)posTerm.getCity()) && ListUtil.isNotEmpty(cityList = cityMap.get(provicneTmp))) {
            for (CityCodeVo cityCodeVo : cityList) {
                if (!cityCodeVo.getCityCode().equals(posTerm.getCity())) continue;
                posTerm.setCityName(cityCodeVo.getCityCode() + "-" + cityCodeVo.getCityDes());
                break;
            }
        }
        if (MapUtil.isNotEmpty(areaMap) && StringUtils.isNotBlank((String)cityTmp) && StringUtils.isNotBlank((String)posTerm.getArea()) && ListUtil.isNotEmpty(areaList = areaMap.get(cityTmp))) {
            for (CityCodeVo cityCodeVo : areaList) {
                if (!cityCodeVo.getCityCode().equals(posTerm.getArea())) continue;
                posTerm.setAreaName(cityCodeVo.getCityCode() + "-" + cityCodeVo.getCityDes());
                break;
            }
        }
    }

    private void decodeBizType(List<PosTerm> posTermList) {
        Map provinceMap = DisUtil.getMapByListJson((String)CACHECITYCODE_PROVINCE, String.class, CityCodeVo.class);
        Map cityMap = DisUtil.getMapByListJson((String)CACHECITYCODE_CITY, String.class, CityCodeVo.class);
        Map areaMap = DisUtil.getMapByListJson((String)CACHECITYCODE_AREA, String.class, CityCodeVo.class);
        for (PosTerm posTerm : posTermList) {
            this.decodeCity(provinceMap, cityMap, areaMap, posTerm);
            if (StringUtils.isNotBlank((String)posTerm.getPropTp())) {
                posTerm.setPropTpName(posTerm.getPropTp() + "-" + DdTransUtil.getDdValue((String)("PosTermInf-propTp-" + posTerm.getPropTp())));
            }
            if (StringUtils.isNotBlank((String)posTerm.getDialTp())) {
                posTerm.setDialTpName(posTerm.getDialTp() + "-" + DdTransUtil.getDdValue((String)("PosTermInf-dialTp-" + posTerm.getDialTp())));
            }
            if (StringUtils.isNotBlank((String)posTerm.getTermTp())) {
                posTerm.setTermTpName(posTerm.getTermTp() + "-" + DdTransUtil.getDdValue((String)("PosTermInf-termTp-" + posTerm.getTermTp())));
            }
            if (StringUtils.isNotBlank((String)posTerm.getTermFactory())) {
                posTerm.setTermFactoryName(posTerm.getTermFactory() + "-" + DdTransUtil.getDdValue((String)("PosTermInf-termFactory-" + posTerm.getTermFactory())));
            }
            if (!StringUtils.isNotBlank((String)posTerm.getTermSta())) continue;
            posTerm.setTermStaName("1".equals(posTerm.getTermSta()) ? "\u542f\u7528" : "\u672a\u542f\u7528");
        }
    }

    @Override
    public QueryResult<PosTerm> queryPosTermPageExt(Map<String, Object> map) {
        List<PosTerm> posTermList = this.queryPosTermModelPage(map);
        if (CollectionUtils.isNotEmpty(posTermList)) {
            this.decodeBizType(posTermList);
        }
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countPosTerm(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(posTermList);
        return queryResult;
    }

    @Override
    public QueryResult<PosTerm> queryPosTermPage(Map<String, Object> map) {
        List<PosTerm> posTermList = this.queryPosTermModelPage(map);
        if (CollectionUtils.isNotEmpty(posTermList)) {
            this.decodeBizType(posTermList);
        }
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countPosTerm(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(posTermList);
        return queryResult;
    }

    @Override
    public QueryResult<PosTerm> queryPosTermKeyIussueApplyPage(Map<String, Object> map) {
        List<PosTerm> posTermList = this.queryTermKeyIussueApply(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.coutTermKeyIussueApply(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(posTermList);
        return queryResult;
    }

    @Override
    public QueryResult<PosTerm> queryTermByState(Map<String, Object> map) {
        List<PosTerm> posTermList = this.queryTermBySta(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countByStates(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(posTermList);
        return queryResult;
    }

    private String queryMaxTermNo(String prefix) {
        String maxTermNo = "";
        try {
            maxTermNo = this.posTermMapper.queryMaxTermNo(prefix);
        }
        catch (Exception e) {
            this.logger.error("post.POS.TERM.PosTermServiceImpl.queryPosMaxTermNo", (Throwable)e);
        }
        return maxTermNo;
    }

    @Override
    public synchronized String queryPosMaxTermNo(String prefix) {
        String maxTermNo = "";
        try {
            List<Object> termNos = DisUtil.getListJson((String)"cacheTermNo", String.class);
            if (CollectionUtils.isNotEmpty((Collection)termNos)) {
                maxTermNo = (String)termNos.remove(0);
                DisUtil.setJsonVer((String)"cacheTermNo", termNos);
                return maxTermNo;
            }
            termNos = termNos == null ? Collections.synchronizedList(new ArrayList()) : Collections.synchronizedList(termNos);
            maxTermNo = this.queryMaxTermNo(prefix);
            if (StringUtils.isEmpty((String)maxTermNo)) {
                maxTermNo = prefix + "000000";
            }
            for (int i = 1; i <= 100; ++i) {
                termNos.add(String.valueOf(Long.parseLong(maxTermNo) + (long)i));
            }
            maxTermNo = (String)termNos.remove(0);
            DisUtil.setJsonVer((String)"cacheTermNo", termNos);
        }
        catch (Exception e) {
            this.logger.error("post.POS.TERM.PosTermServiceImpl.queryPosMaxTermNo", (Throwable)e);
        }
        return maxTermNo;
    }
}

