/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.pos.term.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.pos.term.dao.PosTermStoreMapper;
import com.yqbsoft.laser.service.pos.term.domain.PosTermStoreDomain;
import com.yqbsoft.laser.service.pos.term.model.PosTermStore;
import com.yqbsoft.laser.service.pos.term.service.PosTermStoreService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PosTermStoreServiceImpl
extends BaseServiceImpl
implements PosTermStoreService {
    public static final String SYS_CODE = "post.POS.TERM.PosTermStoreServiceImpl";
    private PosTermStoreMapper posTermStoreMapper;

    public void setPosTermStoreMapper(PosTermStoreMapper posTermStoreMapper) {
        this.posTermStoreMapper = posTermStoreMapper;
    }

    private Date getSysDate() {
        try {
            return this.posTermStoreMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("post.POS.TERM.PosTermStoreServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkPosTermStore(PosTermStoreDomain posTermStoreDomain) {
        if (null == posTermStoreDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        return msg;
    }

    private void setPosTermStoreDefault(PosTermStore posTermStore) {
        if (null == posTermStore) {
            return;
        }
        if (null == posTermStore.getDataState()) {
            posTermStore.setDataState(0);
        }
        if (null == posTermStore.getGmtCreate()) {
            posTermStore.setGmtCreate(this.getSysDate());
        }
        posTermStore.setGmtModified(this.getSysDate());
    }

    private int getMaxCode() {
        int code = 0;
        try {
            return this.posTermStoreMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("post.POS.TERM.PosTermStoreServiceImpl.getMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setPosTermStoreUpdataDefault(PosTermStore posTermStore) {
        if (null == posTermStore) {
            return;
        }
        posTermStore.setGmtModified(this.getSysDate());
    }

    private void savePosTermStoreModel(PosTermStore posTermStore) throws ApiException {
        if (null == posTermStore) {
            return;
        }
        try {
            this.posTermStoreMapper.insert(posTermStore);
        }
        catch (Exception e) {
            throw new ApiException("post.POS.TERM.PosTermStoreServiceImpl.savePosTermStoreModel.ex");
        }
    }

    private PosTermStore getPosTermStoreModelById(Integer termManagementId) {
        if (null == termManagementId) {
            return null;
        }
        try {
            return this.posTermStoreMapper.selectByPrimaryKey(termManagementId);
        }
        catch (Exception e) {
            this.logger.error("post.POS.TERM.PosTermStoreServiceImpl.getPosTermStoreModelById", (Throwable)e);
            return null;
        }
    }

    private void deletePosTermStoreModel(Integer termManagementId) throws ApiException {
        if (null == termManagementId) {
            return;
        }
        int i = 0;
        try {
            i = this.posTermStoreMapper.deleteByPrimaryKey(termManagementId);
        }
        catch (Exception e) {
            throw new ApiException("post.POS.TERM.PosTermStoreServiceImpl.deletePosTermStoreModel.ex");
        }
        if (1 != i) {
            throw new ApiException("post.POS.TERM.PosTermStoreServiceImpl.deletePosTermStoreModel.num");
        }
    }

    private void updatePosTermStoreModel(PosTermStore posTermStore) throws ApiException {
        if (null == posTermStore) {
            return;
        }
        try {
            this.posTermStoreMapper.updateByPrimaryKeySelective(posTermStore);
        }
        catch (Exception e) {
            throw new ApiException("post.POS.TERM.PosTermStoreServiceImpl.updatePosTermStoreModel.ex");
        }
    }

    private void updateStatePosTermStoreModel(Integer termManagementId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == termManagementId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("termManagementId", termManagementId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.posTermStoreMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("post.POS.TERM.PosTermStoreServiceImpl.updateStatePosTermStoreModel.ex");
        }
        if (i <= 0) {
            throw new ApiException("post.POS.TERM.PosTermStoreServiceImpl.updateStatePosTermStoreModel.null");
        }
    }

    private PosTermStore makePosTermStore(PosTermStoreDomain posTermStoreDomain, PosTermStore posTermStore) {
        if (null == posTermStoreDomain) {
            return null;
        }
        if (null == posTermStore) {
            posTermStore = new PosTermStore();
        }
        try {
            BeanUtils.copyAllPropertys((Object)posTermStore, (Object)posTermStoreDomain);
        }
        catch (Exception e) {
            this.logger.error("post.POS.TERM.PosTermStoreServiceImpl.makePosTermStore", (Throwable)e);
        }
        return posTermStore;
    }

    private List<PosTermStore> queryPosTermStoreModelPage(Map<String, Object> parammap) {
        try {
            return this.posTermStoreMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("post.POS.TERM.PosTermStoreServiceImpl.queryPosTermStoreModel", (Throwable)e);
            return null;
        }
    }

    private int countPosTermStore(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.posTermStoreMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("post.POS.TERM.PosTermStoreServiceImpl.countPosTermStore", (Throwable)e);
        }
        return i;
    }

    @Override
    public void savePosTermStore(PosTermStoreDomain posTermStoreDomain) throws ApiException {
        String msg = this.checkPosTermStore(posTermStoreDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("post.POS.TERM.PosTermStoreServiceImpl.savePosTermStore.checkPosTermStore", msg);
        }
        PosTermStore posTermStore = this.makePosTermStore(posTermStoreDomain, null);
        this.setPosTermStoreDefault(posTermStore);
        this.savePosTermStoreModel(posTermStore);
    }

    @Override
    public void updatePosTermStoreState(Integer termManagementId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStatePosTermStoreModel(termManagementId, dataState, oldDataState);
    }

    @Override
    public void updateAdminStateByPrimaryKey(Integer termManagementId, String state, String oldState) throws ApiException {
        if (null == termManagementId || null == state) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("termManagementId", termManagementId);
        map.put("state", state);
        map.put("oldState", oldState);
        int i = 0;
        try {
            i = this.posTermStoreMapper.updateAdminStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("post.POS.TERM.PosTermStoreServiceImpl.updateAdminStateByPrimaryKey.ex");
        }
        if (i <= 0) {
            throw new ApiException("post.POS.TERM.PosTermStoreServiceImpl.updateAdminStateByPrimaryKey.null");
        }
    }

    @Override
    public void updatePosTermStore(PosTermStoreDomain posTermStoreDomain) throws ApiException {
        String msg = this.checkPosTermStore(posTermStoreDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("post.POS.TERM.PosTermStoreServiceImpl.updatePosTermStore.checkPosTermStore", msg);
        }
        PosTermStore oldPosTermStore = this.getPosTermStoreModelById(posTermStoreDomain.getTermManagementId());
        if (null == oldPosTermStore) {
            throw new ApiException("post.POS.TERM.PosTermStoreServiceImpl.updatePosTermStore.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        PosTermStore posTermStore = this.makePosTermStore(posTermStoreDomain, oldPosTermStore);
        this.setPosTermStoreUpdataDefault(posTermStore);
        this.updatePosTermStoreModel(posTermStore);
    }

    @Override
    public PosTermStore getPosTermStore(Integer termManagementId) {
        return this.getPosTermStoreModelById(termManagementId);
    }

    @Override
    public void deletePosTermStore(Integer termManagementId) throws ApiException {
        this.deletePosTermStoreModel(termManagementId);
    }

    @Override
    public QueryResult<PosTermStore> queryPosTermStorePage(Map<String, Object> map) {
        List<PosTermStore> posTermStoreList = this.queryPosTermStoreModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countPosTermStore(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(posTermStoreList);
        return queryResult;
    }

    @Override
    public QueryResult<PosTermStore> queryPosTermStoreByStates(Map<String, Object> map) {
        List<PosTermStore> posTermStoreList = this.posTermStoreMapper.queryByStates(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.posTermStoreMapper.countBystates(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(posTermStoreList);
        return queryResult;
    }
}

