/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.pos.term.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.pos.term.dao.PosTermMapper;
import com.yqbsoft.laser.service.pos.term.dao.PosTermTmkLogMapper;
import com.yqbsoft.laser.service.pos.term.domain.PosTermTmkLogDomain;
import com.yqbsoft.laser.service.pos.term.model.PosTerm;
import com.yqbsoft.laser.service.pos.term.model.PosTermTmkLog;
import com.yqbsoft.laser.service.pos.term.service.PosTermTmkLogService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.DateUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;

public class PosTermTmkLogServiceImpl
extends BaseServiceImpl
implements PosTermTmkLogService {
    public static final String SYS_CODE = "post.POS.TERM.PosTermTmkLogServiceImpl";
    private PosTermTmkLogMapper posTermTmkLogMapper;
    private PosTermMapper posTermMapper;

    public void setPosTermTmkLogMapper(PosTermTmkLogMapper posTermTmkLogMapper) {
        this.posTermTmkLogMapper = posTermTmkLogMapper;
    }

    public void setPosTermMapper(PosTermMapper posTermMapper) {
        this.posTermMapper = posTermMapper;
    }

    private Date getSysDate() {
        try {
            return this.posTermTmkLogMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("post.POS.TERM.PosTermTmkLogServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    @Override
    public String queryMaxBatchNo() {
        return this.posTermTmkLogMapper.queryMaxBatchNo();
    }

    private String checkPosTermTmkLog(PosTermTmkLogDomain posTermTmkLogDomain) {
        if (null == posTermTmkLogDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        return msg;
    }

    private void setPosTermTmkLogDefault(PosTermTmkLog posTermTmkLog) {
        if (null == posTermTmkLog) {
            return;
        }
        if (null == posTermTmkLog.getDataState()) {
            posTermTmkLog.setDataState(0);
        }
        if (null == posTermTmkLog.getGmtCreate()) {
            posTermTmkLog.setGmtCreate(this.getSysDate());
        }
        posTermTmkLog.setGmtModified(this.getSysDate());
    }

    private int getMaxCode() {
        int code = 0;
        try {
            return this.posTermTmkLogMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("post.POS.TERM.PosTermTmkLogServiceImpl.getMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setPosTermTmkLogUpdataDefault(PosTermTmkLog posTermTmkLog) {
        if (null == posTermTmkLog) {
            return;
        }
        posTermTmkLog.setGmtModified(this.getSysDate());
    }

    private void savePosTermTmkLogModel(PosTermTmkLog posTermTmkLog) throws ApiException {
        if (null == posTermTmkLog) {
            return;
        }
        try {
            this.posTermTmkLogMapper.insert(posTermTmkLog);
        }
        catch (Exception e) {
            throw new ApiException("post.POS.TERM.PosTermTmkLogServiceImpl.savePosTermTmkLogModel.ex");
        }
    }

    private PosTermTmkLog getPosTermTmkLogModelById(Integer termTmkLogId) {
        if (null == termTmkLogId) {
            return null;
        }
        try {
            return this.posTermTmkLogMapper.selectByPrimaryKey(termTmkLogId);
        }
        catch (Exception e) {
            this.logger.error("post.POS.TERM.PosTermTmkLogServiceImpl.getPosTermTmkLogModelById", (Throwable)e);
            return null;
        }
    }

    private void deletePosTermTmkLogModel(Integer termTmkLogId) throws ApiException {
        if (null == termTmkLogId) {
            return;
        }
        int i = 0;
        try {
            i = this.posTermTmkLogMapper.deleteByPrimaryKey(termTmkLogId);
        }
        catch (Exception e) {
            throw new ApiException("post.POS.TERM.PosTermTmkLogServiceImpl.deletePosTermTmkLogModel.ex");
        }
        if (1 != i) {
            throw new ApiException("post.POS.TERM.PosTermTmkLogServiceImpl.deletePosTermTmkLogModel.num");
        }
    }

    private void updatePosTermTmkLogModel(PosTermTmkLog posTermTmkLog) throws ApiException {
        if (null == posTermTmkLog) {
            return;
        }
        try {
            this.convertTimeInModel(posTermTmkLog);
            this.posTermTmkLogMapper.updateByPrimaryKeySelective(posTermTmkLog);
        }
        catch (Exception e) {
            throw new ApiException("post.POS.TERM.PosTermTmkLogServiceImpl.updatePosTermTmkLogModel.ex");
        }
    }

    private void updateStatePosTermTmkLogModel(Integer termTmkLogId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == termTmkLogId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("termTmkLogId", termTmkLogId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.posTermTmkLogMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("post.POS.TERM.PosTermTmkLogServiceImpl.updateStatePosTermTmkLogModel.ex");
        }
        if (i <= 0) {
            throw new ApiException("post.POS.TERM.PosTermTmkLogServiceImpl.updateStatePosTermTmkLogModel.null");
        }
    }

    private PosTermTmkLog makePosTermTmkLog(PosTermTmkLogDomain posTermTmkLogDomain, PosTermTmkLog posTermTmkLog) {
        if (null == posTermTmkLogDomain) {
            return null;
        }
        if (null == posTermTmkLog) {
            posTermTmkLog = new PosTermTmkLog();
        }
        try {
            BeanUtils.copyAllPropertys((Object)posTermTmkLog, (Object)posTermTmkLogDomain);
        }
        catch (Exception e) {
            this.logger.error("post.POS.TERM.PosTermTmkLogServiceImpl.makePosTermTmkLog", (Throwable)e);
        }
        return posTermTmkLog;
    }

    private List<PosTermTmkLog> queryPosTermTmkLogModelPage(Map<String, Object> parammap) {
        try {
            return this.posTermTmkLogMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("post.POS.TERM.PosTermTmkLogServiceImpl.queryPosTermTmkLogModel", (Throwable)e);
            return null;
        }
    }

    private int countPosTermTmkLog(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.posTermTmkLogMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("post.POS.TERM.PosTermTmkLogServiceImpl.countPosTermTmkLog", (Throwable)e);
        }
        return i;
    }

    @Override
    public void savePosTermTmkLog(PosTermTmkLogDomain posTermTmkLogDomain) throws ApiException {
        String msg = this.checkPosTermTmkLog(posTermTmkLogDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("post.POS.TERM.PosTermTmkLogServiceImpl.savePosTermTmkLog.checkPosTermTmkLog", msg);
        }
        PosTermTmkLog posTermTmkLog = this.makePosTermTmkLog(posTermTmkLogDomain, null);
        this.setPosTermTmkLogDefault(posTermTmkLog);
        this.savePosTermTmkLogModel(posTermTmkLog);
    }

    @Override
    public Integer saveTermTmkLogReturnId(PosTermTmkLogDomain posTermTmkLogDomain) throws ApiException {
        String msg = this.checkPosTermTmkLog(posTermTmkLogDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("post.POS.TERM.PosTermTmkLogServiceImpl.savePosTermTmkLog.checkPosTermTmkLog", msg);
        }
        PosTermTmkLog posTermTmkLog = this.makePosTermTmkLog(posTermTmkLogDomain, null);
        this.setPosTermTmkLogDefault(posTermTmkLog);
        this.savePosTermTmkLogModel(posTermTmkLog);
        return posTermTmkLog.getTermTmkLogId();
    }

    @Override
    public void applyTMKRandomCode(Integer termInfId, String termId, Integer termTmkLogId) throws ApiException {
    }

    @Override
    public void updateTermAndTMKLog(Integer termInfId, String termId, Integer termTmkLogId, String targetTermSta, String currentTermSta, String termTmkLogSta, String auditUserCode) throws ApiException {
        try {
            if ("1".equals(targetTermSta)) {
                PosTermTmkLog posTermTmkLog = this.getPosTermTmkLog(termTmkLogId);
                posTermTmkLog.setChkOpr(auditUserCode);
                posTermTmkLog.setChkDate(DateUtil.getDateStr((String)"yyyyMMdd"));
                posTermTmkLog.setState(termTmkLogSta);
                this.updatePosTermTmkLogModel(posTermTmkLog);
                PosTerm posTerm = this.posTermMapper.selectByPrimaryKey(termInfId);
                String psamId = this.getRandomNum(8);
                posTerm.setPsamId(psamId);
                posTerm.setChkSta("1");
                this.posTermMapper.updateByPrimaryKeySelective(posTerm);
            } else {
                this.deletePosTermTmkLog(termTmkLogId);
                PosTerm posTerm = this.posTermMapper.selectByPrimaryKey(termInfId);
                posTerm.setChkSta("3");
                this.posTermMapper.updateByPrimaryKeySelective(posTerm);
            }
        }
        catch (Exception e) {
            this.logger.error("post.POS.TERM.PosTermTmkLogServiceImpl.updateTermAndTMKLog.ex", (Throwable)e);
            throw new ApiException("post.POS.TERM.PosTermTmkLogServiceImpl.updateTermAndTMKLog.ex");
        }
    }

    private String getRandomNum(int len) {
        StringBuffer num = new StringBuffer();
        Random random = new Random();
        for (int i = 0; i < len; ++i) {
            num = num.append(random.nextInt(10));
        }
        return num.toString();
    }

    @Override
    public void updatePosTermTmkLogState(Integer termTmkLogId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStatePosTermTmkLogModel(termTmkLogId, dataState, oldDataState);
    }

    @Override
    public void updatePosTermTmkLog(PosTermTmkLogDomain posTermTmkLogDomain) throws ApiException {
        String msg = this.checkPosTermTmkLog(posTermTmkLogDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("post.POS.TERM.PosTermTmkLogServiceImpl.updatePosTermTmkLog.checkPosTermTmkLog", msg);
        }
        PosTermTmkLog oldPosTermTmkLog = this.getPosTermTmkLogModelById(posTermTmkLogDomain.getTermTmkLogId());
        if (null == oldPosTermTmkLog) {
            throw new ApiException("post.POS.TERM.PosTermTmkLogServiceImpl.updatePosTermTmkLog.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        PosTermTmkLog posTermTmkLog = this.makePosTermTmkLog(posTermTmkLogDomain, oldPosTermTmkLog);
        this.setPosTermTmkLogUpdataDefault(posTermTmkLog);
        this.updatePosTermTmkLogModel(posTermTmkLog);
    }

    @Override
    public PosTermTmkLog getPosTermTmkLog(Integer termTmkLogId) {
        return this.getPosTermTmkLogModelById(termTmkLogId);
    }

    @Override
    public void deletePosTermTmkLog(Integer termTmkLogId) throws ApiException {
        this.deletePosTermTmkLogModel(termTmkLogId);
    }

    @Override
    public QueryResult<PosTermTmkLog> queryPosTermTmkLogPage(Map<String, Object> map) {
        List<PosTermTmkLog> posTermTmkLogList = this.queryPosTermTmkLogModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countPosTermTmkLog(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(posTermTmkLogList);
        return queryResult;
    }
}

