/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.tk.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tk.dao.TkTasklistMapper;
import com.yqbsoft.laser.service.tk.domain.TkTasklistDomain;
import com.yqbsoft.laser.service.tk.domain.TkTasklistReDomain;
import com.yqbsoft.laser.service.tk.model.TkTasklist;
import com.yqbsoft.laser.service.tk.service.TkTasklistService;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TkTasklistServiceImpl
extends BaseServiceImpl
implements TkTasklistService {
    private static final String SYS_CODE = "tk.TkTasklistServiceImpl";
    private TkTasklistMapper tkTasklistMapper;

    public void setTkTasklistMapper(TkTasklistMapper tkTasklistMapper) {
        this.tkTasklistMapper = tkTasklistMapper;
    }

    private Date getSysDate() {
        try {
            return this.tkTasklistMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("tk.TkTasklistServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkTasklist(TkTasklistDomain tkTasklistDomain) {
        if (null == tkTasklistDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)tkTasklistDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setTasklistDefault(TkTasklist tkTasklist) {
        if (null == tkTasklist) {
            return;
        }
        if (null == tkTasklist.getDataState()) {
            tkTasklist.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == tkTasklist.getGmtCreate()) {
            tkTasklist.setGmtCreate(date);
        }
        tkTasklist.setGmtModified(date);
        if (StringUtils.isBlank((String)tkTasklist.getTasklistCode())) {
            tkTasklist.setTasklistCode(this.getNo(null, "TkTasklist", "tkTasklist", tkTasklist.getTenantCode()));
        }
    }

    private int getTasklistMaxCode() {
        int code = 0;
        try {
            return this.tkTasklistMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("tk.TkTasklistServiceImpl.getTasklistMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setTasklistUpdataDefault(TkTasklist tkTasklist) {
        if (null == tkTasklist) {
            return;
        }
        tkTasklist.setGmtModified(this.getSysDate());
    }

    private void saveTasklistModel(TkTasklist tkTasklist) throws ApiException {
        if (null == tkTasklist) {
            return;
        }
        try {
            this.tkTasklistMapper.insert(tkTasklist);
        }
        catch (Exception e) {
            throw new ApiException("tk.TkTasklistServiceImpl.saveTasklistModel.ex", (Throwable)e);
        }
    }

    private void saveTasklistBatchModel(List<TkTasklist> tkTasklistList) throws ApiException {
        if (null == tkTasklistList || tkTasklistList.isEmpty()) {
            return;
        }
        try {
            this.tkTasklistMapper.insertBatch(tkTasklistList);
        }
        catch (Exception e) {
            throw new ApiException("tk.TkTasklistServiceImpl.saveTasklistBatchModel.ex", (Throwable)e);
        }
    }

    private TkTasklist getTasklistModelById(Integer tasklistId) {
        if (null == tasklistId) {
            return null;
        }
        try {
            return this.tkTasklistMapper.selectByPrimaryKey(tasklistId);
        }
        catch (Exception e) {
            this.logger.error("tk.TkTasklistServiceImpl.getTasklistModelById", (Throwable)e);
            return null;
        }
    }

    private TkTasklist getTasklistModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.tkTasklistMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("tk.TkTasklistServiceImpl.getTasklistModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delTasklistModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.tkTasklistMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("tk.TkTasklistServiceImpl.delTasklistModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("tk.TkTasklistServiceImpl.delTasklistModelByCode.num");
        }
    }

    private void deleteTasklistModel(Integer tasklistId) throws ApiException {
        if (null == tasklistId) {
            return;
        }
        int i = 0;
        try {
            i = this.tkTasklistMapper.deleteByPrimaryKey(tasklistId);
        }
        catch (Exception e) {
            throw new ApiException("tk.TkTasklistServiceImpl.deleteTasklistModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("tk.TkTasklistServiceImpl.deleteTasklistModel.num");
        }
    }

    private void updateTasklistModel(TkTasklist tkTasklist) throws ApiException {
        if (null == tkTasklist) {
            return;
        }
        int i = 0;
        try {
            i = this.tkTasklistMapper.updateByPrimaryKey(tkTasklist);
        }
        catch (Exception e) {
            throw new ApiException("tk.TkTasklistServiceImpl.updateTasklistModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("tk.TkTasklistServiceImpl.updateTasklistModel.num");
        }
    }

    private void updateStateTasklistModel(Integer tasklistId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == tasklistId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tasklistId", tasklistId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.tkTasklistMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("tk.TkTasklistServiceImpl.updateStateTasklistModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("tk.TkTasklistServiceImpl.updateStateTasklistModel.null");
        }
    }

    private void updateStateTasklistModelByCode(String tenantCode, String tasklistCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)tasklistCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("tasklistCode", tasklistCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.tkTasklistMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("tk.TkTasklistServiceImpl.updateStateTasklistModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("tk.TkTasklistServiceImpl.updateStateTasklistModelByCode.null");
        }
    }

    private TkTasklist makeTasklist(TkTasklistDomain tkTasklistDomain, TkTasklist tkTasklist) {
        if (null == tkTasklistDomain) {
            return null;
        }
        if (null == tkTasklist) {
            tkTasklist = new TkTasklist();
        }
        try {
            BeanUtils.copyAllPropertys((Object)tkTasklist, (Object)tkTasklistDomain);
            return tkTasklist;
        }
        catch (Exception e) {
            this.logger.error("tk.TkTasklistServiceImpl.makeTasklist", (Throwable)e);
            return null;
        }
    }

    private TkTasklistReDomain makeTkTasklistReDomain(TkTasklist tkTasklist) {
        if (null == tkTasklist) {
            return null;
        }
        TkTasklistReDomain tkTasklistReDomain = new TkTasklistReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)tkTasklistReDomain, (Object)tkTasklist);
            return tkTasklistReDomain;
        }
        catch (Exception e) {
            this.logger.error("tk.TkTasklistServiceImpl.makeTkTasklistReDomain", (Throwable)e);
            return null;
        }
    }

    private List<TkTasklist> queryTasklistModelPage(Map<String, Object> parammap) {
        try {
            return this.tkTasklistMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("tk.TkTasklistServiceImpl.queryTasklistModel", (Throwable)e);
            return null;
        }
    }

    private int countTasklist(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.tkTasklistMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("tk.TkTasklistServiceImpl.countTasklist", (Throwable)e);
        }
        return i;
    }

    private TkTasklist createTkTasklist(TkTasklistDomain tkTasklistDomain) {
        String msg = this.checkTasklist(tkTasklistDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("tk.TkTasklistServiceImpl.saveTasklist.checkTasklist", msg);
        }
        TkTasklist tkTasklist = this.makeTasklist(tkTasklistDomain, null);
        this.setTasklistDefault(tkTasklist);
        return tkTasklist;
    }

    @Override
    public String saveTasklist(TkTasklistDomain tkTasklistDomain) throws ApiException {
        TkTasklist tkTasklist = this.createTkTasklist(tkTasklistDomain);
        this.saveTasklistModel(tkTasklist);
        return tkTasklist.getTasklistCode();
    }

    @Override
    public String saveTasklistBatch(List<TkTasklistDomain> tkTasklistDomainList) throws ApiException {
        if (null == tkTasklistDomainList || tkTasklistDomainList.isEmpty()) {
            return null;
        }
        ArrayList<TkTasklist> tkTasklistList = new ArrayList<TkTasklist>();
        String code = "";
        for (TkTasklistDomain tkTasklistDomain : tkTasklistDomainList) {
            TkTasklist tkTasklist = this.createTkTasklist(tkTasklistDomain);
            code = tkTasklist.getTasklistCode();
            tkTasklistList.add(tkTasklist);
        }
        this.saveTasklistBatchModel(tkTasklistList);
        return code;
    }

    @Override
    public void updateTasklistState(Integer tasklistId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == tasklistId) {
            return;
        }
        this.updateStateTasklistModel(tasklistId, dataState, oldDataState, map);
    }

    @Override
    public void updateTasklistStateByCode(String tenantCode, String tasklistCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)tasklistCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateTasklistModelByCode(tenantCode, tasklistCode, dataState, oldDataState, map);
    }

    @Override
    public void updateTasklist(TkTasklistDomain tkTasklistDomain) throws ApiException {
        String msg = this.checkTasklist(tkTasklistDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("tk.TkTasklistServiceImpl.updateTasklist.checkTasklist", msg);
        }
        TkTasklist oldTkTasklist = this.getTasklistModelById(tkTasklistDomain.getTasklistId());
        if (null == oldTkTasklist) {
            throw new ApiException("tk.TkTasklistServiceImpl.updateTasklist.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        TkTasklist tkTasklist = this.makeTasklist(tkTasklistDomain, oldTkTasklist);
        this.setTasklistUpdataDefault(tkTasklist);
        this.updateTasklistModel(tkTasklist);
    }

    @Override
    public TkTasklist getTasklist(Integer tasklistId) {
        if (null == tasklistId) {
            return null;
        }
        return this.getTasklistModelById(tasklistId);
    }

    @Override
    public void deleteTasklist(Integer tasklistId) throws ApiException {
        if (null == tasklistId) {
            return;
        }
        this.deleteTasklistModel(tasklistId);
    }

    @Override
    public QueryResult<TkTasklist> queryTasklistPage(Map<String, Object> map) {
        List<TkTasklist> tkTasklistList = this.queryTasklistModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countTasklist(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(tkTasklistList);
        return queryResult;
    }

    @Override
    public TkTasklist getTasklistByCode(String tenantCode, String tasklistCode) throws ApiException {
        if (StringUtils.isBlank((String)tasklistCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("tasklistCode", tasklistCode);
        return this.getTasklistModelByCode(map);
    }

    @Override
    public void deleteTasklistByCode(String tenantCode, String tasklistCode) throws ApiException {
        if (StringUtils.isBlank((String)tasklistCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("tasklistCode", tasklistCode);
        this.delTasklistModelByCode(map);
    }
}

