/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.tk.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tk.dao.TkTasktypeMapper;
import com.yqbsoft.laser.service.tk.domain.TkTasktypeDomain;
import com.yqbsoft.laser.service.tk.domain.TkTasktypeReDomain;
import com.yqbsoft.laser.service.tk.model.TkTasktype;
import com.yqbsoft.laser.service.tk.service.TkTasktypeService;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TkTasktypeServiceImpl
extends BaseServiceImpl
implements TkTasktypeService {
    private static final String SYS_CODE = "tk.TkTasktypeServiceImpl";
    private TkTasktypeMapper tkTasktypeMapper;

    public void setTkTasktypeMapper(TkTasktypeMapper tkTasktypeMapper) {
        this.tkTasktypeMapper = tkTasktypeMapper;
    }

    private Date getSysDate() {
        try {
            return this.tkTasktypeMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("tk.TkTasktypeServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkTasktype(TkTasktypeDomain tkTasktypeDomain) {
        if (null == tkTasktypeDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)tkTasktypeDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setTasktypeDefault(TkTasktype tkTasktype) {
        if (null == tkTasktype) {
            return;
        }
        if (null == tkTasktype.getDataState()) {
            tkTasktype.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == tkTasktype.getGmtCreate()) {
            tkTasktype.setGmtCreate(date);
        }
        tkTasktype.setGmtModified(date);
        if (StringUtils.isBlank((String)tkTasktype.getTasktypeCode())) {
            tkTasktype.setTasktypeCode(this.getNo(null, "TkTasktype", "tkTasktype", tkTasktype.getTenantCode()));
        }
    }

    private int getTasktypeMaxCode() {
        int code = 0;
        try {
            return this.tkTasktypeMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("tk.TkTasktypeServiceImpl.getTasktypeMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setTasktypeUpdataDefault(TkTasktype tkTasktype) {
        if (null == tkTasktype) {
            return;
        }
        tkTasktype.setGmtModified(this.getSysDate());
    }

    private void saveTasktypeModel(TkTasktype tkTasktype) throws ApiException {
        if (null == tkTasktype) {
            return;
        }
        try {
            this.tkTasktypeMapper.insert(tkTasktype);
        }
        catch (Exception e) {
            throw new ApiException("tk.TkTasktypeServiceImpl.saveTasktypeModel.ex", (Throwable)e);
        }
    }

    private void saveTasktypeBatchModel(List<TkTasktype> tkTasktypeList) throws ApiException {
        if (null == tkTasktypeList || tkTasktypeList.isEmpty()) {
            return;
        }
        try {
            this.tkTasktypeMapper.insertBatch(tkTasktypeList);
        }
        catch (Exception e) {
            throw new ApiException("tk.TkTasktypeServiceImpl.saveTasktypeBatchModel.ex", (Throwable)e);
        }
    }

    private TkTasktype getTasktypeModelById(Integer tasktypeId) {
        if (null == tasktypeId) {
            return null;
        }
        try {
            return this.tkTasktypeMapper.selectByPrimaryKey(tasktypeId);
        }
        catch (Exception e) {
            this.logger.error("tk.TkTasktypeServiceImpl.getTasktypeModelById", (Throwable)e);
            return null;
        }
    }

    private TkTasktype getTasktypeModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.tkTasktypeMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("tk.TkTasktypeServiceImpl.getTasktypeModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delTasktypeModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.tkTasktypeMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("tk.TkTasktypeServiceImpl.delTasktypeModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("tk.TkTasktypeServiceImpl.delTasktypeModelByCode.num");
        }
    }

    private void deleteTasktypeModel(Integer tasktypeId) throws ApiException {
        if (null == tasktypeId) {
            return;
        }
        int i = 0;
        try {
            i = this.tkTasktypeMapper.deleteByPrimaryKey(tasktypeId);
        }
        catch (Exception e) {
            throw new ApiException("tk.TkTasktypeServiceImpl.deleteTasktypeModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("tk.TkTasktypeServiceImpl.deleteTasktypeModel.num");
        }
    }

    private void updateTasktypeModel(TkTasktype tkTasktype) throws ApiException {
        if (null == tkTasktype) {
            return;
        }
        int i = 0;
        try {
            i = this.tkTasktypeMapper.updateByPrimaryKey(tkTasktype);
        }
        catch (Exception e) {
            throw new ApiException("tk.TkTasktypeServiceImpl.updateTasktypeModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("tk.TkTasktypeServiceImpl.updateTasktypeModel.num");
        }
    }

    private void updateStateTasktypeModel(Integer tasktypeId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == tasktypeId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tasktypeId", tasktypeId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.tkTasktypeMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("tk.TkTasktypeServiceImpl.updateStateTasktypeModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("tk.TkTasktypeServiceImpl.updateStateTasktypeModel.null");
        }
    }

    private void updateStateTasktypeModelByCode(String tenantCode, String tasktypeCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)tasktypeCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("tasktypeCode", tasktypeCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.tkTasktypeMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("tk.TkTasktypeServiceImpl.updateStateTasktypeModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("tk.TkTasktypeServiceImpl.updateStateTasktypeModelByCode.null");
        }
    }

    private TkTasktype makeTasktype(TkTasktypeDomain tkTasktypeDomain, TkTasktype tkTasktype) {
        if (null == tkTasktypeDomain) {
            return null;
        }
        if (null == tkTasktype) {
            tkTasktype = new TkTasktype();
        }
        try {
            BeanUtils.copyAllPropertys((Object)tkTasktype, (Object)tkTasktypeDomain);
            return tkTasktype;
        }
        catch (Exception e) {
            this.logger.error("tk.TkTasktypeServiceImpl.makeTasktype", (Throwable)e);
            return null;
        }
    }

    private TkTasktypeReDomain makeTkTasktypeReDomain(TkTasktype tkTasktype) {
        if (null == tkTasktype) {
            return null;
        }
        TkTasktypeReDomain tkTasktypeReDomain = new TkTasktypeReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)tkTasktypeReDomain, (Object)tkTasktype);
            return tkTasktypeReDomain;
        }
        catch (Exception e) {
            this.logger.error("tk.TkTasktypeServiceImpl.makeTkTasktypeReDomain", (Throwable)e);
            return null;
        }
    }

    private List<TkTasktype> queryTasktypeModelPage(Map<String, Object> parammap) {
        try {
            return this.tkTasktypeMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("tk.TkTasktypeServiceImpl.queryTasktypeModel", (Throwable)e);
            return null;
        }
    }

    private int countTasktype(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.tkTasktypeMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("tk.TkTasktypeServiceImpl.countTasktype", (Throwable)e);
        }
        return i;
    }

    private TkTasktype createTkTasktype(TkTasktypeDomain tkTasktypeDomain) {
        String msg = this.checkTasktype(tkTasktypeDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("tk.TkTasktypeServiceImpl.saveTasktype.checkTasktype", msg);
        }
        TkTasktype tkTasktype = this.makeTasktype(tkTasktypeDomain, null);
        this.setTasktypeDefault(tkTasktype);
        return tkTasktype;
    }

    @Override
    public String saveTasktype(TkTasktypeDomain tkTasktypeDomain) throws ApiException {
        TkTasktype tkTasktype = this.createTkTasktype(tkTasktypeDomain);
        this.saveTasktypeModel(tkTasktype);
        return tkTasktype.getTasktypeCode();
    }

    @Override
    public String saveTasktypeBatch(List<TkTasktypeDomain> tkTasktypeDomainList) throws ApiException {
        if (null == tkTasktypeDomainList || tkTasktypeDomainList.isEmpty()) {
            return null;
        }
        ArrayList<TkTasktype> tkTasktypeList = new ArrayList<TkTasktype>();
        String code = "";
        for (TkTasktypeDomain tkTasktypeDomain : tkTasktypeDomainList) {
            TkTasktype tkTasktype = this.createTkTasktype(tkTasktypeDomain);
            code = tkTasktype.getTasktypeCode();
            tkTasktypeList.add(tkTasktype);
        }
        this.saveTasktypeBatchModel(tkTasktypeList);
        return code;
    }

    @Override
    public void updateTasktypeState(Integer tasktypeId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == tasktypeId) {
            return;
        }
        this.updateStateTasktypeModel(tasktypeId, dataState, oldDataState, map);
    }

    @Override
    public void updateTasktypeStateByCode(String tenantCode, String tasktypeCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)tasktypeCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateTasktypeModelByCode(tenantCode, tasktypeCode, dataState, oldDataState, map);
    }

    @Override
    public void updateTasktype(TkTasktypeDomain tkTasktypeDomain) throws ApiException {
        String msg = this.checkTasktype(tkTasktypeDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("tk.TkTasktypeServiceImpl.updateTasktype.checkTasktype", msg);
        }
        TkTasktype oldTkTasktype = this.getTasktypeModelById(tkTasktypeDomain.getTasktypeId());
        if (null == oldTkTasktype) {
            throw new ApiException("tk.TkTasktypeServiceImpl.updateTasktype.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        TkTasktype tkTasktype = this.makeTasktype(tkTasktypeDomain, oldTkTasktype);
        this.setTasktypeUpdataDefault(tkTasktype);
        this.updateTasktypeModel(tkTasktype);
    }

    @Override
    public TkTasktype getTasktype(Integer tasktypeId) {
        if (null == tasktypeId) {
            return null;
        }
        return this.getTasktypeModelById(tasktypeId);
    }

    @Override
    public void deleteTasktype(Integer tasktypeId) throws ApiException {
        if (null == tasktypeId) {
            return;
        }
        this.deleteTasktypeModel(tasktypeId);
    }

    @Override
    public QueryResult<TkTasktype> queryTasktypePage(Map<String, Object> map) {
        List<TkTasktype> tkTasktypeList = this.queryTasktypeModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countTasktype(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(tkTasktypeList);
        return queryResult;
    }

    @Override
    public TkTasktype getTasktypeByCode(String tenantCode, String tasktypeCode) throws ApiException {
        if (StringUtils.isBlank((String)tasktypeCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("tasktypeCode", tasktypeCode);
        return this.getTasktypeModelByCode(map);
    }

    @Override
    public void deleteTasktypeByCode(String tenantCode, String tasktypeCode) throws ApiException {
        if (StringUtils.isBlank((String)tasktypeCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("tasktypeCode", tasktypeCode);
        this.delTasktypeModelByCode(map);
    }
}

