/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.tk.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tk.dao.TkTaskMapper;
import com.yqbsoft.laser.service.tk.domain.OcContractDomain;
import com.yqbsoft.laser.service.tk.domain.OcContractGoodsDomain;
import com.yqbsoft.laser.service.tk.domain.OcContractReDomain;
import com.yqbsoft.laser.service.tk.domain.OcContractpro;
import com.yqbsoft.laser.service.tk.domain.TkChannelsendDomain;
import com.yqbsoft.laser.service.tk.domain.TkTaskDomain;
import com.yqbsoft.laser.service.tk.domain.TkTaskReDomain;
import com.yqbsoft.laser.service.tk.model.TkChannelsend;
import com.yqbsoft.laser.service.tk.model.TkTask;
import com.yqbsoft.laser.service.tk.model.TkTasklist;
import com.yqbsoft.laser.service.tk.service.TkChannelsendService;
import com.yqbsoft.laser.service.tk.service.TkTaskService;
import com.yqbsoft.laser.service.tk.service.TkTasklistService;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TkTaskServiceImpl
extends BaseServiceImpl
implements TkTaskService {
    private static final String SYS_CODE = "tk.TkTaskServiceImpl";
    private TkTaskMapper tkTaskMapper;
    private TkTasklistService tkTasklistService;
    TkChannelsendService tkChannelsendService;

    public void setTkTaskMapper(TkTaskMapper tkTaskMapper) {
        this.tkTaskMapper = tkTaskMapper;
    }

    public void setTkTasklistService(TkTasklistService tkTasklistService) {
        this.tkTasklistService = tkTasklistService;
    }

    public void setTkChannelsendService(TkChannelsendService tkChannelsendService) {
        this.tkChannelsendService = tkChannelsendService;
    }

    private Date getSysDate() {
        try {
            return this.tkTaskMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("tk.TkTaskServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkTask(TkTaskDomain tkTaskDomain) {
        if (null == tkTaskDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)tkTaskDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setTaskDefault(TkTask tkTask) {
        if (null == tkTask) {
            return;
        }
        if (null == tkTask.getDataState()) {
            tkTask.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == tkTask.getGmtCreate()) {
            tkTask.setGmtCreate(date);
        }
        tkTask.setGmtModified(date);
        if (StringUtils.isBlank((String)tkTask.getTaskCode())) {
            tkTask.setTaskCode(this.getNo(null, "TkTask", "tkTask", tkTask.getTenantCode()));
        }
    }

    private int getTaskMaxCode() {
        int code = 0;
        try {
            return this.tkTaskMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("tk.TkTaskServiceImpl.getTaskMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setTaskUpdataDefault(TkTask tkTask) {
        if (null == tkTask) {
            return;
        }
        tkTask.setGmtModified(this.getSysDate());
    }

    private void saveTaskModel(TkTask tkTask) throws ApiException {
        if (null == tkTask) {
            return;
        }
        try {
            this.tkTaskMapper.insert(tkTask);
        }
        catch (Exception e) {
            throw new ApiException("tk.TkTaskServiceImpl.saveTaskModel.ex", (Throwable)e);
        }
    }

    private void saveTaskBatchModel(List<TkTask> tkTaskList) throws ApiException {
        if (null == tkTaskList || tkTaskList.isEmpty()) {
            return;
        }
        try {
            this.tkTaskMapper.insertBatch(tkTaskList);
        }
        catch (Exception e) {
            throw new ApiException("tk.TkTaskServiceImpl.saveTaskBatchModel.ex", (Throwable)e);
        }
    }

    private TkTask getTaskModelById(Integer taskId) {
        if (null == taskId) {
            return null;
        }
        try {
            return this.tkTaskMapper.selectByPrimaryKey(taskId);
        }
        catch (Exception e) {
            this.logger.error("tk.TkTaskServiceImpl.getTaskModelById", (Throwable)e);
            return null;
        }
    }

    private TkTask getTaskModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.tkTaskMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("tk.TkTaskServiceImpl.getTaskModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delTaskModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.tkTaskMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("tk.TkTaskServiceImpl.delTaskModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("tk.TkTaskServiceImpl.delTaskModelByCode.num");
        }
    }

    private void deleteTaskModel(Integer taskId) throws ApiException {
        if (null == taskId) {
            return;
        }
        int i = 0;
        try {
            i = this.tkTaskMapper.deleteByPrimaryKey(taskId);
        }
        catch (Exception e) {
            throw new ApiException("tk.TkTaskServiceImpl.deleteTaskModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("tk.TkTaskServiceImpl.deleteTaskModel.num");
        }
    }

    private void updateTaskModel(TkTask tkTask) throws ApiException {
        if (null == tkTask) {
            return;
        }
        int i = 0;
        try {
            i = this.tkTaskMapper.updateByPrimaryKey(tkTask);
        }
        catch (Exception e) {
            throw new ApiException("tk.TkTaskServiceImpl.updateTaskModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("tk.TkTaskServiceImpl.updateTaskModel.num");
        }
    }

    private void updateStateTaskModel(Integer taskId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == taskId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("taskId", taskId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.tkTaskMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("tk.TkTaskServiceImpl.updateStateTaskModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("tk.TkTaskServiceImpl.updateStateTaskModel.null");
        }
    }

    private void updateStateTaskModelByCode(String tenantCode, String taskCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)taskCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("taskCode", taskCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.tkTaskMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("tk.TkTaskServiceImpl.updateStateTaskModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("tk.TkTaskServiceImpl.updateStateTaskModelByCode.null");
        }
    }

    private TkTask makeTask(TkTaskDomain tkTaskDomain, TkTask tkTask) {
        if (null == tkTaskDomain) {
            return null;
        }
        if (null == tkTask) {
            tkTask = new TkTask();
        }
        try {
            BeanUtils.copyAllPropertys((Object)tkTask, (Object)tkTaskDomain);
            return tkTask;
        }
        catch (Exception e) {
            this.logger.error("tk.TkTaskServiceImpl.makeTask", (Throwable)e);
            return null;
        }
    }

    private TkTaskReDomain makeTkTaskReDomain(TkTask tkTask) {
        if (null == tkTask) {
            return null;
        }
        TkTaskReDomain tkTaskReDomain = new TkTaskReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)tkTaskReDomain, (Object)tkTask);
            return tkTaskReDomain;
        }
        catch (Exception e) {
            this.logger.error("tk.TkTaskServiceImpl.makeTkTaskReDomain", (Throwable)e);
            return null;
        }
    }

    private List<TkTask> queryTaskModelPage(Map<String, Object> parammap) {
        try {
            return this.tkTaskMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("tk.TkTaskServiceImpl.queryTaskModel", (Throwable)e);
            return null;
        }
    }

    private int countTask(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.tkTaskMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("tk.TkTaskServiceImpl.countTask", (Throwable)e);
        }
        return i;
    }

    private TkTask createTkTask(TkTaskDomain tkTaskDomain) {
        String msg = this.checkTask(tkTaskDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("tk.TkTaskServiceImpl.saveTask.checkTask", msg);
        }
        TkTask tkTask = this.makeTask(tkTaskDomain, null);
        this.setTaskDefault(tkTask);
        return tkTask;
    }

    @Override
    public List<TkChannelsend> saveTask(TkTaskDomain tkTaskDomain) throws ApiException {
        TkTask tkTask = this.createTkTask(tkTaskDomain);
        ArrayList<TkTask> tkTaskList = new ArrayList<TkTask>();
        this.saveTaskModel(tkTask);
        tkTaskList.add(tkTask);
        return this.buidPmChannelsend(tkTaskList, "insert");
    }

    @Override
    public List<TkChannelsend> saveTaskBatch(List<TkTaskDomain> tkTaskDomainList) throws ApiException {
        if (null == tkTaskDomainList || tkTaskDomainList.isEmpty()) {
            return null;
        }
        ArrayList<TkTask> tkTaskList = new ArrayList<TkTask>();
        String code = "";
        for (TkTaskDomain tkTaskDomain : tkTaskDomainList) {
            TkTask tkTask = this.createTkTask(tkTaskDomain);
            code = tkTask.getTaskCode();
            tkTaskList.add(tkTask);
        }
        this.saveTaskBatchModel(tkTaskList);
        return this.buidPmChannelsend(tkTaskList, "insert");
    }

    @Override
    public List<TkChannelsend> updateTaskState(Integer taskId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == taskId) {
            return null;
        }
        this.updateStateTaskModel(taskId, dataState, oldDataState, map);
        TkTask tkTask = this.getTask(taskId);
        if (null == tkTask) {
            this.logger.error("tk.TkTaskServiceImpl.updateTaskState", (Object)"\u6570\u636e\u4e3a\u7a7a");
            return null;
        }
        ArrayList<TkTask> tkTaskList = new ArrayList<TkTask>();
        tkTaskList.add(tkTask);
        return this.buidPmChannelsend(tkTaskList, "update");
    }

    @Override
    public List<TkChannelsend> updateTaskStateByCode(String tenantCode, String taskCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)taskCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        this.updateStateTaskModelByCode(tenantCode, taskCode, dataState, oldDataState, map);
        TkTask tkTask = this.getTaskByCode(tenantCode, taskCode);
        if (null == tkTask) {
            this.logger.error("tk.TkTaskServiceImpl.updateTaskStateByCode", (Object)"\u6570\u636e\u4e3a\u7a7a");
            return null;
        }
        ArrayList<TkTask> tkTaskList = new ArrayList<TkTask>();
        tkTaskList.add(tkTask);
        return this.buidPmChannelsend(tkTaskList, "update");
    }

    @Override
    public List<TkChannelsend> updateTask(TkTaskDomain tkTaskDomain) throws ApiException {
        String msg = this.checkTask(tkTaskDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("tk.TkTaskServiceImpl.updateTask.checkTask", msg);
        }
        TkTask oldTkTask = this.getTaskModelById(tkTaskDomain.getTaskId());
        if (null == oldTkTask) {
            throw new ApiException("tk.TkTaskServiceImpl.updateTask.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        TkTask tkTask = this.makeTask(tkTaskDomain, oldTkTask);
        this.setTaskUpdataDefault(tkTask);
        this.updateTaskModel(tkTask);
        ArrayList<TkTask> tkTaskList = new ArrayList<TkTask>();
        tkTaskList.add(tkTask);
        return this.buidPmChannelsend(tkTaskList, "update");
    }

    @Override
    public TkTask getTask(Integer taskId) {
        if (null == taskId) {
            return null;
        }
        TkTask taskModelById = this.getTaskModelById(taskId);
        this.getTkTaskReRelatedData(taskModelById);
        return taskModelById;
    }

    @Override
    public void deleteTask(Integer taskId) throws ApiException {
        if (null == taskId) {
            return;
        }
        this.deleteTaskModel(taskId);
    }

    @Override
    public QueryResult<TkTask> queryTaskPage(Map<String, Object> map) {
        List<TkTask> tkTaskList = this.queryTaskModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countTask(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        for (TkTask tkTask : tkTaskList) {
            this.getTkTaskReRelatedData(tkTask);
        }
        queryResult.setList(tkTaskList);
        return queryResult;
    }

    void getTkTaskReRelatedData(TkTask tkTask) {
        if (null == tkTask) {
            return;
        }
        String tenantCode = tkTask.getTenantCode();
        String taskCode = tkTask.getTaskCode();
        Map paramMap = this.getQueryParamMap("taskCode,tenantCode", new Object[]{taskCode, tenantCode});
        QueryResult<TkTasklist> tkTasklistQueryResult = this.tkTasklistService.queryTasklistPage(paramMap);
        if (null != tkTasklistQueryResult && ListUtil.isNotEmpty((Collection)tkTasklistQueryResult.getList())) {
            tkTask.setTkTasklistList(tkTasklistQueryResult.getList());
        }
    }

    @Override
    public TkTask getTaskByCode(String tenantCode, String taskCode) throws ApiException {
        if (StringUtils.isBlank((String)taskCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("taskCode", taskCode);
        return this.getTaskModelByCode(map);
    }

    @Override
    public void deleteTaskByCode(String tenantCode, String taskCode) throws ApiException {
        if (StringUtils.isBlank((String)taskCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("taskCode", taskCode);
        this.delTaskModelByCode(map);
    }

    @Override
    public String sendOrderTask(OcContractDomain ocContractDomain) {
        if (null == ocContractDomain) {
            return null;
        }
        TkTaskDomain tkTaskDomain = new TkTaskDomain();
        try {
            BeanUtils.copyAllPropertys((Object)tkTaskDomain, (Object)ocContractDomain);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (ocContractDomain.getContractType().equals("17")) {
            List<OcContractpro> ocContractpros = this.querycontractproPage(ocContractDomain.getTenantCode(), ocContractDomain.getContractBillcode());
            OcContractReDomain contractByCode = this.getContractByCode(ocContractDomain.getTenantCode(), ocContractDomain.getContractNbbillcode());
            if (ocContractDomain.getGoodsList().get(0).getGoodsPro().equals("01")) {
                tkTaskDomain.setTaskName("\u7cbe\u4fee");
                tkTaskDomain.setTaskOpcode(ocContractDomain.getContractBillcode());
                tkTaskDomain.setTaskDes("2");
                tkTaskDomain.setTaskDes("\u7cbe\u4fee");
                tkTaskDomain.setTaskName("\u7cbe\u4fee");
                tkTaskDomain.setTasktypeCode(ocContractDomain.getGoodsList().get(0).getContractBillcode());
                tkTaskDomain.setTaskIndes(ocContractDomain.getGoodsList().get(0).getGoodsName());
                tkTaskDomain.setTaskOutdes(ocContractDomain.getGoodsList().get(0).getDataPic());
                tkTaskDomain.setTaskOpdes(ocContractDomain.getContractNbbillcode());
                if (ListUtil.isNotEmpty(ocContractpros)) {
                    tkTaskDomain.setTaskOutdes(ocContractpros.get(0).getContractproValue());
                }
            } else {
                tkTaskDomain.setTaskName("Vlog");
                tkTaskDomain.setTaskOpcode(ocContractDomain.getContractBillcode());
                tkTaskDomain.setTaskDes("3");
                tkTaskDomain.setTaskDes("Vlog");
                tkTaskDomain.setTaskName("Vlog");
                tkTaskDomain.setTasktypeCode(ocContractDomain.getGoodsList().get(0).getContractBillcode());
                tkTaskDomain.setTaskIndes(ocContractDomain.getGoodsList().get(0).getGoodsName());
                tkTaskDomain.setTaskOutdes(ocContractDomain.getGoodsList().get(0).getDataPic());
                tkTaskDomain.setTaskOpdes(ocContractDomain.getContractNbbillcode());
                if (null != contractByCode) {
                    for (OcContractGoodsDomain ocContractGoodsDomain : contractByCode.getGoodsList()) {
                        if (ocContractGoodsDomain.getGoodsType().equals("0")) continue;
                        tkTaskDomain.setTaskOutdes(ocContractGoodsDomain.getDataPic());
                    }
                }
            }
            String goodsname = "";
            if (null != contractByCode) {
                for (OcContractGoodsDomain ocContractGoodsDomain : contractByCode.getGoodsList()) {
                    if (!ocContractGoodsDomain.getGoodsType().equals("0")) {
                        tkTaskDomain.setTaskIndes(ocContractGoodsDomain.getGoodsName());
                    }
                    if (!"02".equals(ocContractGoodsDomain.getGoodsPro())) continue;
                    goodsname = ocContractGoodsDomain.getGoodsName();
                }
            }
            if ("02".equals(ocContractDomain.getGoodsList().get(0).getGoodsPro())) {
                tkTaskDomain.setTaskIndes(goodsname);
            }
            tkTaskDomain.setTaskOpcode1(ocContractDomain.getAreaName());
        } else {
            tkTaskDomain.setTaskName("\u5feb\u4fee");
            tkTaskDomain.setTaskOpcode(ocContractDomain.getContractBillcode());
            tkTaskDomain.setTaskDes("1");
            tkTaskDomain.setTaskDes("\u5feb\u4fee");
            tkTaskDomain.setTaskName("\u5feb\u4fee");
            tkTaskDomain.setTasktypeCode("123456789");
        }
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("tkTaskDomain", JsonUtil.buildNormalBinder().toJson((Object)tkTaskDomain));
        this.internalInvoke("tk.channelsendBase.saveTask", paramMap);
        return "success";
    }

    private List<TkChannelsend> buidPmChannelsend(List<TkTask> tkTaskList, String dri) {
        if (ListUtil.isEmpty(tkTaskList)) {
            return null;
        }
        ArrayList<TkChannelsend> pmChannelsendList = new ArrayList();
        ArrayList<TkChannelsendDomain> disChannelsendDomainList = new ArrayList<TkChannelsendDomain>();
        for (TkTask tkTask : tkTaskList) {
            TkChannelsendDomain tkChannelsendDomain = new TkChannelsendDomain();
            tkChannelsendDomain.setChannelsendOpcode(tkTask.getTaskCode());
            tkChannelsendDomain.setChannelsendType("tkTask");
            tkChannelsendDomain.setChannelsendDir(dri);
            tkChannelsendDomain.setChannelsendTxt(JsonUtil.buildNormalBinder().toJson((Object)tkTask));
            tkChannelsendDomain.setTenantCode(tkTask.getTenantCode());
            disChannelsendDomainList.add(tkChannelsendDomain);
        }
        pmChannelsendList = this.tkChannelsendService.saveChannelsendBatch(disChannelsendDomainList);
        return pmChannelsendList;
    }

    public List<OcContractpro> querycontractproPage(String tenantCode, String contractBillcode) {
        if (StringUtils.isBlank((String)contractBillcode)) {
            return null;
        }
        String api = "oc.contractpro.querycontractproPage";
        HashMap<String, String> parameter = new HashMap<String, String>();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("contractBillcode", contractBillcode);
        map.put("tenantCode", tenantCode);
        parameter.put("map", JsonUtil.buildNonDefaultBinder().toJson(map));
        String json = (String)this.getInternalRouter().inInvoke(api, parameter);
        SupQueryResult ocContractproSupQueryResult = (SupQueryResult)JsonUtil.buildNormalBinder().getJsonToObject(json, SupQueryResult.class);
        List ocContractpros = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)ocContractproSupQueryResult.getList()), OcContractpro.class);
        if (ListUtil.isEmpty((Collection)ocContractpros)) {
            this.logger.error("tk.TkTaskServiceImpl.querycontractproPage.invlist.null", (Object)JsonUtil.buildNonDefaultBinder().toJson(map));
            return null;
        }
        return ocContractpros;
    }

    public OcContractReDomain getContractByCode(String tenantCode, String contractBillcode) {
        if (StringUtils.isBlank((String)contractBillcode)) {
            return null;
        }
        String apiCode = "oc.contract.getContractByCode";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("map", JsonUtil.buildNormalBinder().toJson((Object)this.getQueryParamMap("contractBillcode,tenantCode", new Object[]{contractBillcode, tenantCode})));
        String json = this.internalInvoke(apiCode, paramMap);
        if (StringUtils.isBlank((String)json)) {
            this.logger.error("tk.TkTaskServiceImpl.getContractByCode  json", (Object)((Object)paramMap).toString());
            return null;
        }
        OcContractReDomain ocContractReDomain = (OcContractReDomain)JsonUtil.buildNormalBinder().getJsonToObject(json, OcContractReDomain.class);
        if (null == ocContractReDomain) {
            this.logger.error("tk.TkTaskServiceImpl.getContractByCode  ocContractReDomain", (Object)((Object)paramMap).toString());
            return null;
        }
        return ocContractReDomain;
    }
}

