/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.tool.util;

public class BCDASCIIUtil {
    public static final String DEFAULT_CHARSET = "UTF-8";
    public static final byte ALPHA_A_ASCII_VALUE = 65;
    public static final byte ALPHA_a_ASCII_VALUE = 97;
    public static final byte DIGITAL_0_ASCII_VALUE = 48;

    private BCDASCIIUtil() {
    }

    public static void fromBCDToASCII(byte[] bcdBuf, int bcdOffset, byte[] asciiBuf, int asciiOffset, int asciiLen, boolean rightAlignFlag) {
        int cnt;
        if ((asciiLen & 1) == 1 && rightAlignFlag) {
            cnt = 1;
            ++asciiLen;
        } else {
            cnt = 0;
        }
        while (cnt < asciiLen) {
            asciiBuf[asciiOffset] = (byte)((cnt & 1) == 1 ? bcdBuf[bcdOffset++] & 0xF : bcdBuf[bcdOffset] >> 4 & 0xF);
            asciiBuf[asciiOffset] = (byte)(asciiBuf[asciiOffset] + (asciiBuf[asciiOffset] > 9 ? 55 : 48));
            ++cnt;
            ++asciiOffset;
        }
    }

    public static byte[] fromBCDToASCII(byte[] bcdBuf, int bcdOffset, int asciiLen, boolean rightAlignFlag) {
        byte[] asciiBuf = new byte[asciiLen];
        BCDASCIIUtil.fromBCDToASCII(bcdBuf, bcdOffset, asciiBuf, 0, asciiLen, rightAlignFlag);
        return asciiBuf;
    }

    public static byte[] fromBCDToASCII(byte[] bcdBuf) {
        byte[] asciiBuf = new byte[bcdBuf.length * 2];
        BCDASCIIUtil.fromBCDToASCII(bcdBuf, 0, asciiBuf, 0, bcdBuf.length * 2, false);
        return asciiBuf;
    }

    public static String fromBCDToASCIIString(byte[] bcdBuf, int bcdOffset, int asciiLen, boolean rightAlignFlag) {
        try {
            return new String(BCDASCIIUtil.fromBCDToASCII(bcdBuf, bcdOffset, asciiLen, rightAlignFlag), DEFAULT_CHARSET);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static String fromBCDToASCIIString(byte[] bcdBuf) {
        try {
            return new String(BCDASCIIUtil.fromBCDToASCII(bcdBuf, 0, bcdBuf.length * 2, false), DEFAULT_CHARSET);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static void fromASCIIToBCD(byte[] asciiBuf, int asciiOffset, int asciiLen, byte[] bcdBuf, int bcdOffset, boolean rightAlignFlag) {
        int ch1 = (asciiLen & 1) == 1 && rightAlignFlag ? 0 : 85;
        int cnt = 0;
        while (cnt < asciiLen) {
            byte ch = asciiBuf[asciiOffset] >= 97 ? (byte)(asciiBuf[asciiOffset] - 97 + 10) : (asciiBuf[asciiOffset] >= 65 ? (byte)(asciiBuf[asciiOffset] - 65 + 10) : (asciiBuf[asciiOffset] >= 48 ? (byte)(asciiBuf[asciiOffset] - 48) : (byte)0));
            if (ch1 == 85) {
                ch1 = ch;
            } else {
                bcdBuf[bcdOffset] = (byte)(ch1 << 4 | ch);
                ++bcdOffset;
                ch1 = 85;
            }
            ++cnt;
            ++asciiOffset;
        }
        if (ch1 != 85) {
            bcdBuf[bcdOffset] = (byte)(ch1 << 4);
        }
    }

    public static void fromASCIIToBCD(String asciiStr, int asciiOffset, int asciiLen, byte[] bcdBuf, int bcdOffset, boolean rightAlignFlag) {
        try {
            byte[] asciiBuf = asciiStr.getBytes(DEFAULT_CHARSET);
            BCDASCIIUtil.fromASCIIToBCD(asciiBuf, asciiOffset, asciiLen, bcdBuf, bcdOffset, rightAlignFlag);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static byte[] fromASCIIToBCD(byte[] asciiBuf, int asciiOffset, int asciiLen, boolean rightAlignFlag) {
        byte[] bcdBuf = new byte[(asciiLen + 1) / 2];
        BCDASCIIUtil.fromASCIIToBCD(asciiBuf, asciiOffset, asciiLen, bcdBuf, 0, rightAlignFlag);
        return bcdBuf;
    }

    public static byte[] fromASCIIToBCD(byte[] asciiBuf) {
        int asciiOffset = 0;
        int asciiLen = asciiBuf.length;
        boolean rightAlignFlag = false;
        byte[] bcdBuf = new byte[(asciiLen + 1) / 2];
        BCDASCIIUtil.fromASCIIToBCD(asciiBuf, asciiOffset, asciiLen, bcdBuf, 0, rightAlignFlag);
        return bcdBuf;
    }

    public static byte[] fromASCIIToBCD(String asciiStr, int asciiOffset, int asciiLen, boolean rightAlignFlag) {
        try {
            byte[] asciiBuf = asciiStr.getBytes(DEFAULT_CHARSET);
            return BCDASCIIUtil.fromASCIIToBCD(asciiBuf, asciiOffset, asciiLen, rightAlignFlag);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static void printBytes(byte[] b) {
        for (int j = 0; j < b.length; ++j) {
            for (int i = 7; i >= 0; --i) {
                int v = 1 & b[j] >> i;
                System.out.print(v);
                if (i != 4) continue;
                System.out.print(' ');
            }
            System.out.print(' ');
        }
        System.out.println(' ');
    }
}

