/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.tool.util;

import com.fasterxml.jackson.core.type.TypeReference;
import com.yqbsoft.laser.service.tool.util.FileItem;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import com.yqbsoft.laser.service.tool.util.WebUtils;
import java.util.List;
import java.util.Map;

public class HttpInvokeUtil {
    private static final String CHARSET = "UTF-8";
    public static final String ERRORCODE = "errorCode";
    public static final String MSG = "msg";
    public static final String SUBCODE = "subCode";
    public static final String SUBMSG = "subMsg";
    public static final String ERROR_RESPONSE = "error_response";
    private static final int CONNECTTIMEOUT = 300000;
    private static final int READTIMEOUT = 300000;

    public static <T> T callAsObject(String url, Map<String, String> params, Class<T> cls, String charset, int connectTimeout, int readTimeout) throws RuntimeException {
        return (T)HttpInvokeUtil.call(url, params, "object", charset, connectTimeout, readTimeout, cls);
    }

    public static <T> T callAsObject(String url, Map<String, String> params, Class<T> cls) throws RuntimeException {
        return (T)HttpInvokeUtil.call(url, params, "object", CHARSET, 300000, 300000, cls);
    }

    public static Object callAsSaasMap(String url, Map<String, String> params) throws RuntimeException {
        return HttpInvokeUtil.readObjForSaas(url, params, "object", CHARSET, 300000, 300000);
    }

    public static <T> T callAsObjectForSaas(String url, Map<String, String> params, Class<T> cls) throws RuntimeException {
        return (T)HttpInvokeUtil.call(url, params, "object", CHARSET, 300000, 300000, cls);
    }

    public static void call(String url, Map<String, String> params, String charset, int connectTimeout, int readTimeout) throws RuntimeException {
        HttpInvokeUtil.call(url, params, "", charset, connectTimeout, readTimeout, new Object[0]);
    }

    public static void call(String url, Map<String, String> params) throws RuntimeException {
        HttpInvokeUtil.call(url, params, "", CHARSET, 300000, 300000, new Object[0]);
    }

    public static void call(String url, Map<String, String> params, Map<String, FileItem> fileParams) throws RuntimeException {
        HttpInvokeUtil.callForUpload(url, params, fileParams, CHARSET, 300000, 300000);
    }

    public static Object callUploadAsObject(String url, Map<String, String> params, Map<String, FileItem> fileParams, Class<?> cls) throws RuntimeException {
        String result = HttpInvokeUtil.callForUpload(url, params, fileParams, CHARSET, 300000, 300000);
        Object[] resultMap = new Object[]{cls};
        Map respMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(result, String.class, Object.class);
        if (respMap == null || respMap.isEmpty()) {
            throw new RuntimeException("\u8bf7\u6c42\u5f02\u5e38");
        }
        if (respMap.get(ERROR_RESPONSE) == null) {
            String object = respMap.get(params.get("method").replaceAll("\\.", "_") + "_response") == null ? "" : JsonUtil.buildNormalBinder().toJson(respMap.get(params.get("method").replaceAll("\\.", "_") + "_response"));
            Object obj = JsonUtil.buildNormalBinder().getJsonToObject(object, (Class)resultMap[0]);
            return obj;
        }
        Map errorMap = (Map)respMap.get(ERROR_RESPONSE);
        if (errorMap.get(SUBCODE) != null && StringUtils.isNotBlank(((String)errorMap.get(SUBCODE)).toString())) {
            throw new RuntimeException((String)errorMap.get(SUBCODE) + ":" + (String)errorMap.get(SUBMSG));
        }
        throw new RuntimeException((String)errorMap.get(ERRORCODE) + ":" + (String)errorMap.get(MSG));
    }

    public static Map callAsMap(String url, Map<String, String> params, Class keyclazz, Class valueclazz, String charset, int connectTimeout, int readTimeout) throws RuntimeException {
        return (Map)HttpInvokeUtil.call(url, params, "map", charset, connectTimeout, readTimeout, keyclazz, valueclazz);
    }

    public static Map callAsMap(String url, Map<String, String> params, Class keyclazz, Class valueclazz) throws RuntimeException {
        return (Map)HttpInvokeUtil.call(url, params, "map", CHARSET, 300000, 300000, keyclazz, valueclazz);
    }

    public static List<?> callAsList(String url, Map<String, String> params, Class<?> valueclazz, String charset, int connectTimeout, int readTimeout) throws RuntimeException {
        return (List)HttpInvokeUtil.call(url, params, "list", charset, connectTimeout, readTimeout, valueclazz);
    }

    public static List<?> callAsList(String url, Map<String, String> params, Class<?> valueclazz) throws RuntimeException {
        return (List)HttpInvokeUtil.call(url, params, "list", CHARSET, 300000, 300000, valueclazz);
    }

    private static Object call(String url, Map<String, String> params, String type2, String charset, int connectTimeout, int readTimeout, Object ... resultMap) throws RuntimeException {
        return HttpInvokeUtil.readObj(url, params, type2, charset, connectTimeout, readTimeout, resultMap);
    }

    public static <T> T callAsTypeRefrence(String url, Map<String, String> params, TypeReference<T> typeReference) throws RuntimeException {
        return (T)HttpInvokeUtil.call(url, params, "typeRefrence", CHARSET, 300000, 300000, typeReference);
    }

    public static <T> T callAsTypeRefrence(String url, Map<String, String> params, TypeReference<T> typeReference, String charset, int connectTimeout, int readTimeout) throws RuntimeException {
        return (T)HttpInvokeUtil.call(url, params, "typeRefrence", charset, connectTimeout, readTimeout, typeReference);
    }

    private static Object readObj(String url, Map<String, String> params, String type2, String charset, int connectTimeout, int readTimeout, Object ... resultMap) throws RuntimeException {
        String result = HttpInvokeUtil.callAsJson(url, params, charset, connectTimeout, readTimeout);
        Map respMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(result, String.class, Object.class);
        if (respMap == null || respMap.isEmpty()) {
            throw new RuntimeException("\u8bf7\u6c42\u5f02\u5e38");
        }
        if (respMap.get(ERROR_RESPONSE) == null) {
            String object;
            String string = object = respMap.get(params.get("method").replaceAll("\\.", "_") + "_response") == null ? "" : JsonUtil.buildNormalBinder().toJson(respMap.get(params.get("method").replaceAll("\\.", "_") + "_response"));
            if (type2.equals("")) {
                return "";
            }
            if (object == null) {
                return null;
            }
            if (type2.equals("object")) {
                String cname = ((Class)resultMap[0]).getName();
                Object obj = null;
                if (null != cname && cname.indexOf("java.lang.") == 0) {
                    Map map = (Map)JsonUtil.buildNormalBinder().getJsonToMap(object, String.class, (Class)resultMap[0]);
                    if (null != map) {
                        obj = map.get("result");
                    }
                } else {
                    obj = JsonUtil.buildNormalBinder().getJsonToObject(object, (Class)resultMap[0]);
                }
                return obj;
            }
            if (type2.equals("map")) {
                Object obj = JsonUtil.buildNormalBinder().getJsonToMap(object, (Class)resultMap[0], (Class)resultMap[1]);
                return obj;
            }
            if (type2.equals("list")) {
                Object obj = JsonUtil.buildNormalBinder().getJsonToList(object, (Class)resultMap[0]);
                return obj;
            }
            if (type2.equals("typeRefrence")) {
                Object obj = JsonUtil.buildNormalBinder().getJsonToObject(object, (TypeReference)resultMap[0]);
                return obj;
            }
            throw new RuntimeException("Unsupport " + type2);
        }
        Map errorMap = (Map)respMap.get(ERROR_RESPONSE);
        if (errorMap.get(SUBCODE) != null && StringUtils.isNotBlank(((String)errorMap.get(SUBCODE)).toString())) {
            throw new RuntimeException((String)errorMap.get(SUBCODE) + ":" + (String)errorMap.get(SUBMSG));
        }
        throw new RuntimeException((String)errorMap.get(ERRORCODE) + ":" + (String)errorMap.get(MSG));
    }

    private static Object readObjForSaas(String url, Map<String, String> params, String type2, String charset, int connectTimeout, int readTimeout) throws RuntimeException {
        String result = HttpInvokeUtil.callAsJson(url, params, charset, connectTimeout, readTimeout);
        Map respMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(result, String.class, Object.class);
        if (respMap == null || respMap.isEmpty()) {
            throw new RuntimeException("\u8bf7\u6c42\u5f02\u5e38");
        }
        if (respMap.get(ERROR_RESPONSE) == null) {
            String object = respMap.get(params.get("method").replaceAll("\\.", "_") + "_response") == null ? "" : JsonUtil.buildNormalBinder().toJson(respMap.get(params.get("method").replaceAll("\\.", "_") + "_response"));
            return object;
        }
        return respMap.get(ERROR_RESPONSE);
    }

    private static String callAsJson(String url, Map<String, String> params, String charset, int connectTimeout, int readTimeout) {
        if (StringUtils.isBlank(charset)) {
            charset = CHARSET;
        }
        String result = null;
        try {
            result = WebUtils.doPost(url, params, charset, connectTimeout, readTimeout);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("\u8bf7\u6c42\u9519\u8bef\uff1a" + e.getMessage());
        }
        return result;
    }

    private static String callForUpload(String url, Map<String, String> params, Map<String, FileItem> fileParams, String charset, int connectTimeout, int readTimeout) throws RuntimeException {
        if (StringUtils.isBlank(charset)) {
            charset = CHARSET;
        }
        String result = null;
        try {
            result = WebUtils.doPost(url, params, fileParams, connectTimeout, readTimeout);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("\u8bf7\u6c42\u9519\u8bef\uff1a" + e.getMessage());
        }
        return result;
    }
}

