/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.tool.util;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.io.StringWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class JsonUtil {
    private static JsonUtil allJsonUtil;
    private static JsonUtil notNullJsonUtil;
    private static JsonUtil notDefJsonUtil;
    private static JsonUtil notEmpJsonUtil;
    private ObjectMapper mapper = new ObjectMapper();

    public static JsonUtil getAllJsonUtil() {
        return allJsonUtil;
    }

    public static void setAllJsonUtil(JsonUtil allJsonUtil) {
        JsonUtil.allJsonUtil = allJsonUtil;
    }

    public static JsonUtil getNotNullJsonUtil() {
        return notNullJsonUtil;
    }

    public static void setNotNullJsonUtil(JsonUtil notNullJsonUtil) {
        JsonUtil.notNullJsonUtil = notNullJsonUtil;
    }

    public static JsonUtil getNotDefJsonUtil() {
        return notDefJsonUtil;
    }

    public static void setNotDefJsonUtil(JsonUtil notDefJsonUtil) {
        JsonUtil.notDefJsonUtil = notDefJsonUtil;
    }

    public static JsonUtil getNotEmpJsonUtil() {
        return notEmpJsonUtil;
    }

    public static void setNotEmpJsonUtil(JsonUtil notEmpJsonUtil) {
        JsonUtil.notEmpJsonUtil = notEmpJsonUtil;
    }

    public ObjectMapper getMapper() {
        return this.mapper;
    }

    public void setMapper(ObjectMapper mapper) {
        this.mapper = mapper;
    }

    public JsonUtil(JsonInclude.Include include) {
        this.mapper.setSerializationInclusion(include);
        this.mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.mapper.configure(DeserializationFeature.FAIL_ON_NUMBERS_FOR_ENUMS, true);
        switch (include) {
            case NON_NULL: 
            case NON_EMPTY: {
                this.mapper.disable(SerializationFeature.WRITE_NULL_MAP_VALUES);
            }
        }
        this.setDateFormat("yyyy-MM-dd HH:mm:ss");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JsonUtil buildNormalBinder() {
        Class<JsonUtil> clazz = JsonUtil.class;
        synchronized (JsonUtil.class) {
            if (allJsonUtil == null) {
                allJsonUtil = new JsonUtil(JsonInclude.Include.ALWAYS);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return allJsonUtil;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JsonUtil buildNonNullBinder() {
        Class<JsonUtil> clazz = JsonUtil.class;
        synchronized (JsonUtil.class) {
            if (notNullJsonUtil == null) {
                notNullJsonUtil = new JsonUtil(JsonInclude.Include.NON_NULL);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return notNullJsonUtil;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JsonUtil buildNonDefaultBinder() {
        Class<JsonUtil> clazz = JsonUtil.class;
        synchronized (JsonUtil.class) {
            if (notDefJsonUtil == null) {
                notDefJsonUtil = new JsonUtil(JsonInclude.Include.NON_DEFAULT);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return notDefJsonUtil;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JsonUtil buildNonEmptyBinder() {
        Class<JsonUtil> clazz = JsonUtil.class;
        synchronized (JsonUtil.class) {
            if (notEmpJsonUtil == null) {
                notEmpJsonUtil = new JsonUtil(JsonInclude.Include.NON_EMPTY);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return notEmpJsonUtil;
        }
    }

    public <T> T getJsonToObject(String json, Class<T> clazz) {
        Object object = null;
        if (StringUtils.isNotBlank(json)) {
            try {
                object = this.getMapper().readValue(json, clazz);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return (T)object;
    }

    public Object getJsonToList(String json, Class clazz) {
        Object object = null;
        if (StringUtils.isNotBlank(json)) {
            try {
                object = this.getMapper().readValue(json, (JavaType)TypeFactory.defaultInstance().constructCollectionType(ArrayList.class, clazz));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return object;
    }

    public Object getJsonToListByMap(String json, Class clazz) {
        Object object = null;
        if (StringUtils.isNotBlank(json)) {
            try {
                object = this.getMapper().readValue(json, (JavaType)TypeFactory.defaultInstance().constructArrayType((JavaType)TypeFactory.defaultInstance().constructMapType(HashMap.class, String.class, clazz)));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return object;
    }

    public Object[] getJsonToArray(String json, Class clazz) {
        Object[] object = null;
        if (StringUtils.isNotBlank(json)) {
            try {
                object = (Object[])this.getMapper().readValue(json, (JavaType)TypeFactory.defaultInstance().constructArrayType(clazz));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return object;
    }

    public byte[] getJsonTobyteArray(String json) {
        byte[] object = null;
        if (StringUtils.isNotBlank(json)) {
            try {
                object = (byte[])this.getMapper().readValue(json, (JavaType)TypeFactory.defaultInstance().constructArrayType(Byte.TYPE));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return object;
    }

    public Object getJsonToMap(String json, Class keyclazz, Class valueclazz) {
        Object object = null;
        if (StringUtils.isNotBlank(json)) {
            try {
                object = this.getMapper().readValue(json, TypeFactory.defaultInstance().constructParametricType(HashMap.class, new Class[]{keyclazz, valueclazz}));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return object;
    }

    public Object getJsonToLinkedMap(String json, Class keyclazz, Class valueclazz) {
        Object object = null;
        if (StringUtils.isNotBlank(json)) {
            try {
                object = this.getMapper().readValue(json, TypeFactory.defaultInstance().constructParametricType(LinkedHashMap.class, new Class[]{keyclazz, valueclazz}));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return object;
    }

    public Object getJsonToConcMap(String json, Class keyclazz, Class valueclazz) {
        Object object = null;
        if (StringUtils.isNotBlank(json)) {
            try {
                object = this.getMapper().readValue(json, TypeFactory.defaultInstance().constructParametricType(ConcurrentHashMap.class, new Class[]{keyclazz, valueclazz}));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return object;
    }

    public Object getJsonToMapByMap(String json, Class keyclazz, Class valueclazz) {
        Object object = null;
        if (StringUtils.isNotBlank(json)) {
            try {
                object = this.getMapper().readValue(json, (JavaType)TypeFactory.defaultInstance().constructMapType(HashMap.class, TypeFactory.defaultInstance().uncheckedSimpleType(keyclazz), (JavaType)TypeFactory.defaultInstance().constructMapType(HashMap.class, String.class, valueclazz)));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return object;
    }

    public Object getJsonToMapByList(String json, Class keyclazz, Class valueclazz) {
        Object object = null;
        if (StringUtils.isNotBlank(json)) {
            try {
                object = this.getMapper().readValue(json, (JavaType)TypeFactory.defaultInstance().constructMapType(HashMap.class, TypeFactory.defaultInstance().uncheckedSimpleType(keyclazz), (JavaType)TypeFactory.defaultInstance().constructCollectionType(ArrayList.class, valueclazz)));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return object;
    }

    public static Map<String, String> getJsonToMap(String str) {
        String[] s;
        HashMap<String, String> map = new HashMap<String, String>();
        if (StringUtils.isNotBlank(str) && (s = str.split(",")).length > 0) {
            for (int i = 0; i < s.length; ++i) {
                String con = s[i];
                int s1 = con.indexOf(":");
                if (s1 > 0) {
                    map.put(con.substring(0, s1).trim().replace("\"", ""), con.substring(s1 + 1).replace("\"", ""));
                    continue;
                }
                map.put(con.trim().replace("\"", ""), "");
            }
        }
        return map;
    }

    public String getMapToJson(Map<String, String> map) {
        ArrayList<String[]> list = new ArrayList<String[]>();
        if (null != map && !map.isEmpty()) {
            for (String key : map.keySet()) {
                String[] strS = new String[]{key, map.get(key)};
                list.add(strS);
            }
        }
        return this.jsonObject(list);
    }

    public String jsonObject(List list) {
        StringWriter sw = new StringWriter();
        try {
            JsonGenerator gen = new JsonFactory().createGenerator((Writer)sw);
            this.getMapper().writeValue(gen, (Object)list);
            gen.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        return sw.toString();
    }

    public Object getJsonToObject(String json, Class objclazz, Class ... pclazz) {
        Object object = null;
        if (StringUtils.isNotBlank(json)) {
            try {
                object = this.getMapper().readValue(json, TypeFactory.defaultInstance().constructParametricType(objclazz, pclazz));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return object;
    }

    public <T> Object getJsonToObject(String json, TypeReference<T> typeReference) {
        Object object = null;
        if (StringUtils.isNotBlank(json)) {
            try {
                object = this.getMapper().readValue(json, typeReference);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return object;
    }

    public String toJson(Object object) {
        String json = null;
        try {
            json = this.getMapper().writeValueAsString(object);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return json;
    }

    public void setDateFormat(String pattern) {
        if (StringUtils.isNotBlank(pattern)) {
            SimpleDateFormat df = new SimpleDateFormat(pattern);
            this.getMapper().setDateFormat((DateFormat)df);
        }
    }

    public static Object getResultObject(String json) {
        return json;
    }

    public static void main(String[] args) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("a", null);
        map.put("b", "a");
        System.out.println(JsonUtil.buildNormalBinder().toJson(map));
    }
}

