/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.tool.util;

import com.yqbsoft.laser.service.tool.codec.Base64;
import java.io.ByteArrayOutputStream;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.Cipher;

public class RSAUtils {
    private static final String SIGNATURE_ALGORITHM = "SHA1withRSA";
    private static final String KEY_ALGORITHM = "RSA";
    private static final int MAX_ENCRYPT_BLOCK = 117;
    private static final int MAX_DECRYPT_BLOCK = 128;

    public static byte[] sign(byte[] text, PrivateKey privateKey) throws Exception {
        Signature signature = Signature.getInstance(SIGNATURE_ALGORITHM);
        signature.initSign(privateKey);
        signature.update(text);
        return signature.sign();
    }

    public static boolean verify(byte[] text, byte[] sign, PublicKey publicKey) throws Exception {
        Signature signature = Signature.getInstance(SIGNATURE_ALGORITHM);
        signature.initVerify(publicKey);
        signature.update(text);
        return signature.verify(sign);
    }

    public static byte[] encrypt(byte[] data, Key key) throws Exception {
        Cipher cipher = Cipher.getInstance(KEY_ALGORITHM);
        cipher.init(1, key);
        int inputLen = data.length;
        ByteArrayOutputStream out = new ByteArrayOutputStream(data.length << 1);
        int offSet = 0;
        while (inputLen - offSet > 0) {
            byte[] cache = inputLen - offSet > 117 ? cipher.doFinal(data, offSet, 117) : cipher.doFinal(data, offSet, inputLen - offSet);
            out.write(cache);
            offSet += 117;
        }
        byte[] encryptedData = out.toByteArray();
        out.close();
        return encryptedData;
    }

    public static byte[] decrypt(byte[] encryptedData, Key key) throws Exception {
        Cipher cipher = Cipher.getInstance(KEY_ALGORITHM);
        cipher.init(2, key);
        int inputLen = encryptedData.length;
        ByteArrayOutputStream out = new ByteArrayOutputStream(encryptedData.length);
        int offSet = 0;
        while (inputLen - offSet > 0) {
            byte[] cache = inputLen - offSet > 128 ? cipher.doFinal(encryptedData, offSet, 128) : cipher.doFinal(encryptedData, offSet, inputLen - offSet);
            out.write(cache);
            offSet += 128;
        }
        byte[] decryptedData = out.toByteArray();
        out.close();
        return decryptedData;
    }

    public static KeyPair genKeyPair() throws Exception {
        KeyPairGenerator keyPairGen = KeyPairGenerator.getInstance(KEY_ALGORITHM);
        keyPairGen.initialize(1024);
        return keyPairGen.generateKeyPair();
    }

    public static PrivateKey getPrivateKey(String privateKey) throws Exception {
        return KeyFactory.getInstance(KEY_ALGORITHM).generatePrivate(new PKCS8EncodedKeySpec(Base64.decodeBase64(privateKey)));
    }

    public static PublicKey getPublicKey(String publicKey) throws Exception {
        return KeyFactory.getInstance(KEY_ALGORITHM).generatePublic(new X509EncodedKeySpec(Base64.decodeBase64(publicKey)));
    }

    public static String getPrivateKey(KeyPair keyPair) throws Exception {
        return Base64.encodeBase64String(keyPair.getPrivate().getEncoded());
    }

    public static String getPublicKey(KeyPair keyPair) throws Exception {
        return Base64.encodeBase64String(keyPair.getPublic().getEncoded());
    }

    public static void main(String[] args) throws Exception {
    }
}

