/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.tool.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class StringUtils {
    private StringUtils() {
    }

    public static boolean isEmpty(String value) {
        int strLen;
        if (value == null || (strLen = value.length()) == 0) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(value.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isBlank(String value) {
        int strLen;
        if (value == null || (strLen = value.length()) == 0) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(value.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNotBlank(String value) {
        return !StringUtils.isBlank(value);
    }

    public static boolean isNumeric(Object obj) {
        if (obj == null) {
            return false;
        }
        char[] chars = obj.toString().toCharArray();
        int length = chars.length;
        if (length < 1) {
            return false;
        }
        int i = 0;
        if (length > 1 && chars[0] == '-') {
            i = 1;
        }
        while (i < length) {
            if (!Character.isDigit(chars[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean areNotEmpty(String ... values) {
        boolean result = true;
        if (values == null || values.length == 0) {
            result = false;
        } else {
            for (String value : values) {
                result &= !StringUtils.isEmpty(value);
            }
        }
        return result;
    }

    public static String unicodeToChinese(String unicode) {
        StringBuilder out = new StringBuilder();
        if (!StringUtils.isEmpty(unicode)) {
            for (int i = 0; i < unicode.length(); ++i) {
                out.append(unicode.charAt(i));
            }
        }
        return out.toString();
    }

    public static String stripNonValidXMLCharacters(String input) {
        if (input == null || "".equals(input)) {
            return "";
        }
        StringBuilder out = new StringBuilder();
        for (int i = 0; i < input.length(); ++i) {
            char current = input.charAt(i);
            if (!(current == '\t' || current == '\n' || current == '\r' || current >= ' ' && current <= '\ud7ff' || current >= '\ue000' && current <= '\ufffd') && (current < '\u10000' || current > '\u10ffff')) continue;
            out.append(current);
        }
        return out.toString();
    }

    public static String getFirstUpper(String str) {
        String newStr = "";
        if (str.length() > 0) {
            newStr = str.substring(0, 1).toUpperCase() + str.substring(1, str.length());
        }
        return newStr;
    }

    public static String defaultIfBlank(String value, String defaultVal) {
        return StringUtils.isNotBlank(value) ? value : defaultVal;
    }

    public static String replaceAtIndex(int index, String ostr, String replaceChar) {
        if (StringUtils.isNotBlank(ostr)) {
            try {
                return ostr.replaceFirst(ostr.charAt(index) + "", replaceChar);
            }
            catch (Exception e) {
                return ostr;
            }
        }
        return ostr;
    }

    public static String fillLeft(String source, char fillChar, int len) {
        StringBuffer ret = new StringBuffer();
        if (null == source) {
            ret.append("");
        }
        if (source.length() > len) {
            ret.append(source);
        } else {
            int slen = source.length();
            while (ret.toString().length() + slen < len) {
                ret.append(fillChar);
            }
            ret.append(source);
        }
        return ret.toString();
    }

    public static String filRight(String source, char fillChar, int len) {
        StringBuffer ret = new StringBuffer();
        if (null == source) {
            ret.append("");
        }
        if (source.length() > len) {
            ret.append(source);
        } else {
            ret.append(source);
            while (ret.toString().length() < len) {
                ret.append(fillChar);
            }
        }
        return ret.toString();
    }

    public static String filterStr(String str) {
        if (null == str || "".equals(str)) {
            return str;
        }
        str = str.replaceAll("'", "''");
        return str;
    }

    public static boolean isAllChar(String str) {
        String regex = ".*[a-zA-Z]+.*";
        Matcher m = Pattern.compile(regex).matcher(str);
        return m.matches();
    }

    public static boolean equals(CharSequence cs1, CharSequence cs2) {
        return cs1 == null ? cs2 == null : cs1.equals(cs2);
    }

    public static boolean isMapJson(String str) {
        if (StringUtils.isBlank(str)) {
            return false;
        }
        return str.indexOf("{") == 0 && str.lastIndexOf("}") == str.length() - 1;
    }

    public static boolean isMapOrListJson(String str) {
        if (StringUtils.isBlank(str)) {
            return false;
        }
        if ((str = str.trim()).indexOf("{") == 0 && str.lastIndexOf("}") == str.length() - 1) {
            return true;
        }
        return str.indexOf("[") == 0 && str.lastIndexOf("]") == str.length() - 1;
    }

    public static void main(String[] args) {
        String s = "\"dkj\"";
        System.out.println(StringUtils.isMapOrListJson(s));
    }
}

