/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.tool.util;

import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;

public class ListUtil {
    public static final List EMPTY_LIST = Collections.EMPTY_LIST;

    public static boolean isEmpty(Collection coll) {
        return CollectionUtils.isEmpty((Collection)coll);
    }

    public static boolean isNotEmpty(Collection coll) {
        return !CollectionUtils.isEmpty((Collection)coll);
    }

    public static List intersection(List list1, List list2) {
        ArrayList result = new ArrayList();
        for (Object o : list2) {
            if (!list1.contains(o)) continue;
            result.add(o);
        }
        return result;
    }

    public static void addAll(List list1, List list2) {
        if (list1 == null || ListUtil.isEmpty(list2)) {
            return;
        }
        list1.addAll(list2);
    }

    public static List subtract(List list1, List list2) {
        ArrayList result = new ArrayList(list1);
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            result.remove(iterator.next());
        }
        return result;
    }

    public static List sum(List list1, List list2) {
        return ListUtil.subtract(ListUtil.union(list1, list2), ListUtil.intersection(list1, list2));
    }

    public static List union(List list1, List list2) {
        ArrayList result = new ArrayList(list1);
        result.addAll(list2);
        return result;
    }

    public static boolean isEqualList(Collection list1, Collection list2) {
        if (list1 == list2) {
            return true;
        }
        if (list1 == null || list2 == null || list1.size() != list2.size()) {
            return false;
        }
        Iterator it1 = list1.iterator();
        Iterator it2 = list2.iterator();
        Object obj1 = null;
        Object obj2 = null;
        while (it1.hasNext() && it2.hasNext()) {
            obj1 = it1.next();
            obj2 = it2.next();
            if (obj1 != null ? obj1.equals(obj2) : obj2 == null) continue;
            return false;
        }
        return !it1.hasNext() && !it2.hasNext();
    }

    public static int hashCodeForList(Collection list) {
        if (list == null) {
            return 0;
        }
        int hashCode = 1;
        Iterator it = list.iterator();
        Object obj = null;
        while (it.hasNext()) {
            obj = it.next();
            hashCode = 31 * hashCode + (obj == null ? 0 : obj.hashCode());
        }
        return hashCode;
    }

    public static List retainAll(Collection collection, Collection retain) {
        ArrayList list = new ArrayList(Math.min(collection.size(), retain.size()));
        for (Object obj : collection) {
            if (!retain.contains(obj)) continue;
            list.add(obj);
        }
        return list;
    }

    public static List removeAll(Collection collection, Collection remove) {
        ArrayList list = new ArrayList();
        for (Object obj : collection) {
            if (remove.contains(obj)) continue;
            list.add(obj);
        }
        return list;
    }

    public static List<Object> getFieldValueList(Collection collection, Class clazz, String fieldName) {
        ArrayList<Object> objList = new ArrayList<Object>();
        String methodName = "get" + StringUtils.getFirstUpper(fieldName);
        try {
            Method m = clazz.getMethod(methodName, new Class[0]);
            if (CollectionUtils.isNotEmpty((Collection)collection)) {
                for (Object object : collection) {
                    objList.add(m.invoke(object, new Object[0]));
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return objList;
    }
}

