/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.tool.util;

import com.yqbsoft.laser.service.tool.codec.Base64;
import java.io.ByteArrayOutputStream;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.Cipher;

public class RSAUtils {
    private static final String SIGNATURE_ALGORITHM = "SHA1withRSA";
    private static final String KEY_ALGORITHM = "RSA";
    private static final int MAX_ENCRYPT_BLOCK = 117;
    private static final int MAX_DECRYPT_BLOCK = 128;

    public static byte[] sign(byte[] text, PrivateKey privateKey) throws Exception {
        Signature signature = Signature.getInstance(SIGNATURE_ALGORITHM);
        signature.initSign(privateKey);
        signature.update(text);
        return signature.sign();
    }

    public static boolean verify(byte[] text, byte[] sign, PublicKey publicKey) throws Exception {
        Signature signature = Signature.getInstance(SIGNATURE_ALGORITHM);
        signature.initVerify(publicKey);
        signature.update(text);
        return signature.verify(sign);
    }

    public static byte[] encrypt(byte[] data, Key key) throws Exception {
        Cipher cipher = Cipher.getInstance(KEY_ALGORITHM);
        cipher.init(1, key);
        int inputLen = data.length;
        ByteArrayOutputStream out = new ByteArrayOutputStream(data.length << 1);
        int offSet = 0;
        while (inputLen - offSet > 0) {
            byte[] cache = inputLen - offSet > 117 ? cipher.doFinal(data, offSet, 117) : cipher.doFinal(data, offSet, inputLen - offSet);
            out.write(cache);
            offSet += 117;
        }
        byte[] encryptedData = out.toByteArray();
        out.close();
        return encryptedData;
    }

    public static byte[] decrypt(byte[] encryptedData, Key key) throws Exception {
        Cipher cipher = Cipher.getInstance(KEY_ALGORITHM);
        cipher.init(2, key);
        int inputLen = encryptedData.length;
        ByteArrayOutputStream out = new ByteArrayOutputStream(encryptedData.length);
        int offSet = 0;
        while (inputLen - offSet > 0) {
            byte[] cache = inputLen - offSet > 128 ? cipher.doFinal(encryptedData, offSet, 128) : cipher.doFinal(encryptedData, offSet, inputLen - offSet);
            out.write(cache);
            offSet += 128;
        }
        byte[] decryptedData = out.toByteArray();
        out.close();
        return decryptedData;
    }

    public static KeyPair genKeyPair() throws Exception {
        KeyPairGenerator keyPairGen = KeyPairGenerator.getInstance(KEY_ALGORITHM);
        keyPairGen.initialize(1024);
        return keyPairGen.generateKeyPair();
    }

    public static PrivateKey getPrivateKey(String privateKey) throws Exception {
        return KeyFactory.getInstance(KEY_ALGORITHM).generatePrivate(new PKCS8EncodedKeySpec(Base64.decodeBase64(privateKey)));
    }

    public static PublicKey getPublicKey(String publicKey) throws Exception {
        return KeyFactory.getInstance(KEY_ALGORITHM).generatePublic(new X509EncodedKeySpec(Base64.decodeBase64(publicKey)));
    }

    public static String getPrivateKey(KeyPair keyPair) throws Exception {
        return Base64.encodeBase64String(keyPair.getPrivate().getEncoded());
    }

    public static String getPublicKey(KeyPair keyPair) throws Exception {
        return Base64.encodeBase64String(keyPair.getPublic().getEncoded());
    }

    public static void main(String[] args) throws Exception {
        boolean b = RSAUtils.verify("app_id=83921801&businessOrderno=20161000123090911&fchannelPmodeCode=WEB&merchantCode=2002110026&method=pa.payment.savePyamentToPteForm&opuserCode=1000001&opuserName=xxx&orderAmount=100.00&partnerCode=2002110026&paymentMemo=\u65b0\u82cf\u4e2d\u5fc3\u5ba2\u6237\u8d44\u91d1\u5230\u8d26&paymentReturnurl=http://127.0.0.1:8080/yqbsoft-app-wallet-html-devestate/web/devest/capital/queryReceivablesRecord&ptradeType=03&ptradpdeCode=PAYMENT&sign_type=RSA&tenantCode=00000000&timestamp=2017-03-30 17:05:37&version=1.0&vfinopen_sdk=vfinopen-sdk-java-dynamicVersionNo".getBytes("utf-8"), Base64.decodeBase64("23nN+cyXhoZxF4+Xjvcf6ToM3w0a4vmZsHhZq9jU2tROJOV1HOzt1gQzyg8phO63MME3659oV5YQx3HHswUmu7K3YojPQkZR54w57F297omGea1BjBkvJ7cfizyWldNs+A1zNjXXfhL2+HP2UFD5Mc1iOCHkTBg0qZiDcBeaY3E="), RSAUtils.getPublicKey("MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQD6uOE3QBD359dvDFwkPMgv6DdLu2dxUXysKOQxxbLw5d/XI3M+z0W6/7LBKuF4KL7ydR5aaed2K8Sq5nr/O0N8CfjZfticMFpbRnn8O0qlm+CQdXnJ8J6qkhPZChcf2a2dpYmK0CiT0WAh42Z4x7fT0Mj6RJLji2CQbkSyOToQiQIDAQAB"));
        System.out.println(b);
    }
}

