/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.tool.util;

import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

public class DateUtil {
    public static final String DATESHOWFORMAT = "yyyy-MM-dd";
    public static final String DATEYMFORMAT = "yyyy-MM";
    public static final String DATESTOREFORMAT = "yyyyMMdd";
    public static final String DATEMDSTOREFORMAT = "MMdd";
    public static final String TIMESHOWFORMAT = "HH:mm:ss";
    public static final String TIMESTOREFORMAT = "HHmmss";
    public static final String DATETIMESHOWFORMAT = "yyyy-MM-dd HH:mm:ss";
    public static final String DATETIMESTOREFORMAT = "yyyyMMddHHmmss";
    private static int[] units = new int[]{1, 2, 5, 11, 12, 13, 14};

    public static long getBetweenDays(String startDate, String endDate) {
        if (endDate == null || startDate == null) {
            return -1L;
        }
        Date dateStart = DateUtil.isDate(startDate);
        if (null == dateStart) {
            return -1L;
        }
        Date dateEnd = DateUtil.isDate(endDate);
        if (null == dateEnd) {
            return -1L;
        }
        return DateUtil.getBetweenDays(dateStart, dateEnd);
    }

    public static long getBetweenDays(Date startDate, Date endDate) {
        if (endDate == null || startDate == null) {
            return -1L;
        }
        Long days = endDate.getTime() - startDate.getTime();
        days = days / 86400000L;
        return days;
    }

    public static String getAfterDate(String baseDate, int dayCount, String patternString) {
        int year = Integer.parseInt(baseDate.substring(0, 4));
        int month = Integer.parseInt(baseDate.substring(5, 7));
        int date = Integer.parseInt(baseDate.substring(8, 10));
        Calendar calendar = Calendar.getInstance();
        if (DATETIMESHOWFORMAT.equals(patternString)) {
            int hour = Integer.parseInt(baseDate.substring(11, 13));
            int minute = Integer.parseInt(baseDate.substring(14, 16));
            int second = Integer.parseInt(baseDate.substring(17, 19));
            calendar.set(year, month - 1, date, hour, minute, second);
        } else {
            calendar.set(year, month - 1, date);
        }
        calendar.set(year, month - 1, date);
        calendar.add(5, dayCount);
        Date _date = calendar.getTime();
        SimpleDateFormat formatter = new SimpleDateFormat(patternString);
        String dateString = formatter.format(_date);
        return dateString;
    }

    public static String getAfterDate(Date baseDate, int dayCount, String patternString) {
        String _baseDate = DateUtil.getDateString(baseDate, DATETIMESHOWFORMAT);
        return DateUtil.getAfterDate(_baseDate, dayCount, patternString);
    }

    public static String getAfterMonth(String baseDate, int monthCount, String patternString) {
        int year = Integer.parseInt(baseDate.substring(0, 4));
        int month = Integer.parseInt(baseDate.substring(5, 7));
        int date = Integer.parseInt(baseDate.substring(8, 10));
        Calendar calendar = Calendar.getInstance();
        if (DATETIMESHOWFORMAT.equals(patternString)) {
            int hour = Integer.parseInt(baseDate.substring(11, 13));
            int minute = Integer.parseInt(baseDate.substring(14, 16));
            int second = Integer.parseInt(baseDate.substring(17, 19));
            calendar.set(year, month - 1, date, hour, minute, second);
        } else {
            calendar.set(year, month - 1, date);
        }
        calendar.add(2, monthCount);
        Date _date = calendar.getTime();
        SimpleDateFormat formatter = new SimpleDateFormat(patternString);
        String dateString = formatter.format(_date);
        return dateString;
    }

    public static String getAfterHour(String baseDate, int hourCount, String patternString) {
        int year = Integer.parseInt(baseDate.substring(0, 4));
        int month = Integer.parseInt(baseDate.substring(5, 7));
        int date = Integer.parseInt(baseDate.substring(8, 10));
        Calendar calendar = Calendar.getInstance();
        if (DATETIMESHOWFORMAT.equals(patternString)) {
            int hour = Integer.parseInt(baseDate.substring(11, 13));
            int minute = Integer.parseInt(baseDate.substring(14, 16));
            int second = Integer.parseInt(baseDate.substring(17, 19));
            calendar.set(year, month - 1, date, hour, minute, second);
        } else {
            calendar.set(year, month - 1, date);
        }
        calendar.add(10, hourCount);
        Date _date = calendar.getTime();
        SimpleDateFormat formatter = new SimpleDateFormat(patternString);
        String dateString = formatter.format(_date);
        return dateString;
    }

    public static String getAfterCalendarType(String baseDate, int count, int calendarType, String patternString) {
        int year = Integer.parseInt(baseDate.substring(0, 4));
        int month = Integer.parseInt(baseDate.substring(5, 7));
        int date = Integer.parseInt(baseDate.substring(8, 10));
        Calendar calendar = Calendar.getInstance();
        if (DATETIMESHOWFORMAT.equals(patternString)) {
            int hour = Integer.parseInt(baseDate.substring(11, 13));
            int minute = Integer.parseInt(baseDate.substring(14, 16));
            int second = Integer.parseInt(baseDate.substring(17, 19));
            calendar.set(year, month - 1, date, hour, minute, second);
        } else {
            calendar.set(year, month - 1, date);
        }
        calendar.add(calendarType, count);
        Date _date = calendar.getTime();
        SimpleDateFormat formatter = new SimpleDateFormat(patternString);
        String dateString = formatter.format(_date);
        return dateString;
    }

    public static String getAfterMonth(Date baseDate, int monthCount, String patternString) {
        String _baseDate = DateUtil.getDateString(baseDate, DATETIMESHOWFORMAT);
        return DateUtil.getAfterMonth(_baseDate, monthCount, patternString);
    }

    public static String getEndDate(String baseDate, int monthCount, int dateCount, String patternString) {
        int day = Integer.parseInt(baseDate.substring(8, 10));
        String endDate = DateUtil.getAfterMonth(baseDate, monthCount, patternString);
        int endDay = Integer.parseInt(endDate.substring(8, 10));
        if (endDay == day) {
            endDate = monthCount > 0 ? DateUtil.getAfterDate(endDate, dateCount, patternString) : DateUtil.getAfterDate(endDate, dateCount, patternString);
        } else if (monthCount < 0) {
            endDate = DateUtil.getAfterDate(endDate, dateCount, patternString);
        }
        return endDate;
    }

    public static String getEndDate(Date baseDate, int monthCount, int dateCount, String patternString) {
        String _baseDate = DateUtil.getDateString(baseDate, DATETIMESHOWFORMAT);
        return DateUtil.getEndDate(_baseDate, monthCount, dateCount, patternString);
    }

    public static String getBeforeMonth(int monthCount, String patternString) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(2, monthCount);
        Date _date = calendar.getTime();
        SimpleDateFormat formatter = new SimpleDateFormat(patternString);
        return formatter.format(_date);
    }

    public static Date getDateToString(String dateStr, String patten) {
        if (StringUtils.isBlank(dateStr)) {
            return null;
        }
        SimpleDateFormat formatter = new SimpleDateFormat(patten, Locale.CHINA);
        try {
            return formatter.parse(dateStr);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getDateString(String date, String patternString) {
        if (date == null) {
            return "";
        }
        if (date.length() < 10) {
            return "";
        }
        SimpleDateFormat formatter = new SimpleDateFormat(patternString, Locale.CHINA);
        int len = patternString.length();
        if (len > date.length()) {
            patternString = patternString.substring(0, date.length());
        }
        return formatter.format(DateUtil.getDateToString(date, patternString));
    }

    public static String getDateString(Date _date, String patternString) {
        String dateString = "";
        if (_date != null) {
            SimpleDateFormat formatter = new SimpleDateFormat(patternString);
            dateString = formatter.format(_date);
        }
        return dateString;
    }

    public static Date dateToDate(Date _date, String patten) {
        String dateStr = "";
        SimpleDateFormat formatter = new SimpleDateFormat(patten);
        try {
            if (_date != null) {
                dateStr = formatter.format(_date);
            }
            return formatter.parse(dateStr);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static String getDateOfString(Long dateLong, String patten) {
        if (dateLong != null) {
            return new SimpleDateFormat(patten).format(new Date(dateLong)).toString();
        }
        return "";
    }

    public static java.sql.Date getSqlDate(String baseDate) {
        if (baseDate == null || baseDate.length() == 0) {
            return null;
        }
        Date date = DateUtil.getDateToString(baseDate, DATESHOWFORMAT);
        return new java.sql.Date(date.getTime());
    }

    public static java.sql.Date UtilDateToSQLDate(Date date) {
        return new java.sql.Date(date.getTime());
    }

    public static String getDateString(int year, int month, int date, String patternString) {
        String dateString = "";
        SimpleDateFormat formatter = new SimpleDateFormat(patternString);
        Calendar calendar = Calendar.getInstance();
        calendar.set(year, month - 1, date);
        Date showDate = calendar.getTime();
        dateString = formatter.format(showDate);
        return dateString;
    }

    public static String getDateString(String year, String month, String date, String patternString) {
        String dateString = "";
        try {
            int y = Integer.parseInt(year);
            int m = Integer.parseInt(month);
            int d = Integer.parseInt(date);
            dateString = DateUtil.getDateString(y, m, d, patternString);
        }
        catch (Exception e) {
            // empty catch block
        }
        return dateString;
    }

    public static String getDateStr(String patternString) {
        SimpleDateFormat formatter = new SimpleDateFormat(patternString);
        String date = formatter.format(new Date(System.currentTimeMillis()));
        return date;
    }

    public static Date isDate(String dateStr) {
        String date_format_1 = "yyyy/MM/dd";
        String date_format_2 = DATESHOWFORMAT;
        String date_format_3 = DATESTOREFORMAT;
        String date_format_4 = "yyyy.MM.dd";
        String[] date_format = new String[]{date_format_1, date_format_2, date_format_3, date_format_4};
        for (int i = 0; i < date_format.length; ++i) {
            Date tempDate = DateUtil.isDate(dateStr, date_format[i]);
            if (null == tempDate) continue;
            return tempDate;
        }
        return null;
    }

    public static Date isDate(String dateStr, String patternString) {
        if (StringUtils.isBlank(patternString)) {
            patternString = DATESHOWFORMAT;
        }
        try {
            SimpleDateFormat formatDate = new SimpleDateFormat(patternString);
            formatDate.setLenient(false);
            ParsePosition pos = new ParsePosition(0);
            Date tempDate = formatDate.parse(dateStr, pos);
            tempDate.getTime();
            return tempDate;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Calendar getCalendar(Date d) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(d);
        return cal;
    }

    public static String parseDateTime(Date date) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat bartDateFormat = new SimpleDateFormat(DATETIMESHOWFORMAT);
        return bartDateFormat.format(date);
    }

    public static String parsTime(Date date) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat bartDateFormat = new SimpleDateFormat(TIMESHOWFORMAT);
        return bartDateFormat.format(date);
    }

    public static String parseDate(Date date) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat bartDateFormat = new SimpleDateFormat(DATESHOWFORMAT);
        return bartDateFormat.format(date);
    }

    public static String firstDate() {
        Calendar ca = Calendar.getInstance();
        ca.setTime(new Date());
        ca.set(5, 1);
        Date firstDate = ca.getTime();
        return DateUtil.getDateString(firstDate, DATESHOWFORMAT);
    }

    public static String lastDate() {
        Calendar ca = Calendar.getInstance();
        ca.setTime(new Date());
        ca.set(5, 1);
        ca.add(2, 1);
        ca.add(5, -1);
        Date lastDate = ca.getTime();
        return DateUtil.getDateString(lastDate, DATESHOWFORMAT);
    }

    public static String getDateStr() {
        return "sysdate";
    }

    public static Date getUpMouth(Date date) {
        Calendar ca = Calendar.getInstance();
        ca.setTime(date);
        ca.add(2, -1);
        return ca.getTime();
    }

    public static int getYear(Date date) {
        Calendar ca = Calendar.getInstance();
        ca.setTime(date);
        return ca.get(1);
    }

    public static int getMonth(Date date) {
        Calendar ca = Calendar.getInstance();
        ca.setTime(date);
        return ca.get(2) + 1;
    }

    public static int getDay(Date date) {
        Calendar ca = Calendar.getInstance();
        ca.setTime(date);
        return ca.get(5);
    }

    public static int getWeek(Date date) {
        Calendar ca = Calendar.getInstance();
        ca.setTime(date);
        return ca.get(7);
    }

    public static Date getUpMouth(String date) {
        Calendar ca = Calendar.getInstance();
        ca.setTime(DateUtil.getDateToString(date, DATESHOWFORMAT));
        ca.add(2, -1);
        return ca.getTime();
    }

    public static int getYear(String date) {
        Calendar ca = Calendar.getInstance();
        ca.setTime(DateUtil.getDateToString(date, DATESHOWFORMAT));
        return ca.get(1);
    }

    public static int getMonth(String date) {
        Calendar ca = Calendar.getInstance();
        ca.setTime(DateUtil.getDateToString(date, DATESHOWFORMAT));
        return ca.get(2) + 1;
    }

    public static int getDay(String date) {
        Calendar ca = Calendar.getInstance();
        ca.setTime(DateUtil.getDateToString(date, DATESHOWFORMAT));
        return ca.get(5);
    }

    public static int getWeek(String date) {
        Calendar ca = Calendar.getInstance();
        ca.setTime(DateUtil.getDateToString(date, DATESHOWFORMAT));
        return ca.get(7);
    }

    public static int getHour(Date date) {
        Calendar ca = Calendar.getInstance();
        ca.setTime(date);
        return ca.get(11);
    }

    public static int getMin(Date date) {
        Calendar ca = Calendar.getInstance();
        ca.setTime(date);
        return ca.get(12);
    }

    public static boolean checkMax(Date d1, Date d2) {
        boolean flag = false;
        if (null != d1) {
            if (null != d2) {
                String d1s = DateUtil.getDateString(d1, DATESTOREFORMAT);
                String d12s = DateUtil.getDateString(d2, DATESTOREFORMAT);
                if (Double.valueOf(d1s) >= Double.valueOf(d12s)) {
                    flag = true;
                }
            } else {
                flag = true;
            }
        }
        return flag;
    }

    public static boolean isWeekend(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return 1 == calendar.get(7) || 7 == calendar.get(7);
    }

    public static Date addMinutes(Date date, int minute) {
        if (null == date) {
            date = new Date();
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(12, minute);
        return calendar.getTime();
    }

    public static Long getDiffDay(String beginDate, String endDate) {
        SimpleDateFormat formatter = new SimpleDateFormat(DATESTOREFORMAT);
        Long checkday = 0L;
        try {
            checkday = (formatter.parse(endDate).getTime() - formatter.parse(beginDate).getTime()) / 86400000L;
        }
        catch (ParseException e) {
            // empty catch block
        }
        return checkday;
    }

    public static Date roundDate(Calendar cal, int field) {
        boolean clearFlag = false;
        for (int i = 0; i < units.length; ++i) {
            if (clearFlag) {
                cal.set(units[i], cal.getMinimum(units[i]));
                continue;
            }
            if (units[i] != field) continue;
            clearFlag = true;
        }
        return cal.getTime();
    }

    public static void main(String[] args) throws Exception {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        System.out.println(DateUtil.getDateStr(DATESHOWFORMAT));
    }
}

