/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.tool.json;

import com.yqbsoft.laser.service.tool.json.JSONArray;
import com.yqbsoft.laser.service.tool.json.TypeCast;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class JSONObject
implements Serializable,
Map<String, Object> {
    private static final long serialVersionUID = -4029679228937894529L;
    private final Map<String, Object> map;

    public JSONObject() {
        this(16, false);
    }

    public JSONObject(Map<String, Object> map) {
        this.map = map;
    }

    public JSONObject(boolean ordered) {
        this(16, ordered);
    }

    public JSONObject(int initialCapacity) {
        this(initialCapacity, false);
    }

    public JSONObject(int initialCapacity, boolean ordered) {
        this.map = ordered ? new LinkedHashMap<String, Object>(initialCapacity) : new HashMap<String, Object>(initialCapacity);
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public Object get(Object key) {
        return this.map.get(key);
    }

    public JSONObject getJSONObject(String key) {
        Object value = this.map.get(key);
        if (value instanceof JSONObject) {
            return (JSONObject)value;
        }
        return JsonUtil.buildNormalBinder().getJsonToObject(value.toString(), JSONObject.class);
    }

    public JSONArray getJSONArray(String key) {
        Object value = this.map.get(key);
        if (value instanceof JSONArray) {
            return (JSONArray)value;
        }
        return JsonUtil.buildNormalBinder().getJsonToObject(value.toString(), JSONArray.class);
    }

    public <T> T getObject(String key, Class<T> clazz) {
        Object obj = this.map.get(key);
        return JsonUtil.buildNormalBinder().getJsonToObject(obj.toString(), clazz);
    }

    public Boolean getBoolean(String key) {
        Object value = this.get(key);
        if (value == null) {
            return null;
        }
        return TypeCast.castToBoolean(value);
    }

    public byte[] getBytes(String key) {
        Object value = this.get(key);
        if (value == null) {
            return null;
        }
        return TypeCast.castToBytes(value);
    }

    public Integer getInteger(String key) {
        Object value = this.get(key);
        return TypeCast.castToInt(value);
    }

    public Long getLong(String key) {
        Object value = this.get(key);
        return TypeCast.castToLong(value);
    }

    public Double getDouble(String key) {
        Object value = this.get(key);
        return TypeCast.castToDouble(value);
    }

    public BigDecimal getBigDecimal(String key) {
        Object value = this.get(key);
        return TypeCast.castToBigDecimal(value);
    }

    public BigInteger getBigInteger(String key) {
        Object value = this.get(key);
        return TypeCast.castToBigInteger(value);
    }

    public String getString(String key) {
        Object value = this.get(key);
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    public Date getDate(String key) {
        Object value = this.get(key);
        return TypeCast.castToDate(value);
    }

    @Override
    public Object put(String key, Object value) {
        return this.map.put(key, value);
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> m) {
        this.map.putAll(m);
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public Object remove(Object key) {
        return this.map.remove(key);
    }

    @Override
    public Set<String> keySet() {
        return this.map.keySet();
    }

    @Override
    public Collection<Object> values() {
        return this.map.values();
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return this.map.entrySet();
    }

    public Object clone() {
        return new JSONObject(new HashMap<String, Object>(this.map));
    }

    @Override
    public boolean equals(Object obj) {
        return this.map.equals(obj);
    }

    @Override
    public int hashCode() {
        return this.map.hashCode();
    }

    public static JSONObject json2object(String jsonStr) {
        Map data = (Map)JsonUtil.buildNormalBinder().getJsonToMap(jsonStr, String.class, Object.class);
        return new JSONObject(data);
    }

    public String object2json() {
        return JsonUtil.buildNormalBinder().toJson(this.map);
    }

    public Object addObject(String key, Object value) {
        return this.put(key, value);
    }
}

