/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.tool.util;

import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGEncodeParam;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.awt.image.CropImageFilter;
import java.awt.image.FilteredImageSource;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.imageio.ImageIO;

public class ImageUtils {
    public static String IMAGE_TYPE_GIF = "gif";
    public static String IMAGE_TYPE_JPG = "jpg";
    public static String IMAGE_TYPE_JPEG = "jpeg";
    public static String IMAGE_TYPE_BMP = "bmp";
    public static String IMAGE_TYPE_PNG = "png";
    public static String IMAGE_TYPE_PSD = "psd";

    public static final void scale(String srcImageFile, String result, int scale, boolean flag) {
        try {
            BufferedImage src = ImageIO.read(new File(srcImageFile));
            int width = src.getWidth();
            int height = src.getHeight();
            if (flag) {
                width *= scale;
                height *= scale;
            } else {
                width /= scale;
                height /= scale;
            }
            Image image = src.getScaledInstance(width, height, 1);
            BufferedImage tag = new BufferedImage(width, height, 1);
            Graphics g = tag.getGraphics();
            g.drawImage(image, 0, 0, null);
            g.dispose();
            ImageIO.write((RenderedImage)tag, "JPEG", new File(result));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static final void scale2(String srcImageFile, String result, int width, int height, boolean bb) {
        try {
            double ratio = 0.0;
            File f = new File(srcImageFile);
            BufferedImage bi = ImageIO.read(f);
            Image itemp = bi.getScaledInstance(width, height, 4);
            if (bi.getHeight() > height || bi.getWidth() > width) {
                ratio = bi.getHeight() > bi.getWidth() ? new Integer(height).doubleValue() / (double)bi.getHeight() : new Integer(width).doubleValue() / (double)bi.getWidth();
                AffineTransformOp op = new AffineTransformOp(AffineTransform.getScaleInstance(ratio, ratio), null);
                itemp = op.filter(bi, null);
            }
            if (bb) {
                BufferedImage image = new BufferedImage(width, height, 1);
                Graphics2D g = image.createGraphics();
                g.setColor(Color.white);
                g.fillRect(0, 0, width, height);
                if (width == itemp.getWidth(null)) {
                    g.drawImage(itemp, 0, (height - itemp.getHeight(null)) / 2, itemp.getWidth(null), itemp.getHeight(null), Color.white, null);
                } else {
                    g.drawImage(itemp, (width - itemp.getWidth(null)) / 2, 0, itemp.getWidth(null), itemp.getHeight(null), Color.white, null);
                }
                g.dispose();
                itemp = image;
            }
            ImageIO.write((RenderedImage)((BufferedImage)itemp), "JPEG", new File(result));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static final void scale3(String srcImageFile, String result, int width, int height, boolean bb) {
        try {
            BufferedImage src = ImageIO.read(new File(srcImageFile));
            Image image = src.getScaledInstance(width, height, 1);
            BufferedImage tag = new BufferedImage(width, height, 1);
            Graphics g = tag.getGraphics();
            g.drawImage(image, 0, 0, null);
            g.dispose();
            ImageIO.write((RenderedImage)tag, "JPEG", new File(result));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static final void cut(String srcImageFile, String result, int x, int y, int width, int height) {
        try {
            BufferedImage bi = ImageIO.read(new File(srcImageFile));
            int srcWidth = bi.getHeight();
            int srcHeight = bi.getWidth();
            if (srcWidth > 0 && srcHeight > 0) {
                Image image = bi.getScaledInstance(srcWidth, srcHeight, 1);
                CropImageFilter cropFilter = new CropImageFilter(x, y, width, height);
                Image img = Toolkit.getDefaultToolkit().createImage(new FilteredImageSource(image.getSource(), cropFilter));
                BufferedImage tag = new BufferedImage(width, height, 1);
                Graphics g = tag.getGraphics();
                g.drawImage(img, 0, 0, width, height, null);
                g.dispose();
                ImageIO.write((RenderedImage)tag, "JPEG", new File(result));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static final void cut2(String srcImageFile, String descDir, int rows, int cols) {
        try {
            if (rows <= 0 || rows > 20) {
                rows = 2;
            }
            if (cols <= 0 || cols > 20) {
                cols = 2;
            }
            BufferedImage bi = ImageIO.read(new File(srcImageFile));
            int srcWidth = bi.getHeight();
            int srcHeight = bi.getWidth();
            if (srcWidth > 0 && srcHeight > 0) {
                Image image = bi.getScaledInstance(srcWidth, srcHeight, 1);
                int destWidth = srcWidth;
                int destHeight = srcHeight;
                destWidth = srcWidth % cols == 0 ? srcWidth / cols : (int)Math.floor(srcWidth / cols) + 1;
                destHeight = srcHeight % rows == 0 ? srcHeight / rows : (int)Math.floor(srcWidth / rows) + 1;
                for (int i = 0; i < rows; ++i) {
                    for (int j = 0; j < cols; ++j) {
                        CropImageFilter cropFilter = new CropImageFilter(j * destWidth, i * destHeight, destWidth, destHeight);
                        Image img = Toolkit.getDefaultToolkit().createImage(new FilteredImageSource(image.getSource(), cropFilter));
                        BufferedImage tag = new BufferedImage(destWidth, destHeight, 1);
                        Graphics g = tag.getGraphics();
                        g.drawImage(img, 0, 0, null);
                        g.dispose();
                        ImageIO.write((RenderedImage)tag, "JPEG", new File(descDir + "_r" + i + "_c" + j + ".jpg"));
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static final void cut3(String srcImageFile, String descDir, int destWidth, int destHeight) {
        try {
            if (destWidth <= 0) {
                destWidth = 200;
            }
            if (destHeight <= 0) {
                destHeight = 150;
            }
            BufferedImage bi = ImageIO.read(new File(srcImageFile));
            int srcWidth = bi.getHeight();
            int srcHeight = bi.getWidth();
            if (srcWidth > destWidth && srcHeight > destHeight) {
                Image image = bi.getScaledInstance(srcWidth, srcHeight, 1);
                int cols = 0;
                int rows = 0;
                cols = srcWidth % destWidth == 0 ? srcWidth / destWidth : (int)Math.floor(srcWidth / destWidth) + 1;
                rows = srcHeight % destHeight == 0 ? srcHeight / destHeight : (int)Math.floor(srcHeight / destHeight) + 1;
                for (int i = 0; i < rows; ++i) {
                    for (int j = 0; j < cols; ++j) {
                        CropImageFilter cropFilter = new CropImageFilter(j * destWidth, i * destHeight, destWidth, destHeight);
                        Image img = Toolkit.getDefaultToolkit().createImage(new FilteredImageSource(image.getSource(), cropFilter));
                        BufferedImage tag = new BufferedImage(destWidth, destHeight, 1);
                        Graphics g = tag.getGraphics();
                        g.drawImage(img, 0, 0, null);
                        g.dispose();
                        ImageIO.write((RenderedImage)tag, "JPEG", new File(descDir + "_r" + i + "_c" + j + ".jpg"));
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static final void convert(String srcImageFile, String formatName, String destImageFile) {
        try {
            File f = new File(srcImageFile);
            f.canRead();
            f.canWrite();
            BufferedImage src = ImageIO.read(f);
            ImageIO.write((RenderedImage)src, formatName, new File(destImageFile));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static final void gray(String srcImageFile, String destImageFile) {
        try {
            BufferedImage src = ImageIO.read(new File(srcImageFile));
            ColorSpace cs = ColorSpace.getInstance(1003);
            ColorConvertOp op = new ColorConvertOp(cs, null);
            src = op.filter(src, null);
            ImageIO.write((RenderedImage)src, "JPEG", new File(destImageFile));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static final void pressText(String pressText, String srcImageFile, String destImageFile, String fontName, int fontStyle, Color color, int fontSize, int x, int y, float alpha) {
        try {
            File img = new File(srcImageFile);
            BufferedImage src = ImageIO.read(img);
            int width = ((Image)src).getWidth(null);
            int height = ((Image)src).getHeight(null);
            BufferedImage image = new BufferedImage(width, height, 1);
            Graphics2D g = image.createGraphics();
            g.drawImage(src, 0, 0, width, height, null);
            g.setColor(color);
            g.setFont(new Font(fontName, fontStyle, fontSize));
            g.setComposite(AlphaComposite.getInstance(10, alpha));
            g.drawString(pressText, (width - ImageUtils.getLength(pressText) * fontSize) / 2 + x, (height - fontSize) / 2 + y);
            g.dispose();
            ImageIO.write((RenderedImage)image, "JPEG", new File(destImageFile));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static final void pressText2(String pressText, String srcImageFile, String destImageFile, String fontName, int fontStyle, Color color, int fontSize, int x, int y, float alpha) {
        try {
            File img = new File(srcImageFile);
            BufferedImage src = ImageIO.read(img);
            int width = ((Image)src).getWidth(null);
            int height = ((Image)src).getHeight(null);
            BufferedImage image = new BufferedImage(width, height, 1);
            Graphics2D g = image.createGraphics();
            g.drawImage(src, 0, 0, width, height, null);
            g.setColor(color);
            g.setFont(new Font(fontName, fontStyle, fontSize));
            g.setComposite(AlphaComposite.getInstance(10, alpha));
            g.drawString(pressText, (width - ImageUtils.getLength(pressText) * fontSize) / 2 + x, (height - fontSize) / 2 + y);
            g.dispose();
            ImageIO.write((RenderedImage)image, "JPEG", new File(destImageFile));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static final void pressImage(String pressImg, String srcImageFile, String destImageFile, int x, int y, float alpha) {
        try {
            File img = new File(srcImageFile);
            BufferedImage src = ImageIO.read(img);
            int wideth = ((Image)src).getWidth(null);
            int height = ((Image)src).getHeight(null);
            BufferedImage image = new BufferedImage(wideth, height, 1);
            Graphics2D g = image.createGraphics();
            g.drawImage(src, 0, 0, wideth, height, null);
            BufferedImage src_biao = ImageIO.read(new File(pressImg));
            int wideth_biao = ((Image)src_biao).getWidth(null);
            int height_biao = ((Image)src_biao).getHeight(null);
            g.setComposite(AlphaComposite.getInstance(10, alpha));
            g.drawImage(src_biao, (wideth - wideth_biao) / 2, (height - height_biao) / 2, wideth_biao, height_biao, null);
            g.dispose();
            ImageIO.write((RenderedImage)image, "JPEG", new File(destImageFile));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean createThumbnail(String src, String dist, float width, float height, boolean flag) {
        boolean flag1 = false;
        try {
            File srcfile = new File(src);
            if (!srcfile.exists()) {
                return flag1;
            }
            BufferedImage image = ImageIO.read(srcfile);
            double ratio = 1.0;
            if ((float)image.getHeight() > height || (float)image.getWidth() > width) {
                ratio = image.getHeight() > image.getWidth() ? (double)(height / (float)image.getHeight()) : (double)(width / (float)image.getWidth());
            }
            int newWidth = flag ? (int)width : (int)((double)image.getWidth() * ratio);
            int newHeight = flag ? (int)height : (int)((double)image.getHeight() * ratio);
            BufferedImage bfImage = new BufferedImage(newWidth, newHeight, 1);
            flag1 = bfImage.getGraphics().drawImage(image.getScaledInstance(newWidth, newHeight, 4), 0, 0, null);
            FileOutputStream os = new FileOutputStream(dist);
            JPEGImageEncoder encoder = JPEGCodec.createJPEGEncoder((OutputStream)os);
            JPEGEncodeParam jParam = encoder.getDefaultJPEGEncodeParam(bfImage);
            jParam.setQuality(1.0f, false);
            encoder.encode(bfImage);
            os.close();
            flag1 = true;
        }
        catch (Exception e) {
            flag1 = false;
        }
        return flag1;
    }

    public static final int getLength(String text) {
        int length = 0;
        for (int i = 0; i < text.length(); ++i) {
            if (new String(text.charAt(i) + "").getBytes().length > 1) {
                length += 2;
                continue;
            }
            ++length;
        }
        return length / 2;
    }

    public static int getImgWidth(File file) {
        FileInputStream is = null;
        BufferedImage src = null;
        int ret = -1;
        try {
            is = new FileInputStream(file);
            src = ImageIO.read(is);
            ret = src.getWidth(null);
            ((InputStream)is).close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public static int getImgHeight(File file) {
        FileInputStream is = null;
        BufferedImage src = null;
        int ret = -1;
        try {
            is = new FileInputStream(file);
            src = ImageIO.read(is);
            ret = src.getHeight(null);
            ((InputStream)is).close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }
}

