/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.tool.util;

import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.util.CellRangeAddress;

public class WorkbookBuilder {
    private String sheetname;
    private String[] titles;
    private String titlename;
    private String undefined;

    public HSSFWorkbook build() {
        HSSFWorkbook workbook = new HSSFWorkbook();
        if (this.sheetname != null) {
            HSSFSheet sheet = workbook.createSheet(this.sheetname);
            if (this.titles != null && this.titles.length > 0 && this.titlename != null) {
                Row tableTitleRow = sheet.createRow(sheet.getPhysicalNumberOfRows());
                Cell tableTitleCell = tableTitleRow.createCell(0);
                tableTitleCell.setCellValue(this.titlename);
                sheet.addMergedRegion(new CellRangeAddress(0, 0, 0, this.titles.length));
            }
            if (this.titles != null && this.titles.length > 0) {
                HSSFRow titleRow = (HSSFRow)sheet.createRow(sheet.getPhysicalNumberOfRows());
                for (int i = 0; i < this.titles.length; ++i) {
                    titleRow.createCell(i).setCellValue(this.titles[i]);
                }
            }
            if (this.titles != null && this.undefined != null) {
                Row row = sheet.createRow(sheet.getPhysicalNumberOfRows());
                Cell cell = row.createCell(0);
                cell.setCellValue(this.undefined);
                sheet.addMergedRegion(new CellRangeAddress(sheet.getPhysicalNumberOfRows() - 1, sheet.getPhysicalNumberOfRows() - 1, 0, this.titles.length));
            }
        }
        return workbook;
    }

    public static WorkbookBuilder create() {
        return new WorkbookBuilder();
    }

    public WorkbookBuilder setTitle(String titlename, String[] titles) {
        this.titles = titles;
        this.titlename = titlename;
        return this;
    }

    public WorkbookBuilder setTitle(String[] titles) {
        this.titles = titles;
        return this;
    }

    public WorkbookBuilder createSheet(String sheetname) {
        this.sheetname = sheetname;
        return this;
    }

    public WorkbookBuilder setUndefined(String undefined) {
        this.undefined = undefined;
        return this;
    }
}

