/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.tool.util;

class Caesar {
    private String table;
    private int seedA = 1103515245;
    private int seedB = 12345;

    public Caesar(String table, int seed) {
        this.table = this.chaos(table, seed, table.length());
    }

    public Caesar(String table) {
        this(table, 11);
    }

    public Caesar() {
        this(11);
    }

    public Caesar(int seed) {
        this("ABCDEFGHIJKLMNOPQRSTUVWXYZ", seed);
    }

    public char dict(int i, boolean reverse) {
        int s = this.table.length();
        int index = reverse ? s - i : i;
        return this.table.charAt(index);
    }

    public int dict(char c, boolean reverse) {
        int s = this.table.length();
        int index = this.table.indexOf(c);
        return reverse ? s - index : index;
    }

    public int seed(int seed) {
        long temp = seed;
        return (int)(temp * (long)this.seedA + (long)this.seedB & Integer.MAX_VALUE);
    }

    public String chaos(String data, int seed, int cnt) {
        StringBuffer buf = new StringBuffer(data);
        int r = data.length();
        for (int i = 0; i < cnt; ++i) {
            seed = this.seed(seed);
            int a = seed % r;
            seed = this.seed(seed);
            int b = seed % r;
            char tmp = buf.charAt(a);
            buf.setCharAt(a, buf.charAt(b));
            buf.setCharAt(b, tmp);
        }
        return buf.toString();
    }

    public String crypto(boolean reverse, int key, String text) {
        int m;
        String ret = null;
        StringBuilder buf = new StringBuilder();
        int s = this.table.length();
        int e = text.length();
        for (int i = 0; i < e && (m = this.dict(text.charAt(i), reverse)) >= 0; ++i) {
            m = m + key + i;
            buf.append(this.dict(m % s, reverse));
        }
        if (buf.length() == e) {
            ret = buf.toString();
        }
        return ret;
    }

    public String encode(int key, String text) {
        return this.crypto(false, key, text);
    }

    public String decode(int key, String text) {
        return this.crypto(true, key, text);
    }

    public static void main(String[] args) {
        Caesar caesar = new Caesar();
        String data = caesar.encode(32, "APPLE");
        caesar.decode(32, data);
    }
}

