/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.tool.json;

import com.yqbsoft.laser.service.tool.codec.Base64;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class TypeCast {
    public static final Boolean castToBoolean(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue() == 1;
        }
        if (value instanceof String) {
            String strVal = (String)value;
            if (strVal.length() == 0) {
                return null;
            }
            if ("true".equalsIgnoreCase(strVal)) {
                return Boolean.TRUE;
            }
            if ("false".equalsIgnoreCase(strVal)) {
                return Boolean.FALSE;
            }
            if ("1".equals(strVal)) {
                return Boolean.TRUE;
            }
            if ("0".equals(strVal)) {
                return Boolean.FALSE;
            }
            if ("null".equals(strVal) || "NULL".equals(strVal)) {
                return null;
            }
        }
        return null;
    }

    public static final Integer castToInt(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        if (value instanceof String) {
            String strVal = (String)value;
            if (strVal.length() == 0) {
                return null;
            }
            if ("null".equals(strVal)) {
                return null;
            }
            if ("null".equals(strVal) || "NULL".equals(strVal)) {
                return null;
            }
            return Integer.parseInt(strVal);
        }
        return null;
    }

    public static final Long castToLong(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        String strVal = null;
        if (value instanceof String) {
            strVal = (String)value;
            if (strVal.length() == 0) {
                return null;
            }
            if ("null".equals(strVal) || "NULL".equals(strVal)) {
                return null;
            }
        }
        try {
            return Long.parseLong(strVal);
        }
        catch (NumberFormatException dateParser) {
            return null;
        }
    }

    public static final Double castToDouble(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        if (value instanceof String) {
            String strVal = value.toString();
            if (strVal.length() == 0) {
                return null;
            }
            if ("null".equals(strVal) || "NULL".equals(strVal)) {
                return null;
            }
            return Double.parseDouble(strVal);
        }
        return null;
    }

    public static final BigDecimal castToBigDecimal(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof BigDecimal) {
            return (BigDecimal)value;
        }
        if (value instanceof BigInteger) {
            return new BigDecimal((BigInteger)value);
        }
        String strVal = value.toString();
        if (strVal.length() == 0) {
            return null;
        }
        return new BigDecimal(strVal);
    }

    public static final BigInteger castToBigInteger(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof BigInteger) {
            return (BigInteger)value;
        }
        if (value instanceof Float || value instanceof Double) {
            return BigInteger.valueOf(((Number)value).longValue());
        }
        String strVal = value.toString();
        if (strVal.length() == 0) {
            return null;
        }
        return new BigInteger(strVal);
    }

    public static final Date castToDate(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Calendar) {
            return ((Calendar)value).getTime();
        }
        if (value instanceof Date) {
            return (Date)value;
        }
        long longValue = -1L;
        if (value instanceof Number) {
            longValue = ((Number)value).longValue();
            return new Date(longValue);
        }
        if (value instanceof String) {
            String strVal = (String)value;
            if (strVal.indexOf(45) != -1) {
                String format = null;
                format = strVal.length() == 10 ? "yyyy-MM-dd" : (strVal.length() == "yyyy-MM-dd HH:mm:ss".length() ? "yyyy-MM-dd HH:mm:ss" : "yyyy-MM-dd HH:mm:ss.SSS");
                SimpleDateFormat dateFormat = new SimpleDateFormat(format);
                try {
                    return dateFormat.parse(strVal);
                }
                catch (ParseException e) {
                    return null;
                }
            }
            if (strVal.length() == 0) {
                return null;
            }
            longValue = Long.parseLong(strVal);
        }
        if (longValue < 0L) {
            return null;
        }
        return new Date(longValue);
    }

    public static final byte[] castToBytes(Object value) {
        if (value instanceof byte[]) {
            return (byte[])value;
        }
        if (value instanceof String) {
            return Base64.decodeBase64(((String)value).getBytes());
        }
        return null;
    }
}

