/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.tool.util;

import java.io.IOException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;

public class EmailUtil {
    private MimeMessage mineMessage;
    private Session session;
    private Properties props;
    private String userName;
    private String password;
    private Multipart multipart;

    public void setSmtpHost(String hostName) {
        if (this.props == null) {
            this.props = System.getProperties();
        }
        this.props.put("mail.smtp.host", hostName);
    }

    public void createMimeMessage() {
        try {
            this.session = Session.getDefaultInstance((Properties)this.props, null);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.mineMessage = new MimeMessage(this.session);
            this.multipart = new MimeMultipart();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setNeedAuth(boolean need) {
        if (this.props == null) {
            this.props = System.getProperties();
        }
        if (need) {
            this.props.put("mail.smtp.auth", "true");
        } else {
            this.props.put("mail.smtp.auth", "false");
        }
    }

    public void setSubject(String mailSubject) {
        try {
            this.mineMessage.setSubject(MimeUtility.encodeText((String)mailSubject, (String)"utf-8", (String)"B"));
        }
        catch (Exception e) {
            System.err.println("\u8bbe\u7f6e\u90ae\u4ef6\u6807\u9898\u65f6\u53d1\u751f\u9519\u8bef\uff01" + e);
        }
    }

    public void setBody(String mailBody) {
        try {
            MimeBodyPart bp = new MimeBodyPart();
            bp.setContent((Object)("" + mailBody), "text/html;charset=utf-8");
            this.multipart.addBodyPart((BodyPart)bp);
        }
        catch (Exception e) {
            System.err.println("\u8bbe\u7f6e\u90ae\u4ef6\u6b63\u6587\u65f6\u53d1\u751f\u9519\u8bef\uff01" + e);
        }
    }

    public void setFrom(String from) {
        try {
            this.mineMessage.setFrom((Address)new InternetAddress(from));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int sendMail() throws IOException, MessagingException {
        this.mineMessage.setContent(this.multipart);
        this.mineMessage.saveChanges();
        Session mailSession = Session.getInstance((Properties)this.props, null);
        Transport transport = mailSession.getTransport("smtp");
        try {
            try {
                transport.connect((String)this.props.get("mail.smtp.host"), this.userName, this.password);
            }
            catch (Exception e) {
                e.printStackTrace();
                int n = 3;
                try {
                    if (transport != null && transport.isConnected()) {
                        transport.close();
                    }
                }
                catch (Exception e2) {
                    System.out.println(e2.toString());
                }
                return n;
            }
            transport.sendMessage((Message)this.mineMessage, this.mineMessage.getAllRecipients());
            transport.close();
        }
        catch (MessagingException mex) {
            mex.printStackTrace();
            Exception ex = null;
            ex = mex.getNextException();
            if (ex != null) {
                System.out.println(ex.toString());
                ex.printStackTrace();
            }
            int n = 3;
            return n;
        }
        finally {
            try {
                if (transport != null && transport.isConnected()) {
                    transport.close();
                }
            }
            catch (Exception e) {
                System.out.println(e.toString());
            }
        }
        return 0;
    }

    public Session getSession() {
        return this.session;
    }

    public void setSession(Session session) {
        this.session = session;
    }

    public Properties getProps() {
        return this.props;
    }

    public void setProps(Properties props) {
        this.props = props;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public Multipart getMultipart() {
        return this.multipart;
    }

    public void setMultipart(Multipart multipart) {
        this.multipart = multipart;
    }

    public boolean setTo(String to) {
        if (to == null) {
            return false;
        }
        try {
            this.mineMessage.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)to));
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean setCc(String cc) {
        if (cc == null) {
            return false;
        }
        try {
            this.mineMessage.setRecipients(Message.RecipientType.CC, (Address[])InternetAddress.parse((String)cc));
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static void main(String[] args) throws Exception {
        String str = "Host:" + InetAddress.getLocalHost() + "<br>";
        Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
        while (en.hasMoreElements()) {
            NetworkInterface networkinterface = en.nextElement();
            str = str + networkinterface.getName() + "<br>";
            Enumeration<InetAddress> addresses = networkinterface.getInetAddresses();
            while (addresses.hasMoreElements()) {
                str = str + addresses.nextElement().getHostAddress() + "<br>";
            }
        }
        String mailbody = str;
        EmailUtil themail = new EmailUtil();
        themail.createMimeMessage();
        themail.setNeedAuth(true);
        themail.setSmtpHost("smtp.qq.com");
        themail.setSubject("\u6d4b\u8bd5");
        themail.setBody(mailbody);
        themail.setTo("253142031@qq.com");
        themail.setFrom("253142031@qq.com");
        themail.setUserName("253142031@qq.com");
        themail.setPassword("");
        System.out.println(themail.sendMail() + "===============");
    }
}

