/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.tool.util;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.yqbsoft.laser.service.tool.util.FileUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlUtil {
    private static XmlUtil allXmlUtil;
    private static XmlUtil notNullXmlUtil;
    private static XmlUtil notDefXmlUtil;
    private static XmlUtil notEmpXmlUtil;
    private ObjectMapper mapper = new XmlMapper();

    public static XmlUtil getAllXmlUtil() {
        return allXmlUtil;
    }

    public static void setAllXmlUtil(XmlUtil allXmlUtil) {
        XmlUtil.allXmlUtil = allXmlUtil;
    }

    public static XmlUtil getNotNullXmlUtil() {
        return notNullXmlUtil;
    }

    public static void setNotNullXmlUtil(XmlUtil notNullXmlUtil) {
        XmlUtil.notNullXmlUtil = notNullXmlUtil;
    }

    public static XmlUtil getNotDefXmlUtil() {
        return notDefXmlUtil;
    }

    public static void setNotDefXmlUtil(XmlUtil notDefXmlUtil) {
        XmlUtil.notDefXmlUtil = notDefXmlUtil;
    }

    public static XmlUtil getNotEmpXmlUtil() {
        return notEmpXmlUtil;
    }

    public static void setNotEmpXmlUtil(XmlUtil notEmpXmlUtil) {
        XmlUtil.notEmpXmlUtil = notEmpXmlUtil;
    }

    public ObjectMapper getMapper() {
        return this.mapper;
    }

    public void setMapper(ObjectMapper mapper) {
        this.mapper = mapper;
    }

    public XmlUtil(JsonInclude.Include include) {
        this.mapper.setSerializationInclusion(include);
        this.mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.mapper.configure(DeserializationFeature.FAIL_ON_NUMBERS_FOR_ENUMS, true);
        this.setDateFormat("yyyy-MM-dd HH:mm:ss");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static XmlUtil buildNormalBinder() {
        Class<XmlUtil> clazz = XmlUtil.class;
        synchronized (XmlUtil.class) {
            if (allXmlUtil == null) {
                allXmlUtil = new XmlUtil(JsonInclude.Include.ALWAYS);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return allXmlUtil;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static XmlUtil buildNonNullBinder() {
        Class<XmlUtil> clazz = XmlUtil.class;
        synchronized (XmlUtil.class) {
            if (notNullXmlUtil == null) {
                notNullXmlUtil = new XmlUtil(JsonInclude.Include.NON_NULL);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return notNullXmlUtil;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static XmlUtil buildNonDefaultBinder() {
        Class<XmlUtil> clazz = XmlUtil.class;
        synchronized (XmlUtil.class) {
            if (notDefXmlUtil == null) {
                notDefXmlUtil = new XmlUtil(JsonInclude.Include.NON_DEFAULT);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return notDefXmlUtil;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static XmlUtil buildNonEmptyBinder() {
        Class<XmlUtil> clazz = XmlUtil.class;
        synchronized (XmlUtil.class) {
            if (notEmpXmlUtil == null) {
                notEmpXmlUtil = new XmlUtil(JsonInclude.Include.NON_EMPTY);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return notEmpXmlUtil;
        }
    }

    public <T> T getJsonToObject(String json, Class<T> clazz) {
        Object object = null;
        if (StringUtils.isNotBlank(json)) {
            try {
                object = this.getMapper().readValue(json, clazz);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return (T)object;
    }

    public Object getJsonToList(String json, Class clazz) {
        Object object = null;
        if (StringUtils.isNotBlank(json)) {
            try {
                object = this.getMapper().readValue(json, (JavaType)TypeFactory.defaultInstance().constructCollectionType(ArrayList.class, clazz));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return object;
    }

    public Object[] getJsonToArray(String json, Class clazz) {
        Object[] object = null;
        if (StringUtils.isNotBlank(json)) {
            try {
                object = (Object[])this.getMapper().readValue(json, (JavaType)TypeFactory.defaultInstance().constructArrayType(clazz));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return object;
    }

    public byte[] getJsonTobyteArray(String json) {
        byte[] object = null;
        if (StringUtils.isNotBlank(json)) {
            try {
                object = (byte[])this.getMapper().readValue(json, (JavaType)TypeFactory.defaultInstance().constructArrayType(Byte.TYPE));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return object;
    }

    public Object getJsonToMap(String json, Class keyclazz, Class valueclazz) {
        Object object = null;
        if (StringUtils.isNotBlank(json)) {
            try {
                object = this.getMapper().readValue(json, TypeFactory.defaultInstance().constructParametricType(HashMap.class, new Class[]{keyclazz, valueclazz}));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return object;
    }

    public static Map<String, String> getJsonToMap(String str) {
        String[] s;
        HashMap<String, String> map = new HashMap<String, String>();
        if (StringUtils.isNotBlank(str) && (s = str.split(",")).length > 0) {
            for (int i = 0; i < s.length; ++i) {
                String con = s[i];
                int s1 = con.indexOf(":");
                if (s1 > 0) {
                    map.put(con.substring(0, s1).trim().replace("\"", ""), con.substring(s1 + 1).replace("\"", ""));
                    continue;
                }
                map.put(con.trim().replace("\"", ""), "");
            }
        }
        return map;
    }

    public String getMapToJson(Map<String, String> map) {
        ArrayList<String[]> list = new ArrayList<String[]>();
        if (null != map && !map.isEmpty()) {
            for (String key : map.keySet()) {
                String[] strS = new String[]{key, map.get(key)};
                list.add(strS);
            }
        }
        return this.jsonObject(list);
    }

    public String jsonObject(List list) {
        StringWriter sw = new StringWriter();
        try {
            JsonGenerator gen = new JsonFactory().createGenerator((Writer)sw);
            this.getMapper().writeValue(gen, (Object)list);
            gen.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        return sw.toString();
    }

    public Object getJsonToObject(String json, Class objclazz, Class ... pclazz) {
        Object object = null;
        if (StringUtils.isNotBlank(json)) {
            try {
                object = this.getMapper().readValue(json, TypeFactory.defaultInstance().constructParametricType(objclazz, pclazz));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return object;
    }

    public String toJson(Object object) {
        String json = null;
        try {
            json = this.getMapper().writeValueAsString(object);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return json;
    }

    public void setDateFormat(String pattern) {
        if (StringUtils.isNotBlank(pattern)) {
            SimpleDateFormat df = new SimpleDateFormat(pattern);
            this.getMapper().setDateFormat((DateFormat)df);
        }
    }

    public static Map<String, String> getMapFromXML(String xmlString) {
        HashMap<String, String> map = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            InputStream is = FileUtil.getStringStream(xmlString);
            Document document = builder.parse(is);
            NodeList allNodes = document.getFirstChild().getChildNodes();
            map = new HashMap<String, String>();
            for (int i = 0; i < allNodes.getLength(); ++i) {
                String value;
                Node node = allNodes.item(i);
                if (!(node instanceof Element) || node.getFirstChild() == null || !StringUtils.isNotBlank(value = node.getFirstChild().getNodeValue())) continue;
                map.put(node.getNodeName(), node.getFirstChild().getNodeValue());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return map;
    }

    public static String callMapToXML(Map<String, String> map) {
        StringBuilder sb = new StringBuilder();
        sb.append("<xml>");
        Set<String> set = map.keySet();
        for (String key : set) {
            String value = map.get(key);
            if (null == value) {
                value = "";
            }
            sb.append("<" + key + ">" + value + "</" + key + ">");
        }
        sb.append("</xml>");
        return sb.toString();
    }

    public static void main(String[] args) {
    }
}

