/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.tool.util;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Random;
import javax.imageio.ImageIO;

public class VerifyImgUtils {
    private int width = 120;
    private int height = 40;
    private int lineCount = 10;
    private String verCode = null;
    private BufferedImage buffImg = null;

    public VerifyImgUtils(String verCode) {
        this.verCode = verCode;
        this.createCode();
    }

    public VerifyImgUtils(String verCode, int width, int height) {
        this.width = width;
        this.height = height;
        this.verCode = verCode;
        this.createCode();
    }

    public void createCode() {
        int x = 0;
        int fontHeight = 0;
        int codeY = 0;
        int red = 0;
        int green = 0;
        int blue = 0;
        int codeCount = this.verCode.length();
        x = this.width / this.verCode.length() + 2;
        fontHeight = this.height - 2;
        codeY = this.height - 10;
        this.buffImg = new BufferedImage(this.width, this.height, 1);
        Graphics2D g = this.buffImg.createGraphics();
        Random random = new Random();
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, this.width, this.height);
        for (int i = 0; i < this.lineCount; ++i) {
            int xs = random.nextInt(this.width / 2);
            int ys = random.nextInt(this.height);
            int xe = random.nextInt(this.width / 2) + this.width / 2;
            int ye = random.nextInt(this.height);
            red = random.nextInt(255);
            green = random.nextInt(255);
            blue = random.nextInt(255);
            g.setColor(new Color(red, green, blue));
            g.drawLine(xs, ys, xe, ye);
        }
        Font font = new Font("Arial", 1, fontHeight);
        g.setFont(font);
        for (int i = 0; i < codeCount; ++i) {
            red = random.nextInt(255);
            green = random.nextInt(255);
            blue = random.nextInt(255);
            g.setColor(new Color(red, green, blue));
            g.drawString(String.valueOf(this.verCode.charAt(i)), i * x, codeY);
        }
    }

    public void write(String path) throws IOException {
        FileOutputStream sos = new FileOutputStream(path);
        this.write(sos);
    }

    public void write(OutputStream sos) throws IOException {
        ImageIO.write((RenderedImage)this.buffImg, "png", sos);
        sos.close();
    }

    public BufferedImage getBuffImg() {
        return this.buffImg;
    }

    public static void main(String[] args) {
        try {
            new VerifyImgUtils("edasf").write("D:\\a.png");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

