/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.tool.util;

import com.yqbsoft.laser.service.tool.util.FileItem;
import com.yqbsoft.laser.service.tool.util.HttpConnectionThreadLocal;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.ParseException;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.HttpContext;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;
import org.apache.http.util.EntityUtils;

public abstract class WebUtils {
    private static final String DEFAULT_CHARSET = "UTF-8";
    private static final String METHOD_POST = "POST";
    private static final String METHOD_GET = "GET";
    private static final String METHOD_DELETE = "DELETE";
    public static final String ACCEPT_JSON = "application/json";
    public static HttpClient client;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpClient getHttpClient() {
        String string = ACCEPT_JSON;
        synchronized (ACCEPT_JSON) {
            if (null == client) {
                try {
                    SSLContext sslcontext = SSLContexts.custom().loadTrustMaterial(null, (TrustStrategy)new TrustSelfSignedStrategy()).build();
                    X509HostnameVerifier hostnameVerifier = SSLConnectionSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER;
                    SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslcontext, (HostnameVerifier)hostnameVerifier);
                    Registry socketFactoryRegistry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)sslsf).build();
                    PoolingHttpClientConnectionManager connManager = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
                    connManager.setMaxTotal(200);
                    connManager.setDefaultMaxPerRoute(15);
                    ConnectionKeepAliveStrategy connectionKeepAliveStrategy = new ConnectionKeepAliveStrategy(){

                        public long getKeepAliveDuration(HttpResponse httpResponse, HttpContext httpContext) {
                            return 20000L;
                        }
                    };
                    client = HttpClientBuilder.create().setConnectionManager((HttpClientConnectionManager)connManager).setKeepAliveStrategy(connectionKeepAliveStrategy).build();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return client;
        }
    }

    private WebUtils() {
    }

    public static String doPost(String url, Map<String, String> params, int connectTimeout, int readTimeout) throws IOException {
        return WebUtils.doPost(url, params, DEFAULT_CHARSET, connectTimeout, readTimeout, null);
    }

    public static String doPost(String url, Map<String, String> params, int connectTimeout, int readTimeout, String authorization) throws IOException {
        return WebUtils.doPost(url, params, DEFAULT_CHARSET, connectTimeout, readTimeout, authorization);
    }

    public static String doJsonPost(String url, Map<String, String> params, int connectTimeout, int readTimeout) throws IOException {
        return WebUtils.doPost(url, params, DEFAULT_CHARSET, ACCEPT_JSON, connectTimeout, readTimeout);
    }

    public static String doPostByJson(String url, Map<String, Object> params, int connectTimeout, int readTimeout) throws IOException {
        String ctype = "application/x-www-form-urlencoded;charset=UTF-8";
        byte[] content = JsonUtil.buildNormalBinder().toJson(params).getBytes(DEFAULT_CHARSET);
        return WebUtils.doPost(url, ACCEPT_JSON, ctype, content, connectTimeout, readTimeout, null);
    }

    public static String doPostJson(String url, Map<String, Object> params, int connectTimeout, int readTimeout, String authorization) throws IOException {
        String ctype = "application/json;charset=UTF-8";
        String json = JsonUtil.buildNormalBinder().toJson(params);
        byte[] content = json.getBytes(DEFAULT_CHARSET);
        return WebUtils.doPost(url, ACCEPT_JSON, ctype, content, connectTimeout, readTimeout, null);
    }

    public static String doPostJson(String url, Map<String, Object> params, int connectTimeout, int readTimeout) throws IOException {
        String ctype = "application/json;charset=UTF-8";
        byte[] content = JsonUtil.buildNormalBinder().toJson(params).getBytes(DEFAULT_CHARSET);
        return WebUtils.doPost(url, ACCEPT_JSON, ctype, content, connectTimeout, readTimeout, null);
    }

    public static byte[] doPostReByte(String url, String accept, String ctype, byte[] content, int connectTimeout, int readTimeout, String authorization) throws IOException {
        HttpURLConnection conn = null;
        OutputStream out = null;
        try {
            conn = WebUtils.getConnection(new URL(url), METHOD_POST, accept, ctype, null, authorization);
            conn.setConnectTimeout(connectTimeout);
            conn.setReadTimeout(readTimeout);
            out = conn.getOutputStream();
            out.write(content);
            byte[] e = WebUtils.getResponseAsStringReByte(conn);
            return e;
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    public static byte[] doPostJsonReByte(String url, Map<String, Object> params, int connectTimeout, int readTimeout) throws IOException {
        String ctype = "application/json;charset=UTF-8";
        byte[] content = JsonUtil.buildNormalBinder().toJson(params).getBytes(DEFAULT_CHARSET);
        return WebUtils.doPostReByte(url, ACCEPT_JSON, ctype, content, connectTimeout, readTimeout, null);
    }

    public static <T> T postForObject(String url, String json, Class<T> clazz, int connectTimeout, int readTimeout) throws IOException {
        if (StringUtils.hasBlank(url, json)) {
            return null;
        }
        String ctype = "application/x-www-form-urlencoded;charset=UTF-8";
        byte[] content = json.getBytes(DEFAULT_CHARSET);
        String resultStr = WebUtils.doPost(url, ACCEPT_JSON, ctype, content, connectTimeout, readTimeout, null);
        return JsonUtil.buildNonDefaultBinder().getJsonToObject(resultStr, clazz);
    }

    public static String doDelete(String url, int connectTimeout, int readTimeout) throws IOException {
        return WebUtils.doDelete(url, DEFAULT_CHARSET, connectTimeout, readTimeout, null);
    }

    public static String doPost(String url, Map<String, String> params, String charset, int connectTimeout, int readTimeout) {
        try {
            return WebUtils.doPost(url, params, charset, connectTimeout, readTimeout, null);
        }
        catch (IOException e) {
            return null;
        }
    }

    public static String doPost(String url, String ctype, Map<String, String> params, String charset, int connectTimeout, int readTimeout, String authorization) throws IOException {
        if (StringUtils.isBlank(charset)) {
            charset = DEFAULT_CHARSET;
        }
        String query = WebUtils.buildQuery(params, charset);
        byte[] content = new byte[]{};
        if (query != null) {
            content = query.getBytes(charset);
        }
        return WebUtils.doPost(url, ctype, content, connectTimeout, readTimeout, authorization);
    }

    public static String doPost(String url, Map<String, String> params, String charset, int connectTimeout, int readTimeout, String authorization) throws IOException {
        String ctype = "application/x-www-form-urlencoded;charset=" + charset;
        String query = WebUtils.buildQuery(params, charset);
        byte[] content = new byte[]{};
        if (query != null) {
            content = query.getBytes(charset);
        }
        return WebUtils.doPost(url, ctype, content, connectTimeout, readTimeout, authorization);
    }

    public static String doPost(String url, Map<String, String> params, String charset, String accept, int connectTimeout, int readTimeout) throws IOException {
        String ctype = "application/x-www-form-urlencoded;charset=" + charset;
        String query = WebUtils.buildQuery(params, charset);
        byte[] content = new byte[]{};
        if (query != null) {
            content = query.getBytes(charset);
        }
        return WebUtils.doPost(url, accept, ctype, content, connectTimeout, readTimeout, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String doDelete(String url, String charset, int connectTimeout, int readTimeout, String authorization) throws IOException {
        String ctype = "application/x-www-form-urlencoded;charset=" + charset;
        HttpURLConnection conn = null;
        OutputStream out = null;
        String rsp = null;
        try {
            conn = WebUtils.getConnectionprotocol(new URL(url), METHOD_DELETE, ctype, null, authorization, null);
            conn.setConnectTimeout(connectTimeout);
            conn.setReadTimeout(readTimeout);
            rsp = WebUtils.getResponseAsString(conn);
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (conn != null) {
                conn.disconnect();
            }
        }
        return rsp;
    }

    public static String doPost(String url, String ctype, byte[] content, int connectTimeout, int readTimeout) throws IOException {
        return WebUtils.doPost(url, ctype, content, connectTimeout, readTimeout, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String doPost(String url, String ctype, byte[] content, int connectTimeout, int readTimeout, String authorization) throws IOException {
        HttpURLConnection conn = null;
        OutputStream out = null;
        String rsp = null;
        try {
            conn = WebUtils.getConnectionprotocol(new URL(url), METHOD_POST, ctype, null, authorization, null);
            conn.setConnectTimeout(connectTimeout);
            conn.setReadTimeout(readTimeout);
            out = conn.getOutputStream();
            out.write(content);
            rsp = WebUtils.getResponseAsString(conn);
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (conn != null) {
                conn.disconnect();
            }
        }
        return rsp;
    }

    public static String processHttpRequest(String url, String requestMethod, Map<String, String> paramsMap, int connectTimeout, int readTimeout, String accept, String ctype, String user_agent) {
        ArrayList<BasicNameValuePair> formparams = new ArrayList<BasicNameValuePair>();
        if (METHOD_POST.equals(requestMethod.toUpperCase())) {
            HttpPost httppost = new HttpPost(url);
            httppost.setHeader("Content-Type", ctype);
            httppost.setHeader("User-Agent", user_agent);
            for (String key : paramsMap.keySet()) {
                String value = paramsMap.get(key);
                formparams.add(new BasicNameValuePair(key, value));
            }
            return WebUtils.doRequest(httppost, null, formparams, connectTimeout, readTimeout, accept);
        }
        if (METHOD_GET.equals(requestMethod)) {
            HttpGet httppost = new HttpGet(url);
            httppost.setHeader("Content-Type", ctype);
            httppost.setHeader("User-Agent", user_agent);
            for (String key : paramsMap.keySet()) {
                String value = paramsMap.get(key);
                formparams.add(new BasicNameValuePair(key, value));
            }
            return WebUtils.doRequest(null, httppost, formparams, connectTimeout, readTimeout, accept);
        }
        return "";
    }

    public static String processPostJson(String postUrl, String json) throws ClientProtocolException, Exception {
        HttpPost post = new HttpPost(postUrl);
        post.setHeader("Content-Type", ACCEPT_JSON);
        String str = null;
        StringEntity s = new StringEntity(json, "utf-8");
        s.setContentType(ACCEPT_JSON);
        RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(30000).setConnectTimeout(30000).setConnectionRequestTimeout(10000).build();
        post.setEntity((HttpEntity)s);
        post.setConfig(requestConfig);
        HttpResponse response = WebUtils.getHttpClient().execute((HttpUriRequest)post);
        HttpEntity entity = response.getEntity();
        if (entity != null) {
            InputStream instreams = entity.getContent();
            str = WebUtils.convertStreamToString(instreams);
            post.abort();
        }
        return str;
    }

    public static String processGetJson(String postUrl, String json) throws ClientProtocolException, Exception {
        HttpGet post = new HttpGet(postUrl);
        post.setHeader("Content-Type", "application/json;charset=UTF-8");
        String str = null;
        RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(30000).setConnectTimeout(30000).build();
        post.setConfig(requestConfig);
        HttpResponse response = WebUtils.getHttpClient().execute((HttpUriRequest)post);
        HttpEntity entity = response.getEntity();
        if (entity != null) {
            InputStream instreams = entity.getContent();
            str = WebUtils.convertStreamToString(instreams);
            post.abort();
        }
        return str;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String convertStreamToString(InputStream is) {
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        StringBuilder sb = new StringBuilder();
        String line = null;
        try {
            while ((line = reader.readLine()) != null) {
                sb.append(line + "\n");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String doRequest(HttpPost httpPost, HttpGet httpGet, List<BasicNameValuePair> formparams, int connectTimeout, int readTimeout, String accept) {
        try {
            CloseableHttpResponse response = null;
            UrlEncodedFormEntity uefEntity = new UrlEncodedFormEntity(formparams);
            RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(readTimeout).setConnectTimeout(connectTimeout).build();
            if (null != httpPost) {
                uefEntity.setContentEncoding((Header)new BasicHeader("Accept", accept));
                httpPost.setEntity((HttpEntity)uefEntity);
                httpPost.setConfig(requestConfig);
                response = (CloseableHttpResponse)WebUtils.getHttpClient().execute((HttpUriRequest)httpPost);
            } else {
                httpGet.setConfig(requestConfig);
                response = (CloseableHttpResponse)WebUtils.getHttpClient().execute((HttpUriRequest)httpGet);
            }
            HttpEntity entity = response.getEntity();
            String str = EntityUtils.toString((HttpEntity)entity, (String)DEFAULT_CHARSET);
            if (null == str) return "";
            if ("".equals(str)) return "";
            return str;
        }
        catch (ParseException e) {
            e.printStackTrace();
            return "";
        }
        catch (IOException e) {
            e.printStackTrace();
            return "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String doPost(String url, String accept, String ctype, byte[] content, int connectTimeout, int readTimeout, String authorization) throws IOException {
        HttpURLConnection conn = null;
        OutputStream out = null;
        String rsp = null;
        try {
            conn = WebUtils.getConnection(new URL(url), METHOD_POST, accept, ctype, null, authorization);
            conn.setConnectTimeout(connectTimeout);
            conn.setReadTimeout(readTimeout);
            out = conn.getOutputStream();
            out.write(content);
            rsp = WebUtils.getResponseAsString(conn);
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (conn != null) {
                conn.disconnect();
            }
        }
        return rsp;
    }

    public static String doPostByThreadLocal(String url, Map<String, String> params, int connectTimeout, int readTimeout, boolean isThreadLocal) throws IOException {
        return WebUtils.doPostByThreadLocal(url, params, DEFAULT_CHARSET, connectTimeout, readTimeout, isThreadLocal);
    }

    public static String doPostByThreadLocal(String url, Map<String, String> params, String charset, int connectTimeout, int readTimeout, boolean isThreadLocal) throws IOException {
        String ctype = "application/x-www-form-urlencoded;charset=" + charset;
        String query = WebUtils.buildQuery(params, charset);
        byte[] content = new byte[]{};
        if (query != null) {
            content = query.getBytes(charset);
        }
        return WebUtils.doPostByThreadLocal(url, ctype, content, connectTimeout, readTimeout, isThreadLocal, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String doPostByThreadLocal(String url, String ctype, byte[] content, int connectTimeout, int readTimeout, boolean isThreadLocal, String authorization) throws IOException {
        HttpURLConnection conn = null;
        OutputStream out = null;
        String rsp = null;
        try {
            conn = WebUtils.getConnectionprotocol(new URL(url), METHOD_POST, ctype, null, authorization, null);
            if (HttpConnectionThreadLocal.get() != null) {
                Map<String, List<String>> map = HttpConnectionThreadLocal.get().getHeaderFields();
                List<String> server = map.get("Set-Cookie");
                conn.addRequestProperty("Cookie", server.get(0));
            }
            conn.setConnectTimeout(connectTimeout);
            conn.setReadTimeout(readTimeout);
            out = conn.getOutputStream();
            out.write(content);
            rsp = WebUtils.getResponseAsString(conn);
            if (isThreadLocal) {
                HttpConnectionThreadLocal.set(conn);
            }
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (conn != null) {
                conn.disconnect();
            }
        }
        return rsp;
    }

    public static String doPost(String url, Map<String, String> params, Map<String, FileItem> fileParams, int connectTimeout, int readTimeout) throws IOException {
        if (fileParams == null || fileParams.isEmpty()) {
            return WebUtils.doPost(url, params, DEFAULT_CHARSET, connectTimeout, readTimeout, null);
        }
        return WebUtils.doPost(url, params, fileParams, DEFAULT_CHARSET, connectTimeout, readTimeout, null);
    }

    public static String doPost(String url, Map<String, String> params, Map<String, FileItem> fileParams, String charset, int connectTimeout, int readTimeout) throws IOException {
        return WebUtils.doPost(url, params, fileParams, charset, connectTimeout, readTimeout, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String doPost(String url, Map<String, String> params, Map<String, FileItem> fileParams, String charset, int connectTimeout, int readTimeout, String authorization) throws IOException {
        if (StringUtils.isBlank(charset)) {
            charset = DEFAULT_CHARSET;
        }
        if (fileParams == null || fileParams.isEmpty()) {
            return WebUtils.doPost(url, params, charset, connectTimeout, readTimeout, authorization);
        }
        String boundary = System.currentTimeMillis() + "";
        HttpURLConnection conn = null;
        OutputStream out = null;
        String rsp = null;
        try {
            String ctype = "multipart/form-data;boundary=" + boundary + ";charset=" + charset;
            conn = WebUtils.getConnectionprotocol(new URL(url), METHOD_POST, ctype, null, authorization, null);
            conn.setConnectTimeout(connectTimeout);
            conn.setReadTimeout(readTimeout);
            out = conn.getOutputStream();
            byte[] entryBoundaryBytes = ("\r\n--" + boundary + "\r\n").getBytes(charset);
            Set<Map.Entry<String, String>> textEntrySet = params.entrySet();
            for (Map.Entry<String, String> textEntry : textEntrySet) {
                byte[] textBytes = WebUtils.getTextEntry(textEntry.getKey(), textEntry.getValue(), charset);
                out.write(entryBoundaryBytes);
                out.write(textBytes);
            }
            Set<Map.Entry<String, FileItem>> fileEntrySet = fileParams.entrySet();
            for (Map.Entry<String, FileItem> fileEntry : fileEntrySet) {
                FileItem fileItem = fileEntry.getValue();
                byte[] fileBytes = WebUtils.getFileEntry(fileEntry.getKey(), fileItem.getFileName(), fileItem.getMimeType(), charset);
                out.write(entryBoundaryBytes);
                out.write(fileBytes);
                out.write(fileItem.getContent());
            }
            byte[] endBoundaryBytes = ("\r\n--" + boundary + "--\r\n").getBytes(charset);
            out.write(endBoundaryBytes);
            rsp = WebUtils.getResponseAsString(conn);
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (conn != null) {
                conn.disconnect();
            }
        }
        return rsp;
    }

    private static byte[] getTextEntry(String fieldName, String fieldValue, String charset) throws IOException {
        StringBuilder entry = new StringBuilder();
        entry.append("Content-Disposition:form-data;name=\"");
        entry.append(fieldName);
        entry.append("\"\r\nContent-Type:text/plain\r\n\r\n");
        entry.append(fieldValue);
        return entry.toString().getBytes(charset);
    }

    private static byte[] getFileEntry(String fieldName, String fileName, String mimeType, String charset) throws IOException {
        StringBuilder entry = new StringBuilder();
        entry.append("Content-Disposition:form-data;name=\"");
        entry.append(fieldName);
        entry.append("\";filename=\"");
        entry.append(fileName);
        entry.append("\"\r\nContent-Type:");
        entry.append(mimeType);
        entry.append("\r\n\r\n");
        return entry.toString().getBytes(charset);
    }

    public static String doGet(String url, Map<String, String> params) throws IOException {
        return WebUtils.doGet(url, params, DEFAULT_CHARSET, null, null, 0, 0);
    }

    public static String doGet(String url, Map<String, String> params, int connectTimeout, int readTimeout) throws IOException {
        return WebUtils.doGet(url, params, DEFAULT_CHARSET, null, null, connectTimeout, readTimeout);
    }

    public static String doGet(String url, Map<String, String> params, String user_agent) throws IOException {
        return WebUtils.doGet(url, params, DEFAULT_CHARSET, user_agent, null, 0, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String doGet(String url, Map<String, String> params, String charset, String user_agent, String authorization, int connectTimeout, int readTimeout) throws IOException {
        HttpURLConnection conn = null;
        String rsp = null;
        try {
            String ctype = "application/x-www-form-urlencoded;charset=" + charset;
            String query = WebUtils.buildQuery(params, charset);
            conn = WebUtils.getConnectionprotocol(WebUtils.buildGetUrl(url, query), METHOD_GET, ctype, user_agent, authorization, null);
            conn.setConnectTimeout(connectTimeout);
            conn.setReadTimeout(readTimeout);
            rsp = WebUtils.getResponseAsString(conn);
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
        return rsp;
    }

    private static HttpURLConnection getConnectionprotocol(URL url, String method, String ctype, String user_agent, String authorization, String protocol) throws IOException {
        HttpURLConnection conn = null;
        if ("https".equals(url.getProtocol())) {
            SSLContext ctx = null;
            try {
                if (StringUtils.isBlank(protocol)) {
                    protocol = "TLS";
                }
                ctx = SSLContext.getInstance(protocol);
                ctx.init(new KeyManager[0], new TrustManager[]{new DefaultTrustManager()}, new SecureRandom());
            }
            catch (Exception e) {
                throw new IOException(e);
            }
            HttpsURLConnection connHttps = (HttpsURLConnection)url.openConnection();
            connHttps.setSSLSocketFactory(ctx.getSocketFactory());
            connHttps.setHostnameVerifier(new HostnameVerifier(){

                @Override
                public boolean verify(String hostname, SSLSession session) {
                    return true;
                }
            });
            conn = connHttps;
        } else {
            conn = (HttpURLConnection)url.openConnection();
        }
        conn.setRequestMethod(method);
        conn.setDoInput(true);
        conn.setDoOutput(true);
        if (StringUtils.isNotBlank(authorization)) {
            conn.setRequestProperty("Authorization", "Basic " + authorization);
        }
        conn.setRequestProperty("Accept", "text/xml,text/javascript,text/html,application/json");
        if (StringUtils.isBlank(user_agent)) {
            user_agent = "aop-sdk-java";
        }
        conn.setRequestProperty("User-Agent", user_agent);
        conn.setRequestProperty("Content-Type", ctype);
        return conn;
    }

    private static HttpURLConnection getConnection(URL url, String method, String accept, String ctype, String user_agent, String authorization) throws IOException {
        HttpURLConnection conn = null;
        if ("https".equals(url.getProtocol())) {
            SSLContext ctx = null;
            try {
                ctx = SSLContext.getInstance("TLS");
                ctx.init(new KeyManager[0], new TrustManager[]{new DefaultTrustManager()}, new SecureRandom());
            }
            catch (Exception e) {
                throw new IOException(e);
            }
            HttpsURLConnection connHttps = (HttpsURLConnection)url.openConnection();
            connHttps.setSSLSocketFactory(ctx.getSocketFactory());
            connHttps.setHostnameVerifier(new HostnameVerifier(){

                @Override
                public boolean verify(String hostname, SSLSession session) {
                    return false;
                }
            });
            conn = connHttps;
        } else {
            conn = (HttpURLConnection)url.openConnection();
        }
        conn.setRequestMethod(method);
        conn.setDoInput(true);
        conn.setDoOutput(true);
        if (StringUtils.isNotBlank(authorization)) {
            conn.setRequestProperty("Authorization", "Basic " + authorization);
        }
        conn.setRequestProperty("Accept", accept);
        if (StringUtils.isBlank(user_agent)) {
            user_agent = "aop-sdk-java";
        }
        conn.setRequestProperty("User-Agent", user_agent);
        conn.setRequestProperty("Content-Type", ctype);
        return conn;
    }

    private static URL buildGetUrl(String strUrl, String query) throws IOException {
        URL url = new URL(strUrl);
        if (StringUtils.isEmpty(query)) {
            return url;
        }
        strUrl = StringUtils.isEmpty(url.getQuery()) ? (strUrl.endsWith("?") ? strUrl + query : strUrl + "?" + query) : (strUrl.endsWith("&") ? strUrl + query : strUrl + "&" + query);
        return new URL(strUrl);
    }

    public static String buildQuery(Map<String, String> params, String charset) throws IOException {
        if (params == null || params.isEmpty()) {
            return null;
        }
        StringBuilder query = new StringBuilder();
        Set<Map.Entry<String, String>> entries = params.entrySet();
        boolean hasParam = false;
        for (Map.Entry<String, String> entry : entries) {
            String value;
            String name = entry.getKey();
            if (!StringUtils.areNotEmpty(name, value = entry.getValue())) continue;
            if (hasParam) {
                query.append("&");
            } else {
                hasParam = true;
            }
            query.append(name).append("=").append(URLEncoder.encode(value, charset));
        }
        return query.toString();
    }

    protected static String getResponseAsString(HttpURLConnection conn) throws IOException {
        String charset = WebUtils.getResponseCharset(conn.getContentType());
        InputStream es = conn.getErrorStream();
        if (es == null) {
            return WebUtils.getStreamAsString(conn.getInputStream(), charset);
        }
        String msg = WebUtils.getStreamAsString(es, charset);
        if (StringUtils.isEmpty(msg)) {
            throw new IOException(conn.getResponseCode() + ":" + conn.getResponseMessage());
        }
        throw new IOException(msg);
    }

    protected static byte[] getResponseAsStringReByte(HttpURLConnection conn) throws IOException {
        InputStream es = conn.getErrorStream();
        if (es == null) {
            es = conn.getInputStream();
        }
        byte[] buffer = new byte[es.read()];
        int numRead = 0;
        for (int offset = 0; offset < buffer.length && (numRead = es.read(buffer, offset, buffer.length - offset)) >= 0; offset += numRead) {
        }
        return buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getStreamAsString(InputStream stream, String charset) throws IOException {
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream, charset));
            StringWriter writer = new StringWriter();
            char[] chars = new char[256];
            int count = 0;
            while ((count = reader.read(chars)) > 0) {
                writer.write(chars, 0, count);
            }
            String string = writer.toString();
            return string;
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
    }

    private static String getResponseCharset(String ctype) {
        String charset = DEFAULT_CHARSET;
        if (!StringUtils.isEmpty(ctype)) {
            String[] params;
            for (String param : params = ctype.split(";")) {
                if (!(param = param.trim()).startsWith("charset")) continue;
                String[] pair = param.split("=", 2);
                if (pair.length != 2 || StringUtils.isEmpty(pair[1])) break;
                charset = pair[1].trim();
                break;
            }
        }
        return charset;
    }

    public static String decode(String value) {
        return WebUtils.decode(value, DEFAULT_CHARSET);
    }

    public static String encode(String value) {
        return WebUtils.encode(value, DEFAULT_CHARSET);
    }

    public static String decode(String value, String charset) {
        String result = null;
        if (!StringUtils.isEmpty(value)) {
            try {
                result = URLDecoder.decode(value, charset);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return result;
    }

    public static String encode(String value, String charset) {
        String result = null;
        if (!StringUtils.isEmpty(value)) {
            try {
                result = URLEncoder.encode(value, charset);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return result;
    }

    public static Map<String, String> getParamsFromUrl(String url) {
        Map<Object, Object> map = null;
        if (url != null && url.indexOf(63) != -1) {
            map = WebUtils.splitUrlQuery(url.substring(url.indexOf(63) + 1));
        }
        if (map == null) {
            map = new HashMap();
        }
        return map;
    }

    public static Map<String, String> splitUrlQuery(String query) {
        HashMap<String, String> result = new HashMap<String, String>();
        String[] pairs = query.split("&");
        if (pairs != null && pairs.length > 0) {
            for (String pair : pairs) {
                String[] param = pair.split("=", 2);
                if (param == null || param.length != 2) continue;
                result.put(param[0], param[1]);
            }
        }
        return result;
    }

    private static class DefaultTrustManager
    implements X509TrustManager {
        private DefaultTrustManager() {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }
    }
}

