/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.transferaccounts.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import com.yqbsoft.laser.service.transferaccounts.PtradpdeEnum;
import com.yqbsoft.laser.service.transferaccounts.dao.TaTransferaListMapper;
import com.yqbsoft.laser.service.transferaccounts.dao.TaTransferaMapper;
import com.yqbsoft.laser.service.transferaccounts.domain.PtePtradeDomain;
import com.yqbsoft.laser.service.transferaccounts.domain.PtePtradeInfoDomain;
import com.yqbsoft.laser.service.transferaccounts.domain.PtePtradeParticipantDomain;
import com.yqbsoft.laser.service.transferaccounts.domain.PtradeBean;
import com.yqbsoft.laser.service.transferaccounts.domain.TaTransferaBean;
import com.yqbsoft.laser.service.transferaccounts.domain.TaTransferaDomain;
import com.yqbsoft.laser.service.transferaccounts.domain.TaTransferaListBean;
import com.yqbsoft.laser.service.transferaccounts.domain.TaTransferaListDomain;
import com.yqbsoft.laser.service.transferaccounts.domain.TaTransferaListReDomain;
import com.yqbsoft.laser.service.transferaccounts.domain.TaTransferaReDomain;
import com.yqbsoft.laser.service.transferaccounts.domain.UmUserDomainBean;
import com.yqbsoft.laser.service.transferaccounts.domain.UmUserinfoDomainBean;
import com.yqbsoft.laser.service.transferaccounts.domain.VdFaccountInfo;
import com.yqbsoft.laser.service.transferaccounts.model.TaTransfera;
import com.yqbsoft.laser.service.transferaccounts.model.TaTransferaList;
import com.yqbsoft.laser.service.transferaccounts.service.TaTransferaService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TaTransferaServiceImpl
extends BaseServiceImpl
implements TaTransferaService {
    private static final String SYS_CODE = "ta.TaTransferaServiceImpl";
    private TaTransferaMapper taTransferaMapper;
    private TaTransferaListMapper taTransferaListMapper;

    public void setTaTransferaMapper(TaTransferaMapper taTransferaMapper) {
        this.taTransferaMapper = taTransferaMapper;
    }

    public void setTaTransferaListMapper(TaTransferaListMapper taTransferaListMapper) {
        this.taTransferaListMapper = taTransferaListMapper;
    }

    private Date getSysDate() {
        try {
            return this.taTransferaMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("ta.TaTransferaServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkTransfera(TaTransferaDomain taTransferaDomain) {
        if (null == taTransferaDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)taTransferaDomain.getFaccountId())) {
            msg = msg + "FaccountId\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)taTransferaDomain.getFchannelPmodeCode())) {
            msg = msg + "FchannelPmodeCode\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)taTransferaDomain.getFundType())) {
            msg = msg + "FundType\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)taTransferaDomain.getUserinfoCode())) {
            msg = msg + "UserinfoCode\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)taTransferaDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        if (null == taTransferaDomain.getTransferaMoney() || BigDecimal.ZERO.compareTo(taTransferaDomain.getTransferaMoney()) == 0) {
            msg = msg + "TransferaMoney\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setTransferaDefault(TaTransfera taTransfera) {
        if (null == taTransfera) {
            return;
        }
        if (null == taTransfera.getDataState()) {
            taTransfera.setDataState(0);
        }
        if (null == taTransfera.getGmtCreate()) {
            taTransfera.setGmtCreate(this.getSysDate());
        }
        taTransfera.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)taTransfera.getTransferaCode())) {
            taTransfera.setTransferaCode(this.createUUIDString());
        }
    }

    private int getTransferaMaxCode() {
        int code = 0;
        try {
            return this.taTransferaMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("ta.TaTransferaServiceImpl.getTransferaMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setTransferaUpdataDefault(TaTransfera taTransfera) {
        if (null == taTransfera) {
            return;
        }
        taTransfera.setGmtModified(this.getSysDate());
    }

    private void saveTransferaModel(TaTransfera taTransfera) throws ApiException {
        if (null == taTransfera) {
            return;
        }
        try {
            this.taTransferaMapper.insert(taTransfera);
        }
        catch (Exception e) {
            throw new ApiException("ta.TaTransferaServiceImpl.saveTransferaModel.ex", (Throwable)e);
        }
    }

    private void saveTransferaBatchModel(List<TaTransfera> taTransferaList) throws ApiException {
        if (null == taTransferaList || taTransferaList.isEmpty()) {
            return;
        }
        try {
            this.taTransferaMapper.insertBatch(taTransferaList);
        }
        catch (Exception e) {
            throw new ApiException("ta.TaTransferaServiceImpl.saveTransferaBatchModel.ex", (Throwable)e);
        }
    }

    private TaTransfera getTransferaModelById(Integer transferaId) {
        if (null == transferaId) {
            return null;
        }
        try {
            return this.taTransferaMapper.selectByPrimaryKey(transferaId);
        }
        catch (Exception e) {
            this.logger.error("ta.TaTransferaServiceImpl.getTransferaModelById", (Throwable)e);
            return null;
        }
    }

    private TaTransfera getTransferaModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.taTransferaMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("ta.TaTransferaServiceImpl.getTransferaModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delTransferaModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.taTransferaMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("ta.TaTransferaServiceImpl.delTransferaModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("ta.TaTransferaServiceImpl.delTransferaModelByCode.num");
        }
    }

    private void deleteTransferaModel(Integer transferaId) throws ApiException {
        if (null == transferaId) {
            return;
        }
        int i = 0;
        try {
            i = this.taTransferaMapper.deleteByPrimaryKey(transferaId);
        }
        catch (Exception e) {
            throw new ApiException("ta.TaTransferaServiceImpl.deleteTransferaModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("ta.TaTransferaServiceImpl.deleteTransferaModel.num");
        }
    }

    private void updateTransferaModel(TaTransfera taTransfera) throws ApiException {
        if (null == taTransfera) {
            return;
        }
        int i = 0;
        try {
            i = this.taTransferaMapper.updateByPrimaryKeySelective(taTransfera);
        }
        catch (Exception e) {
            throw new ApiException("ta.TaTransferaServiceImpl.updateTransferaModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("ta.TaTransferaServiceImpl.updateTransferaModel.num");
        }
    }

    private void updateStateTransferaModel(Integer transferaId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == transferaId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("transferaId", transferaId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.taTransferaMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("ta.TaTransferaServiceImpl.updateStateTransferaModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("ta.TaTransferaServiceImpl.updateStateTransferaModel.null");
        }
    }

    private void updateStateTransferaModelByCode(String tenantCode, String transferaCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)transferaCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("transferaCode", transferaCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.taTransferaMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("ta.TaTransferaServiceImpl.updateStateTransferaModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("ta.TaTransferaServiceImpl.updateStateTransferaModelByCode.null");
        }
    }

    private void updateStateTransferaListModelByTransfreaCode(String tenantCode, String transferaCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)transferaCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("transferaCode", transferaCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        try {
            this.taTransferaListMapper.updateStateByTransfreaCode(map);
        }
        catch (Exception e) {
            throw new ApiException("ta.TaTransferaServiceImpl.updateStateTransferaListModelByTransfreaCode.ex", (Throwable)e);
        }
    }

    private TaTransfera makeTransfera(TaTransferaDomain taTransferaDomain, TaTransfera taTransfera) {
        if (null == taTransferaDomain) {
            return null;
        }
        if (null == taTransfera) {
            taTransfera = new TaTransfera();
        }
        try {
            BeanUtils.copyAllPropertys((Object)taTransfera, (Object)taTransferaDomain);
            return taTransfera;
        }
        catch (Exception e) {
            this.logger.error("ta.TaTransferaServiceImpl.makeTransfera", (Throwable)e);
            return null;
        }
    }

    private TaTransferaReDomain makeTaTransferaReDomain(TaTransfera taTransfera) {
        if (null == taTransfera) {
            return null;
        }
        TaTransferaReDomain taTransferaReDomain = new TaTransferaReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)taTransferaReDomain, (Object)taTransfera);
            return taTransferaReDomain;
        }
        catch (Exception e) {
            this.logger.error("ta.TaTransferaServiceImpl.makeTaTransferaReDomain", (Throwable)e);
            return null;
        }
    }

    private List<TaTransfera> queryTransferaModelPage(Map<String, Object> parammap) {
        try {
            return this.taTransferaMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("ta.TaTransferaServiceImpl.queryTransferaModel", (Throwable)e);
            return null;
        }
    }

    private int countTransfera(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.taTransferaMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("ta.TaTransferaServiceImpl.countTransfera", (Throwable)e);
        }
        return i;
    }

    private TaTransfera createTaTransfera(TaTransferaDomain taTransferaDomain) {
        String msg = this.checkTransfera(taTransferaDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("ta.TaTransferaServiceImpl.saveTransfera.checkTransfera", msg);
        }
        TaTransfera taTransfera = this.makeTransfera(taTransferaDomain, null);
        this.setTransferaDefault(taTransfera);
        return taTransfera;
    }

    private String checkTransferaList(TaTransferaListDomain taTransferaListDomain) {
        if (null == taTransferaListDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)taTransferaListDomain.getTransferaListUcode())) {
            msg = msg + "TransferaListUcode\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)taTransferaListDomain.getTransferaListUno())) {
            msg = msg + "TransferaListUno\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)taTransferaListDomain.getTransferaListFtype())) {
            msg = msg + "TransferaListFtype\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)taTransferaListDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setTransferaListDefault(TaTransferaList taTransferaList) {
        if (null == taTransferaList) {
            return;
        }
        if (null == taTransferaList.getDataState()) {
            taTransferaList.setDataState(0);
        }
        if (null == taTransferaList.getGmtCreate()) {
            taTransferaList.setGmtCreate(this.getSysDate());
        }
        taTransferaList.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)taTransferaList.getTransferaListCode())) {
            taTransferaList.setTransferaListCode(this.createUUIDString());
        }
    }

    private int getTransferaListMaxCode() {
        int code = 0;
        try {
            return this.taTransferaListMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("ta.TaTransferaServiceImpl.getTransferaListMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setTransferaListUpdataDefault(TaTransferaList taTransferaList) {
        if (null == taTransferaList) {
            return;
        }
        taTransferaList.setGmtModified(this.getSysDate());
    }

    private void saveTransferaListModel(TaTransferaList taTransferaList) throws ApiException {
        if (null == taTransferaList) {
            return;
        }
        try {
            this.taTransferaListMapper.insert(taTransferaList);
        }
        catch (Exception e) {
            throw new ApiException("ta.TaTransferaServiceImpl.saveTransferaListModel.ex", (Throwable)e);
        }
    }

    private void saveTransferaListBatchModel(List<TaTransferaList> taTransferaListList) throws ApiException {
        if (null == taTransferaListList || taTransferaListList.isEmpty()) {
            return;
        }
        try {
            this.taTransferaListMapper.insertBatch(taTransferaListList);
        }
        catch (Exception e) {
            throw new ApiException("ta.TaTransferaServiceImpl.saveTransferaListBatchModel.ex", (Throwable)e);
        }
    }

    private TaTransferaList getTransferaListModelById(Integer transferaListId) {
        if (null == transferaListId) {
            return null;
        }
        try {
            return this.taTransferaListMapper.selectByPrimaryKey(transferaListId);
        }
        catch (Exception e) {
            this.logger.error("ta.TaTransferaServiceImpl.getTransferaListModelById", (Throwable)e);
            return null;
        }
    }

    private TaTransferaList getTransferaListModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.taTransferaListMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("ta.TaTransferaServiceImpl.getTransferaListModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delTransferaListModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.taTransferaListMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("ta.TaTransferaServiceImpl.delTransferaListModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("ta.TaTransferaServiceImpl.delTransferaListModelByCode.num");
        }
    }

    private void delTransferaListModelByTransferaCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        try {
            this.taTransferaListMapper.delByTransferaCode(map);
        }
        catch (Exception e) {
            throw new ApiException("ta.TaTransferaServiceImpl.delTransferaListModelByTransferaCode.ex", (Throwable)e);
        }
    }

    private void deleteTransferaListModel(Integer transferaListId) throws ApiException {
        if (null == transferaListId) {
            return;
        }
        int i = 0;
        try {
            i = this.taTransferaListMapper.deleteByPrimaryKey(transferaListId);
        }
        catch (Exception e) {
            throw new ApiException("ta.TaTransferaServiceImpl.deleteTransferaListModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("ta.TaTransferaServiceImpl.deleteTransferaListModel.num");
        }
    }

    private void updateTransferaListModel(TaTransferaList taTransferaList) throws ApiException {
        if (null == taTransferaList) {
            return;
        }
        int i = 0;
        try {
            i = this.taTransferaListMapper.updateByPrimaryKeySelective(taTransferaList);
        }
        catch (Exception e) {
            throw new ApiException("ta.TaTransferaServiceImpl.updateTransferaListModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("ta.TaTransferaServiceImpl.updateTransferaListModel.num");
        }
    }

    private void updateStateTransferaListModel(Integer transferaListId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == transferaListId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("transferaListId", transferaListId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.taTransferaListMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("ta.TaTransferaServiceImpl.updateStateTransferaListModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("ta.TaTransferaServiceImpl.updateStateTransferaListModel.null");
        }
    }

    private void updateStateTransferaListModelByCode(String tenantCode, String transferaListCode, Integer dataState, Integer oldDataState) throws ApiException {
        if (StringUtils.isBlank((String)transferaListCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("transferaListCode", transferaListCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.taTransferaListMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("ta.TaTransferaServiceImpl.updateStateTransferaListModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("ta.TaTransferaServiceImpl.updateStateTransferaListModelByCode.null");
        }
    }

    private TaTransferaList makeTransferaList(TaTransferaListDomain taTransferaListDomain, TaTransferaList taTransferaList) {
        if (null == taTransferaListDomain) {
            return null;
        }
        if (null == taTransferaList) {
            taTransferaList = new TaTransferaList();
        }
        try {
            BeanUtils.copyAllPropertys((Object)taTransferaList, (Object)taTransferaListDomain);
            return taTransferaList;
        }
        catch (Exception e) {
            this.logger.error("ta.TaTransferaServiceImpl.makeTransferaList", (Throwable)e);
            return null;
        }
    }

    private TaTransferaListReDomain makeTaTransferaListReDomain(TaTransferaList taTransferaList) {
        if (null == taTransferaList) {
            return null;
        }
        TaTransferaListReDomain taTransferaListReDomain = new TaTransferaListReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)taTransferaListReDomain, (Object)taTransferaList);
            return taTransferaListReDomain;
        }
        catch (Exception e) {
            this.logger.error("ta.TaTransferaServiceImpl.makeTaTransferaListReDomain", (Throwable)e);
            return null;
        }
    }

    private List<TaTransferaList> queryTransferaListModelPage(Map<String, Object> parammap) {
        try {
            return this.taTransferaListMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("ta.TaTransferaServiceImpl.queryTransferaListModel", (Throwable)e);
            return null;
        }
    }

    private int countTransferaList(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.taTransferaListMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("ta.TaTransferaServiceImpl.countTransferaList", (Throwable)e);
        }
        return i;
    }

    private TaTransferaList createTaTransferaList(TaTransferaListDomain taTransferaListDomain) {
        String msg = this.checkTransferaList(taTransferaListDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("ta.TaTransferaServiceImpl.saveTransferaList.checkTransferaList", msg);
        }
        TaTransferaList taTransferaList = this.makeTransferaList(taTransferaListDomain, null);
        this.setTransferaListDefault(taTransferaList);
        return taTransferaList;
    }

    @Override
    public String saveTransfera(TaTransferaDomain taTransferaDomain) throws ApiException {
        TaTransfera taTransfera = this.createTaTransfera(taTransferaDomain);
        this.saveTransferaModel(taTransfera);
        if (ListUtil.isNotEmpty(taTransferaDomain.getTaTransferaListDomainList())) {
            for (TaTransferaListDomain taTransferaListDomain : taTransferaDomain.getTaTransferaListDomainList()) {
                try {
                    BeanUtils.copyAllPropertys((Object)taTransferaListDomain, (Object)taTransfera);
                }
                catch (Exception e) {
                    throw new ApiException("ta.TaTransferaServiceImpl.saveTransfera.list");
                }
            }
            this.saveTransferaListBatch(taTransferaDomain.getTaTransferaListDomainList());
        }
        return taTransfera.getTransferaCode();
    }

    @Override
    public String saveTransferaOne(TaTransferaDomain taTransferaDomain) throws ApiException {
        String transferaCode = this.saveTransfera(taTransferaDomain);
        if (StringUtils.isBlank((String)transferaCode)) {
            throw new ApiException("ta.TaTransferaServiceImpl.saveTransferaOne.blank");
        }
        this.updateTransferaStateByCode(taTransferaDomain.getTenantCode(), transferaCode, 3, 0, null);
        return transferaCode;
    }

    private UmUserinfoDomainBean getUmUserinfoDomainBean(String userinfoCode, String tenantCode) {
        HashMap<String, String> pmap = new HashMap<String, String>();
        pmap.put("userinfoCode", userinfoCode);
        pmap.put("tenantCode", tenantCode);
        UmUserinfoDomainBean umUserinfoDomainBean = (UmUserinfoDomainBean)this.getForObject("um.user.getUserinfoByCode", UmUserinfoDomainBean.class, pmap);
        return umUserinfoDomainBean;
    }

    private VdFaccountInfo getOuterFaccount(String merchantCode, String faccountType, String tenantCode) {
        HashMap<String, String> pmap = new HashMap<String, String>();
        pmap.put("merchantCode", merchantCode);
        pmap.put("faccountType", faccountType);
        pmap.put("tenantCode", tenantCode);
        List list = (List)this.readObj("vd.faccount.queryOuterFaccount", pmap, "list", new Object[]{VdFaccountInfo.class});
        if (ListUtil.isEmpty((Collection)list)) {
            return null;
        }
        return (VdFaccountInfo)list.get(0);
    }

    private UmUserDomainBean getUmUserDomainBean(String phone, String tenantCode) {
        HashMap<String, String> pmap = new HashMap<String, String>();
        pmap.put("userPhone", phone);
        pmap.put("tenantCode", tenantCode);
        QueryResult qresult = this.sendReSupObject("um.user.queryUserPage", pmap, UmUserDomainBean.class);
        if (null == qresult || null == qresult.getList() || qresult.getList().isEmpty()) {
            return null;
        }
        return (UmUserDomainBean)qresult.getList().get(0);
    }

    private String check(TaTransferaBean taTransferaBean) {
        if (null == taTransferaBean) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)taTransferaBean.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)taTransferaBean.getUserinfoCode())) {
            msg = msg + "UserinfoCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    @Override
    public String saveTransferaBeanOne(TaTransferaBean taTransferaBean) throws ApiException {
        String msg = this.check(taTransferaBean);
        if (StringUtils.isNotBlank((String)msg)) {
            return msg;
        }
        TaTransferaDomain taTransferaDomain = new TaTransferaDomain();
        try {
            BeanUtils.copyAllPropertys((Object)taTransferaDomain, (Object)taTransferaBean);
        }
        catch (Exception e) {
            // empty catch block
        }
        String type = taTransferaBean.getUserinfoCode().substring(0, 1);
        String fundType = taTransferaBean.getFundType();
        if (StringUtils.isBlank((String)fundType)) {
            fundType = "01";
        }
        String faccountType = "1" + fundType;
        if ("2".equals(type)) {
            faccountType = "2" + fundType;
        }
        taTransferaDomain.setUserinfoCode(taTransferaBean.getUserinfoCode());
        UmUserinfoDomainBean umUserinfoDomainBean = this.getUmUserinfoDomainBean(taTransferaBean.getUserinfoCode(), taTransferaBean.getTenantCode());
        if (null == umUserinfoDomainBean) {
            return "\u7528\u6237\u4e0d\u5b58\u5728";
        }
        taTransferaDomain.setUserinfoName(umUserinfoDomainBean.getUserinfoCompname());
        VdFaccountInfo vdFaccountInfo = this.getOuterFaccount(taTransferaBean.getUserinfoCode(), faccountType, taTransferaBean.getTenantCode());
        if (null == vdFaccountInfo) {
            return "\u7528\u6237\u8d26\u6237\u4e3a\u7a7a";
        }
        taTransferaDomain.setTransferaCategory(type);
        taTransferaDomain.setFaccountId(vdFaccountInfo.getFaccountOuterNo());
        if (null == vdFaccountInfo.getFaccountAmount()) {
            vdFaccountInfo.setFaccountAmount(BigDecimal.ZERO);
        }
        if (null == taTransferaDomain.getTransferaMoney()) {
            taTransferaDomain.setTransferaMoney(BigDecimal.ZERO);
        }
        if (vdFaccountInfo.getFaccountAmount().compareTo(taTransferaDomain.getTransferaMoney()) == -1) {
            return "\u4f59\u989d\u4e0d\u8db3";
        }
        taTransferaDomain.setTransferaCategory(taTransferaDomain.getUserinfoCode().substring(0, 1));
        if (StringUtils.isBlank((String)taTransferaDomain.getTransferaType())) {
            taTransferaDomain.setTransferaType("09");
        }
        if (StringUtils.isBlank((String)taTransferaDomain.getTransferaMode())) {
            // empty if block
        }
        taTransferaDomain.setTransferaMode("1");
        taTransferaDomain.setFchannelPmodeCode("wep");
        taTransferaDomain.setFundType(fundType);
        List<TaTransferaListBean> taTransferaListBeanList = taTransferaBean.getTaTransferaListBeanList();
        if (ListUtil.isEmpty(taTransferaListBeanList)) {
            return "\u8f6c\u5165\u6d41\u6c34\u4e3a\u7a7a";
        }
        ArrayList<TaTransferaListDomain> taTransferaListDomainList = new ArrayList<TaTransferaListDomain>();
        for (TaTransferaListBean taTransferaListBean : taTransferaListBeanList) {
            TaTransferaListDomain taTransferaListDomain = new TaTransferaListDomain();
            try {
                BeanUtils.copyAllPropertys((Object)taTransferaListDomain, (Object)taTransferaListBean);
            }
            catch (Exception e) {
                // empty catch block
            }
            taTransferaListDomainList.add(taTransferaListDomain);
            String phone = taTransferaListBean.getPhone();
            String userinfoCode = taTransferaListDomain.getTransferaListUcode();
            if (StringUtils.isNotBlank((String)phone) && StringUtils.isBlank((String)userinfoCode)) {
                UmUserDomainBean umUserDomainBean = this.getUmUserDomainBean(phone, taTransferaDomain.getTenantCode());
                if (null == umUserDomainBean) {
                    return "\u7528\u6237\u4fe1\u606f" + phone + "\u4e3a\u7a7a";
                }
                userinfoCode = umUserDomainBean.getUserPcode();
                taTransferaListDomain.setTransferaListUname(umUserDomainBean.getUserName());
            } else {
                UmUserinfoDomainBean userinfoDomainBean = this.getUmUserinfoDomainBean(userinfoCode, taTransferaDomain.getTenantCode());
                if (null == userinfoDomainBean) {
                    return "\u7528\u6237\u4fe1\u606f" + phone + "\u4e3a\u7a7a";
                }
                taTransferaListDomain.setTransferaListUname(userinfoDomainBean.getUserinfoCompname());
            }
            type = userinfoCode.substring(0, 1);
            faccountType = "1" + fundType;
            if ("2".equals(type)) {
                faccountType = "2" + fundType;
            }
            taTransferaListDomain.setTransferaListUcode(userinfoCode);
            vdFaccountInfo = this.getOuterFaccount(taTransferaBean.getUserinfoCode(), faccountType, taTransferaBean.getTenantCode());
            if (null == vdFaccountInfo) {
                return "\u8f6c\u5165\u7528\u6237" + phone + "\u8d26\u6237\u4e3a\u7a7a";
            }
            taTransferaListDomain.setTransferaListCategory(type);
            taTransferaListDomain.setTransferaListUno(vdFaccountInfo.getFaccountOuterNo());
            taTransferaListDomain.setTransferaListFtype(vdFaccountInfo.getFundType());
        }
        taTransferaDomain.setTaTransferaListDomainList(taTransferaListDomainList);
        this.saveTransferaOne(taTransferaDomain);
        return "success";
    }

    @Override
    public String saveTransferaBatch(List<TaTransferaDomain> taTransferaDomainList) throws ApiException {
        if (null == taTransferaDomainList || taTransferaDomainList.isEmpty()) {
            return null;
        }
        ArrayList<TaTransfera> taTransferaList = new ArrayList<TaTransfera>();
        String code = "";
        for (TaTransferaDomain taTransferaDomain : taTransferaDomainList) {
            TaTransfera taTransfera = this.createTaTransfera(taTransferaDomain);
            code = taTransfera.getTransferaCode();
            taTransferaList.add(taTransfera);
        }
        this.saveTransferaBatchModel(taTransferaList);
        return code;
    }

    @Override
    public TaTransferaReDomain getTransferaReDomain(Integer transferaId) {
        TaTransfera taTransfera = this.getTransfera(transferaId);
        if (null == taTransfera) {
            return null;
        }
        TaTransferaReDomain taTransferaReDomain = this.makeRedomain(taTransfera);
        if (null == taTransferaReDomain) {
            return null;
        }
        this.makeRedomainList(taTransferaReDomain);
        return taTransferaReDomain;
    }

    private void makeRedomainList(TaTransferaReDomain taTransferaReDomain) {
        if (null == taTransferaReDomain) {
            return;
        }
        HashMap<String, Object> parammap = new HashMap<String, Object>();
        parammap.put("tenantCode", taTransferaReDomain.getTenantCode());
        parammap.put("transferaCode", taTransferaReDomain.getTransferaCode());
        List<TaTransferaList> taTransferaListList = this.queryTransferaListModelPage(parammap);
        if (ListUtil.isEmpty(taTransferaListList)) {
            return;
        }
        ArrayList<TaTransferaListDomain> list = new ArrayList<TaTransferaListDomain>();
        for (TaTransferaList taTransferaList : taTransferaListList) {
            TaTransferaListDomain taTransferaListDomain = this.makeListdomain(taTransferaList);
            if (null == taTransferaListDomain) continue;
            list.add(taTransferaListDomain);
        }
        taTransferaReDomain.setTaTransferaListDomainList(list);
    }

    private TaTransferaListDomain makeListdomain(TaTransferaList taTransferaList) {
        if (null == taTransferaList) {
            return null;
        }
        TaTransferaListDomain taTransferaListDomain = new TaTransferaListDomain();
        try {
            BeanUtils.copyAllPropertys((Object)taTransferaListDomain, (Object)taTransferaList);
            return taTransferaListDomain;
        }
        catch (Exception e) {
            return null;
        }
    }

    private TaTransferaReDomain makeRedomain(TaTransfera taTransfera) {
        if (null == taTransfera) {
            return null;
        }
        TaTransferaReDomain taTransferaReDomain = new TaTransferaReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)taTransferaReDomain, (Object)taTransfera);
            return taTransferaReDomain;
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public TaTransferaReDomain getTransferaReDomainByCode(String tenantCode, String transferaCode) throws ApiException {
        TaTransfera taTransfera = this.getTransferaByCode(tenantCode, transferaCode);
        if (null == taTransfera) {
            return null;
        }
        TaTransferaReDomain taTransferaReDomain = this.makeRedomain(taTransfera);
        if (null == taTransferaReDomain) {
            return null;
        }
        this.makeRedomainList(taTransferaReDomain);
        return null;
    }

    @Override
    public void updateTransferaState(Integer transferaId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        this.updateStateTransferaModel(transferaId, dataState, oldDataState, map);
        TaTransfera taTransfera = this.getTransferaModelById(transferaId);
        this.updateStateTransferaListModelByTransfreaCode(taTransfera.getTenantCode(), taTransfera.getTransferaCode(), dataState, oldDataState, map);
        if (3 == dataState) {
            HashMap<String, Object> parammap = new HashMap<String, Object>();
            parammap.put("tenantCode", taTransfera.getTenantCode());
            parammap.put("transferaCode", taTransfera.getTransferaCode());
            List<TaTransferaList> taTransferaListList = this.queryTransferaListModelPage(parammap);
            this.sendPay(taTransfera, taTransferaListList);
        }
    }

    @Override
    public void updateTransferaStateByCode(String tenantCode, String transferaCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        this.updateStateTransferaModelByCode(tenantCode, transferaCode, dataState, oldDataState, map);
        this.updateStateTransferaListModelByTransfreaCode(tenantCode, transferaCode, dataState, oldDataState, map);
        if (3 == dataState) {
            TaTransfera taTransfera = this.getTransferaByCode(tenantCode, transferaCode);
            HashMap<String, Object> parammap = new HashMap<String, Object>();
            parammap.put("tenantCode", tenantCode);
            parammap.put("transferaCode", transferaCode);
            List<TaTransferaList> taTransferaListList = this.queryTransferaListModelPage(parammap);
            this.sendPay(taTransfera, taTransferaListList);
        }
    }

    private PtePtradeInfoDomain makePtePtradeInfoDomain(TaTransferaList taTransferaList, String fchannelPmodeCode, TaTransfera taTransfera) {
        if (null == taTransferaList || StringUtils.isBlank((String)fchannelPmodeCode) || null == taTransfera) {
            return null;
        }
        PtePtradeInfoDomain ptePtradeInfoDomain = new PtePtradeInfoDomain();
        ptePtradeInfoDomain.setOrderOamount(taTransferaList.getTransferaListMoney());
        ptePtradeInfoDomain.setOrderAmount(taTransferaList.getTransferaListMoney());
        ptePtradeInfoDomain.setPartnerCode(taTransferaList.getUserinfoCode());
        ptePtradeInfoDomain.setBusinessOrderno(taTransferaList.getTransferaCode());
        ptePtradeInfoDomain.setBusinessOrder(taTransferaList.getTransferaCode());
        ptePtradeInfoDomain.setPaymentMemo(taTransfera.getUserinfoName() + " " + taTransfera.getTransferaName());
        ptePtradeInfoDomain.setOpuserCode(taTransferaList.getUserinfoCode());
        ptePtradeInfoDomain.setOpuserName(taTransferaList.getUserinfoName());
        ptePtradeInfoDomain.setTenantCode(taTransferaList.getTenantCode());
        ptePtradeInfoDomain.setMerchantCode(taTransferaList.getTransferaListUcode());
        ptePtradeInfoDomain.setFchannelPmodeCode(fchannelPmodeCode);
        return ptePtradeInfoDomain;
    }

    private PtradeBean makeParticipant(TaTransfera taTransfera) {
        if (null == taTransfera) {
            return null;
        }
        PtradeBean pb = new PtradeBean();
        pb.setTenantCode(taTransfera.getTenantCode());
        pb.setFchannelPmodeCode(taTransfera.getFchannelPmodeCode());
        pb.setFchannelMode("0");
        ArrayList<PtePtradeParticipantDomain> partList = new ArrayList<PtePtradeParticipantDomain>();
        String code = taTransfera.getUserinfoCode().substring(0, 1);
        PtePtradeParticipantDomain pd1 = new PtePtradeParticipantDomain();
        pd1.setDicActorCode("BUY_B");
        pd1.setFaccountId(taTransfera.getFaccountId());
        pd1.setFchannelCode("0" + code);
        pd1.setFchannelClassifyCode(code + "01");
        pd1.setOrderAmount(taTransfera.getTransferaMoney());
        partList.add(pd1);
        pb.setPartList(partList);
        return pb;
    }

    private void sendPay(TaTransfera taTransfera, List<TaTransferaList> taTransferaListList) {
        if (null == taTransfera || ListUtil.isEmpty(taTransferaListList)) {
            return;
        }
        BigDecimal orderAmount = BigDecimal.ZERO;
        BigDecimal orderOamount = BigDecimal.ZERO;
        ArrayList<PtePtradeInfoDomain> ptePtradeInfoDomainList = new ArrayList<PtePtradeInfoDomain>();
        for (TaTransferaList taTransferaList : taTransferaListList) {
            orderAmount = orderAmount.add(taTransferaList.getTransferaListMoney());
            orderOamount = orderOamount.add(taTransferaList.getTransferaListMoney());
            ptePtradeInfoDomainList.add(this.makePtePtradeInfoDomain(taTransferaList, taTransfera.getFchannelPmodeCode(), taTransfera));
        }
        PtePtradeDomain ptePtradeDomain = new PtePtradeDomain();
        ptePtradeDomain.setPtePtradeInfoDomainList(ptePtradeInfoDomainList);
        ptePtradeDomain.setOrderOamount(orderOamount);
        ptePtradeDomain.setOrderAmount(orderAmount);
        ptePtradeDomain.setPtradeType(taTransfera.getTransferaType());
        ptePtradeDomain.setAcquireSeqno(taTransfera.getTransferaCode());
        ptePtradeDomain.setPartnerCode(taTransfera.getUserinfoCode());
        ptePtradeDomain.setBusinessOrderno(taTransfera.getTransferaCode());
        ptePtradeDomain.setBusinessOrder(taTransfera.getTransferaCode());
        ptePtradeDomain.setPaymentMemo(taTransfera.getUserinfoName() + " " + (null == taTransfera.getTransferaName() ? "" : taTransfera.getTransferaName()));
        ptePtradeDomain.setOpuserCode(taTransfera.getUserinfoCode());
        ptePtradeDomain.setOpuserName(taTransfera.getUserinfoName());
        ptePtradeDomain.setPtradpdeCode(PtradpdeEnum.TRANSFER.getCode());
        ptePtradeDomain.setTenantCode(taTransfera.getTenantCode());
        ptePtradeDomain.setMerchantCode(taTransferaListList.get(0).getTransferaListUcode());
        ptePtradeDomain.setFchannelPmodeCode(taTransfera.getFchannelPmodeCode());
        ptePtradeDomain.setPaymentNotifyurl("ta.taTransfera.updateTransferaToPteBack");
        PtradeBean ptradeBean = this.makeParticipant(taTransfera);
        ptePtradeDomain.setPtradeBean(ptradeBean);
        HashMap<String, String> queryMap = new HashMap<String, String>();
        queryMap.put("ptePtradeDomain", JsonUtil.buildNormalBinder().toJson((Object)ptePtradeDomain));
        String result = this.internalInvoke("pte.ptrade.sendSavePtrade", queryMap);
        if (StringUtils.isBlank((String)result)) {
            throw new ApiException("ta.TaTransferaServiceImpl.sendPay.send", "\u8c03\u7528\u4ea4\u6613\u5f15\u64ce\u5931\u8d25\uff01");
        }
    }

    @Override
    public void updateTransfera(TaTransferaDomain taTransferaDomain) throws ApiException {
        String msg = this.checkTransfera(taTransferaDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("ta.TaTransferaServiceImpl.updateTransfera.checkTransfera", msg);
        }
        TaTransfera oldTaTransfera = this.getTransferaModelById(taTransferaDomain.getTransferaId());
        if (null == oldTaTransfera) {
            throw new ApiException("ta.TaTransferaServiceImpl.updateTransfera.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        TaTransfera taTransfera = this.makeTransfera(taTransferaDomain, oldTaTransfera);
        this.setTransferaUpdataDefault(taTransfera);
        this.updateTransferaModel(taTransfera);
    }

    @Override
    public TaTransfera getTransfera(Integer transferaId) {
        return this.getTransferaModelById(transferaId);
    }

    @Override
    public void deleteTransfera(Integer transferaId) throws ApiException {
        TaTransfera taTransfera = this.getTransfera(transferaId);
        if (null == taTransfera) {
            throw new ApiException("ta.TaTransferaServiceImpl.deleteTransfera.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        this.deleteTransferaModel(transferaId);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", taTransfera.getTenantCode());
        map.put("transferaCode", taTransfera.getTransferaCode());
        this.delTransferaListModelByTransferaCode(map);
    }

    @Override
    public QueryResult<TaTransfera> queryTransferaPage(Map<String, Object> map) {
        List<TaTransfera> taTransferaList = this.queryTransferaModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countTransfera(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(taTransferaList);
        return queryResult;
    }

    @Override
    public TaTransfera getTransferaByCode(String tenantCode, String transferaCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("transferaCode", transferaCode);
        return this.getTransferaModelByCode(map);
    }

    @Override
    public void deleteTransferaByCode(String tenantCode, String transferaCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("transferaCode", transferaCode);
        this.delTransferaModelByCode(map);
        this.delTransferaListModelByTransferaCode(map);
    }

    @Override
    public String saveTransferaList(TaTransferaListDomain taTransferaListDomain) throws ApiException {
        TaTransferaList taTransferaList = this.createTaTransferaList(taTransferaListDomain);
        this.saveTransferaListModel(taTransferaList);
        return taTransferaList.getTransferaListCode();
    }

    @Override
    public String saveTransferaListBatch(List<TaTransferaListDomain> taTransferaListDomainList) throws ApiException {
        if (null == taTransferaListDomainList || taTransferaListDomainList.isEmpty()) {
            return null;
        }
        ArrayList<TaTransferaList> taTransferaListList = new ArrayList<TaTransferaList>();
        String code = "";
        for (TaTransferaListDomain taTransferaListDomain : taTransferaListDomainList) {
            TaTransferaList taTransferaList = this.createTaTransferaList(taTransferaListDomain);
            code = taTransferaList.getTransferaListCode();
            taTransferaListList.add(taTransferaList);
        }
        this.saveTransferaListBatchModel(taTransferaListList);
        return code;
    }

    @Override
    public void updateTransferaListState(Integer transferaListId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateTransferaListModel(transferaListId, dataState, oldDataState);
    }

    @Override
    public void updateTransferaListStateByCode(String tenantCode, String transferaListCode, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateTransferaListModelByCode(tenantCode, transferaListCode, dataState, oldDataState);
    }

    @Override
    public void updateTransferaList(TaTransferaListDomain taTransferaListDomain) throws ApiException {
        String msg = this.checkTransferaList(taTransferaListDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("ta.TaTransferaServiceImpl.updateTransferaList.checkTransferaList", msg);
        }
        TaTransferaList oldTaTransferaList = this.getTransferaListModelById(taTransferaListDomain.getTransferaListId());
        if (null == oldTaTransferaList) {
            throw new ApiException("ta.TaTransferaServiceImpl.updateTransferaList.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        TaTransferaList taTransferaList = this.makeTransferaList(taTransferaListDomain, oldTaTransferaList);
        this.setTransferaListUpdataDefault(taTransferaList);
        this.updateTransferaListModel(taTransferaList);
    }

    @Override
    public TaTransferaList getTransferaList(Integer transferaListId) {
        return this.getTransferaListModelById(transferaListId);
    }

    @Override
    public void deleteTransferaList(Integer transferaListId) throws ApiException {
        this.deleteTransferaListModel(transferaListId);
    }

    @Override
    public QueryResult<TaTransferaList> queryTransferaListPage(Map<String, Object> map) {
        List<TaTransferaList> taTransferaListList = this.queryTransferaListModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countTransferaList(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(taTransferaListList);
        return queryResult;
    }

    @Override
    public TaTransferaList getTransferaListByCode(String tenantCode, String transferaListCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("transferaListCode", transferaListCode);
        return this.getTransferaListModelByCode(map);
    }

    @Override
    public void deleteTransferaListByCode(String tenantCode, String transferaListCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("transferaListCode", transferaListCode);
        this.delTransferaListModelByCode(map);
    }

    @Override
    public boolean updateTransferaToPteBack(Map<String, Object> map) throws ApiException {
        if (map == null || map.isEmpty()) {
            this.logger.error("ta.TaTransferaServiceImpl.updateTransferaToPteBack.map", (Object)"\u53c2\u6570\u4e3a\u7a7a\uff01");
            return false;
        }
        String transferaCode = (String)map.get("businessOrderno");
        String tenantCode = (String)map.get("tenantCode");
        Integer dataState = (Integer)map.get("dataState");
        if (StringUtils.isBlank((String)transferaCode) || dataState == null) {
            throw new ApiException("ta.TaTransferaServiceImpl.updateTransferaToPteBack.null", "\u53c2\u6570\u4e3a\u7a7a\uff01" + map.toString());
        }
        HashMap<String, String> pmap = new HashMap<String, String>();
        pmap.put("transferaCode", transferaCode);
        pmap.put("tenantCode", tenantCode);
        TaTransfera taTransfera = this.getTransferaByCode(tenantCode, transferaCode);
        if (null == taTransfera) {
            throw new ApiException("ta.TaTransferaServiceImpl.updateTransferaToPteBack.null", "\u67e5\u8be2\u4fe1\u606f\u5931\u8d25\uff01" + map.toString());
        }
        if (dataState == taTransfera.getDataState()) {
            return true;
        }
        this.updateStateTransferaModel(taTransfera.getTransferaId(), dataState, taTransfera.getDataState(), null);
        return true;
    }
}

