/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ul.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.ul.domain.OcReorderDomain;
import com.yqbsoft.laser.service.ul.domain.UlLevelClearDomain;
import com.yqbsoft.laser.service.ul.domain.UlLevelUpointsDomain;
import com.yqbsoft.laser.service.ul.es.SendPutThread;
import com.yqbsoft.laser.service.ul.model.UlLevelClear;
import com.yqbsoft.laser.service.ul.model.UlLevelList;
import com.yqbsoft.laser.service.ul.model.UlLevelUllist;
import com.yqbsoft.laser.service.ul.model.UlLevelUpoints;
import com.yqbsoft.laser.service.ul.model.UmUser;
import com.yqbsoft.laser.service.ul.model.UmUserinfo;
import com.yqbsoft.laser.service.ul.service.UlLevelClearBaseService;
import com.yqbsoft.laser.service.ul.service.UlLevelClearService;
import com.yqbsoft.laser.service.ul.service.UlLevelService;
import com.yqbsoft.laser.service.ul.service.UlLevelUllistService;
import com.yqbsoft.laser.service.ul.service.impl.UlLevelClearServiceImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;

public class UlLevelClearBaseServiceImpl
extends BaseServiceImpl
implements UlLevelClearBaseService {
    private static final String SYS_CODE = "service.ul.UlLevelClearBaseServiceImpl";
    private UlLevelClearService ulLevelClearService;
    private UlLevelService ulLevelService;
    private UlLevelUllistService ulLevelUllistService;

    public UlLevelClearService getUlLevelClearService() {
        return this.ulLevelClearService;
    }

    public void setUlLevelClearService(UlLevelClearService ulLevelClearService) {
        this.ulLevelClearService = ulLevelClearService;
    }

    public UlLevelService getUlLevelService() {
        return this.ulLevelService;
    }

    public void setUlLevelService(UlLevelService ulLevelService) {
        this.ulLevelService = ulLevelService;
    }

    public UlLevelUllistService getUlLevelUllistService() {
        return this.ulLevelUllistService;
    }

    public void setUlLevelUllistService(UlLevelUllistService ulLevelUllistService) {
        this.ulLevelUllistService = ulLevelUllistService;
    }

    @Override
    public String sendLevelClearToPoints(UlLevelClear ulLevelClear) throws ApiException {
        UlLevelUllist ulLevelUllist = this.ulLevelClearService.saveUlLevelClearToLevel(ulLevelClear);
        if (null == ulLevelUllist) {
            return null;
        }
        ArrayList<UlLevelUllist> ulLevelUllists = new ArrayList<UlLevelUllist>();
        ulLevelUllists.add(ulLevelUllist);
        UlLevelClearServiceImpl.getSendService().addPutPool(new SendPutThread(UlLevelClearServiceImpl.getSendService(), ulLevelUllists));
        this.updateLevel(ulLevelUllist);
        return ulLevelUllist.getLevelClearCode();
    }

    private void updateLevel(UlLevelUllist ulLevelUllist) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("levelType", ulLevelUllist.getLevelType());
        map.put("memberCode", ulLevelUllist.getMemberCode());
        map.put("tenantCode", ulLevelUllist.getTenantCode());
        UlLevelUpoints levelUpoints = this.ulLevelUllistService.getUlLevelUpointsByMember(map);
        if (null == levelUpoints) {
            return;
        }
        map.remove("memberCode");
        map.put("levelListStart", levelUpoints.getLevelNum().intValue());
        map.put("levelListEnd", levelUpoints.getLevelNum().intValue());
        List<UlLevelList> ulLevelLists = this.ulLevelService.queryLevelListByLevelNum(map);
        if (ListUtil.isNotEmpty(ulLevelLists)) {
            UlLevelList ulLevelList = ulLevelLists.get(0);
            if (levelUpoints.getLevelListLevel().equals(ulLevelList.getLevelListLevel())) {
                return;
            }
            levelUpoints.setLevelListLevel(ulLevelList.getLevelListLevel());
            levelUpoints.setLevelListName(ulLevelList.getLevelListName());
            UlLevelUpointsDomain ulLevelUpointsDomain = new UlLevelUpointsDomain();
            try {
                BeanUtils.copyAllPropertys((Object)ulLevelUpointsDomain, (Object)levelUpoints);
            }
            catch (Exception e) {
                this.logger.error("service.ul.UlLevelClearBaseServiceImpl.ulLevelUpointsDomain.e", (Throwable)e);
                return;
            }
            this.ulLevelUllistService.updateUlLevelUpoints(ulLevelUpointsDomain);
            this.updateUserInfoLevel(levelUpoints);
        }
    }

    private void updateUserInfoLevel(UlLevelUpoints levelUpoints) throws ApiException {
        HashMap<String, Object> umInfoMapStr = new HashMap<String, Object>();
        umInfoMapStr.put("userinfoCode", levelUpoints.getMemberCode());
        umInfoMapStr.put("tenantCode", levelUpoints.getTenantCode());
        umInfoMapStr.put("userinfoLevel", levelUpoints.getLevelListLevel());
        HashMap<String, String> umUserParamMap = new HashMap<String, String>();
        umUserParamMap.put("map", JsonUtil.buildNormalBinder().toJson(umInfoMapStr));
        try {
            this.getInternalRouter().inInvoke("um.userbase.updateLevel", umUserParamMap);
        }
        catch (Exception e) {
            this.logger.error("service.ul.UlLevelClearBaseServiceImpl.sendLevelClearToPoints.updateLevel.e", (Object)("\u4fee\u6539\u7528\u6237\u4f1a\u5458\u5f02\u5e38\uff01\uff01\uff01umUserParamMap:" + umUserParamMap));
            return;
        }
    }

    @Override
    public OcReorderDomain sendLevelClear(UlLevelClearDomain ulLevelClearDomain) throws ApiException {
        OcReorderDomain ocReorderDomain = new OcReorderDomain();
        ocReorderDomain.setOrderState("2");
        UlLevelClear ulLevelClear = this.ulLevelClearService.savesendLevelClear(ulLevelClearDomain);
        this.fristOcContract(ulLevelClearDomain);
        if (null == ulLevelClear) {
            return ocReorderDomain;
        }
        ocReorderDomain.setReorderCode(ulLevelClear.getLevelClearCode());
        ocReorderDomain.setOrderState("2");
        UlLevelClearServiceImpl.getUlLevelClearService().putQueue(ulLevelClear);
        return ocReorderDomain;
    }

    private void fristOcContract(UlLevelClearDomain ulLevelClearDomain) {
        QueryResult<UlLevelUllist> ulLevelUllistQueryResult;
        if (null != ulLevelClearDomain && null != ulLevelClearDomain.getLevelRuleApi() && "OcContract".equals(ulLevelClearDomain.getLevelRuleApi()) && ListUtil.isNotEmpty((Collection)(ulLevelUllistQueryResult = this.ulLevelUllistService.queryUlLevelUllistPage(this.getQueryParamMap("memberCode,tenantCode,levelRuleApi", new Object[]{ulLevelClearDomain.getMemberCode(), ulLevelClearDomain.getTenantCode(), "FristOcContract"}))).getList())) {
            ulLevelClearDomain.setLevelRuleApi("FristOcContract");
            this.sendLevelClear(ulLevelClearDomain);
        }
    }

    @Override
    public String sendLevelClearBySignIn(UmUserinfo umUserinfo, UmUser umUser, String optype) throws ApiException {
        if (null == umUserinfo) {
            return "error";
        }
        UlLevelClearDomain ulLevelClearDomain = new UlLevelClearDomain();
        ulLevelClearDomain.setLevelRuleApi("UmUserinfo");
        ulLevelClearDomain.setTenantCode(umUserinfo.getTenantCode());
        ulLevelClearDomain.setLevelClearDirection("0");
        ulLevelClearDomain.setMemberCode(umUserinfo.getUserinfoCode());
        ulLevelClearDomain.setMemberName(umUserinfo.getUserinfoCompname());
        ulLevelClearDomain.setLevelType("0");
        OcReorderDomain ocReorderDomain = this.sendLevelClear(ulLevelClearDomain);
        if (null == ocReorderDomain || ocReorderDomain.isError()) {
            return "error";
        }
        return "success";
    }
}

